import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComposerEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * User-defined labels for this environment.
     *
     * The labels map can contain no more than 64 entries. Entries of the labels map are UTF8 strings that comply with the following restrictions: Label keys must be between 1 and 63 characters long and must conform to the following regular expression: [a-z]([-a-z0-9]*[a-z0-9])?. Label values must be between 0 and 63 characters long and must conform to the regular expression ([a-z]([-a-z0-9]*[a-z0-9])?)?. No more than 64 labels can be associated with a given environment. Both keys and values must be <= 128 bytes in size.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#labels ComposerEnvironment#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Name of the environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#name ComposerEnvironment#name}
     */
    readonly name: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#project ComposerEnvironment#project}
     */
    readonly project?: string;
    /**
     * The location or Compute Engine region for the environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#region ComposerEnvironment#region}
     */
    readonly region?: string;
    /**
     * config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#config ComposerEnvironment#config}
     */
    readonly config?: ComposerEnvironmentConfigA;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#timeouts ComposerEnvironment#timeouts}
     */
    readonly timeouts?: ComposerEnvironmentTimeouts;
}
export interface ComposerEnvironmentConfigNodeConfigIpAllocationPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#cluster_ipv4_cidr_block ComposerEnvironment#cluster_ipv4_cidr_block}.
     */
    readonly clusterIpv4CidrBlock?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#cluster_secondary_range_name ComposerEnvironment#cluster_secondary_range_name}.
     */
    readonly clusterSecondaryRangeName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#services_ipv4_cidr_block ComposerEnvironment#services_ipv4_cidr_block}.
     */
    readonly servicesIpv4CidrBlock?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#services_secondary_range_name ComposerEnvironment#services_secondary_range_name}.
     */
    readonly servicesSecondaryRangeName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#use_ip_aliases ComposerEnvironment#use_ip_aliases}.
     */
    readonly useIpAliases?: boolean | cdktf.IResolvable;
}
export interface ComposerEnvironmentConfigNodeConfig {
    /**
     * The disk size in GB used for node VMs.
     *
     * Minimum size is 20GB. If unspecified, defaults to 100GB. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#disk_size_gb ComposerEnvironment#disk_size_gb}
     */
    readonly diskSizeGb?: number;
    /**
     * Configuration for controlling how IPs are allocated in the GKE cluster. Cannot be updated.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#ip_allocation_policy ComposerEnvironment#ip_allocation_policy}
     */
    readonly ipAllocationPolicy?: ComposerEnvironmentConfigNodeConfigIpAllocationPolicy[];
    /**
     * The Compute Engine machine type used for cluster instances, specified as a name or relative resource name.
     *
     * For example: "projects/{project}/zones/{zone}/machineTypes/{machineType}". Must belong to the enclosing environment's project and region/zone. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#machine_type ComposerEnvironment#machine_type}
     */
    readonly machineType?: string;
    /**
     * The Compute Engine machine type used for cluster instances, specified as a name or relative resource name.
     *
     * For example: "projects/{project}/zones/{zone}/machineTypes/{machineType}". Must belong to the enclosing environment's project and region/zone. The network must belong to the environment's project. If unspecified, the "default" network ID in the environment's project is used. If a Custom Subnet Network is provided, subnetwork must also be provided.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#network ComposerEnvironment#network}
     */
    readonly network?: string;
    /**
     * The set of Google API scopes to be made available on all node VMs.
     *
     * Cannot be updated. If empty, defaults to ["https://www.googleapis.com/auth/cloud-platform"]. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#oauth_scopes ComposerEnvironment#oauth_scopes}
     */
    readonly oauthScopes?: string[];
    /**
     * The Google Cloud Platform Service Account to be used by the node VMs.
     *
     * If a service account is not specified, the "default" Compute Engine service account is used. Cannot be updated. If given, note that the service account must have roles/composer.worker for any GCP resources created under the Cloud Composer Environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#service_account ComposerEnvironment#service_account}
     */
    readonly serviceAccount?: string;
    /**
     * The Compute Engine subnetwork to be used for machine communications, , specified as a self-link, relative resource name (e.g. "projects/{project}/regions/{region}/subnetworks/{subnetwork}"), or by name. If subnetwork is provided, network must also be provided and the subnetwork must belong to the enclosing environment's project and region.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#subnetwork ComposerEnvironment#subnetwork}
     */
    readonly subnetwork?: string;
    /**
     * The list of instance tags applied to all node VMs.
     *
     * Tags are used to identify valid sources or targets for network firewalls. Each tag within the list must comply with RFC1035. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#tags ComposerEnvironment#tags}
     */
    readonly tags?: string[];
    /**
     * The Compute Engine zone in which to deploy the VMs running the Apache Airflow software, specified as the zone name or relative resource name (e.g. "projects/{project}/zones/{zone}"). Must belong to the enclosing environment's project and region. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#zone ComposerEnvironment#zone}
     */
    readonly zone?: string;
}
export declare class ComposerEnvironmentConfigNodeConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _diskSizeGb?;
    get diskSizeGb(): number | undefined;
    set diskSizeGb(value: number | undefined);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _ipAllocationPolicy?;
    get ipAllocationPolicy(): ComposerEnvironmentConfigNodeConfigIpAllocationPolicy[] | undefined;
    set ipAllocationPolicy(value: ComposerEnvironmentConfigNodeConfigIpAllocationPolicy[] | undefined);
    resetIpAllocationPolicy(): void;
    get ipAllocationPolicyInput(): ComposerEnvironmentConfigNodeConfigIpAllocationPolicy[] | undefined;
    private _machineType?;
    get machineType(): string | undefined;
    set machineType(value: string | undefined);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _network?;
    get network(): string | undefined;
    set network(value: string | undefined);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[] | undefined;
    set oauthScopes(value: string[] | undefined);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
    private _serviceAccount?;
    get serviceAccount(): string | undefined;
    set serviceAccount(value: string | undefined);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _subnetwork?;
    get subnetwork(): string | undefined;
    set subnetwork(value: string | undefined);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    private _tags?;
    get tags(): string[] | undefined;
    set tags(value: string[] | undefined);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _zone?;
    get zone(): string | undefined;
    set zone(value: string | undefined);
    resetZone(): void;
    get zoneInput(): string | undefined;
}
export interface ComposerEnvironmentConfigPrivateEnvironmentConfig {
    /**
     * The CIDR block from which IP range in tenant project will be reserved for Cloud SQL.
     *
     * Needs to be disjoint from web_server_ipv4_cidr_block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#cloud_sql_ipv4_cidr_block ComposerEnvironment#cloud_sql_ipv4_cidr_block}
     */
    readonly cloudSqlIpv4CidrBlock?: string;
    /**
     * If true, access to the public endpoint of the GKE cluster is denied.
     *
     * If this field is set to true, ip_allocation_policy.use_ip_aliases must be set to true for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#enable_private_endpoint ComposerEnvironment#enable_private_endpoint}
     */
    readonly enablePrivateEndpoint?: boolean | cdktf.IResolvable;
    /**
     * The IP range in CIDR notation to use for the hosted master network.
     *
     * This range is used for assigning internal IP addresses to the cluster master or set of masters and to the internal load balancer virtual IP. This range must not overlap with any other ranges in use within the cluster's network. If left blank, the default value of '172.16.0.0/28' is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#master_ipv4_cidr_block ComposerEnvironment#master_ipv4_cidr_block}
     */
    readonly masterIpv4CidrBlock?: string;
    /**
     * The CIDR block from which IP range for web server will be reserved.
     *
     * Needs to be disjoint from master_ipv4_cidr_block and cloud_sql_ipv4_cidr_block. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#web_server_ipv4_cidr_block ComposerEnvironment#web_server_ipv4_cidr_block}
     */
    readonly webServerIpv4CidrBlock?: string;
}
export declare class ComposerEnvironmentConfigPrivateEnvironmentConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _cloudSqlIpv4CidrBlock?;
    get cloudSqlIpv4CidrBlock(): string | undefined;
    set cloudSqlIpv4CidrBlock(value: string | undefined);
    resetCloudSqlIpv4CidrBlock(): void;
    get cloudSqlIpv4CidrBlockInput(): string | undefined;
    private _enablePrivateEndpoint?;
    get enablePrivateEndpoint(): boolean | cdktf.IResolvable | undefined;
    set enablePrivateEndpoint(value: boolean | cdktf.IResolvable | undefined);
    resetEnablePrivateEndpoint(): void;
    get enablePrivateEndpointInput(): boolean | cdktf.IResolvable | undefined;
    private _masterIpv4CidrBlock?;
    get masterIpv4CidrBlock(): string | undefined;
    set masterIpv4CidrBlock(value: string | undefined);
    resetMasterIpv4CidrBlock(): void;
    get masterIpv4CidrBlockInput(): string | undefined;
    private _webServerIpv4CidrBlock?;
    get webServerIpv4CidrBlock(): string | undefined;
    set webServerIpv4CidrBlock(value: string | undefined);
    resetWebServerIpv4CidrBlock(): void;
    get webServerIpv4CidrBlockInput(): string | undefined;
}
export interface ComposerEnvironmentConfigSoftwareConfig {
    /**
     * Apache Airflow configuration properties to override.
     *
     * Property keys contain the section and property names, separated by a hyphen, for example "core-dags_are_paused_at_creation". Section names must not contain hyphens ("-"), opening square brackets ("["), or closing square brackets ("]"). The property name must not be empty and cannot contain "=" or ";". Section and property names cannot contain characters: "." Apache Airflow configuration property names must be written in snake_case. Property values can contain any character, and can be written in any lower/upper case format. Certain Apache Airflow configuration property values are blacklisted, and cannot be overridden.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#airflow_config_overrides ComposerEnvironment#airflow_config_overrides}
     */
    readonly airflowConfigOverrides?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Additional environment variables to provide to the Apache Airflow schedulerf, worker, and webserver processes.
     *
     * Environment variable names must match the regular expression [a-zA-Z_][a-zA-Z0-9_]*. They cannot specify Apache Airflow software configuration overrides (they cannot match the regular expression AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+), and they cannot match any of the following reserved names: AIRFLOW_HOME C_FORCE_ROOT CONTAINER_NAME DAGS_FOLDER GCP_PROJECT GCS_BUCKET GKE_CLUSTER_NAME SQL_DATABASE SQL_INSTANCE SQL_PASSWORD SQL_PROJECT SQL_REGION SQL_USER.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#env_variables ComposerEnvironment#env_variables}
     */
    readonly envVariables?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The version of the software running in the environment.
     *
     * This encapsulates both the version of Cloud Composer functionality and the version of Apache Airflow. It must match the regular expression composer-[0-9]+\.[0-9]+(\.[0-9]+)?-airflow-[0-9]+\.[0-9]+(\.[0-9]+.*)?. The Cloud Composer portion of the version is a semantic version. The portion of the image version following 'airflow-' is an official Apache Airflow repository release name. See documentation for allowed release names.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#image_version ComposerEnvironment#image_version}
     */
    readonly imageVersion?: string;
    /**
     * Custom Python Package Index (PyPI) packages to be installed in the environment.
     *
     * Keys refer to the lowercase package name (e.g. "numpy"). Values are the lowercase extras and version specifier (e.g. "==1.12.0", "[devel,gcp_api]", "[devel]>=1.8.2, <1.9.2"). To specify a package without pinning it to a version specifier, use the empty string as the value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#pypi_packages ComposerEnvironment#pypi_packages}
     */
    readonly pypiPackages?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The major version of Python used to run the Apache Airflow scheduler, worker, and webserver processes.
     *
     * Can be set to '2' or '3'. If not specified, the default is '2'. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*. Environments in newer versions always use Python major version 3.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#python_version ComposerEnvironment#python_version}
     */
    readonly pythonVersion?: string;
    /**
     * The number of schedulers for Airflow. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-2.*.*.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#scheduler_count ComposerEnvironment#scheduler_count}
     */
    readonly schedulerCount?: number;
}
export declare class ComposerEnvironmentConfigSoftwareConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _airflowConfigOverrides?;
    get airflowConfigOverrides(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set airflowConfigOverrides(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetAirflowConfigOverrides(): void;
    get airflowConfigOverridesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _envVariables?;
    get envVariables(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set envVariables(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetEnvVariables(): void;
    get envVariablesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _imageVersion?;
    get imageVersion(): string | undefined;
    set imageVersion(value: string | undefined);
    resetImageVersion(): void;
    get imageVersionInput(): string | undefined;
    private _pypiPackages?;
    get pypiPackages(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set pypiPackages(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetPypiPackages(): void;
    get pypiPackagesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _pythonVersion?;
    get pythonVersion(): string | undefined;
    set pythonVersion(value: string | undefined);
    resetPythonVersion(): void;
    get pythonVersionInput(): string | undefined;
    private _schedulerCount?;
    get schedulerCount(): number | undefined;
    set schedulerCount(value: number | undefined);
    resetSchedulerCount(): void;
    get schedulerCountInput(): number | undefined;
}
export interface ComposerEnvironmentConfigA {
    /**
     * The number of nodes in the Kubernetes Engine cluster that will be used to run this environment.
     *
     * This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#node_count ComposerEnvironment#node_count}
     */
    readonly nodeCount?: number;
    /**
     * node_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#node_config ComposerEnvironment#node_config}
     */
    readonly nodeConfig?: ComposerEnvironmentConfigNodeConfig;
    /**
     * private_environment_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#private_environment_config ComposerEnvironment#private_environment_config}
     */
    readonly privateEnvironmentConfig?: ComposerEnvironmentConfigPrivateEnvironmentConfig;
    /**
     * software_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#software_config ComposerEnvironment#software_config}
     */
    readonly softwareConfig?: ComposerEnvironmentConfigSoftwareConfig;
}
export declare class ComposerEnvironmentConfigAOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _nodeCount?;
    get nodeCount(): number | undefined;
    set nodeCount(value: number | undefined);
    resetNodeCount(): void;
    get nodeCountInput(): number | undefined;
    private _nodeConfig?;
    private __nodeConfigOutput;
    get nodeConfig(): ComposerEnvironmentConfigNodeConfigOutputReference;
    putNodeConfig(value: ComposerEnvironmentConfigNodeConfig | undefined): void;
    resetNodeConfig(): void;
    get nodeConfigInput(): ComposerEnvironmentConfigNodeConfig | undefined;
    private _privateEnvironmentConfig?;
    private __privateEnvironmentConfigOutput;
    get privateEnvironmentConfig(): ComposerEnvironmentConfigPrivateEnvironmentConfigOutputReference;
    putPrivateEnvironmentConfig(value: ComposerEnvironmentConfigPrivateEnvironmentConfig | undefined): void;
    resetPrivateEnvironmentConfig(): void;
    get privateEnvironmentConfigInput(): ComposerEnvironmentConfigPrivateEnvironmentConfig | undefined;
    private _softwareConfig?;
    private __softwareConfigOutput;
    get softwareConfig(): ComposerEnvironmentConfigSoftwareConfigOutputReference;
    putSoftwareConfig(value: ComposerEnvironmentConfigSoftwareConfig | undefined): void;
    resetSoftwareConfig(): void;
    get softwareConfigInput(): ComposerEnvironmentConfigSoftwareConfig | undefined;
}
export interface ComposerEnvironmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#create ComposerEnvironment#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#delete ComposerEnvironment#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html#update ComposerEnvironment#update}.
     */
    readonly update?: string;
}
export declare class ComposerEnvironmentTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html google_composer_environment}.
 */
export declare class ComposerEnvironment extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/composer_environment.html google_composer_environment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComposerEnvironmentConfig);
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _config?;
    private __configOutput;
    get config(): ComposerEnvironmentConfigAOutputReference;
    putConfig(value: ComposerEnvironmentConfigA | undefined): void;
    resetConfig(): void;
    get configInput(): ComposerEnvironmentConfigA | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComposerEnvironmentTimeoutsOutputReference;
    putTimeouts(value: ComposerEnvironmentTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComposerEnvironmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
