import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudiotRegistryConfig extends cdktf.TerraformMetaArguments {
    /**
     * Activate or deactivate HTTP.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry.html#http_config CloudiotRegistry#http_config}
     */
    readonly httpConfig?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The default logging verbosity for activity from devices in this registry.
     *
     * Specifies which events should be written to logs. For
     * example, if the LogLevel is ERROR, only events that terminate in
     * errors will be logged. LogLevel is inclusive; enabling INFO logging
     * will also enable ERROR logging. Default value: "NONE" Possible values: ["NONE", "ERROR", "INFO", "DEBUG"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry.html#log_level CloudiotRegistry#log_level}
     */
    readonly logLevel?: string;
    /**
     * Activate or deactivate MQTT.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry.html#mqtt_config CloudiotRegistry#mqtt_config}
     */
    readonly mqttConfig?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * A unique name for the resource, required by device registry.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry.html#name CloudiotRegistry#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry.html#project CloudiotRegistry#project}.
     */
    readonly project?: string;
    /**
     * The region in which the created registry should reside. If it is not provided, the provider region is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry.html#region CloudiotRegistry#region}
     */
    readonly region?: string;
    /**
     * A PubSub topic to publish device state updates.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry.html#state_notification_config CloudiotRegistry#state_notification_config}
     */
    readonly stateNotificationConfig?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * credentials block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry.html#credentials CloudiotRegistry#credentials}
     */
    readonly credentials?: CloudiotRegistryCredentials[];
    /**
     * event_notification_configs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry.html#event_notification_configs CloudiotRegistry#event_notification_configs}
     */
    readonly eventNotificationConfigs?: CloudiotRegistryEventNotificationConfigs[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry.html#timeouts CloudiotRegistry#timeouts}
     */
    readonly timeouts?: CloudiotRegistryTimeouts;
}
export interface CloudiotRegistryCredentials {
    /**
     * A public key certificate format and data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry.html#public_key_certificate CloudiotRegistry#public_key_certificate}
     */
    readonly publicKeyCertificate: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export interface CloudiotRegistryEventNotificationConfigs {
    /**
     * PubSub topic name to publish device events.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry.html#pubsub_topic_name CloudiotRegistry#pubsub_topic_name}
     */
    readonly pubsubTopicName: string;
    /**
     * If the subfolder name matches this string exactly, this configuration will be used.
     *
     * The string must not include the
     * leading '/' character. If empty, all strings are matched. Empty
     * value can only be used for the last 'event_notification_configs'
     * item.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry.html#subfolder_matches CloudiotRegistry#subfolder_matches}
     */
    readonly subfolderMatches?: string;
}
export interface CloudiotRegistryTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry.html#create CloudiotRegistry#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry.html#delete CloudiotRegistry#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry.html#update CloudiotRegistry#update}.
     */
    readonly update?: string;
}
export declare class CloudiotRegistryTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry.html google_cloudiot_registry}.
 */
export declare class CloudiotRegistry extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry.html google_cloudiot_registry} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: CloudiotRegistryConfig);
    private _httpConfig?;
    get httpConfig(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set httpConfig(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetHttpConfig(): void;
    get httpConfigInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    get id(): string;
    private _logLevel?;
    get logLevel(): string | undefined;
    set logLevel(value: string | undefined);
    resetLogLevel(): void;
    get logLevelInput(): string | undefined;
    private _mqttConfig?;
    get mqttConfig(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set mqttConfig(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetMqttConfig(): void;
    get mqttConfigInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _stateNotificationConfig?;
    get stateNotificationConfig(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set stateNotificationConfig(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetStateNotificationConfig(): void;
    get stateNotificationConfigInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _credentials?;
    get credentials(): CloudiotRegistryCredentials[] | undefined;
    set credentials(value: CloudiotRegistryCredentials[] | undefined);
    resetCredentials(): void;
    get credentialsInput(): CloudiotRegistryCredentials[] | undefined;
    private _eventNotificationConfigs?;
    get eventNotificationConfigs(): CloudiotRegistryEventNotificationConfigs[] | undefined;
    set eventNotificationConfigs(value: CloudiotRegistryEventNotificationConfigs[] | undefined);
    resetEventNotificationConfigs(): void;
    get eventNotificationConfigsInput(): CloudiotRegistryEventNotificationConfigs[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): CloudiotRegistryTimeoutsOutputReference;
    putTimeouts(value: CloudiotRegistryTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): CloudiotRegistryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
