import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudiotDeviceConfig extends cdktf.TerraformMetaArguments {
    /**
     * If a device is blocked, connections or requests from this device will fail.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#blocked CloudiotDevice#blocked}
     */
    readonly blocked?: boolean | cdktf.IResolvable;
    /**
     * The logging verbosity for device activity. Possible values: ["NONE", "ERROR", "INFO", "DEBUG"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#log_level CloudiotDevice#log_level}
     */
    readonly logLevel?: string;
    /**
     * The metadata key-value pairs assigned to the device.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#metadata CloudiotDevice#metadata}
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * A unique name for the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#name CloudiotDevice#name}
     */
    readonly name: string;
    /**
     * The name of the device registry where this device should be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#registry CloudiotDevice#registry}
     */
    readonly registry: string;
    /**
     * credentials block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#credentials CloudiotDevice#credentials}
     */
    readonly credentials?: CloudiotDeviceCredentials[];
    /**
     * gateway_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#gateway_config CloudiotDevice#gateway_config}
     */
    readonly gatewayConfig?: CloudiotDeviceGatewayConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#timeouts CloudiotDevice#timeouts}
     */
    readonly timeouts?: CloudiotDeviceTimeouts;
}
export declare class CloudiotDeviceConfigA extends cdktf.ComplexComputedList {
    get binaryData(): string;
    get cloudUpdateTime(): string;
    get deviceAckTime(): string;
    get version(): string;
}
export declare class CloudiotDeviceLastErrorStatus extends cdktf.ComplexComputedList {
    get details(): any;
    get message(): string;
    get number(): number;
}
export declare class CloudiotDeviceState extends cdktf.ComplexComputedList {
    get binaryData(): string;
    get updateTime(): string;
}
export interface CloudiotDeviceCredentialsPublicKey {
    /**
     * The format of the key. Possible values: ["RSA_PEM", "RSA_X509_PEM", "ES256_PEM", "ES256_X509_PEM"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#format CloudiotDevice#format}
     */
    readonly format: string;
    /**
     * The key data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#key CloudiotDevice#key}
     */
    readonly key: string;
}
export declare class CloudiotDeviceCredentialsPublicKeyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _format?;
    get format(): string;
    set format(value: string);
    get formatInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
}
export interface CloudiotDeviceCredentials {
    /**
     * The time at which this credential becomes invalid.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#expiration_time CloudiotDevice#expiration_time}
     */
    readonly expirationTime?: string;
    /**
     * public_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#public_key CloudiotDevice#public_key}
     */
    readonly publicKey: CloudiotDeviceCredentialsPublicKey;
}
export interface CloudiotDeviceGatewayConfig {
    /**
     * Indicates whether the device is a gateway. Possible values: ["ASSOCIATION_ONLY", "DEVICE_AUTH_TOKEN_ONLY", "ASSOCIATION_AND_DEVICE_AUTH_TOKEN"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#gateway_auth_method CloudiotDevice#gateway_auth_method}
     */
    readonly gatewayAuthMethod?: string;
    /**
     * Indicates whether the device is a gateway. Default value: "NON_GATEWAY" Possible values: ["GATEWAY", "NON_GATEWAY"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#gateway_type CloudiotDevice#gateway_type}
     */
    readonly gatewayType?: string;
}
export declare class CloudiotDeviceGatewayConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _gatewayAuthMethod?;
    get gatewayAuthMethod(): string | undefined;
    set gatewayAuthMethod(value: string | undefined);
    resetGatewayAuthMethod(): void;
    get gatewayAuthMethodInput(): string | undefined;
    private _gatewayType?;
    get gatewayType(): string | undefined;
    set gatewayType(value: string | undefined);
    resetGatewayType(): void;
    get gatewayTypeInput(): string | undefined;
}
export interface CloudiotDeviceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#create CloudiotDevice#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#delete CloudiotDevice#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#update CloudiotDevice#update}.
     */
    readonly update?: string;
}
export declare class CloudiotDeviceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html google_cloudiot_device}.
 */
export declare class CloudiotDevice extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html google_cloudiot_device} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: CloudiotDeviceConfig);
    private _blocked?;
    get blocked(): boolean | cdktf.IResolvable | undefined;
    set blocked(value: boolean | cdktf.IResolvable | undefined);
    resetBlocked(): void;
    get blockedInput(): boolean | cdktf.IResolvable | undefined;
    config(index: string): CloudiotDeviceConfigA;
    get id(): string;
    get lastConfigAckTime(): string;
    get lastConfigSendTime(): string;
    lastErrorStatus(index: string): CloudiotDeviceLastErrorStatus;
    get lastErrorTime(): string;
    get lastEventTime(): string;
    get lastHeartbeatTime(): string;
    get lastStateTime(): string;
    private _logLevel?;
    get logLevel(): string | undefined;
    set logLevel(value: string | undefined);
    resetLogLevel(): void;
    get logLevelInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetMetadata(): void;
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get numId(): string;
    private _registry?;
    get registry(): string;
    set registry(value: string);
    get registryInput(): string | undefined;
    state(index: string): CloudiotDeviceState;
    private _credentials?;
    get credentials(): CloudiotDeviceCredentials[] | undefined;
    set credentials(value: CloudiotDeviceCredentials[] | undefined);
    resetCredentials(): void;
    get credentialsInput(): CloudiotDeviceCredentials[] | undefined;
    private _gatewayConfig?;
    private __gatewayConfigOutput;
    get gatewayConfig(): CloudiotDeviceGatewayConfigOutputReference;
    putGatewayConfig(value: CloudiotDeviceGatewayConfig | undefined): void;
    resetGatewayConfig(): void;
    get gatewayConfigInput(): CloudiotDeviceGatewayConfig | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): CloudiotDeviceTimeoutsOutputReference;
    putTimeouts(value: CloudiotDeviceTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): CloudiotDeviceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
