import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudfunctionsFunctionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Memory (in MB), available to the function. Default value is 256. Possible values include 128, 256, 512, 1024, etc.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#available_memory_mb CloudfunctionsFunction#available_memory_mb}
     */
    readonly availableMemoryMb?: number;
    /**
     * A set of key/value environment variable pairs available during build time.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#build_environment_variables CloudfunctionsFunction#build_environment_variables}
     */
    readonly buildEnvironmentVariables?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Description of the function.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#description CloudfunctionsFunction#description}
     */
    readonly description?: string;
    /**
     * Name of the function that will be executed when the Google Cloud Function is triggered.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#entry_point CloudfunctionsFunction#entry_point}
     */
    readonly entryPoint?: string;
    /**
     * A set of key/value environment variable pairs to assign to the function.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#environment_variables CloudfunctionsFunction#environment_variables}
     */
    readonly environmentVariables?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * URL which triggers function execution. Returned only if trigger_http is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#https_trigger_url CloudfunctionsFunction#https_trigger_url}
     */
    readonly httpsTriggerUrl?: string;
    /**
     * String value that controls what traffic can reach the function.
     *
     * Allowed values are ALLOW_ALL and ALLOW_INTERNAL_ONLY. Changes to this field will recreate the cloud function.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#ingress_settings CloudfunctionsFunction#ingress_settings}
     */
    readonly ingressSettings?: string;
    /**
     * A set of key/value label pairs to assign to the function. Label keys must follow the requirements at https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#labels CloudfunctionsFunction#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The limit on the maximum number of function instances that may coexist at a given time.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#max_instances CloudfunctionsFunction#max_instances}
     */
    readonly maxInstances?: number;
    /**
     * A user-defined name of the function. Function names must be unique globally.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#name CloudfunctionsFunction#name}
     */
    readonly name: string;
    /**
     * Project of the function. If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#project CloudfunctionsFunction#project}
     */
    readonly project?: string;
    /**
     * Region of function. If it is not provided, the provider region is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#region CloudfunctionsFunction#region}
     */
    readonly region?: string;
    /**
     * The runtime in which the function is going to run. Eg. "nodejs8", "nodejs10", "python37", "go111".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#runtime CloudfunctionsFunction#runtime}
     */
    readonly runtime: string;
    /**
     * If provided, the self-provided service account to run the function with.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#service_account_email CloudfunctionsFunction#service_account_email}
     */
    readonly serviceAccountEmail?: string;
    /**
     * The GCS bucket containing the zip archive which contains the function.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#source_archive_bucket CloudfunctionsFunction#source_archive_bucket}
     */
    readonly sourceArchiveBucket?: string;
    /**
     * The source archive object (file) in archive bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#source_archive_object CloudfunctionsFunction#source_archive_object}
     */
    readonly sourceArchiveObject?: string;
    /**
     * Timeout (in seconds) for the function. Default value is 60 seconds. Cannot be more than 540 seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#timeout CloudfunctionsFunction#timeout}
     */
    readonly timeout?: number;
    /**
     * Boolean variable.
     *
     * Any HTTP request (of a supported type) to the endpoint will trigger function execution. Supported HTTP request types are: POST, PUT, GET, DELETE, and OPTIONS. Endpoint is returned as https_trigger_url. Cannot be used with trigger_bucket and trigger_topic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#trigger_http CloudfunctionsFunction#trigger_http}
     */
    readonly triggerHttp?: boolean | cdktf.IResolvable;
    /**
     * The VPC Network Connector that this cloud function can connect to.
     *
     * It can be either the fully-qualified URI, or the short name of the network connector resource. The format of this field is projects/*\/locations/*\/connectors/*.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#vpc_connector CloudfunctionsFunction#vpc_connector}
     */
    readonly vpcConnector?: string;
    /**
     * The egress settings for the connector, controlling what traffic is diverted through it.
     *
     * Allowed values are ALL_TRAFFIC and PRIVATE_RANGES_ONLY. Defaults to PRIVATE_RANGES_ONLY. If unset, this field preserves the previously set value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#vpc_connector_egress_settings CloudfunctionsFunction#vpc_connector_egress_settings}
     */
    readonly vpcConnectorEgressSettings?: string;
    /**
     * event_trigger block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#event_trigger CloudfunctionsFunction#event_trigger}
     */
    readonly eventTrigger?: CloudfunctionsFunctionEventTrigger;
    /**
     * source_repository block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#source_repository CloudfunctionsFunction#source_repository}
     */
    readonly sourceRepository?: CloudfunctionsFunctionSourceRepository;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#timeouts CloudfunctionsFunction#timeouts}
     */
    readonly timeouts?: CloudfunctionsFunctionTimeouts;
}
export interface CloudfunctionsFunctionEventTriggerFailurePolicy {
    /**
     * Whether the function should be retried on failure. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#retry CloudfunctionsFunction#retry}
     */
    readonly retry: boolean | cdktf.IResolvable;
}
export declare class CloudfunctionsFunctionEventTriggerFailurePolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _retry?;
    get retry(): boolean | cdktf.IResolvable;
    set retry(value: boolean | cdktf.IResolvable);
    get retryInput(): boolean | cdktf.IResolvable | undefined;
}
export interface CloudfunctionsFunctionEventTrigger {
    /**
     * The type of event to observe.
     *
     * For example: "google.storage.object.finalize". See the documentation on calling Cloud Functions for a full reference of accepted triggers.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#event_type CloudfunctionsFunction#event_type}
     */
    readonly eventType: string;
    /**
     * The name or partial URI of the resource from which to observe events. For example, "myBucket" or "projects/my-project/topics/my-topic".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#resource CloudfunctionsFunction#resource}
     */
    readonly resource: string;
    /**
     * failure_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#failure_policy CloudfunctionsFunction#failure_policy}
     */
    readonly failurePolicy?: CloudfunctionsFunctionEventTriggerFailurePolicy;
}
export declare class CloudfunctionsFunctionEventTriggerOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _eventType?;
    get eventType(): string;
    set eventType(value: string);
    get eventTypeInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    get resourceInput(): string | undefined;
    private _failurePolicy?;
    private __failurePolicyOutput;
    get failurePolicy(): CloudfunctionsFunctionEventTriggerFailurePolicyOutputReference;
    putFailurePolicy(value: CloudfunctionsFunctionEventTriggerFailurePolicy | undefined): void;
    resetFailurePolicy(): void;
    get failurePolicyInput(): CloudfunctionsFunctionEventTriggerFailurePolicy | undefined;
}
export interface CloudfunctionsFunctionSourceRepository {
    /**
     * The URL pointing to the hosted repository where the function is defined.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#url CloudfunctionsFunction#url}
     */
    readonly url: string;
}
export declare class CloudfunctionsFunctionSourceRepositoryOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export interface CloudfunctionsFunctionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#create CloudfunctionsFunction#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#delete CloudfunctionsFunction#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#read CloudfunctionsFunction#read}.
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html#update CloudfunctionsFunction#update}.
     */
    readonly update?: string;
}
export declare class CloudfunctionsFunctionTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string | undefined;
    set read(value: string | undefined);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html google_cloudfunctions_function}.
 */
export declare class CloudfunctionsFunction extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function.html google_cloudfunctions_function} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: CloudfunctionsFunctionConfig);
    private _availableMemoryMb?;
    get availableMemoryMb(): number | undefined;
    set availableMemoryMb(value: number | undefined);
    resetAvailableMemoryMb(): void;
    get availableMemoryMbInput(): number | undefined;
    private _buildEnvironmentVariables?;
    get buildEnvironmentVariables(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set buildEnvironmentVariables(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetBuildEnvironmentVariables(): void;
    get buildEnvironmentVariablesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _entryPoint?;
    get entryPoint(): string | undefined;
    set entryPoint(value: string | undefined);
    resetEntryPoint(): void;
    get entryPointInput(): string | undefined;
    private _environmentVariables?;
    get environmentVariables(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set environmentVariables(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetEnvironmentVariables(): void;
    get environmentVariablesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _httpsTriggerUrl?;
    get httpsTriggerUrl(): string | undefined;
    set httpsTriggerUrl(value: string | undefined);
    resetHttpsTriggerUrl(): void;
    get httpsTriggerUrlInput(): string | undefined;
    get id(): string;
    private _ingressSettings?;
    get ingressSettings(): string | undefined;
    set ingressSettings(value: string | undefined);
    resetIngressSettings(): void;
    get ingressSettingsInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _maxInstances?;
    get maxInstances(): number | undefined;
    set maxInstances(value: number | undefined);
    resetMaxInstances(): void;
    get maxInstancesInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _runtime?;
    get runtime(): string;
    set runtime(value: string);
    get runtimeInput(): string | undefined;
    private _serviceAccountEmail?;
    get serviceAccountEmail(): string | undefined;
    set serviceAccountEmail(value: string | undefined);
    resetServiceAccountEmail(): void;
    get serviceAccountEmailInput(): string | undefined;
    private _sourceArchiveBucket?;
    get sourceArchiveBucket(): string | undefined;
    set sourceArchiveBucket(value: string | undefined);
    resetSourceArchiveBucket(): void;
    get sourceArchiveBucketInput(): string | undefined;
    private _sourceArchiveObject?;
    get sourceArchiveObject(): string | undefined;
    set sourceArchiveObject(value: string | undefined);
    resetSourceArchiveObject(): void;
    get sourceArchiveObjectInput(): string | undefined;
    private _timeout?;
    get timeout(): number | undefined;
    set timeout(value: number | undefined);
    resetTimeout(): void;
    get timeoutInput(): number | undefined;
    private _triggerHttp?;
    get triggerHttp(): boolean | cdktf.IResolvable | undefined;
    set triggerHttp(value: boolean | cdktf.IResolvable | undefined);
    resetTriggerHttp(): void;
    get triggerHttpInput(): boolean | cdktf.IResolvable | undefined;
    private _vpcConnector?;
    get vpcConnector(): string | undefined;
    set vpcConnector(value: string | undefined);
    resetVpcConnector(): void;
    get vpcConnectorInput(): string | undefined;
    private _vpcConnectorEgressSettings?;
    get vpcConnectorEgressSettings(): string | undefined;
    set vpcConnectorEgressSettings(value: string | undefined);
    resetVpcConnectorEgressSettings(): void;
    get vpcConnectorEgressSettingsInput(): string | undefined;
    private _eventTrigger?;
    private __eventTriggerOutput;
    get eventTrigger(): CloudfunctionsFunctionEventTriggerOutputReference;
    putEventTrigger(value: CloudfunctionsFunctionEventTrigger | undefined): void;
    resetEventTrigger(): void;
    get eventTriggerInput(): CloudfunctionsFunctionEventTrigger | undefined;
    private _sourceRepository?;
    private __sourceRepositoryOutput;
    get sourceRepository(): CloudfunctionsFunctionSourceRepositoryOutputReference;
    putSourceRepository(value: CloudfunctionsFunctionSourceRepository | undefined): void;
    resetSourceRepository(): void;
    get sourceRepositoryInput(): CloudfunctionsFunctionSourceRepository | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): CloudfunctionsFunctionTimeoutsOutputReference;
    putTimeouts(value: CloudfunctionsFunctionTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): CloudfunctionsFunctionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
