import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudbuildTriggerConfig extends cdktf.TerraformMetaArguments {
    /**
     * Human-readable description of the trigger.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#description CloudbuildTrigger#description}
     */
    readonly description?: string;
    /**
     * Whether the trigger is disabled or not. If true, the trigger will never result in a build.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#disabled CloudbuildTrigger#disabled}
     */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
     * Path, from the source root, to a file whose contents is used for the template.
     *
     * Either a filename or build template must be provided.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#filename CloudbuildTrigger#filename}
     */
    readonly filename?: string;
    /**
     * ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match extended with support for '**'.
     *
     * If ignoredFiles and changed files are both empty, then they are not
     * used to determine whether or not to trigger a build.
     *
     * If ignoredFiles is not empty, then we ignore any files that match any
     * of the ignored_file globs. If the change has no files that are outside
     * of the ignoredFiles globs, then we do not trigger a build.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#ignored_files CloudbuildTrigger#ignored_files}
     */
    readonly ignoredFiles?: string[];
    /**
     * ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match extended with support for '**'.
     *
     * If any of the files altered in the commit pass the ignoredFiles filter
     * and includedFiles is empty, then as far as this filter is concerned, we
     * should trigger the build.
     *
     * If any of the files altered in the commit pass the ignoredFiles filter
     * and includedFiles is not empty, then we make sure that at least one of
     * those files matches a includedFiles glob. If not, then we do not trigger
     * a build.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#included_files CloudbuildTrigger#included_files}
     */
    readonly includedFiles?: string[];
    /**
     * Name of the trigger. Must be unique within the project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#name CloudbuildTrigger#name}
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#project CloudbuildTrigger#project}.
     */
    readonly project?: string;
    /**
     * The service account used for all user-controlled operations including triggers.patch, triggers.run, builds.create, and builds.cancel.
     *
     * If no service account is set, then the standard Cloud Build service account
     * ([PROJECT_NUM]@system.gserviceaccount.com) will be used instead.
     *
     * Format: projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT_ID_OR_EMAIL}
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#service_account CloudbuildTrigger#service_account}
     */
    readonly serviceAccount?: string;
    /**
     * Substitutions data for Build resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#substitutions CloudbuildTrigger#substitutions}
     */
    readonly substitutions?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Tags for annotation of a BuildTrigger.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#tags CloudbuildTrigger#tags}
     */
    readonly tags?: string[];
    /**
     * build block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#build CloudbuildTrigger#build}
     */
    readonly buildAttribute?: CloudbuildTriggerBuild;
    /**
     * github block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#github CloudbuildTrigger#github}
     */
    readonly github?: CloudbuildTriggerGithub;
    /**
     * pubsub_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#pubsub_config CloudbuildTrigger#pubsub_config}
     */
    readonly pubsubConfig?: CloudbuildTriggerPubsubConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#timeouts CloudbuildTrigger#timeouts}
     */
    readonly timeouts?: CloudbuildTriggerTimeouts;
    /**
     * trigger_template block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#trigger_template CloudbuildTrigger#trigger_template}
     */
    readonly triggerTemplate?: CloudbuildTriggerTriggerTemplate;
    /**
     * webhook_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#webhook_config CloudbuildTrigger#webhook_config}
     */
    readonly webhookConfig?: CloudbuildTriggerWebhookConfig;
}
export interface CloudbuildTriggerBuildArtifactsObjects {
    /**
     * Cloud Storage bucket and optional object path, in the form "gs://bucket/path/to/somewhere/".
     *
     * Files in the workspace matching any path pattern will be uploaded to Cloud Storage with
     * this location as a prefix.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#location CloudbuildTrigger#location}
     */
    readonly location?: string;
    /**
     * Path globs used to match files in the build's workspace.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#paths CloudbuildTrigger#paths}
     */
    readonly paths?: string[];
}
export declare class CloudbuildTriggerBuildArtifactsObjectsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _location?;
    get location(): string | undefined;
    set location(value: string | undefined);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _paths?;
    get paths(): string[] | undefined;
    set paths(value: string[] | undefined);
    resetPaths(): void;
    get pathsInput(): string[] | undefined;
}
export interface CloudbuildTriggerBuildArtifacts {
    /**
     * A list of images to be pushed upon the successful completion of all build steps.
     *
     * The images will be pushed using the builder service account's credentials.
     *
     * The digests of the pushed images will be stored in the Build resource's results field.
     *
     * If any of the images fail to be pushed, the build is marked FAILURE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#images CloudbuildTrigger#images}
     */
    readonly images?: string[];
    /**
     * objects block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#objects CloudbuildTrigger#objects}
     */
    readonly objects?: CloudbuildTriggerBuildArtifactsObjects;
}
export declare class CloudbuildTriggerBuildArtifactsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _images?;
    get images(): string[] | undefined;
    set images(value: string[] | undefined);
    resetImages(): void;
    get imagesInput(): string[] | undefined;
    private _objects?;
    private __objectsOutput;
    get objects(): CloudbuildTriggerBuildArtifactsObjectsOutputReference;
    putObjects(value: CloudbuildTriggerBuildArtifactsObjects | undefined): void;
    resetObjects(): void;
    get objectsInput(): CloudbuildTriggerBuildArtifactsObjects | undefined;
}
export interface CloudbuildTriggerBuildOptionsVolumes {
    /**
     * Name of the volume to mount.
     *
     * Volume names must be unique per build step and must be valid names for Docker volumes.
     * Each named volume must be used by at least two build steps.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#name CloudbuildTrigger#name}
     */
    readonly name?: string;
    /**
     * Path at which to mount the volume.
     *
     * Paths must be absolute and cannot conflict with other volume paths on the same
     * build step or with certain reserved volume paths.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#path CloudbuildTrigger#path}
     */
    readonly path?: string;
}
export interface CloudbuildTriggerBuildOptions {
    /**
     * Requested disk size for the VM that runs the build.
     *
     * Note that this is NOT "disk free";
     * some of the space will be used by the operating system and build utilities.
     * Also note that this is the minimum disk size that will be allocated for the build --
     * the build may run with a larger disk than requested. At present, the maximum disk size
     * is 1000GB; builds that request more than the maximum are rejected with an error.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#disk_size_gb CloudbuildTrigger#disk_size_gb}
     */
    readonly diskSizeGb?: number;
    /**
     * Option to specify whether or not to apply bash style string operations to the substitutions.
     *
     * NOTE this is always enabled for triggered builds and cannot be overridden in the build configuration file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#dynamic_substitutions CloudbuildTrigger#dynamic_substitutions}
     */
    readonly dynamicSubstitutions?: boolean | cdktf.IResolvable;
    /**
     * A list of global environment variable definitions that will exist for all build steps in this build.
     *
     * If a variable is defined in both globally and in a build step,
     * the variable will use the build step value.
     *
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#env CloudbuildTrigger#env}
     */
    readonly env?: string[];
    /**
     * Option to define build log streaming behavior to Google Cloud Storage. Possible values: ["STREAM_DEFAULT", "STREAM_ON", "STREAM_OFF"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#log_streaming_option CloudbuildTrigger#log_streaming_option}
     */
    readonly logStreamingOption?: string;
    /**
     * Option to specify the logging mode, which determines if and where build logs are stored.
     *
     * Possible values: ["LOGGING_UNSPECIFIED", "LEGACY", "GCS_ONLY", "STACKDRIVER_ONLY", "NONE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#logging CloudbuildTrigger#logging}
     */
    readonly logging?: string;
    /**
     * Compute Engine machine type on which to run the build. Possible values: ["UNSPECIFIED", "N1_HIGHCPU_8", "N1_HIGHCPU_32", "E2_HIGHCPU_8", "E2_HIGHCPU_32"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#machine_type CloudbuildTrigger#machine_type}
     */
    readonly machineType?: string;
    /**
     * Requested verifiability options. Possible values: ["NOT_VERIFIED", "VERIFIED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#requested_verify_option CloudbuildTrigger#requested_verify_option}
     */
    readonly requestedVerifyOption?: string;
    /**
     * A list of global environment variables, which are encrypted using a Cloud Key Management Service crypto key.
     *
     * These values must be specified in the build's Secret. These variables
     * will be available to all build steps in this build.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#secret_env CloudbuildTrigger#secret_env}
     */
    readonly secretEnv?: string[];
    /**
     * Requested hash for SourceProvenance. Possible values: ["NONE", "SHA256", "MD5"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#source_provenance_hash CloudbuildTrigger#source_provenance_hash}
     */
    readonly sourceProvenanceHash?: string[];
    /**
     * Option to specify behavior when there is an error in the substitution checks.
     *
     * NOTE this is always set to ALLOW_LOOSE for triggered builds and cannot be overridden
     * in the build configuration file. Possible values: ["MUST_MATCH", "ALLOW_LOOSE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#substitution_option CloudbuildTrigger#substitution_option}
     */
    readonly substitutionOption?: string;
    /**
     * Option to specify a WorkerPool for the build. Format projects/{project}/workerPools/{workerPool}.
     *
     * This field is experimental.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#worker_pool CloudbuildTrigger#worker_pool}
     */
    readonly workerPool?: string;
    /**
     * volumes block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#volumes CloudbuildTrigger#volumes}
     */
    readonly volumes?: CloudbuildTriggerBuildOptionsVolumes[];
}
export declare class CloudbuildTriggerBuildOptionsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _diskSizeGb?;
    get diskSizeGb(): number | undefined;
    set diskSizeGb(value: number | undefined);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _dynamicSubstitutions?;
    get dynamicSubstitutions(): boolean | cdktf.IResolvable | undefined;
    set dynamicSubstitutions(value: boolean | cdktf.IResolvable | undefined);
    resetDynamicSubstitutions(): void;
    get dynamicSubstitutionsInput(): boolean | cdktf.IResolvable | undefined;
    private _env?;
    get env(): string[] | undefined;
    set env(value: string[] | undefined);
    resetEnv(): void;
    get envInput(): string[] | undefined;
    private _logStreamingOption?;
    get logStreamingOption(): string | undefined;
    set logStreamingOption(value: string | undefined);
    resetLogStreamingOption(): void;
    get logStreamingOptionInput(): string | undefined;
    private _logging?;
    get logging(): string | undefined;
    set logging(value: string | undefined);
    resetLogging(): void;
    get loggingInput(): string | undefined;
    private _machineType?;
    get machineType(): string | undefined;
    set machineType(value: string | undefined);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _requestedVerifyOption?;
    get requestedVerifyOption(): string | undefined;
    set requestedVerifyOption(value: string | undefined);
    resetRequestedVerifyOption(): void;
    get requestedVerifyOptionInput(): string | undefined;
    private _secretEnv?;
    get secretEnv(): string[] | undefined;
    set secretEnv(value: string[] | undefined);
    resetSecretEnv(): void;
    get secretEnvInput(): string[] | undefined;
    private _sourceProvenanceHash?;
    get sourceProvenanceHash(): string[] | undefined;
    set sourceProvenanceHash(value: string[] | undefined);
    resetSourceProvenanceHash(): void;
    get sourceProvenanceHashInput(): string[] | undefined;
    private _substitutionOption?;
    get substitutionOption(): string | undefined;
    set substitutionOption(value: string | undefined);
    resetSubstitutionOption(): void;
    get substitutionOptionInput(): string | undefined;
    private _workerPool?;
    get workerPool(): string | undefined;
    set workerPool(value: string | undefined);
    resetWorkerPool(): void;
    get workerPoolInput(): string | undefined;
    private _volumes?;
    get volumes(): CloudbuildTriggerBuildOptionsVolumes[] | undefined;
    set volumes(value: CloudbuildTriggerBuildOptionsVolumes[] | undefined);
    resetVolumes(): void;
    get volumesInput(): CloudbuildTriggerBuildOptionsVolumes[] | undefined;
}
export interface CloudbuildTriggerBuildSecret {
    /**
     * Cloud KMS key name to use to decrypt these envs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#kms_key_name CloudbuildTrigger#kms_key_name}
     */
    readonly kmsKeyName: string;
    /**
     * Map of environment variable name to its encrypted value.
     *
     * Secret environment variables must be unique across all of a build's secrets,
     * and must be used by at least one build step. Values can be at most 64 KB in size.
     * There can be at most 100 secret values across all of a build's secrets.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#secret_env CloudbuildTrigger#secret_env}
     */
    readonly secretEnv?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export interface CloudbuildTriggerBuildSourceRepoSource {
    /**
     * Regex matching branches to build.
     *
     * Exactly one a of branch name, tag, or commit SHA must be provided.
     * The syntax of the regular expressions accepted is the syntax accepted by RE2 and
     * described at https://github.com/google/re2/wiki/Syntax
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#branch_name CloudbuildTrigger#branch_name}
     */
    readonly branchName?: string;
    /**
     * Explicit commit SHA to build. Exactly one a of branch name, tag, or commit SHA must be provided.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#commit_sha CloudbuildTrigger#commit_sha}
     */
    readonly commitSha?: string;
    /**
     * Directory, relative to the source root, in which to run the build.
     *
     * This must be a relative path. If a step's dir is specified and is an absolute path,
     * this value is ignored for that step's execution.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#dir CloudbuildTrigger#dir}
     */
    readonly dir?: string;
    /**
     * Only trigger a build if the revision regex does NOT match the revision regex.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#invert_regex CloudbuildTrigger#invert_regex}
     */
    readonly invertRegex?: boolean | cdktf.IResolvable;
    /**
     * ID of the project that owns the Cloud Source Repository.
     *
     * If omitted, the project ID requesting the build is assumed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#project_id CloudbuildTrigger#project_id}
     */
    readonly projectId?: string;
    /**
     * Name of the Cloud Source Repository.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#repo_name CloudbuildTrigger#repo_name}
     */
    readonly repoName: string;
    /**
     * Substitutions to use in a triggered build. Should only be used with triggers.run.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#substitutions CloudbuildTrigger#substitutions}
     */
    readonly substitutions?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Regex matching tags to build.
     *
     * Exactly one a of branch name, tag, or commit SHA must be provided.
     * The syntax of the regular expressions accepted is the syntax accepted by RE2 and
     * described at https://github.com/google/re2/wiki/Syntax
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#tag_name CloudbuildTrigger#tag_name}
     */
    readonly tagName?: string;
}
export declare class CloudbuildTriggerBuildSourceRepoSourceOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _branchName?;
    get branchName(): string | undefined;
    set branchName(value: string | undefined);
    resetBranchName(): void;
    get branchNameInput(): string | undefined;
    private _commitSha?;
    get commitSha(): string | undefined;
    set commitSha(value: string | undefined);
    resetCommitSha(): void;
    get commitShaInput(): string | undefined;
    private _dir?;
    get dir(): string | undefined;
    set dir(value: string | undefined);
    resetDir(): void;
    get dirInput(): string | undefined;
    private _invertRegex?;
    get invertRegex(): boolean | cdktf.IResolvable | undefined;
    set invertRegex(value: boolean | cdktf.IResolvable | undefined);
    resetInvertRegex(): void;
    get invertRegexInput(): boolean | cdktf.IResolvable | undefined;
    private _projectId?;
    get projectId(): string | undefined;
    set projectId(value: string | undefined);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
    private _repoName?;
    get repoName(): string;
    set repoName(value: string);
    get repoNameInput(): string | undefined;
    private _substitutions?;
    get substitutions(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set substitutions(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetSubstitutions(): void;
    get substitutionsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _tagName?;
    get tagName(): string | undefined;
    set tagName(value: string | undefined);
    resetTagName(): void;
    get tagNameInput(): string | undefined;
}
export interface CloudbuildTriggerBuildSourceStorageSource {
    /**
     * Google Cloud Storage bucket containing the source.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#bucket CloudbuildTrigger#bucket}
     */
    readonly bucket: string;
    /**
     * Google Cloud Storage generation for the object.  If the generation is omitted, the latest generation will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#generation CloudbuildTrigger#generation}
     */
    readonly generation?: string;
    /**
     * Google Cloud Storage object containing the source. This object must be a gzipped archive file (.tar.gz) containing source to build.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#object CloudbuildTrigger#object}
     */
    readonly object: string;
}
export declare class CloudbuildTriggerBuildSourceStorageSourceOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _generation?;
    get generation(): string | undefined;
    set generation(value: string | undefined);
    resetGeneration(): void;
    get generationInput(): string | undefined;
    private _object?;
    get object(): string;
    set object(value: string);
    get objectInput(): string | undefined;
}
export interface CloudbuildTriggerBuildSource {
    /**
     * repo_source block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#repo_source CloudbuildTrigger#repo_source}
     */
    readonly repoSource?: CloudbuildTriggerBuildSourceRepoSource;
    /**
     * storage_source block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#storage_source CloudbuildTrigger#storage_source}
     */
    readonly storageSource?: CloudbuildTriggerBuildSourceStorageSource;
}
export declare class CloudbuildTriggerBuildSourceOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _repoSource?;
    private __repoSourceOutput;
    get repoSource(): CloudbuildTriggerBuildSourceRepoSourceOutputReference;
    putRepoSource(value: CloudbuildTriggerBuildSourceRepoSource | undefined): void;
    resetRepoSource(): void;
    get repoSourceInput(): CloudbuildTriggerBuildSourceRepoSource | undefined;
    private _storageSource?;
    private __storageSourceOutput;
    get storageSource(): CloudbuildTriggerBuildSourceStorageSourceOutputReference;
    putStorageSource(value: CloudbuildTriggerBuildSourceStorageSource | undefined): void;
    resetStorageSource(): void;
    get storageSourceInput(): CloudbuildTriggerBuildSourceStorageSource | undefined;
}
export interface CloudbuildTriggerBuildStepVolumes {
    /**
     * Name of the volume to mount.
     *
     * Volume names must be unique per build step and must be valid names for
     * Docker volumes. Each named volume must be used by at least two build steps.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#name CloudbuildTrigger#name}
     */
    readonly name: string;
    /**
     * Path at which to mount the volume.
     *
     * Paths must be absolute and cannot conflict with other volume paths on
     * the same build step or with certain reserved volume paths.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#path CloudbuildTrigger#path}
     */
    readonly path: string;
}
export interface CloudbuildTriggerBuildStep {
    /**
     * A list of arguments that will be presented to the step when it is started.
     *
     * If the image used to run the step's container has an entrypoint, the args
     * are used as arguments to that entrypoint. If the image does not define an
     * entrypoint, the first element in args is used as the entrypoint, and the
     * remainder will be used as arguments.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#args CloudbuildTrigger#args}
     */
    readonly args?: string[];
    /**
     * Working directory to use when running this step's container.
     *
     * If this value is a relative path, it is relative to the build's working
     * directory. If this value is absolute, it may be outside the build's working
     * directory, in which case the contents of the path may not be persisted
     * across build step executions, unless a 'volume' for that path is specified.
     *
     * If the build specifies a 'RepoSource' with 'dir' and a step with a
     * 'dir',
     * which specifies an absolute path, the 'RepoSource' 'dir' is ignored
     * for the step's execution.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#dir CloudbuildTrigger#dir}
     */
    readonly dir?: string;
    /**
     * Entrypoint to be used instead of the build step image's default entrypoint. If unset, the image's default entrypoint is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#entrypoint CloudbuildTrigger#entrypoint}
     */
    readonly entrypoint?: string;
    /**
     * A list of environment variable definitions to be used when running a step.
     *
     * The elements are of the form "KEY=VALUE" for the environment variable
     * "KEY" being given the value "VALUE".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#env CloudbuildTrigger#env}
     */
    readonly env?: string[];
    /**
     * Unique identifier for this build step, used in 'wait_for' to reference this build step as a dependency.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#id CloudbuildTrigger#id}
     */
    readonly id?: string;
    /**
     * The name of the container image that will run this particular build step.
     *
     * If the image is available in the host's Docker daemon's cache, it will be
     * run directly. If not, the host will attempt to pull the image first, using
     * the builder service account's credentials if necessary.
     *
     * The Docker daemon's cache will already have the latest versions of all of
     * the officially supported build steps (see https://github.com/GoogleCloudPlatform/cloud-builders
     * for images and examples).
     * The Docker daemon will also have cached many of the layers for some popular
     * images, like "ubuntu", "debian", but they will be refreshed at the time
     * you attempt to use them.
     *
     * If you built an image in a previous build step, it will be stored in the
     * host's Docker daemon's cache and is available to use as the name for a
     * later build step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#name CloudbuildTrigger#name}
     */
    readonly name: string;
    /**
     * A list of environment variables which are encrypted using a Cloud Key Management Service crypto key.
     *
     * These values must be specified in
     * the build's 'Secret'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#secret_env CloudbuildTrigger#secret_env}
     */
    readonly secretEnv?: string[];
    /**
     * Time limit for executing this build step.
     *
     * If not defined,
     * the step has no
     * time limit and will be allowed to continue to run until either it
     * completes or the build itself times out.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#timeout CloudbuildTrigger#timeout}
     */
    readonly timeout?: string;
    /**
     * Output only. Stores timing information for executing this build step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#timing CloudbuildTrigger#timing}
     */
    readonly timing?: string;
    /**
     * The ID(s) of the step(s) that this build step depends on.
     *
     * This build step will not start until all the build steps in 'wait_for'
     * have completed successfully. If 'wait_for' is empty, this build step
     * will start when all previous build steps in the 'Build.Steps' list
     * have completed successfully.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#wait_for CloudbuildTrigger#wait_for}
     */
    readonly waitFor?: string[];
    /**
     * volumes block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#volumes CloudbuildTrigger#volumes}
     */
    readonly volumes?: CloudbuildTriggerBuildStepVolumes[];
}
export interface CloudbuildTriggerBuild {
    /**
     * A list of images to be pushed upon the successful completion of all build steps.
     *
     * The images are pushed using the builder service account's credentials.
     * The digests of the pushed images will be stored in the Build resource's results field.
     * If any of the images fail to be pushed, the build status is marked FAILURE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#images CloudbuildTrigger#images}
     */
    readonly images?: string[];
    /**
     * Google Cloud Storage bucket where logs should be written.  Logs file names will be of the format ${logsBucket}/log-${build_id}.txt.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#logs_bucket CloudbuildTrigger#logs_bucket}
     */
    readonly logsBucket?: string;
    /**
     * TTL in queue for this build.
     *
     * If provided and the build is enqueued longer than this value,
     * the build will expire and the build status will be EXPIRED.
     * The TTL starts ticking from createTime.
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#queue_ttl CloudbuildTrigger#queue_ttl}
     */
    readonly queueTtl?: string;
    /**
     * Substitutions data for Build resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#substitutions CloudbuildTrigger#substitutions}
     */
    readonly substitutions?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Tags for annotation of a Build. These are not docker tags.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#tags CloudbuildTrigger#tags}
     */
    readonly tags?: string[];
    /**
     * Amount of time that this build should be allowed to run, to second granularity.
     *
     * If this amount of time elapses, work on the build will cease and the build status will be TIMEOUT.
     * This timeout must be equal to or greater than the sum of the timeouts for build steps within the build.
     * The expected format is the number of seconds followed by s.
     * Default time is ten minutes (600s).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#timeout CloudbuildTrigger#timeout}
     */
    readonly timeout?: string;
    /**
     * artifacts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#artifacts CloudbuildTrigger#artifacts}
     */
    readonly artifacts?: CloudbuildTriggerBuildArtifacts;
    /**
     * options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#options CloudbuildTrigger#options}
     */
    readonly options?: CloudbuildTriggerBuildOptions;
    /**
     * secret block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#secret CloudbuildTrigger#secret}
     */
    readonly secret?: CloudbuildTriggerBuildSecret[];
    /**
     * source block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#source CloudbuildTrigger#source}
     */
    readonly source?: CloudbuildTriggerBuildSource;
    /**
     * step block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#step CloudbuildTrigger#step}
     */
    readonly step: CloudbuildTriggerBuildStep[];
}
export declare class CloudbuildTriggerBuildOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _images?;
    get images(): string[] | undefined;
    set images(value: string[] | undefined);
    resetImages(): void;
    get imagesInput(): string[] | undefined;
    private _logsBucket?;
    get logsBucket(): string | undefined;
    set logsBucket(value: string | undefined);
    resetLogsBucket(): void;
    get logsBucketInput(): string | undefined;
    private _queueTtl?;
    get queueTtl(): string | undefined;
    set queueTtl(value: string | undefined);
    resetQueueTtl(): void;
    get queueTtlInput(): string | undefined;
    private _substitutions?;
    get substitutions(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set substitutions(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetSubstitutions(): void;
    get substitutionsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _tags?;
    get tags(): string[] | undefined;
    set tags(value: string[] | undefined);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _timeout?;
    get timeout(): string | undefined;
    set timeout(value: string | undefined);
    resetTimeout(): void;
    get timeoutInput(): string | undefined;
    private _artifacts?;
    private __artifactsOutput;
    get artifacts(): CloudbuildTriggerBuildArtifactsOutputReference;
    putArtifacts(value: CloudbuildTriggerBuildArtifacts | undefined): void;
    resetArtifacts(): void;
    get artifactsInput(): CloudbuildTriggerBuildArtifacts | undefined;
    private _options?;
    private __optionsOutput;
    get options(): CloudbuildTriggerBuildOptionsOutputReference;
    putOptions(value: CloudbuildTriggerBuildOptions | undefined): void;
    resetOptions(): void;
    get optionsInput(): CloudbuildTriggerBuildOptions | undefined;
    private _secret?;
    get secret(): CloudbuildTriggerBuildSecret[] | undefined;
    set secret(value: CloudbuildTriggerBuildSecret[] | undefined);
    resetSecret(): void;
    get secretInput(): CloudbuildTriggerBuildSecret[] | undefined;
    private _source?;
    private __sourceOutput;
    get source(): CloudbuildTriggerBuildSourceOutputReference;
    putSource(value: CloudbuildTriggerBuildSource | undefined): void;
    resetSource(): void;
    get sourceInput(): CloudbuildTriggerBuildSource | undefined;
    private _step?;
    get step(): CloudbuildTriggerBuildStep[];
    set step(value: CloudbuildTriggerBuildStep[]);
    get stepInput(): CloudbuildTriggerBuildStep[] | undefined;
}
export interface CloudbuildTriggerGithubPullRequest {
    /**
     * Regex of branches to match.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#branch CloudbuildTrigger#branch}
     */
    readonly branch: string;
    /**
     * Whether to block builds on a "/gcbrun" comment from a repository owner or collaborator. Possible values: ["COMMENTS_DISABLED", "COMMENTS_ENABLED", "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#comment_control CloudbuildTrigger#comment_control}
     */
    readonly commentControl?: string;
    /**
     * If true, branches that do NOT match the git_ref will trigger a build.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#invert_regex CloudbuildTrigger#invert_regex}
     */
    readonly invertRegex?: boolean | cdktf.IResolvable;
}
export declare class CloudbuildTriggerGithubPullRequestOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _branch?;
    get branch(): string;
    set branch(value: string);
    get branchInput(): string | undefined;
    private _commentControl?;
    get commentControl(): string | undefined;
    set commentControl(value: string | undefined);
    resetCommentControl(): void;
    get commentControlInput(): string | undefined;
    private _invertRegex?;
    get invertRegex(): boolean | cdktf.IResolvable | undefined;
    set invertRegex(value: boolean | cdktf.IResolvable | undefined);
    resetInvertRegex(): void;
    get invertRegexInput(): boolean | cdktf.IResolvable | undefined;
}
export interface CloudbuildTriggerGithubPush {
    /**
     * Regex of branches to match.  Specify only one of branch or tag.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#branch CloudbuildTrigger#branch}
     */
    readonly branch?: string;
    /**
     * When true, only trigger a build if the revision regex does NOT match the git_ref regex.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#invert_regex CloudbuildTrigger#invert_regex}
     */
    readonly invertRegex?: boolean | cdktf.IResolvable;
    /**
     * Regex of tags to match.  Specify only one of branch or tag.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#tag CloudbuildTrigger#tag}
     */
    readonly tag?: string;
}
export declare class CloudbuildTriggerGithubPushOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _branch?;
    get branch(): string | undefined;
    set branch(value: string | undefined);
    resetBranch(): void;
    get branchInput(): string | undefined;
    private _invertRegex?;
    get invertRegex(): boolean | cdktf.IResolvable | undefined;
    set invertRegex(value: boolean | cdktf.IResolvable | undefined);
    resetInvertRegex(): void;
    get invertRegexInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    get tag(): string | undefined;
    set tag(value: string | undefined);
    resetTag(): void;
    get tagInput(): string | undefined;
}
export interface CloudbuildTriggerGithub {
    /**
     * Name of the repository. For example: The name for https://github.com/googlecloudplatform/cloud-builders is "cloud-builders".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#name CloudbuildTrigger#name}
     */
    readonly name?: string;
    /**
     * Owner of the repository. For example: The owner for https://github.com/googlecloudplatform/cloud-builders is "googlecloudplatform".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#owner CloudbuildTrigger#owner}
     */
    readonly owner?: string;
    /**
     * pull_request block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#pull_request CloudbuildTrigger#pull_request}
     */
    readonly pullRequest?: CloudbuildTriggerGithubPullRequest;
    /**
     * push block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#push CloudbuildTrigger#push}
     */
    readonly push?: CloudbuildTriggerGithubPush;
}
export declare class CloudbuildTriggerGithubOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    resetName(): void;
    get nameInput(): string | undefined;
    private _owner?;
    get owner(): string | undefined;
    set owner(value: string | undefined);
    resetOwner(): void;
    get ownerInput(): string | undefined;
    private _pullRequest?;
    private __pullRequestOutput;
    get pullRequest(): CloudbuildTriggerGithubPullRequestOutputReference;
    putPullRequest(value: CloudbuildTriggerGithubPullRequest | undefined): void;
    resetPullRequest(): void;
    get pullRequestInput(): CloudbuildTriggerGithubPullRequest | undefined;
    private _push?;
    private __pushOutput;
    get push(): CloudbuildTriggerGithubPushOutputReference;
    putPush(value: CloudbuildTriggerGithubPush | undefined): void;
    resetPush(): void;
    get pushInput(): CloudbuildTriggerGithubPush | undefined;
}
export interface CloudbuildTriggerPubsubConfig {
    /**
     * Service account that will make the push request.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#service_account_email CloudbuildTrigger#service_account_email}
     */
    readonly serviceAccountEmail?: string;
    /**
     * The name of the topic from which this subscription is receiving messages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#topic CloudbuildTrigger#topic}
     */
    readonly topic: string;
}
export declare class CloudbuildTriggerPubsubConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _serviceAccountEmail?;
    get serviceAccountEmail(): string | undefined;
    set serviceAccountEmail(value: string | undefined);
    resetServiceAccountEmail(): void;
    get serviceAccountEmailInput(): string | undefined;
    private _topic?;
    get topic(): string;
    set topic(value: string);
    get topicInput(): string | undefined;
}
export interface CloudbuildTriggerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#create CloudbuildTrigger#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#delete CloudbuildTrigger#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#update CloudbuildTrigger#update}.
     */
    readonly update?: string;
}
export declare class CloudbuildTriggerTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface CloudbuildTriggerTriggerTemplate {
    /**
     * Name of the branch to build.
     *
     * Exactly one a of branch name, tag, or commit SHA must be provided.
     * This field is a regular expression.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#branch_name CloudbuildTrigger#branch_name}
     */
    readonly branchName?: string;
    /**
     * Explicit commit SHA to build. Exactly one of a branch name, tag, or commit SHA must be provided.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#commit_sha CloudbuildTrigger#commit_sha}
     */
    readonly commitSha?: string;
    /**
     * Directory, relative to the source root, in which to run the build.
     *
     * This must be a relative path. If a step's dir is specified and
     * is an absolute path, this value is ignored for that step's
     * execution.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#dir CloudbuildTrigger#dir}
     */
    readonly dir?: string;
    /**
     * Only trigger a build if the revision regex does NOT match the revision regex.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#invert_regex CloudbuildTrigger#invert_regex}
     */
    readonly invertRegex?: boolean | cdktf.IResolvable;
    /**
     * ID of the project that owns the Cloud Source Repository. If omitted, the project ID requesting the build is assumed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#project_id CloudbuildTrigger#project_id}
     */
    readonly projectId?: string;
    /**
     * Name of the Cloud Source Repository. If omitted, the name "default" is assumed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#repo_name CloudbuildTrigger#repo_name}
     */
    readonly repoName?: string;
    /**
     * Name of the tag to build.
     *
     * Exactly one of a branch name, tag, or commit SHA must be provided.
     * This field is a regular expression.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#tag_name CloudbuildTrigger#tag_name}
     */
    readonly tagName?: string;
}
export declare class CloudbuildTriggerTriggerTemplateOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _branchName?;
    get branchName(): string | undefined;
    set branchName(value: string | undefined);
    resetBranchName(): void;
    get branchNameInput(): string | undefined;
    private _commitSha?;
    get commitSha(): string | undefined;
    set commitSha(value: string | undefined);
    resetCommitSha(): void;
    get commitShaInput(): string | undefined;
    private _dir?;
    get dir(): string | undefined;
    set dir(value: string | undefined);
    resetDir(): void;
    get dirInput(): string | undefined;
    private _invertRegex?;
    get invertRegex(): boolean | cdktf.IResolvable | undefined;
    set invertRegex(value: boolean | cdktf.IResolvable | undefined);
    resetInvertRegex(): void;
    get invertRegexInput(): boolean | cdktf.IResolvable | undefined;
    private _projectId?;
    get projectId(): string | undefined;
    set projectId(value: string | undefined);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
    private _repoName?;
    get repoName(): string | undefined;
    set repoName(value: string | undefined);
    resetRepoName(): void;
    get repoNameInput(): string | undefined;
    private _tagName?;
    get tagName(): string | undefined;
    set tagName(value: string | undefined);
    resetTagName(): void;
    get tagNameInput(): string | undefined;
}
export interface CloudbuildTriggerWebhookConfig {
    /**
     * Resource name for the secret required as a URL parameter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#secret CloudbuildTrigger#secret}
     */
    readonly secret: string;
}
export declare class CloudbuildTriggerWebhookConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _secret?;
    get secret(): string;
    set secret(value: string);
    get secretInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html google_cloudbuild_trigger}.
 */
export declare class CloudbuildTrigger extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html google_cloudbuild_trigger} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config?: CloudbuildTriggerConfig);
    get createTime(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable | undefined;
    set disabled(value: boolean | cdktf.IResolvable | undefined);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filename?;
    get filename(): string | undefined;
    set filename(value: string | undefined);
    resetFilename(): void;
    get filenameInput(): string | undefined;
    get id(): string;
    private _ignoredFiles?;
    get ignoredFiles(): string[] | undefined;
    set ignoredFiles(value: string[] | undefined);
    resetIgnoredFiles(): void;
    get ignoredFilesInput(): string[] | undefined;
    private _includedFiles?;
    get includedFiles(): string[] | undefined;
    set includedFiles(value: string[] | undefined);
    resetIncludedFiles(): void;
    get includedFilesInput(): string[] | undefined;
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    resetName(): void;
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _serviceAccount?;
    get serviceAccount(): string | undefined;
    set serviceAccount(value: string | undefined);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _substitutions?;
    get substitutions(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set substitutions(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetSubstitutions(): void;
    get substitutionsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _tags?;
    get tags(): string[] | undefined;
    set tags(value: string[] | undefined);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    get triggerId(): string;
    private _build?;
    private __buildOutput;
    get buildAttribute(): CloudbuildTriggerBuildOutputReference;
    putBuildAttribute(value: CloudbuildTriggerBuild | undefined): void;
    resetBuildAttribute(): void;
    get buildAttributeInput(): CloudbuildTriggerBuild | undefined;
    private _github?;
    private __githubOutput;
    get github(): CloudbuildTriggerGithubOutputReference;
    putGithub(value: CloudbuildTriggerGithub | undefined): void;
    resetGithub(): void;
    get githubInput(): CloudbuildTriggerGithub | undefined;
    private _pubsubConfig?;
    private __pubsubConfigOutput;
    get pubsubConfig(): CloudbuildTriggerPubsubConfigOutputReference;
    putPubsubConfig(value: CloudbuildTriggerPubsubConfig | undefined): void;
    resetPubsubConfig(): void;
    get pubsubConfigInput(): CloudbuildTriggerPubsubConfig | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): CloudbuildTriggerTimeoutsOutputReference;
    putTimeouts(value: CloudbuildTriggerTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): CloudbuildTriggerTimeouts | undefined;
    private _triggerTemplate?;
    private __triggerTemplateOutput;
    get triggerTemplate(): CloudbuildTriggerTriggerTemplateOutputReference;
    putTriggerTemplate(value: CloudbuildTriggerTriggerTemplate | undefined): void;
    resetTriggerTemplate(): void;
    get triggerTemplateInput(): CloudbuildTriggerTriggerTemplate | undefined;
    private _webhookConfig?;
    private __webhookConfigOutput;
    get webhookConfig(): CloudbuildTriggerWebhookConfigOutputReference;
    putWebhookConfig(value: CloudbuildTriggerWebhookConfig | undefined): void;
    resetWebhookConfig(): void;
    get webhookConfigInput(): CloudbuildTriggerWebhookConfig | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
