import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudTasksQueueConfig extends cdktf.TerraformMetaArguments {
    /**
     * The location of the queue.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#location CloudTasksQueue#location}
     */
    readonly location: string;
    /**
     * The queue name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#name CloudTasksQueue#name}
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#project CloudTasksQueue#project}.
     */
    readonly project?: string;
    /**
     * app_engine_routing_override block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#app_engine_routing_override CloudTasksQueue#app_engine_routing_override}
     */
    readonly appEngineRoutingOverride?: CloudTasksQueueAppEngineRoutingOverride;
    /**
     * rate_limits block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#rate_limits CloudTasksQueue#rate_limits}
     */
    readonly rateLimits?: CloudTasksQueueRateLimits;
    /**
     * retry_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#retry_config CloudTasksQueue#retry_config}
     */
    readonly retryConfig?: CloudTasksQueueRetryConfig;
    /**
     * stackdriver_logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#stackdriver_logging_config CloudTasksQueue#stackdriver_logging_config}
     */
    readonly stackdriverLoggingConfig?: CloudTasksQueueStackdriverLoggingConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#timeouts CloudTasksQueue#timeouts}
     */
    readonly timeouts?: CloudTasksQueueTimeouts;
}
export interface CloudTasksQueueAppEngineRoutingOverride {
    /**
     * App instance.
     *
     * By default, the task is sent to an instance which is available when the task is attempted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#instance CloudTasksQueue#instance}
     */
    readonly instance?: string;
    /**
     * App service.
     *
     * By default, the task is sent to the service which is the default service when the task is attempted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#service CloudTasksQueue#service}
     */
    readonly service?: string;
    /**
     * App version.
     *
     * By default, the task is sent to the version which is the default version when the task is attempted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#version CloudTasksQueue#version}
     */
    readonly version?: string;
}
export declare class CloudTasksQueueAppEngineRoutingOverrideOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _instance?;
    get instance(): string | undefined;
    set instance(value: string | undefined);
    resetInstance(): void;
    get instanceInput(): string | undefined;
    private _service?;
    get service(): string | undefined;
    set service(value: string | undefined);
    resetService(): void;
    get serviceInput(): string | undefined;
    private _version?;
    get version(): string | undefined;
    set version(value: string | undefined);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export interface CloudTasksQueueRateLimits {
    /**
     * The maximum number of concurrent tasks that Cloud Tasks allows to be dispatched for this queue.
     *
     * After this threshold has been
     * reached, Cloud Tasks stops dispatching tasks until the number of
     * concurrent requests decreases.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#max_concurrent_dispatches CloudTasksQueue#max_concurrent_dispatches}
     */
    readonly maxConcurrentDispatches?: number;
    /**
     * The maximum rate at which tasks are dispatched from this queue.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the default.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#max_dispatches_per_second CloudTasksQueue#max_dispatches_per_second}
     */
    readonly maxDispatchesPerSecond?: number;
}
export declare class CloudTasksQueueRateLimitsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _maxConcurrentDispatches?;
    get maxConcurrentDispatches(): number | undefined;
    set maxConcurrentDispatches(value: number | undefined);
    resetMaxConcurrentDispatches(): void;
    get maxConcurrentDispatchesInput(): number | undefined;
    private _maxDispatchesPerSecond?;
    get maxDispatchesPerSecond(): number | undefined;
    set maxDispatchesPerSecond(value: number | undefined);
    resetMaxDispatchesPerSecond(): void;
    get maxDispatchesPerSecondInput(): number | undefined;
}
export interface CloudTasksQueueRetryConfig {
    /**
     * Number of attempts per task.
     *
     * Cloud Tasks will attempt the task maxAttempts times (that is, if
     * the first attempt fails, then there will be maxAttempts - 1
     * retries). Must be >= -1.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick
     * the default.
     *
     * -1 indicates unlimited attempts.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#max_attempts CloudTasksQueue#max_attempts}
     */
    readonly maxAttempts?: number;
    /**
     * A task will be scheduled for retry between minBackoff and maxBackoff duration after it fails, if the queue's RetryConfig specifies that the task should be retried.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#max_backoff CloudTasksQueue#max_backoff}
     */
    readonly maxBackoff?: string;
    /**
     * The time between retries will double maxDoublings times.
     *
     * A task's retry interval starts at minBackoff, then doubles maxDoublings times,
     * then increases linearly, and finally retries retries at intervals of maxBackoff
     * up to maxAttempts times.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#max_doublings CloudTasksQueue#max_doublings}
     */
    readonly maxDoublings?: number;
    /**
     * If positive, maxRetryDuration specifies the time limit for retrying a failed task, measured from when the task was first attempted.
     *
     * Once maxRetryDuration time has passed and the task has
     * been attempted maxAttempts times, no further attempts will be
     * made and the task will be deleted.
     *
     * If zero, then the task age is unlimited.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#max_retry_duration CloudTasksQueue#max_retry_duration}
     */
    readonly maxRetryDuration?: string;
    /**
     * A task will be scheduled for retry between minBackoff and maxBackoff duration after it fails, if the queue's RetryConfig specifies that the task should be retried.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#min_backoff CloudTasksQueue#min_backoff}
     */
    readonly minBackoff?: string;
}
export declare class CloudTasksQueueRetryConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _maxAttempts?;
    get maxAttempts(): number | undefined;
    set maxAttempts(value: number | undefined);
    resetMaxAttempts(): void;
    get maxAttemptsInput(): number | undefined;
    private _maxBackoff?;
    get maxBackoff(): string | undefined;
    set maxBackoff(value: string | undefined);
    resetMaxBackoff(): void;
    get maxBackoffInput(): string | undefined;
    private _maxDoublings?;
    get maxDoublings(): number | undefined;
    set maxDoublings(value: number | undefined);
    resetMaxDoublings(): void;
    get maxDoublingsInput(): number | undefined;
    private _maxRetryDuration?;
    get maxRetryDuration(): string | undefined;
    set maxRetryDuration(value: string | undefined);
    resetMaxRetryDuration(): void;
    get maxRetryDurationInput(): string | undefined;
    private _minBackoff?;
    get minBackoff(): string | undefined;
    set minBackoff(value: string | undefined);
    resetMinBackoff(): void;
    get minBackoffInput(): string | undefined;
}
export interface CloudTasksQueueStackdriverLoggingConfig {
    /**
     * Specifies the fraction of operations to write to Stackdriver Logging.
     *
     * This field may contain any value between 0.0 and 1.0, inclusive. 0.0 is the
     * default and means that no operations are logged.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#sampling_ratio CloudTasksQueue#sampling_ratio}
     */
    readonly samplingRatio: number;
}
export declare class CloudTasksQueueStackdriverLoggingConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _samplingRatio?;
    get samplingRatio(): number;
    set samplingRatio(value: number);
    get samplingRatioInput(): number | undefined;
}
export interface CloudTasksQueueTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#create CloudTasksQueue#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#delete CloudTasksQueue#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html#update CloudTasksQueue#update}.
     */
    readonly update?: string;
}
export declare class CloudTasksQueueTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html google_cloud_tasks_queue}.
 */
export declare class CloudTasksQueue extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue.html google_cloud_tasks_queue} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: CloudTasksQueueConfig);
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    resetName(): void;
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _appEngineRoutingOverride?;
    private __appEngineRoutingOverrideOutput;
    get appEngineRoutingOverride(): CloudTasksQueueAppEngineRoutingOverrideOutputReference;
    putAppEngineRoutingOverride(value: CloudTasksQueueAppEngineRoutingOverride | undefined): void;
    resetAppEngineRoutingOverride(): void;
    get appEngineRoutingOverrideInput(): CloudTasksQueueAppEngineRoutingOverride | undefined;
    private _rateLimits?;
    private __rateLimitsOutput;
    get rateLimits(): CloudTasksQueueRateLimitsOutputReference;
    putRateLimits(value: CloudTasksQueueRateLimits | undefined): void;
    resetRateLimits(): void;
    get rateLimitsInput(): CloudTasksQueueRateLimits | undefined;
    private _retryConfig?;
    private __retryConfigOutput;
    get retryConfig(): CloudTasksQueueRetryConfigOutputReference;
    putRetryConfig(value: CloudTasksQueueRetryConfig | undefined): void;
    resetRetryConfig(): void;
    get retryConfigInput(): CloudTasksQueueRetryConfig | undefined;
    private _stackdriverLoggingConfig?;
    private __stackdriverLoggingConfigOutput;
    get stackdriverLoggingConfig(): CloudTasksQueueStackdriverLoggingConfigOutputReference;
    putStackdriverLoggingConfig(value: CloudTasksQueueStackdriverLoggingConfig | undefined): void;
    resetStackdriverLoggingConfig(): void;
    get stackdriverLoggingConfigInput(): CloudTasksQueueStackdriverLoggingConfig | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): CloudTasksQueueTimeoutsOutputReference;
    putTimeouts(value: CloudTasksQueueTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): CloudTasksQueueTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
