import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudSchedulerJobConfig extends cdktf.TerraformMetaArguments {
    /**
     * The deadline for job attempts.
     *
     * If the request handler does not respond by this deadline then the request is
     * cancelled and the attempt is marked as a DEADLINE_EXCEEDED failure. The failed attempt can be viewed in
     * execution logs. Cloud Scheduler will retry the job according to the RetryConfig.
     * The allowed duration for this deadline is:
     * For HTTP targets, between 15 seconds and 30 minutes.
     * For App Engine HTTP targets, between 15 seconds and 24 hours.
     * **Note**: For PubSub targets, this field is ignored - setting it will introduce an unresolvable diff.
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s"
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#attempt_deadline CloudSchedulerJob#attempt_deadline}
     */
    readonly attemptDeadline?: string;
    /**
     * A human-readable description for the job.  This string must not contain more than 500 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#description CloudSchedulerJob#description}
     */
    readonly description?: string;
    /**
     * The name of the job.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#name CloudSchedulerJob#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#project CloudSchedulerJob#project}.
     */
    readonly project?: string;
    /**
     * Region where the scheduler job resides. If it is not provided, Terraform will use the provider default.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#region CloudSchedulerJob#region}
     */
    readonly region?: string;
    /**
     * Describes the schedule on which the job will be executed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#schedule CloudSchedulerJob#schedule}
     */
    readonly schedule?: string;
    /**
     * Specifies the time zone to be used in interpreting schedule.
     *
     * The value of this field must be a time zone name from the tz database.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#time_zone CloudSchedulerJob#time_zone}
     */
    readonly timeZone?: string;
    /**
     * app_engine_http_target block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#app_engine_http_target CloudSchedulerJob#app_engine_http_target}
     */
    readonly appEngineHttpTarget?: CloudSchedulerJobAppEngineHttpTarget;
    /**
     * http_target block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#http_target CloudSchedulerJob#http_target}
     */
    readonly httpTarget?: CloudSchedulerJobHttpTarget;
    /**
     * pubsub_target block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#pubsub_target CloudSchedulerJob#pubsub_target}
     */
    readonly pubsubTarget?: CloudSchedulerJobPubsubTarget;
    /**
     * retry_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#retry_config CloudSchedulerJob#retry_config}
     */
    readonly retryConfig?: CloudSchedulerJobRetryConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#timeouts CloudSchedulerJob#timeouts}
     */
    readonly timeouts?: CloudSchedulerJobTimeouts;
}
export interface CloudSchedulerJobAppEngineHttpTargetAppEngineRouting {
    /**
     * App instance. By default, the job is sent to an instance which is available when the job is attempted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#instance CloudSchedulerJob#instance}
     */
    readonly instance?: string;
    /**
     * App service.
     *
     * By default, the job is sent to the service which is the default service when the job is attempted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#service CloudSchedulerJob#service}
     */
    readonly service?: string;
    /**
     * App version.
     *
     * By default, the job is sent to the version which is the default version when the job is attempted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#version CloudSchedulerJob#version}
     */
    readonly version?: string;
}
export declare class CloudSchedulerJobAppEngineHttpTargetAppEngineRoutingOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _instance?;
    get instance(): string | undefined;
    set instance(value: string | undefined);
    resetInstance(): void;
    get instanceInput(): string | undefined;
    private _service?;
    get service(): string | undefined;
    set service(value: string | undefined);
    resetService(): void;
    get serviceInput(): string | undefined;
    private _version?;
    get version(): string | undefined;
    set version(value: string | undefined);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export interface CloudSchedulerJobAppEngineHttpTarget {
    /**
     * HTTP request body.
     *
     * A request body is allowed only if the HTTP method is POST or PUT.
     * It will result in invalid argument error to set a body on a job with an incompatible HttpMethod.
     *
     * A base64-encoded string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#body CloudSchedulerJob#body}
     */
    readonly body?: string;
    /**
     * HTTP request headers.
     *
     * This map contains the header field names and values.
     * Headers can be set when the job is created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#headers CloudSchedulerJob#headers}
     */
    readonly headers?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Which HTTP method to use for the request.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#http_method CloudSchedulerJob#http_method}
     */
    readonly httpMethod?: string;
    /**
     * The relative URI.
     *
     * The relative URL must begin with "/" and must be a valid HTTP relative URL.
     * It can contain a path, query string arguments, and \# fragments.
     * If the relative URL is empty, then the root path "/" will be used.
     * No spaces are allowed, and the maximum length allowed is 2083 characters
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#relative_uri CloudSchedulerJob#relative_uri}
     */
    readonly relativeUri: string;
    /**
     * app_engine_routing block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#app_engine_routing CloudSchedulerJob#app_engine_routing}
     */
    readonly appEngineRouting?: CloudSchedulerJobAppEngineHttpTargetAppEngineRouting;
}
export declare class CloudSchedulerJobAppEngineHttpTargetOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _body?;
    get body(): string | undefined;
    set body(value: string | undefined);
    resetBody(): void;
    get bodyInput(): string | undefined;
    private _headers?;
    get headers(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set headers(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _httpMethod?;
    get httpMethod(): string | undefined;
    set httpMethod(value: string | undefined);
    resetHttpMethod(): void;
    get httpMethodInput(): string | undefined;
    private _relativeUri?;
    get relativeUri(): string;
    set relativeUri(value: string);
    get relativeUriInput(): string | undefined;
    private _appEngineRouting?;
    private __appEngineRoutingOutput;
    get appEngineRouting(): CloudSchedulerJobAppEngineHttpTargetAppEngineRoutingOutputReference;
    putAppEngineRouting(value: CloudSchedulerJobAppEngineHttpTargetAppEngineRouting | undefined): void;
    resetAppEngineRouting(): void;
    get appEngineRoutingInput(): CloudSchedulerJobAppEngineHttpTargetAppEngineRouting | undefined;
}
export interface CloudSchedulerJobHttpTargetOauthToken {
    /**
     * OAuth scope to be used for generating OAuth access token. If not specified, "https://www.googleapis.com/auth/cloud-platform" will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#scope CloudSchedulerJob#scope}
     */
    readonly scope?: string;
    /**
     * Service account email to be used for generating OAuth token.
     *
     * The service account must be within the same project as the job.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#service_account_email CloudSchedulerJob#service_account_email}
     */
    readonly serviceAccountEmail: string;
}
export declare class CloudSchedulerJobHttpTargetOauthTokenOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _scope?;
    get scope(): string | undefined;
    set scope(value: string | undefined);
    resetScope(): void;
    get scopeInput(): string | undefined;
    private _serviceAccountEmail?;
    get serviceAccountEmail(): string;
    set serviceAccountEmail(value: string);
    get serviceAccountEmailInput(): string | undefined;
}
export interface CloudSchedulerJobHttpTargetOidcToken {
    /**
     * Audience to be used when generating OIDC token. If not specified, the URI specified in target will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#audience CloudSchedulerJob#audience}
     */
    readonly audience?: string;
    /**
     * Service account email to be used for generating OAuth token.
     *
     * The service account must be within the same project as the job.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#service_account_email CloudSchedulerJob#service_account_email}
     */
    readonly serviceAccountEmail: string;
}
export declare class CloudSchedulerJobHttpTargetOidcTokenOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _audience?;
    get audience(): string | undefined;
    set audience(value: string | undefined);
    resetAudience(): void;
    get audienceInput(): string | undefined;
    private _serviceAccountEmail?;
    get serviceAccountEmail(): string;
    set serviceAccountEmail(value: string);
    get serviceAccountEmailInput(): string | undefined;
}
export interface CloudSchedulerJobHttpTarget {
    /**
     * HTTP request body.
     *
     * A request body is allowed only if the HTTP method is POST, PUT, or PATCH.
     * It is an error to set body on a job with an incompatible HttpMethod.
     *
     * A base64-encoded string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#body CloudSchedulerJob#body}
     */
    readonly body?: string;
    /**
     * This map contains the header field names and values.
     *
     * Repeated headers are not supported, but a header value can contain commas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#headers CloudSchedulerJob#headers}
     */
    readonly headers?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Which HTTP method to use for the request.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#http_method CloudSchedulerJob#http_method}
     */
    readonly httpMethod?: string;
    /**
     * The full URI path that the request will be sent to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#uri CloudSchedulerJob#uri}
     */
    readonly uri: string;
    /**
     * oauth_token block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#oauth_token CloudSchedulerJob#oauth_token}
     */
    readonly oauthToken?: CloudSchedulerJobHttpTargetOauthToken;
    /**
     * oidc_token block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#oidc_token CloudSchedulerJob#oidc_token}
     */
    readonly oidcToken?: CloudSchedulerJobHttpTargetOidcToken;
}
export declare class CloudSchedulerJobHttpTargetOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _body?;
    get body(): string | undefined;
    set body(value: string | undefined);
    resetBody(): void;
    get bodyInput(): string | undefined;
    private _headers?;
    get headers(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set headers(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _httpMethod?;
    get httpMethod(): string | undefined;
    set httpMethod(value: string | undefined);
    resetHttpMethod(): void;
    get httpMethodInput(): string | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
    private _oauthToken?;
    private __oauthTokenOutput;
    get oauthToken(): CloudSchedulerJobHttpTargetOauthTokenOutputReference;
    putOauthToken(value: CloudSchedulerJobHttpTargetOauthToken | undefined): void;
    resetOauthToken(): void;
    get oauthTokenInput(): CloudSchedulerJobHttpTargetOauthToken | undefined;
    private _oidcToken?;
    private __oidcTokenOutput;
    get oidcToken(): CloudSchedulerJobHttpTargetOidcTokenOutputReference;
    putOidcToken(value: CloudSchedulerJobHttpTargetOidcToken | undefined): void;
    resetOidcToken(): void;
    get oidcTokenInput(): CloudSchedulerJobHttpTargetOidcToken | undefined;
}
export interface CloudSchedulerJobPubsubTarget {
    /**
     * Attributes for PubsubMessage. Pubsub message must contain either non-empty data, or at least one attribute.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#attributes CloudSchedulerJob#attributes}
     */
    readonly attributes?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The message payload for PubsubMessage. Pubsub message must contain either non-empty data, or at least one attribute.
     *
     * A base64-encoded string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#data CloudSchedulerJob#data}
     */
    readonly data?: string;
    /**
     * The full resource name for the Cloud Pub/Sub topic to which messages will be published when a job is delivered.
     *
     * ~>**NOTE:**
     * The topic name must be in the same format as required by PubSub's
     * PublishRequest.name, e.g. 'projects/my-project/topics/my-topic'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#topic_name CloudSchedulerJob#topic_name}
     */
    readonly topicName: string;
}
export declare class CloudSchedulerJobPubsubTargetOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _attributes?;
    get attributes(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set attributes(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetAttributes(): void;
    get attributesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _data?;
    get data(): string | undefined;
    set data(value: string | undefined);
    resetData(): void;
    get dataInput(): string | undefined;
    private _topicName?;
    get topicName(): string;
    set topicName(value: string);
    get topicNameInput(): string | undefined;
}
export interface CloudSchedulerJobRetryConfig {
    /**
     * The maximum amount of time to wait before retrying a job after it fails.
     *
     * A duration in seconds with up to nine fractional digits, terminated by 's'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#max_backoff_duration CloudSchedulerJob#max_backoff_duration}
     */
    readonly maxBackoffDuration?: string;
    /**
     * The time between retries will double maxDoublings times.
     *
     * A job's retry interval starts at minBackoffDuration,
     * then doubles maxDoublings times, then increases linearly,
     * and finally retries retries at intervals of maxBackoffDuration up to retryCount times.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#max_doublings CloudSchedulerJob#max_doublings}
     */
    readonly maxDoublings?: number;
    /**
     * The time limit for retrying a failed job, measured from time when an execution was first attempted.
     *
     * If specified with retryCount, the job will be retried until both limits are reached.
     * A duration in seconds with up to nine fractional digits, terminated by 's'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#max_retry_duration CloudSchedulerJob#max_retry_duration}
     */
    readonly maxRetryDuration?: string;
    /**
     * The minimum amount of time to wait before retrying a job after it fails.
     *
     * A duration in seconds with up to nine fractional digits, terminated by 's'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#min_backoff_duration CloudSchedulerJob#min_backoff_duration}
     */
    readonly minBackoffDuration?: string;
    /**
     * The number of attempts that the system will make to run a  job using the exponential backoff procedure described by maxDoublings.
     *
     * Values greater than 5 and negative values are not allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#retry_count CloudSchedulerJob#retry_count}
     */
    readonly retryCount?: number;
}
export declare class CloudSchedulerJobRetryConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _maxBackoffDuration?;
    get maxBackoffDuration(): string | undefined;
    set maxBackoffDuration(value: string | undefined);
    resetMaxBackoffDuration(): void;
    get maxBackoffDurationInput(): string | undefined;
    private _maxDoublings?;
    get maxDoublings(): number | undefined;
    set maxDoublings(value: number | undefined);
    resetMaxDoublings(): void;
    get maxDoublingsInput(): number | undefined;
    private _maxRetryDuration?;
    get maxRetryDuration(): string | undefined;
    set maxRetryDuration(value: string | undefined);
    resetMaxRetryDuration(): void;
    get maxRetryDurationInput(): string | undefined;
    private _minBackoffDuration?;
    get minBackoffDuration(): string | undefined;
    set minBackoffDuration(value: string | undefined);
    resetMinBackoffDuration(): void;
    get minBackoffDurationInput(): string | undefined;
    private _retryCount?;
    get retryCount(): number | undefined;
    set retryCount(value: number | undefined);
    resetRetryCount(): void;
    get retryCountInput(): number | undefined;
}
export interface CloudSchedulerJobTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#create CloudSchedulerJob#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#delete CloudSchedulerJob#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html#update CloudSchedulerJob#update}.
     */
    readonly update?: string;
}
export declare class CloudSchedulerJobTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html google_cloud_scheduler_job}.
 */
export declare class CloudSchedulerJob extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job.html google_cloud_scheduler_job} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: CloudSchedulerJobConfig);
    private _attemptDeadline?;
    get attemptDeadline(): string | undefined;
    set attemptDeadline(value: string | undefined);
    resetAttemptDeadline(): void;
    get attemptDeadlineInput(): string | undefined;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _schedule?;
    get schedule(): string | undefined;
    set schedule(value: string | undefined);
    resetSchedule(): void;
    get scheduleInput(): string | undefined;
    private _timeZone?;
    get timeZone(): string | undefined;
    set timeZone(value: string | undefined);
    resetTimeZone(): void;
    get timeZoneInput(): string | undefined;
    private _appEngineHttpTarget?;
    private __appEngineHttpTargetOutput;
    get appEngineHttpTarget(): CloudSchedulerJobAppEngineHttpTargetOutputReference;
    putAppEngineHttpTarget(value: CloudSchedulerJobAppEngineHttpTarget | undefined): void;
    resetAppEngineHttpTarget(): void;
    get appEngineHttpTargetInput(): CloudSchedulerJobAppEngineHttpTarget | undefined;
    private _httpTarget?;
    private __httpTargetOutput;
    get httpTarget(): CloudSchedulerJobHttpTargetOutputReference;
    putHttpTarget(value: CloudSchedulerJobHttpTarget | undefined): void;
    resetHttpTarget(): void;
    get httpTargetInput(): CloudSchedulerJobHttpTarget | undefined;
    private _pubsubTarget?;
    private __pubsubTargetOutput;
    get pubsubTarget(): CloudSchedulerJobPubsubTargetOutputReference;
    putPubsubTarget(value: CloudSchedulerJobPubsubTarget | undefined): void;
    resetPubsubTarget(): void;
    get pubsubTargetInput(): CloudSchedulerJobPubsubTarget | undefined;
    private _retryConfig?;
    private __retryConfigOutput;
    get retryConfig(): CloudSchedulerJobRetryConfigOutputReference;
    putRetryConfig(value: CloudSchedulerJobRetryConfig | undefined): void;
    resetRetryConfig(): void;
    get retryConfigInput(): CloudSchedulerJobRetryConfig | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): CloudSchedulerJobTimeoutsOutputReference;
    putTimeouts(value: CloudSchedulerJobTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): CloudSchedulerJobTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
