import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudRunServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#autogenerate_revision_name CloudRunService#autogenerate_revision_name}.
     */
    readonly autogenerateRevisionName?: boolean | cdktf.IResolvable;
    /**
     * The location of the cloud run instance. eg us-central1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#location CloudRunService#location}
     */
    readonly location: string;
    /**
     * Name must be unique within a namespace, within a Cloud Run region.
     *
     * Is required when creating resources. Name is primarily intended
     * for creation idempotence and configuration definition. Cannot be updated.
     * More info: http://kubernetes.io/docs/user-guide/identifiers#names
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#name CloudRunService#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#project CloudRunService#project}.
     */
    readonly project?: string;
    /**
     * metadata block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#metadata CloudRunService#metadata}
     */
    readonly metadata?: CloudRunServiceMetadata;
    /**
     * template block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#template CloudRunService#template}
     */
    readonly template?: CloudRunServiceTemplate;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#timeouts CloudRunService#timeouts}
     */
    readonly timeouts?: CloudRunServiceTimeouts;
    /**
     * traffic block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#traffic CloudRunService#traffic}
     */
    readonly traffic?: CloudRunServiceTraffic[];
}
export declare class CloudRunServiceStatusConditions extends cdktf.ComplexComputedList {
    get message(): string;
    get reason(): string;
    get status(): string;
    get type(): string;
}
export declare class CloudRunServiceStatus extends cdktf.ComplexComputedList {
    get conditions(): any;
    get latestCreatedRevisionName(): string;
    get latestReadyRevisionName(): string;
    get observedGeneration(): number;
    get url(): string;
}
export interface CloudRunServiceMetadata {
    /**
     * Annotations is a key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata.
     *
     * More
     * info: http://kubernetes.io/docs/user-guide/annotations
     *
     * *Note**: The Cloud Run API may add additional annotations that were not provided in your config.
     * If terraform plan shows a diff where a server-side annotation is added, you can add it to your config
     * or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
     *
     * Cloud Run (fully managed) uses the following annotation keys to configure features on a Service:
     *
     * - 'run.googleapis.com/ingress' sets the [ingress settings](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--ingress)
     * for the Service. For example, '"run.googleapis.com/ingress" = "all"'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#annotations CloudRunService#annotations}
     */
    readonly annotations?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Map of string keys and values that can be used to organize and categorize (scope and select) objects.
     *
     * May match selectors of replication controllers
     * and routes.
     * More info: http://kubernetes.io/docs/user-guide/labels
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#labels CloudRunService#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * In Cloud Run the namespace must be equal to either the project ID or project number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#namespace CloudRunService#namespace}
     */
    readonly namespace?: string;
}
export declare class CloudRunServiceMetadataOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set annotations(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetAnnotations(): void;
    get annotationsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _namespace?;
    get namespace(): string | undefined;
    set namespace(value: string | undefined);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
export interface CloudRunServiceTemplateMetadata {
    /**
     * Annotations is a key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata.
     *
     * More
     * info: http://kubernetes.io/docs/user-guide/annotations
     *
     * *Note**: The Cloud Run API may add additional annotations that were not provided in your config.
     * If terraform plan shows a diff where a server-side annotation is added, you can add it to your config
     * or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#annotations CloudRunService#annotations}
     */
    readonly annotations?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Map of string keys and values that can be used to organize and categorize (scope and select) objects.
     *
     * May match selectors of replication controllers
     * and routes.
     * More info: http://kubernetes.io/docs/user-guide/labels
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#labels CloudRunService#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Name must be unique within a namespace, within a Cloud Run region.
     *
     * Is required when creating resources. Name is primarily intended
     * for creation idempotence and configuration definition. Cannot be updated.
     * More info: http://kubernetes.io/docs/user-guide/identifiers#names
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#name CloudRunService#name}
     */
    readonly name?: string;
    /**
     * In Cloud Run the namespace must be equal to either the project ID or project number.
     *
     * It will default to the resource's project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#namespace CloudRunService#namespace}
     */
    readonly namespace?: string;
}
export declare class CloudRunServiceTemplateMetadataOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set annotations(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetAnnotations(): void;
    get annotationsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string | undefined;
    set namespace(value: string | undefined);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
export interface CloudRunServiceTemplateSpecContainersEnv {
    /**
     * Name of the environment variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#name CloudRunService#name}
     */
    readonly name?: string;
    /**
     * Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any route environment variables.
     *
     * If a variable cannot be resolved,
     * the reference in the input string will be unchanged. The $(VAR_NAME)
     * syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
     * references will never be expanded, regardless of whether the variable
     * exists or not.
     * Defaults to "".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#value CloudRunService#value}
     */
    readonly value?: string;
}
export interface CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference {
    /**
     * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#name CloudRunService#name}
     */
    readonly name: string;
}
export declare class CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReferenceOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface CloudRunServiceTemplateSpecContainersEnvFromConfigMapRef {
    /**
     * Specify whether the ConfigMap must be defined.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#optional CloudRunService#optional}
     */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
     * local_object_reference block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#local_object_reference CloudRunService#local_object_reference}
     */
    readonly localObjectReference?: CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference;
}
export declare class CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _optional?;
    get optional(): boolean | cdktf.IResolvable | undefined;
    set optional(value: boolean | cdktf.IResolvable | undefined);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _localObjectReference?;
    private __localObjectReferenceOutput;
    get localObjectReference(): CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReferenceOutputReference;
    putLocalObjectReference(value: CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference | undefined): void;
    resetLocalObjectReference(): void;
    get localObjectReferenceInput(): CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference | undefined;
}
export interface CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference {
    /**
     * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#name CloudRunService#name}
     */
    readonly name: string;
}
export declare class CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReferenceOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface CloudRunServiceTemplateSpecContainersEnvFromSecretRef {
    /**
     * Specify whether the Secret must be defined.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#optional CloudRunService#optional}
     */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
     * local_object_reference block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#local_object_reference CloudRunService#local_object_reference}
     */
    readonly localObjectReference?: CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference;
}
export declare class CloudRunServiceTemplateSpecContainersEnvFromSecretRefOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _optional?;
    get optional(): boolean | cdktf.IResolvable | undefined;
    set optional(value: boolean | cdktf.IResolvable | undefined);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _localObjectReference?;
    private __localObjectReferenceOutput;
    get localObjectReference(): CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReferenceOutputReference;
    putLocalObjectReference(value: CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference | undefined): void;
    resetLocalObjectReference(): void;
    get localObjectReferenceInput(): CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference | undefined;
}
export interface CloudRunServiceTemplateSpecContainersEnvFrom {
    /**
     * An optional identifier to prepend to each key in the ConfigMap.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#prefix CloudRunService#prefix}
     */
    readonly prefix?: string;
    /**
     * config_map_ref block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#config_map_ref CloudRunService#config_map_ref}
     */
    readonly configMapRef?: CloudRunServiceTemplateSpecContainersEnvFromConfigMapRef;
    /**
     * secret_ref block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#secret_ref CloudRunService#secret_ref}
     */
    readonly secretRef?: CloudRunServiceTemplateSpecContainersEnvFromSecretRef;
}
export interface CloudRunServiceTemplateSpecContainersPorts {
    /**
     * Port number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#container_port CloudRunService#container_port}
     */
    readonly containerPort: number;
    /**
     * Name of the port.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#name CloudRunService#name}
     */
    readonly name?: string;
    /**
     * Protocol used on port. Defaults to TCP.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#protocol CloudRunService#protocol}
     */
    readonly protocol?: string;
}
export interface CloudRunServiceTemplateSpecContainersResources {
    /**
     * Limits describes the maximum amount of compute resources allowed.
     *
     * The values of the map is string form of the 'quantity' k8s type:
     * https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#limits CloudRunService#limits}
     */
    readonly limits?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Requests describes the minimum amount of compute resources required.
     *
     * If Requests is omitted for a container, it defaults to Limits if that is
     * explicitly specified, otherwise to an implementation-defined value.
     * The values of the map is string form of the 'quantity' k8s type:
     * https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#requests CloudRunService#requests}
     */
    readonly requests?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export declare class CloudRunServiceTemplateSpecContainersResourcesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _limits?;
    get limits(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set limits(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLimits(): void;
    get limitsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _requests?;
    get requests(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set requests(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetRequests(): void;
    get requestsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
}
export interface CloudRunServiceTemplateSpecContainers {
    /**
     * Arguments to the entrypoint.
     *
     * The docker image's CMD is used if this is not provided.
     * Variable references $(VAR_NAME) are expanded using the container's
     * environment. If a variable cannot be resolved, the reference in the input
     * string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
     * double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
     * regardless of whether the variable exists or not.
     * More info:
     * https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#args CloudRunService#args}
     */
    readonly args?: string[];
    /**
     * Entrypoint array.
     *
     * Not executed within a shell.
     * The docker image's ENTRYPOINT is used if this is not provided.
     * Variable references $(VAR_NAME) are expanded using the container's
     * environment. If a variable cannot be resolved, the reference in the input
     * string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
     * double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
     * regardless of whether the variable exists or not.
     * More info:
     * https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#command CloudRunService#command}
     */
    readonly command?: string[];
    /**
     * Docker image name.
     *
     * This is most often a reference to a container located
     * in the container registry, such as gcr.io/cloudrun/hello
     * More info: https://kubernetes.io/docs/concepts/containers/images
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#image CloudRunService#image}
     */
    readonly image: string;
    /**
     * Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#working_dir CloudRunService#working_dir}
     */
    readonly workingDir?: string;
    /**
     * env block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#env CloudRunService#env}
     */
    readonly env?: CloudRunServiceTemplateSpecContainersEnv[];
    /**
     * env_from block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#env_from CloudRunService#env_from}
     */
    readonly envFrom?: CloudRunServiceTemplateSpecContainersEnvFrom[];
    /**
     * ports block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#ports CloudRunService#ports}
     */
    readonly ports?: CloudRunServiceTemplateSpecContainersPorts[];
    /**
     * resources block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#resources CloudRunService#resources}
     */
    readonly resources?: CloudRunServiceTemplateSpecContainersResources;
}
export interface CloudRunServiceTemplateSpec {
    /**
     * ContainerConcurrency specifies the maximum allowed in-flight (concurrent) requests per container of the Revision.
     *
     * Values are:
     * - '0' thread-safe, the system should manage the max concurrency. This is
     * the default value.
     * - '1' not-thread-safe. Single concurrency
     * - '2-N' thread-safe, max concurrency of N
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#container_concurrency CloudRunService#container_concurrency}
     */
    readonly containerConcurrency?: number;
    /**
     * Email address of the IAM service account associated with the revision of the service.
     *
     * The service account represents the identity of the running revision,
     * and determines what permissions the revision has. If not provided, the revision
     * will use the project's default service account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#service_account_name CloudRunService#service_account_name}
     */
    readonly serviceAccountName?: string;
    /**
     * TimeoutSeconds holds the max duration the instance is allowed for responding to a request.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#timeout_seconds CloudRunService#timeout_seconds}
     */
    readonly timeoutSeconds?: number;
    /**
     * containers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#containers CloudRunService#containers}
     */
    readonly containers?: CloudRunServiceTemplateSpecContainers[];
}
export declare class CloudRunServiceTemplateSpecOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _containerConcurrency?;
    get containerConcurrency(): number | undefined;
    set containerConcurrency(value: number | undefined);
    resetContainerConcurrency(): void;
    get containerConcurrencyInput(): number | undefined;
    private _serviceAccountName?;
    get serviceAccountName(): string | undefined;
    set serviceAccountName(value: string | undefined);
    resetServiceAccountName(): void;
    get serviceAccountNameInput(): string | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number | undefined;
    set timeoutSeconds(value: number | undefined);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _containers?;
    get containers(): CloudRunServiceTemplateSpecContainers[] | undefined;
    set containers(value: CloudRunServiceTemplateSpecContainers[] | undefined);
    resetContainers(): void;
    get containersInput(): CloudRunServiceTemplateSpecContainers[] | undefined;
}
export interface CloudRunServiceTemplate {
    /**
     * metadata block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#metadata CloudRunService#metadata}
     */
    readonly metadata?: CloudRunServiceTemplateMetadata;
    /**
     * spec block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#spec CloudRunService#spec}
     */
    readonly spec?: CloudRunServiceTemplateSpec;
}
export declare class CloudRunServiceTemplateOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _metadata?;
    private __metadataOutput;
    get metadata(): CloudRunServiceTemplateMetadataOutputReference;
    putMetadata(value: CloudRunServiceTemplateMetadata | undefined): void;
    resetMetadata(): void;
    get metadataInput(): CloudRunServiceTemplateMetadata | undefined;
    private _spec?;
    private __specOutput;
    get spec(): CloudRunServiceTemplateSpecOutputReference;
    putSpec(value: CloudRunServiceTemplateSpec | undefined): void;
    resetSpec(): void;
    get specInput(): CloudRunServiceTemplateSpec | undefined;
}
export interface CloudRunServiceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#create CloudRunService#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#delete CloudRunService#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#update CloudRunService#update}.
     */
    readonly update?: string;
}
export declare class CloudRunServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface CloudRunServiceTraffic {
    /**
     * LatestRevision may be optionally provided to indicate that the latest ready Revision of the Configuration should be used for this traffic target.
     *
     * When
     * provided LatestRevision must be true if RevisionName is empty; it must be
     * false when RevisionName is non-empty.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#latest_revision CloudRunService#latest_revision}
     */
    readonly latestRevision?: boolean | cdktf.IResolvable;
    /**
     * Percent specifies percent of the traffic to this Revision or Configuration.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#percent CloudRunService#percent}
     */
    readonly percent: number;
    /**
     * RevisionName of a specific revision to which to send this portion of traffic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#revision_name CloudRunService#revision_name}
     */
    readonly revisionName?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html google_cloud_run_service}.
 */
export declare class CloudRunService extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html google_cloud_run_service} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: CloudRunServiceConfig);
    private _autogenerateRevisionName?;
    get autogenerateRevisionName(): boolean | cdktf.IResolvable | undefined;
    set autogenerateRevisionName(value: boolean | cdktf.IResolvable | undefined);
    resetAutogenerateRevisionName(): void;
    get autogenerateRevisionNameInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    status(index: string): CloudRunServiceStatus;
    private _metadata?;
    private __metadataOutput;
    get metadata(): CloudRunServiceMetadataOutputReference;
    putMetadata(value: CloudRunServiceMetadata | undefined): void;
    resetMetadata(): void;
    get metadataInput(): CloudRunServiceMetadata | undefined;
    private _template?;
    private __templateOutput;
    get template(): CloudRunServiceTemplateOutputReference;
    putTemplate(value: CloudRunServiceTemplate | undefined): void;
    resetTemplate(): void;
    get templateInput(): CloudRunServiceTemplate | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): CloudRunServiceTimeoutsOutputReference;
    putTimeouts(value: CloudRunServiceTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): CloudRunServiceTimeouts | undefined;
    private _traffic?;
    get traffic(): CloudRunServiceTraffic[] | undefined;
    set traffic(value: CloudRunServiceTraffic[] | undefined);
    resetTraffic(): void;
    get trafficInput(): CloudRunServiceTraffic[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
