import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudRunServiceIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service_iam_policy.html#location CloudRunServiceIamPolicy#location}.
     */
    readonly location?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service_iam_policy.html#policy_data CloudRunServiceIamPolicy#policy_data}.
     */
    readonly policyData: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service_iam_policy.html#project CloudRunServiceIamPolicy#project}.
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service_iam_policy.html#service CloudRunServiceIamPolicy#service}.
     */
    readonly service: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service_iam_policy.html google_cloud_run_service_iam_policy}.
 */
export declare class CloudRunServiceIamPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service_iam_policy.html google_cloud_run_service_iam_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: CloudRunServiceIamPolicyConfig);
    get etag(): string;
    get id(): string;
    private _location?;
    get location(): string | undefined;
    set location(value: string | undefined);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _policyData?;
    get policyData(): string;
    set policyData(value: string);
    get policyDataInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
