import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudRunDomainMappingConfig extends cdktf.TerraformMetaArguments {
    /**
     * The location of the cloud run instance. eg us-central1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html#location CloudRunDomainMapping#location}
     */
    readonly location: string;
    /**
     * Name should be a [verified](https://support.google.com/webmasters/answer/9008080) domain.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html#name CloudRunDomainMapping#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html#project CloudRunDomainMapping#project}.
     */
    readonly project?: string;
    /**
     * metadata block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html#metadata CloudRunDomainMapping#metadata}
     */
    readonly metadata: CloudRunDomainMappingMetadata;
    /**
     * spec block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html#spec CloudRunDomainMapping#spec}
     */
    readonly spec: CloudRunDomainMappingSpec;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html#timeouts CloudRunDomainMapping#timeouts}
     */
    readonly timeouts?: CloudRunDomainMappingTimeouts;
}
export declare class CloudRunDomainMappingStatusConditions extends cdktf.ComplexComputedList {
    get message(): string;
    get reason(): string;
    get status(): string;
    get type(): string;
}
export declare class CloudRunDomainMappingStatusResourceRecords extends cdktf.ComplexComputedList {
    get name(): string;
    get rrdata(): string;
    get type(): string;
}
export declare class CloudRunDomainMappingStatus extends cdktf.ComplexComputedList {
    get conditions(): any;
    get mappedRouteName(): string;
    get observedGeneration(): number;
    get resourceRecords(): any;
}
export interface CloudRunDomainMappingMetadata {
    /**
     * Annotations is a key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata.
     *
     * More
     * info: http://kubernetes.io/docs/user-guide/annotations
     *
     * *Note**: The Cloud Run API may add additional annotations that were not provided in your config.
     * If terraform plan shows a diff where a server-side annotation is added, you can add it to your config
     * or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html#annotations CloudRunDomainMapping#annotations}
     */
    readonly annotations?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Map of string keys and values that can be used to organize and categorize (scope and select) objects.
     *
     * May match selectors of replication controllers
     * and routes.
     * More info: http://kubernetes.io/docs/user-guide/labels
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html#labels CloudRunDomainMapping#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * In Cloud Run the namespace must be equal to either the project ID or project number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html#namespace CloudRunDomainMapping#namespace}
     */
    readonly namespace: string;
}
export declare class CloudRunDomainMappingMetadataOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set annotations(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetAnnotations(): void;
    get annotationsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
}
export interface CloudRunDomainMappingSpec {
    /**
     * The mode of the certificate. Default value: "AUTOMATIC" Possible values: ["NONE", "AUTOMATIC"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html#certificate_mode CloudRunDomainMapping#certificate_mode}
     */
    readonly certificateMode?: string;
    /**
     * If set, the mapping will override any mapping set before this spec was set.
     *
     * It is recommended that the user leaves this empty to receive an error
     * warning about a potential conflict and only set it once the respective UI
     * has given such a warning.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html#force_override CloudRunDomainMapping#force_override}
     */
    readonly forceOverride?: boolean | cdktf.IResolvable;
    /**
     * The name of the Cloud Run Service that this DomainMapping applies to. The route must exist.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html#route_name CloudRunDomainMapping#route_name}
     */
    readonly routeName: string;
}
export declare class CloudRunDomainMappingSpecOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _certificateMode?;
    get certificateMode(): string | undefined;
    set certificateMode(value: string | undefined);
    resetCertificateMode(): void;
    get certificateModeInput(): string | undefined;
    private _forceOverride?;
    get forceOverride(): boolean | cdktf.IResolvable | undefined;
    set forceOverride(value: boolean | cdktf.IResolvable | undefined);
    resetForceOverride(): void;
    get forceOverrideInput(): boolean | cdktf.IResolvable | undefined;
    private _routeName?;
    get routeName(): string;
    set routeName(value: string);
    get routeNameInput(): string | undefined;
}
export interface CloudRunDomainMappingTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html#create CloudRunDomainMapping#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html#delete CloudRunDomainMapping#delete}.
     */
    readonly delete?: string;
}
export declare class CloudRunDomainMappingTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html google_cloud_run_domain_mapping}.
 */
export declare class CloudRunDomainMapping extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping.html google_cloud_run_domain_mapping} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: CloudRunDomainMappingConfig);
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    status(index: string): CloudRunDomainMappingStatus;
    private _metadata?;
    private __metadataOutput;
    get metadata(): CloudRunDomainMappingMetadataOutputReference;
    putMetadata(value: CloudRunDomainMappingMetadata): void;
    get metadataInput(): CloudRunDomainMappingMetadata | undefined;
    private _spec?;
    private __specOutput;
    get spec(): CloudRunDomainMappingSpecOutputReference;
    putSpec(value: CloudRunDomainMappingSpec): void;
    get specInput(): CloudRunDomainMappingSpec | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): CloudRunDomainMappingTimeoutsOutputReference;
    putTimeouts(value: CloudRunDomainMappingTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): CloudRunDomainMappingTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
