import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudIdentityGroupMembershipConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the Group to create this membership in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership.html#group CloudIdentityGroupMembership#group}
     */
    readonly group: string;
    /**
     * preferred_member_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership.html#preferred_member_key CloudIdentityGroupMembership#preferred_member_key}
     */
    readonly preferredMemberKey?: CloudIdentityGroupMembershipPreferredMemberKey;
    /**
     * roles block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership.html#roles CloudIdentityGroupMembership#roles}
     */
    readonly roles: CloudIdentityGroupMembershipRoles[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership.html#timeouts CloudIdentityGroupMembership#timeouts}
     */
    readonly timeouts?: CloudIdentityGroupMembershipTimeouts;
}
export interface CloudIdentityGroupMembershipPreferredMemberKey {
    /**
     * The ID of the entity.
     *
     * For Google-managed entities, the id must be the email address of an existing
     * group or user.
     *
     * For external-identity-mapped entities, the id must be a string conforming
     * to the Identity Source's requirements.
     *
     * Must be unique within a namespace.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership.html#id CloudIdentityGroupMembership#id}
     */
    readonly id: string;
    /**
     * The namespace in which the entity exists.
     *
     * If not specified, the EntityKey represents a Google-managed entity
     * such as a Google user or a Google Group.
     *
     * If specified, the EntityKey represents an external-identity-mapped group.
     * The namespace must correspond to an identity source created in Admin Console
     * and must be in the form of 'identitysources/{identity_source_id}'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership.html#namespace CloudIdentityGroupMembership#namespace}
     */
    readonly namespace?: string;
}
export declare class CloudIdentityGroupMembershipPreferredMemberKeyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string | undefined;
    set namespace(value: string | undefined);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
export interface CloudIdentityGroupMembershipRoles {
    /**
     * The name of the MembershipRole. Must be one of OWNER, MANAGER, MEMBER. Possible values: ["OWNER", "MANAGER", "MEMBER"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership.html#name CloudIdentityGroupMembership#name}
     */
    readonly name: string;
}
export interface CloudIdentityGroupMembershipTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership.html#create CloudIdentityGroupMembership#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership.html#delete CloudIdentityGroupMembership#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership.html#update CloudIdentityGroupMembership#update}.
     */
    readonly update?: string;
}
export declare class CloudIdentityGroupMembershipTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership.html google_cloud_identity_group_membership}.
 */
export declare class CloudIdentityGroupMembership extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership.html google_cloud_identity_group_membership} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: CloudIdentityGroupMembershipConfig);
    get createTime(): string;
    private _group?;
    get group(): string;
    set group(value: string);
    get groupInput(): string | undefined;
    get id(): string;
    get name(): string;
    get type(): string;
    get updateTime(): string;
    private _preferredMemberKey?;
    private __preferredMemberKeyOutput;
    get preferredMemberKey(): CloudIdentityGroupMembershipPreferredMemberKeyOutputReference;
    putPreferredMemberKey(value: CloudIdentityGroupMembershipPreferredMemberKey | undefined): void;
    resetPreferredMemberKey(): void;
    get preferredMemberKeyInput(): CloudIdentityGroupMembershipPreferredMemberKey | undefined;
    private _roles?;
    get roles(): CloudIdentityGroupMembershipRoles[];
    set roles(value: CloudIdentityGroupMembershipRoles[]);
    get rolesInput(): CloudIdentityGroupMembershipRoles[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): CloudIdentityGroupMembershipTimeoutsOutputReference;
    putTimeouts(value: CloudIdentityGroupMembershipTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): CloudIdentityGroupMembershipTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
