import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudAssetFolderFeedConfig extends cdktf.TerraformMetaArguments {
    /**
     * A list of the full names of the assets to receive updates.
     *
     * You must specify either or both of
     * assetNames and assetTypes. Only asset updates matching specified assetNames and assetTypes are
     * exported to the feed. For example: //compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1.
     * See https://cloud.google.com/apis/design/resourceNames#fullResourceName for more info.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed.html#asset_names CloudAssetFolderFeed#asset_names}
     */
    readonly assetNames?: string[];
    /**
     * A list of types of the assets to receive updates.
     *
     * You must specify either or both of assetNames
     * and assetTypes. Only asset updates matching specified assetNames and assetTypes are exported to
     * the feed. For example: "compute.googleapis.com/Disk"
     * See https://cloud.google.com/asset-inventory/docs/supported-asset-types for a list of all
     * supported asset types.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed.html#asset_types CloudAssetFolderFeed#asset_types}
     */
    readonly assetTypes?: string[];
    /**
     * The project whose identity will be used when sending messages to the destination pubsub topic.
     *
     * It also specifies the project for API
     * enablement check, quota, and billing.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed.html#billing_project CloudAssetFolderFeed#billing_project}
     */
    readonly billingProject: string;
    /**
     * Asset content type.
     *
     * If not specified, no content but the asset name and type will be returned. Possible values: ["CONTENT_TYPE_UNSPECIFIED", "RESOURCE", "IAM_POLICY", "ORG_POLICY", "ACCESS_POLICY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed.html#content_type CloudAssetFolderFeed#content_type}
     */
    readonly contentType?: string;
    /**
     * This is the client-assigned asset feed identifier and it needs to be unique under a specific parent.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed.html#feed_id CloudAssetFolderFeed#feed_id}
     */
    readonly feedId: string;
    /**
     * The folder this feed should be created in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed.html#folder CloudAssetFolderFeed#folder}
     */
    readonly folder: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed.html#condition CloudAssetFolderFeed#condition}
     */
    readonly condition?: CloudAssetFolderFeedCondition;
    /**
     * feed_output_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed.html#feed_output_config CloudAssetFolderFeed#feed_output_config}
     */
    readonly feedOutputConfig: CloudAssetFolderFeedFeedOutputConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed.html#timeouts CloudAssetFolderFeed#timeouts}
     */
    readonly timeouts?: CloudAssetFolderFeedTimeouts;
}
export interface CloudAssetFolderFeedCondition {
    /**
     * Description of the expression.
     *
     * This is a longer text which describes the expression,
     * e.g. when hovered over it in a UI.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed.html#description CloudAssetFolderFeed#description}
     */
    readonly description?: string;
    /**
     * Textual representation of an expression in Common Expression Language syntax.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed.html#expression CloudAssetFolderFeed#expression}
     */
    readonly expression: string;
    /**
     * String indicating the location of the expression for error reporting, e.g. a file  name and a position in the file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed.html#location CloudAssetFolderFeed#location}
     */
    readonly location?: string;
    /**
     * Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed.html#title CloudAssetFolderFeed#title}
     */
    readonly title?: string;
}
export declare class CloudAssetFolderFeedConditionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string | undefined;
    set location(value: string | undefined);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string | undefined;
    set title(value: string | undefined);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface CloudAssetFolderFeedFeedOutputConfigPubsubDestination {
    /**
     * Destination on Cloud Pubsub topic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed.html#topic CloudAssetFolderFeed#topic}
     */
    readonly topic: string;
}
export declare class CloudAssetFolderFeedFeedOutputConfigPubsubDestinationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _topic?;
    get topic(): string;
    set topic(value: string);
    get topicInput(): string | undefined;
}
export interface CloudAssetFolderFeedFeedOutputConfig {
    /**
     * pubsub_destination block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed.html#pubsub_destination CloudAssetFolderFeed#pubsub_destination}
     */
    readonly pubsubDestination: CloudAssetFolderFeedFeedOutputConfigPubsubDestination;
}
export declare class CloudAssetFolderFeedFeedOutputConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _pubsubDestination?;
    private __pubsubDestinationOutput;
    get pubsubDestination(): CloudAssetFolderFeedFeedOutputConfigPubsubDestinationOutputReference;
    putPubsubDestination(value: CloudAssetFolderFeedFeedOutputConfigPubsubDestination): void;
    get pubsubDestinationInput(): CloudAssetFolderFeedFeedOutputConfigPubsubDestination | undefined;
}
export interface CloudAssetFolderFeedTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed.html#create CloudAssetFolderFeed#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed.html#delete CloudAssetFolderFeed#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed.html#update CloudAssetFolderFeed#update}.
     */
    readonly update?: string;
}
export declare class CloudAssetFolderFeedTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed.html google_cloud_asset_folder_feed}.
 */
export declare class CloudAssetFolderFeed extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed.html google_cloud_asset_folder_feed} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: CloudAssetFolderFeedConfig);
    private _assetNames?;
    get assetNames(): string[] | undefined;
    set assetNames(value: string[] | undefined);
    resetAssetNames(): void;
    get assetNamesInput(): string[] | undefined;
    private _assetTypes?;
    get assetTypes(): string[] | undefined;
    set assetTypes(value: string[] | undefined);
    resetAssetTypes(): void;
    get assetTypesInput(): string[] | undefined;
    private _billingProject?;
    get billingProject(): string;
    set billingProject(value: string);
    get billingProjectInput(): string | undefined;
    private _contentType?;
    get contentType(): string | undefined;
    set contentType(value: string | undefined);
    resetContentType(): void;
    get contentTypeInput(): string | undefined;
    private _feedId?;
    get feedId(): string;
    set feedId(value: string);
    get feedIdInput(): string | undefined;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    get folderInput(): string | undefined;
    get folderId(): string;
    get id(): string;
    get name(): string;
    private _condition?;
    private __conditionOutput;
    get condition(): CloudAssetFolderFeedConditionOutputReference;
    putCondition(value: CloudAssetFolderFeedCondition | undefined): void;
    resetCondition(): void;
    get conditionInput(): CloudAssetFolderFeedCondition | undefined;
    private _feedOutputConfig?;
    private __feedOutputConfigOutput;
    get feedOutputConfig(): CloudAssetFolderFeedFeedOutputConfigOutputReference;
    putFeedOutputConfig(value: CloudAssetFolderFeedFeedOutputConfig): void;
    get feedOutputConfigInput(): CloudAssetFolderFeedFeedOutputConfig | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): CloudAssetFolderFeedTimeoutsOutputReference;
    putTimeouts(value: CloudAssetFolderFeedTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): CloudAssetFolderFeedTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
