import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BinaryAuthorizationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * A descriptive comment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#description BinaryAuthorizationPolicy#description}
     */
    readonly description?: string;
    /**
     * Controls the evaluation of a Google-maintained global admission policy for common system-level images.
     *
     * Images not covered by the global
     * policy will be subject to the project admission policy. Possible values: ["ENABLE", "DISABLE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#global_policy_evaluation_mode BinaryAuthorizationPolicy#global_policy_evaluation_mode}
     */
    readonly globalPolicyEvaluationMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#project BinaryAuthorizationPolicy#project}.
     */
    readonly project?: string;
    /**
     * admission_whitelist_patterns block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#admission_whitelist_patterns BinaryAuthorizationPolicy#admission_whitelist_patterns}
     */
    readonly admissionWhitelistPatterns?: BinaryAuthorizationPolicyAdmissionWhitelistPatterns[];
    /**
     * cluster_admission_rules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#cluster_admission_rules BinaryAuthorizationPolicy#cluster_admission_rules}
     */
    readonly clusterAdmissionRules?: BinaryAuthorizationPolicyClusterAdmissionRules[];
    /**
     * default_admission_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#default_admission_rule BinaryAuthorizationPolicy#default_admission_rule}
     */
    readonly defaultAdmissionRule: BinaryAuthorizationPolicyDefaultAdmissionRule;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#timeouts BinaryAuthorizationPolicy#timeouts}
     */
    readonly timeouts?: BinaryAuthorizationPolicyTimeouts;
}
export interface BinaryAuthorizationPolicyAdmissionWhitelistPatterns {
    /**
     * An image name pattern to whitelist, in the form 'registry/path/to/image'.
     *
     * This supports a trailing * as a
     * wildcard, but this is allowed only in text after the registry/
     * part.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#name_pattern BinaryAuthorizationPolicy#name_pattern}
     */
    readonly namePattern: string;
}
export interface BinaryAuthorizationPolicyClusterAdmissionRules {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#cluster BinaryAuthorizationPolicy#cluster}.
     */
    readonly cluster: string;
    /**
     * The action when a pod creation is denied by the admission rule. Possible values: ["ENFORCED_BLOCK_AND_AUDIT_LOG", "DRYRUN_AUDIT_LOG_ONLY"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#enforcement_mode BinaryAuthorizationPolicy#enforcement_mode}
     */
    readonly enforcementMode: string;
    /**
     * How this admission rule will be evaluated. Possible values: ["ALWAYS_ALLOW", "REQUIRE_ATTESTATION", "ALWAYS_DENY"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#evaluation_mode BinaryAuthorizationPolicy#evaluation_mode}
     */
    readonly evaluationMode: string;
    /**
     * The resource names of the attestors that must attest to a container image.
     *
     * If the attestor is in a different project from the
     * policy, it should be specified in the format 'projects/*\/attestors/*'.
     * Each attestor must exist before a policy can reference it. To add an
     * attestor to a policy the principal issuing the policy change
     * request must be able to read the attestor resource.
     *
     * Note: this field must be non-empty when the evaluation_mode field
     * specifies REQUIRE_ATTESTATION, otherwise it must be empty.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#require_attestations_by BinaryAuthorizationPolicy#require_attestations_by}
     */
    readonly requireAttestationsBy?: string[];
}
export interface BinaryAuthorizationPolicyDefaultAdmissionRule {
    /**
     * The action when a pod creation is denied by the admission rule. Possible values: ["ENFORCED_BLOCK_AND_AUDIT_LOG", "DRYRUN_AUDIT_LOG_ONLY"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#enforcement_mode BinaryAuthorizationPolicy#enforcement_mode}
     */
    readonly enforcementMode: string;
    /**
     * How this admission rule will be evaluated. Possible values: ["ALWAYS_ALLOW", "REQUIRE_ATTESTATION", "ALWAYS_DENY"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#evaluation_mode BinaryAuthorizationPolicy#evaluation_mode}
     */
    readonly evaluationMode: string;
    /**
     * The resource names of the attestors that must attest to a container image.
     *
     * If the attestor is in a different project from the
     * policy, it should be specified in the format 'projects/*\/attestors/*'.
     * Each attestor must exist before a policy can reference it. To add an
     * attestor to a policy the principal issuing the policy change
     * request must be able to read the attestor resource.
     *
     * Note: this field must be non-empty when the evaluation_mode field
     * specifies REQUIRE_ATTESTATION, otherwise it must be empty.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#require_attestations_by BinaryAuthorizationPolicy#require_attestations_by}
     */
    readonly requireAttestationsBy?: string[];
}
export declare class BinaryAuthorizationPolicyDefaultAdmissionRuleOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enforcementMode?;
    get enforcementMode(): string;
    set enforcementMode(value: string);
    get enforcementModeInput(): string | undefined;
    private _evaluationMode?;
    get evaluationMode(): string;
    set evaluationMode(value: string);
    get evaluationModeInput(): string | undefined;
    private _requireAttestationsBy?;
    get requireAttestationsBy(): string[] | undefined;
    set requireAttestationsBy(value: string[] | undefined);
    resetRequireAttestationsBy(): void;
    get requireAttestationsByInput(): string[] | undefined;
}
export interface BinaryAuthorizationPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#create BinaryAuthorizationPolicy#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#delete BinaryAuthorizationPolicy#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#update BinaryAuthorizationPolicy#update}.
     */
    readonly update?: string;
}
export declare class BinaryAuthorizationPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html google_binary_authorization_policy}.
 */
export declare class BinaryAuthorizationPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html google_binary_authorization_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: BinaryAuthorizationPolicyConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _globalPolicyEvaluationMode?;
    get globalPolicyEvaluationMode(): string | undefined;
    set globalPolicyEvaluationMode(value: string | undefined);
    resetGlobalPolicyEvaluationMode(): void;
    get globalPolicyEvaluationModeInput(): string | undefined;
    get id(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _admissionWhitelistPatterns?;
    get admissionWhitelistPatterns(): BinaryAuthorizationPolicyAdmissionWhitelistPatterns[] | undefined;
    set admissionWhitelistPatterns(value: BinaryAuthorizationPolicyAdmissionWhitelistPatterns[] | undefined);
    resetAdmissionWhitelistPatterns(): void;
    get admissionWhitelistPatternsInput(): BinaryAuthorizationPolicyAdmissionWhitelistPatterns[] | undefined;
    private _clusterAdmissionRules?;
    get clusterAdmissionRules(): BinaryAuthorizationPolicyClusterAdmissionRules[] | undefined;
    set clusterAdmissionRules(value: BinaryAuthorizationPolicyClusterAdmissionRules[] | undefined);
    resetClusterAdmissionRules(): void;
    get clusterAdmissionRulesInput(): BinaryAuthorizationPolicyClusterAdmissionRules[] | undefined;
    private _defaultAdmissionRule?;
    private __defaultAdmissionRuleOutput;
    get defaultAdmissionRule(): BinaryAuthorizationPolicyDefaultAdmissionRuleOutputReference;
    putDefaultAdmissionRule(value: BinaryAuthorizationPolicyDefaultAdmissionRule): void;
    get defaultAdmissionRuleInput(): BinaryAuthorizationPolicyDefaultAdmissionRule | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): BinaryAuthorizationPolicyTimeoutsOutputReference;
    putTimeouts(value: BinaryAuthorizationPolicyTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): BinaryAuthorizationPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
