import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BillingSubaccountConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_subaccount.html#deletion_policy BillingSubaccount#deletion_policy}.
     */
    readonly deletionPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_subaccount.html#display_name BillingSubaccount#display_name}.
     */
    readonly displayName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_subaccount.html#master_billing_account BillingSubaccount#master_billing_account}.
     */
    readonly masterBillingAccount: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/billing_subaccount.html google_billing_subaccount}.
 */
export declare class BillingSubaccount extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/billing_subaccount.html google_billing_subaccount} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: BillingSubaccountConfig);
    get billingAccountId(): string;
    private _deletionPolicy?;
    get deletionPolicy(): string | undefined;
    set deletionPolicy(value: string | undefined);
    resetDeletionPolicy(): void;
    get deletionPolicyInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get id(): string;
    private _masterBillingAccount?;
    get masterBillingAccount(): string;
    set masterBillingAccount(value: string);
    get masterBillingAccountInput(): string | undefined;
    get name(): string;
    get open(): any;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
