import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BillingBudgetConfig extends cdktf.TerraformMetaArguments {
    /**
     * ID of the billing account to set a budget on.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#billing_account BillingBudget#billing_account}
     */
    readonly billingAccount: string;
    /**
     * User data for display name in UI. Must be <= 60 chars.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#display_name BillingBudget#display_name}
     */
    readonly displayName?: string;
    /**
     * all_updates_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#all_updates_rule BillingBudget#all_updates_rule}
     */
    readonly allUpdatesRule?: BillingBudgetAllUpdatesRule;
    /**
     * amount block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#amount BillingBudget#amount}
     */
    readonly amount: BillingBudgetAmount;
    /**
     * budget_filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#budget_filter BillingBudget#budget_filter}
     */
    readonly budgetFilter?: BillingBudgetBudgetFilter;
    /**
     * threshold_rules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#threshold_rules BillingBudget#threshold_rules}
     */
    readonly thresholdRules: BillingBudgetThresholdRules[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#timeouts BillingBudget#timeouts}
     */
    readonly timeouts?: BillingBudgetTimeouts;
}
export interface BillingBudgetAllUpdatesRule {
    /**
     * Boolean.
     *
     * When set to true, disables default notifications sent
     * when a threshold is exceeded. Default recipients are
     * those with Billing Account Administrators and Billing
     * Account Users IAM roles for the target account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#disable_default_iam_recipients BillingBudget#disable_default_iam_recipients}
     */
    readonly disableDefaultIamRecipients?: boolean | cdktf.IResolvable;
    /**
     * The full resource name of a monitoring notification channel in the form projects/{project_id}/notificationChannels/{channel_id}. A maximum of 5 channels are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#monitoring_notification_channels BillingBudget#monitoring_notification_channels}
     */
    readonly monitoringNotificationChannels?: string[];
    /**
     * The name of the Cloud Pub/Sub topic where budget related messages will be published, in the form projects/{project_id}/topics/{topic_id}.
     *
     * Updates are sent
     * at regular intervals to the topic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#pubsub_topic BillingBudget#pubsub_topic}
     */
    readonly pubsubTopic?: string;
    /**
     * The schema version of the notification. Only "1.0" is accepted. It represents the JSON schema as defined in https://cloud.google.com/billing/docs/how-to/budgets#notification_format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#schema_version BillingBudget#schema_version}
     */
    readonly schemaVersion?: string;
}
export declare class BillingBudgetAllUpdatesRuleOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _disableDefaultIamRecipients?;
    get disableDefaultIamRecipients(): boolean | cdktf.IResolvable | undefined;
    set disableDefaultIamRecipients(value: boolean | cdktf.IResolvable | undefined);
    resetDisableDefaultIamRecipients(): void;
    get disableDefaultIamRecipientsInput(): boolean | cdktf.IResolvable | undefined;
    private _monitoringNotificationChannels?;
    get monitoringNotificationChannels(): string[] | undefined;
    set monitoringNotificationChannels(value: string[] | undefined);
    resetMonitoringNotificationChannels(): void;
    get monitoringNotificationChannelsInput(): string[] | undefined;
    private _pubsubTopic?;
    get pubsubTopic(): string | undefined;
    set pubsubTopic(value: string | undefined);
    resetPubsubTopic(): void;
    get pubsubTopicInput(): string | undefined;
    private _schemaVersion?;
    get schemaVersion(): string | undefined;
    set schemaVersion(value: string | undefined);
    resetSchemaVersion(): void;
    get schemaVersionInput(): string | undefined;
}
export interface BillingBudgetAmountSpecifiedAmount {
    /**
     * The 3-letter currency code defined in ISO 4217.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#currency_code BillingBudget#currency_code}
     */
    readonly currencyCode?: string;
    /**
     * Number of nano (10^-9) units of the amount.
     *
     * The value must be between -999,999,999 and +999,999,999
     * inclusive. If units is positive, nanos must be positive or
     * zero. If units is zero, nanos can be positive, zero, or
     * negative. If units is negative, nanos must be negative or
     * zero. For example $-1.75 is represented as units=-1 and
     * nanos=-750,000,000.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#nanos BillingBudget#nanos}
     */
    readonly nanos?: number;
    /**
     * The whole units of the amount. For example if currencyCode is "USD", then 1 unit is one US dollar.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#units BillingBudget#units}
     */
    readonly units?: string;
}
export declare class BillingBudgetAmountSpecifiedAmountOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _currencyCode?;
    get currencyCode(): string | undefined;
    set currencyCode(value: string | undefined);
    resetCurrencyCode(): void;
    get currencyCodeInput(): string | undefined;
    private _nanos?;
    get nanos(): number | undefined;
    set nanos(value: number | undefined);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _units?;
    get units(): string | undefined;
    set units(value: string | undefined);
    resetUnits(): void;
    get unitsInput(): string | undefined;
}
export interface BillingBudgetAmount {
    /**
     * Configures a budget amount that is automatically set to 100% of last period's spend.
     *
     * Boolean. Set value to true to use. Do not set to false, instead
     * use the 'specified_amount' block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#last_period_amount BillingBudget#last_period_amount}
     */
    readonly lastPeriodAmount?: boolean | cdktf.IResolvable;
    /**
     * specified_amount block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#specified_amount BillingBudget#specified_amount}
     */
    readonly specifiedAmount?: BillingBudgetAmountSpecifiedAmount;
}
export declare class BillingBudgetAmountOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _lastPeriodAmount?;
    get lastPeriodAmount(): boolean | cdktf.IResolvable | undefined;
    set lastPeriodAmount(value: boolean | cdktf.IResolvable | undefined);
    resetLastPeriodAmount(): void;
    get lastPeriodAmountInput(): boolean | cdktf.IResolvable | undefined;
    private _specifiedAmount?;
    private __specifiedAmountOutput;
    get specifiedAmount(): BillingBudgetAmountSpecifiedAmountOutputReference;
    putSpecifiedAmount(value: BillingBudgetAmountSpecifiedAmount | undefined): void;
    resetSpecifiedAmount(): void;
    get specifiedAmountInput(): BillingBudgetAmountSpecifiedAmount | undefined;
}
export interface BillingBudgetBudgetFilter {
    /**
     * A set of subaccounts of the form billingAccounts/{account_id}, specifying that usage from only this set of subaccounts should be included in the budget.
     *
     * If a subaccount is set to the name of
     * the parent account, usage from the parent account will be included.
     * If the field is omitted, the report will include usage from the parent
     * account and all subaccounts, if they exist.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#credit_types BillingBudget#credit_types}
     */
    readonly creditTypes?: string[];
    /**
     * Specifies how credits should be treated when determining spend for threshold calculations. Default value: "INCLUDE_ALL_CREDITS" Possible values: ["INCLUDE_ALL_CREDITS", "EXCLUDE_ALL_CREDITS", "INCLUDE_SPECIFIED_CREDITS"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#credit_types_treatment BillingBudget#credit_types_treatment}
     */
    readonly creditTypesTreatment?: string;
    /**
     * A single label and value pair specifying that usage from only this set of labeled resources should be included in the budget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#labels BillingBudget#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * A set of projects of the form projects/{project_number}, specifying that usage from only this set of projects should be included in the budget.
     *
     * If omitted, the report will include
     * all usage for the billing account, regardless of which project
     * the usage occurred on.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#projects BillingBudget#projects}
     */
    readonly projects?: string[];
    /**
     * A set of services of the form services/{service_id}, specifying that usage from only this set of services should be included in the budget.
     *
     * If omitted, the report will include
     * usage for all the services. The service names are available
     * through the Catalog API:
     * https://cloud.google.com/billing/v1/how-tos/catalog-api.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#services BillingBudget#services}
     */
    readonly services?: string[];
    /**
     * A set of subaccounts of the form billingAccounts/{account_id}, specifying that usage from only this set of subaccounts should be included in the budget.
     *
     * If a subaccount is set to the name of
     * the parent account, usage from the parent account will be included.
     * If the field is omitted, the report will include usage from the parent
     * account and all subaccounts, if they exist.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#subaccounts BillingBudget#subaccounts}
     */
    readonly subaccounts?: string[];
}
export declare class BillingBudgetBudgetFilterOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _creditTypes?;
    get creditTypes(): string[] | undefined;
    set creditTypes(value: string[] | undefined);
    resetCreditTypes(): void;
    get creditTypesInput(): string[] | undefined;
    private _creditTypesTreatment?;
    get creditTypesTreatment(): string | undefined;
    set creditTypesTreatment(value: string | undefined);
    resetCreditTypesTreatment(): void;
    get creditTypesTreatmentInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _projects?;
    get projects(): string[] | undefined;
    set projects(value: string[] | undefined);
    resetProjects(): void;
    get projectsInput(): string[] | undefined;
    private _services?;
    get services(): string[] | undefined;
    set services(value: string[] | undefined);
    resetServices(): void;
    get servicesInput(): string[] | undefined;
    private _subaccounts?;
    get subaccounts(): string[] | undefined;
    set subaccounts(value: string[] | undefined);
    resetSubaccounts(): void;
    get subaccountsInput(): string[] | undefined;
}
export interface BillingBudgetThresholdRules {
    /**
     * The type of basis used to determine if spend has passed the threshold. Default value: "CURRENT_SPEND" Possible values: ["CURRENT_SPEND", "FORECASTED_SPEND"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#spend_basis BillingBudget#spend_basis}
     */
    readonly spendBasis?: string;
    /**
     * Send an alert when this threshold is exceeded.
     *
     * This is a
     * 1.0-based percentage, so 0.5 = 50%. Must be >= 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#threshold_percent BillingBudget#threshold_percent}
     */
    readonly thresholdPercent: number;
}
export interface BillingBudgetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#create BillingBudget#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#delete BillingBudget#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#update BillingBudget#update}.
     */
    readonly update?: string;
}
export declare class BillingBudgetTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html google_billing_budget}.
 */
export declare class BillingBudget extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html google_billing_budget} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: BillingBudgetConfig);
    private _billingAccount?;
    get billingAccount(): string;
    set billingAccount(value: string);
    get billingAccountInput(): string | undefined;
    private _displayName?;
    get displayName(): string | undefined;
    set displayName(value: string | undefined);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get id(): string;
    get name(): string;
    private _allUpdatesRule?;
    private __allUpdatesRuleOutput;
    get allUpdatesRule(): BillingBudgetAllUpdatesRuleOutputReference;
    putAllUpdatesRule(value: BillingBudgetAllUpdatesRule | undefined): void;
    resetAllUpdatesRule(): void;
    get allUpdatesRuleInput(): BillingBudgetAllUpdatesRule | undefined;
    private _amount?;
    private __amountOutput;
    get amount(): BillingBudgetAmountOutputReference;
    putAmount(value: BillingBudgetAmount): void;
    get amountInput(): BillingBudgetAmount | undefined;
    private _budgetFilter?;
    private __budgetFilterOutput;
    get budgetFilter(): BillingBudgetBudgetFilterOutputReference;
    putBudgetFilter(value: BillingBudgetBudgetFilter | undefined): void;
    resetBudgetFilter(): void;
    get budgetFilterInput(): BillingBudgetBudgetFilter | undefined;
    private _thresholdRules?;
    get thresholdRules(): BillingBudgetThresholdRules[];
    set thresholdRules(value: BillingBudgetThresholdRules[]);
    get thresholdRulesInput(): BillingBudgetThresholdRules[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): BillingBudgetTimeoutsOutputReference;
    putTimeouts(value: BillingBudgetTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): BillingBudgetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
