import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BigtableTableConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the Bigtable instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_table.html#instance_name BigtableTable#instance_name}
     */
    readonly instanceName: string;
    /**
     * The name of the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_table.html#name BigtableTable#name}
     */
    readonly name: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_table.html#project BigtableTable#project}
     */
    readonly project?: string;
    /**
     * A list of predefined keys to split the table on.
     *
     * !> Warning: Modifying the split_keys of an existing table will cause Terraform to delete/recreate the entire google_bigtable_table resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_table.html#split_keys BigtableTable#split_keys}
     */
    readonly splitKeys?: string[];
    /**
     * column_family block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_table.html#column_family BigtableTable#column_family}
     */
    readonly columnFamily?: BigtableTableColumnFamily[];
}
export interface BigtableTableColumnFamily {
    /**
     * The name of the column family.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_table.html#family BigtableTable#family}
     */
    readonly family: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/bigtable_table.html google_bigtable_table}.
 */
export declare class BigtableTable extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigtable_table.html google_bigtable_table} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: BigtableTableConfig);
    get id(): string;
    private _instanceName?;
    get instanceName(): string;
    set instanceName(value: string);
    get instanceNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _splitKeys?;
    get splitKeys(): string[] | undefined;
    set splitKeys(value: string[] | undefined);
    resetSplitKeys(): void;
    get splitKeysInput(): string[] | undefined;
    private _columnFamily?;
    get columnFamily(): BigtableTableColumnFamily[] | undefined;
    set columnFamily(value: BigtableTableColumnFamily[] | undefined);
    resetColumnFamily(): void;
    get columnFamilyInput(): BigtableTableColumnFamily[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
