import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BigtableGcPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the column family.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy.html#column_family BigtableGcPolicy#column_family}
     */
    readonly columnFamily: string;
    /**
     * The name of the Bigtable instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy.html#instance_name BigtableGcPolicy#instance_name}
     */
    readonly instanceName: string;
    /**
     * If multiple policies are set, you should choose between UNION OR INTERSECTION.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy.html#mode BigtableGcPolicy#mode}
     */
    readonly mode?: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy.html#project BigtableGcPolicy#project}
     */
    readonly project?: string;
    /**
     * The name of the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy.html#table BigtableGcPolicy#table}
     */
    readonly table: string;
    /**
     * max_age block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy.html#max_age BigtableGcPolicy#max_age}
     */
    readonly maxAge?: BigtableGcPolicyMaxAge;
    /**
     * max_version block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy.html#max_version BigtableGcPolicy#max_version}
     */
    readonly maxVersion?: BigtableGcPolicyMaxVersion[];
}
export interface BigtableGcPolicyMaxAge {
    /**
     * Number of days before applying GC policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy.html#days BigtableGcPolicy#days}
     */
    readonly days?: number;
    /**
     * Duration before applying GC policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy.html#duration BigtableGcPolicy#duration}
     */
    readonly duration?: string;
}
export declare class BigtableGcPolicyMaxAgeOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _days?;
    get days(): number | undefined;
    set days(value: number | undefined);
    resetDays(): void;
    get daysInput(): number | undefined;
    private _duration?;
    get duration(): string | undefined;
    set duration(value: string | undefined);
    resetDuration(): void;
    get durationInput(): string | undefined;
}
export interface BigtableGcPolicyMaxVersion {
    /**
     * Number of version before applying the GC policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy.html#number BigtableGcPolicy#number}
     */
    readonly number: number;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy.html google_bigtable_gc_policy}.
 */
export declare class BigtableGcPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy.html google_bigtable_gc_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: BigtableGcPolicyConfig);
    private _columnFamily?;
    get columnFamily(): string;
    set columnFamily(value: string);
    get columnFamilyInput(): string | undefined;
    get id(): string;
    private _instanceName?;
    get instanceName(): string;
    set instanceName(value: string);
    get instanceNameInput(): string | undefined;
    private _mode?;
    get mode(): string | undefined;
    set mode(value: string | undefined);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _table?;
    get table(): string;
    set table(value: string);
    get tableInput(): string | undefined;
    private _maxAge?;
    private __maxAgeOutput;
    get maxAge(): BigtableGcPolicyMaxAgeOutputReference;
    putMaxAge(value: BigtableGcPolicyMaxAge | undefined): void;
    resetMaxAge(): void;
    get maxAgeInput(): BigtableGcPolicyMaxAge | undefined;
    private _maxVersion?;
    get maxVersion(): BigtableGcPolicyMaxVersion[] | undefined;
    set maxVersion(value: BigtableGcPolicyMaxVersion[] | undefined);
    resetMaxVersion(): void;
    get maxVersionInput(): BigtableGcPolicyMaxVersion[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
