import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BigtableAppProfileConfig extends cdktf.TerraformMetaArguments {
    /**
     * The unique name of the app profile in the form '[_a-zA-Z0-9][-_.a-zA-Z0-9]*'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#app_profile_id BigtableAppProfile#app_profile_id}
     */
    readonly appProfileId: string;
    /**
     * Long form description of the use case for this app profile.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#description BigtableAppProfile#description}
     */
    readonly description?: string;
    /**
     * If true, ignore safety checks when deleting/updating the app profile.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#ignore_warnings BigtableAppProfile#ignore_warnings}
     */
    readonly ignoreWarnings?: boolean | cdktf.IResolvable;
    /**
     * The name of the instance to create the app profile within.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#instance BigtableAppProfile#instance}
     */
    readonly instance?: string;
    /**
     * If true, read/write requests are routed to the nearest cluster in the instance, and will fail over to the nearest cluster that is available in the event of transient errors or delays.
     *
     * Clusters in a region are considered equidistant. Choosing this option sacrifices read-your-writes
     * consistency to improve availability.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#multi_cluster_routing_use_any BigtableAppProfile#multi_cluster_routing_use_any}
     */
    readonly multiClusterRoutingUseAny?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#project BigtableAppProfile#project}.
     */
    readonly project?: string;
    /**
     * single_cluster_routing block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#single_cluster_routing BigtableAppProfile#single_cluster_routing}
     */
    readonly singleClusterRouting?: BigtableAppProfileSingleClusterRouting;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#timeouts BigtableAppProfile#timeouts}
     */
    readonly timeouts?: BigtableAppProfileTimeouts;
}
export interface BigtableAppProfileSingleClusterRouting {
    /**
     * If true, CheckAndMutateRow and ReadModifyWriteRow requests are allowed by this app profile.
     *
     * It is unsafe to send these requests to the same table/row/column in multiple clusters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#allow_transactional_writes BigtableAppProfile#allow_transactional_writes}
     */
    readonly allowTransactionalWrites?: boolean | cdktf.IResolvable;
    /**
     * The cluster to which read/write requests should be routed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#cluster_id BigtableAppProfile#cluster_id}
     */
    readonly clusterId: string;
}
export declare class BigtableAppProfileSingleClusterRoutingOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _allowTransactionalWrites?;
    get allowTransactionalWrites(): boolean | cdktf.IResolvable | undefined;
    set allowTransactionalWrites(value: boolean | cdktf.IResolvable | undefined);
    resetAllowTransactionalWrites(): void;
    get allowTransactionalWritesInput(): boolean | cdktf.IResolvable | undefined;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
}
export interface BigtableAppProfileTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#create BigtableAppProfile#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#delete BigtableAppProfile#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#update BigtableAppProfile#update}.
     */
    readonly update?: string;
}
export declare class BigtableAppProfileTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html google_bigtable_app_profile}.
 */
export declare class BigtableAppProfile extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html google_bigtable_app_profile} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: BigtableAppProfileConfig);
    private _appProfileId?;
    get appProfileId(): string;
    set appProfileId(value: string);
    get appProfileIdInput(): string | undefined;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _ignoreWarnings?;
    get ignoreWarnings(): boolean | cdktf.IResolvable | undefined;
    set ignoreWarnings(value: boolean | cdktf.IResolvable | undefined);
    resetIgnoreWarnings(): void;
    get ignoreWarningsInput(): boolean | cdktf.IResolvable | undefined;
    private _instance?;
    get instance(): string | undefined;
    set instance(value: string | undefined);
    resetInstance(): void;
    get instanceInput(): string | undefined;
    private _multiClusterRoutingUseAny?;
    get multiClusterRoutingUseAny(): boolean | cdktf.IResolvable | undefined;
    set multiClusterRoutingUseAny(value: boolean | cdktf.IResolvable | undefined);
    resetMultiClusterRoutingUseAny(): void;
    get multiClusterRoutingUseAnyInput(): boolean | cdktf.IResolvable | undefined;
    get name(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _singleClusterRouting?;
    private __singleClusterRoutingOutput;
    get singleClusterRouting(): BigtableAppProfileSingleClusterRoutingOutputReference;
    putSingleClusterRouting(value: BigtableAppProfileSingleClusterRouting | undefined): void;
    resetSingleClusterRouting(): void;
    get singleClusterRoutingInput(): BigtableAppProfileSingleClusterRouting | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): BigtableAppProfileTimeoutsOutputReference;
    putTimeouts(value: BigtableAppProfileTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): BigtableAppProfileTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
