import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BigqueryTableConfig extends cdktf.TerraformMetaArguments {
    /**
     * Specifies column names to use for data clustering.
     *
     * Up to four top-level columns are allowed, and should be specified in descending priority order.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#clustering BigqueryTable#clustering}
     */
    readonly clustering?: string[];
    /**
     * The dataset ID to create the table in. Changing this forces a new resource to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#dataset_id BigqueryTable#dataset_id}
     */
    readonly datasetId: string;
    /**
     * Whether or not to allow Terraform to destroy the instance.
     *
     * Unless this field is set to false in Terraform state, a terraform destroy or terraform apply that would delete the instance will fail.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#deletion_protection BigqueryTable#deletion_protection}
     */
    readonly deletionProtection?: boolean | cdktf.IResolvable;
    /**
     * The field description.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#description BigqueryTable#description}
     */
    readonly description?: string;
    /**
     * The time when this table expires, in milliseconds since the epoch.
     *
     * If not present, the table will persist indefinitely. Expired tables will be deleted and their storage reclaimed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#expiration_time BigqueryTable#expiration_time}
     */
    readonly expirationTime?: number;
    /**
     * A descriptive name for the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#friendly_name BigqueryTable#friendly_name}
     */
    readonly friendlyName?: string;
    /**
     * A mapping of labels to assign to the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#labels BigqueryTable#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The ID of the project in which the resource belongs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#project BigqueryTable#project}
     */
    readonly project?: string;
    /**
     * A JSON schema for the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#schema BigqueryTable#schema}
     */
    readonly schema?: string;
    /**
     * A unique ID for the resource. Changing this forces a new resource to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#table_id BigqueryTable#table_id}
     */
    readonly tableId: string;
    /**
     * encryption_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#encryption_configuration BigqueryTable#encryption_configuration}
     */
    readonly encryptionConfiguration?: BigqueryTableEncryptionConfiguration;
    /**
     * external_data_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#external_data_configuration BigqueryTable#external_data_configuration}
     */
    readonly externalDataConfiguration?: BigqueryTableExternalDataConfiguration;
    /**
     * materialized_view block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#materialized_view BigqueryTable#materialized_view}
     */
    readonly materializedView?: BigqueryTableMaterializedView;
    /**
     * range_partitioning block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#range_partitioning BigqueryTable#range_partitioning}
     */
    readonly rangePartitioning?: BigqueryTableRangePartitioning;
    /**
     * time_partitioning block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#time_partitioning BigqueryTable#time_partitioning}
     */
    readonly timePartitioning?: BigqueryTableTimePartitioning;
    /**
     * view block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#view BigqueryTable#view}
     */
    readonly view?: BigqueryTableView;
}
export interface BigqueryTableEncryptionConfiguration {
    /**
     * The self link or full name of a key which should be used to encrypt this table.
     *
     * Note that the default bigquery service account will need to have encrypt/decrypt permissions on this key - you may want to see the google_bigquery_default_service_account datasource and the google_kms_crypto_key_iam_binding resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#kms_key_name BigqueryTable#kms_key_name}
     */
    readonly kmsKeyName: string;
}
export declare class BigqueryTableEncryptionConfigurationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
}
export interface BigqueryTableExternalDataConfigurationCsvOptions {
    /**
     * Indicates if BigQuery should accept rows that are missing trailing optional columns.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#allow_jagged_rows BigqueryTable#allow_jagged_rows}
     */
    readonly allowJaggedRows?: boolean | cdktf.IResolvable;
    /**
     * Indicates if BigQuery should allow quoted data sections that contain newline characters in a CSV file.
     *
     * The default value is false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#allow_quoted_newlines BigqueryTable#allow_quoted_newlines}
     */
    readonly allowQuotedNewlines?: boolean | cdktf.IResolvable;
    /**
     * The character encoding of the data. The supported values are UTF-8 or ISO-8859-1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#encoding BigqueryTable#encoding}
     */
    readonly encoding?: string;
    /**
     * The separator for fields in a CSV file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#field_delimiter BigqueryTable#field_delimiter}
     */
    readonly fieldDelimiter?: string;
    /**
     * The value that is used to quote data sections in a CSV file.
     *
     * If your data does not contain quoted sections, set the property value to an empty string. If your data contains quoted newline characters, you must also set the allow_quoted_newlines property to true. The API-side default is ", specified in Terraform escaped as \". Due to limitations with Terraform default values, this value is required to be explicitly set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#quote BigqueryTable#quote}
     */
    readonly quote: string;
    /**
     * The number of rows at the top of a CSV file that BigQuery will skip when reading the data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#skip_leading_rows BigqueryTable#skip_leading_rows}
     */
    readonly skipLeadingRows?: number;
}
export declare class BigqueryTableExternalDataConfigurationCsvOptionsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _allowJaggedRows?;
    get allowJaggedRows(): boolean | cdktf.IResolvable | undefined;
    set allowJaggedRows(value: boolean | cdktf.IResolvable | undefined);
    resetAllowJaggedRows(): void;
    get allowJaggedRowsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowQuotedNewlines?;
    get allowQuotedNewlines(): boolean | cdktf.IResolvable | undefined;
    set allowQuotedNewlines(value: boolean | cdktf.IResolvable | undefined);
    resetAllowQuotedNewlines(): void;
    get allowQuotedNewlinesInput(): boolean | cdktf.IResolvable | undefined;
    private _encoding?;
    get encoding(): string | undefined;
    set encoding(value: string | undefined);
    resetEncoding(): void;
    get encodingInput(): string | undefined;
    private _fieldDelimiter?;
    get fieldDelimiter(): string | undefined;
    set fieldDelimiter(value: string | undefined);
    resetFieldDelimiter(): void;
    get fieldDelimiterInput(): string | undefined;
    private _quote?;
    get quote(): string;
    set quote(value: string);
    get quoteInput(): string | undefined;
    private _skipLeadingRows?;
    get skipLeadingRows(): number | undefined;
    set skipLeadingRows(value: number | undefined);
    resetSkipLeadingRows(): void;
    get skipLeadingRowsInput(): number | undefined;
}
export interface BigqueryTableExternalDataConfigurationGoogleSheetsOptions {
    /**
     * Range of a sheet to query from.
     *
     * Only used when non-empty. At least one of range or skip_leading_rows must be set. Typical format: "sheet_name!top_left_cell_id:bottom_right_cell_id" For example: "sheet1!A1:B20"
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#range BigqueryTable#range}
     */
    readonly range?: string;
    /**
     * The number of rows at the top of the sheet that BigQuery will skip when reading the data.
     *
     * At least one of range or skip_leading_rows must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#skip_leading_rows BigqueryTable#skip_leading_rows}
     */
    readonly skipLeadingRows?: number;
}
export declare class BigqueryTableExternalDataConfigurationGoogleSheetsOptionsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _range?;
    get range(): string | undefined;
    set range(value: string | undefined);
    resetRange(): void;
    get rangeInput(): string | undefined;
    private _skipLeadingRows?;
    get skipLeadingRows(): number | undefined;
    set skipLeadingRows(value: number | undefined);
    resetSkipLeadingRows(): void;
    get skipLeadingRowsInput(): number | undefined;
}
export interface BigqueryTableExternalDataConfigurationHivePartitioningOptions {
    /**
     * When set, what mode of hive partitioning to use when reading data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#mode BigqueryTable#mode}
     */
    readonly mode?: string;
    /**
     * If set to true, queries over this table require a partition filter that can be used for partition elimination to be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#require_partition_filter BigqueryTable#require_partition_filter}
     */
    readonly requirePartitionFilter?: boolean | cdktf.IResolvable;
    /**
     * When hive partition detection is requested, a common for all source uris must be required.
     *
     * The prefix must end immediately before the partition key encoding begins.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#source_uri_prefix BigqueryTable#source_uri_prefix}
     */
    readonly sourceUriPrefix?: string;
}
export declare class BigqueryTableExternalDataConfigurationHivePartitioningOptionsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _mode?;
    get mode(): string | undefined;
    set mode(value: string | undefined);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _requirePartitionFilter?;
    get requirePartitionFilter(): boolean | cdktf.IResolvable | undefined;
    set requirePartitionFilter(value: boolean | cdktf.IResolvable | undefined);
    resetRequirePartitionFilter(): void;
    get requirePartitionFilterInput(): boolean | cdktf.IResolvable | undefined;
    private _sourceUriPrefix?;
    get sourceUriPrefix(): string | undefined;
    set sourceUriPrefix(value: string | undefined);
    resetSourceUriPrefix(): void;
    get sourceUriPrefixInput(): string | undefined;
}
export interface BigqueryTableExternalDataConfiguration {
    /**
     * Let BigQuery try to autodetect the schema and format of the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#autodetect BigqueryTable#autodetect}
     */
    readonly autodetect: boolean | cdktf.IResolvable;
    /**
     * The compression type of the data source. Valid values are "NONE" or "GZIP".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#compression BigqueryTable#compression}
     */
    readonly compression?: string;
    /**
     * Indicates if BigQuery should allow extra values that are not represented in the table schema.
     *
     * If true, the extra values are ignored. If false, records with extra columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. The default value is false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#ignore_unknown_values BigqueryTable#ignore_unknown_values}
     */
    readonly ignoreUnknownValues?: boolean | cdktf.IResolvable;
    /**
     * The maximum number of bad records that BigQuery can ignore when reading data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#max_bad_records BigqueryTable#max_bad_records}
     */
    readonly maxBadRecords?: number;
    /**
     * A JSON schema for the external table.
     *
     * Schema is required for CSV and JSON formats and is disallowed for Google Cloud Bigtable, Cloud Datastore backups, and Avro formats when using external tables.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#schema BigqueryTable#schema}
     */
    readonly schema?: string;
    /**
     * The data format.
     *
     * Supported values are: "CSV", "GOOGLE_SHEETS", "NEWLINE_DELIMITED_JSON", "AVRO", "PARQUET", "ORC" and "DATASTORE_BACKUP". To use "GOOGLE_SHEETS" the scopes must include "googleapis.com/auth/drive.readonly".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#source_format BigqueryTable#source_format}
     */
    readonly sourceFormat: string;
    /**
     * A list of the fully-qualified URIs that point to your data in Google Cloud.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#source_uris BigqueryTable#source_uris}
     */
    readonly sourceUris: string[];
    /**
     * csv_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#csv_options BigqueryTable#csv_options}
     */
    readonly csvOptions?: BigqueryTableExternalDataConfigurationCsvOptions;
    /**
     * google_sheets_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#google_sheets_options BigqueryTable#google_sheets_options}
     */
    readonly googleSheetsOptions?: BigqueryTableExternalDataConfigurationGoogleSheetsOptions;
    /**
     * hive_partitioning_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#hive_partitioning_options BigqueryTable#hive_partitioning_options}
     */
    readonly hivePartitioningOptions?: BigqueryTableExternalDataConfigurationHivePartitioningOptions;
}
export declare class BigqueryTableExternalDataConfigurationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _autodetect?;
    get autodetect(): boolean | cdktf.IResolvable;
    set autodetect(value: boolean | cdktf.IResolvable);
    get autodetectInput(): boolean | cdktf.IResolvable | undefined;
    private _compression?;
    get compression(): string | undefined;
    set compression(value: string | undefined);
    resetCompression(): void;
    get compressionInput(): string | undefined;
    private _ignoreUnknownValues?;
    get ignoreUnknownValues(): boolean | cdktf.IResolvable | undefined;
    set ignoreUnknownValues(value: boolean | cdktf.IResolvable | undefined);
    resetIgnoreUnknownValues(): void;
    get ignoreUnknownValuesInput(): boolean | cdktf.IResolvable | undefined;
    private _maxBadRecords?;
    get maxBadRecords(): number | undefined;
    set maxBadRecords(value: number | undefined);
    resetMaxBadRecords(): void;
    get maxBadRecordsInput(): number | undefined;
    private _schema?;
    get schema(): string | undefined;
    set schema(value: string | undefined);
    resetSchema(): void;
    get schemaInput(): string | undefined;
    private _sourceFormat?;
    get sourceFormat(): string;
    set sourceFormat(value: string);
    get sourceFormatInput(): string | undefined;
    private _sourceUris?;
    get sourceUris(): string[];
    set sourceUris(value: string[]);
    get sourceUrisInput(): string[] | undefined;
    private _csvOptions?;
    private __csvOptionsOutput;
    get csvOptions(): BigqueryTableExternalDataConfigurationCsvOptionsOutputReference;
    putCsvOptions(value: BigqueryTableExternalDataConfigurationCsvOptions | undefined): void;
    resetCsvOptions(): void;
    get csvOptionsInput(): BigqueryTableExternalDataConfigurationCsvOptions | undefined;
    private _googleSheetsOptions?;
    private __googleSheetsOptionsOutput;
    get googleSheetsOptions(): BigqueryTableExternalDataConfigurationGoogleSheetsOptionsOutputReference;
    putGoogleSheetsOptions(value: BigqueryTableExternalDataConfigurationGoogleSheetsOptions | undefined): void;
    resetGoogleSheetsOptions(): void;
    get googleSheetsOptionsInput(): BigqueryTableExternalDataConfigurationGoogleSheetsOptions | undefined;
    private _hivePartitioningOptions?;
    private __hivePartitioningOptionsOutput;
    get hivePartitioningOptions(): BigqueryTableExternalDataConfigurationHivePartitioningOptionsOutputReference;
    putHivePartitioningOptions(value: BigqueryTableExternalDataConfigurationHivePartitioningOptions | undefined): void;
    resetHivePartitioningOptions(): void;
    get hivePartitioningOptionsInput(): BigqueryTableExternalDataConfigurationHivePartitioningOptions | undefined;
}
export interface BigqueryTableMaterializedView {
    /**
     * Specifies if BigQuery should automatically refresh materialized view when the base table is updated. The default is true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#enable_refresh BigqueryTable#enable_refresh}
     */
    readonly enableRefresh?: boolean | cdktf.IResolvable;
    /**
     * A query whose result is persisted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#query BigqueryTable#query}
     */
    readonly query: string;
    /**
     * Specifies maximum frequency at which this materialized view will be refreshed. The default is 1800000.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#refresh_interval_ms BigqueryTable#refresh_interval_ms}
     */
    readonly refreshIntervalMs?: number;
}
export declare class BigqueryTableMaterializedViewOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enableRefresh?;
    get enableRefresh(): boolean | cdktf.IResolvable | undefined;
    set enableRefresh(value: boolean | cdktf.IResolvable | undefined);
    resetEnableRefresh(): void;
    get enableRefreshInput(): boolean | cdktf.IResolvable | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
    private _refreshIntervalMs?;
    get refreshIntervalMs(): number | undefined;
    set refreshIntervalMs(value: number | undefined);
    resetRefreshIntervalMs(): void;
    get refreshIntervalMsInput(): number | undefined;
}
export interface BigqueryTableRangePartitioningRange {
    /**
     * End of the range partitioning, exclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#end BigqueryTable#end}
     */
    readonly end: number;
    /**
     * The width of each range within the partition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#interval BigqueryTable#interval}
     */
    readonly interval: number;
    /**
     * Start of the range partitioning, inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#start BigqueryTable#start}
     */
    readonly start: number;
}
export declare class BigqueryTableRangePartitioningRangeOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _end?;
    get end(): number;
    set end(value: number);
    get endInput(): number | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    get intervalInput(): number | undefined;
    private _start?;
    get start(): number;
    set start(value: number);
    get startInput(): number | undefined;
}
export interface BigqueryTableRangePartitioning {
    /**
     * The field used to determine how to create a range-based partition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#field BigqueryTable#field}
     */
    readonly field: string;
    /**
     * range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#range BigqueryTable#range}
     */
    readonly range: BigqueryTableRangePartitioningRange;
}
export declare class BigqueryTableRangePartitioningOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _field?;
    get field(): string;
    set field(value: string);
    get fieldInput(): string | undefined;
    private _range?;
    private __rangeOutput;
    get range(): BigqueryTableRangePartitioningRangeOutputReference;
    putRange(value: BigqueryTableRangePartitioningRange): void;
    get rangeInput(): BigqueryTableRangePartitioningRange | undefined;
}
export interface BigqueryTableTimePartitioning {
    /**
     * Number of milliseconds for which to keep the storage for a partition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#expiration_ms BigqueryTable#expiration_ms}
     */
    readonly expirationMs?: number;
    /**
     * The field used to determine how to create a time-based partition.
     *
     * If time-based partitioning is enabled without this value, the table is partitioned based on the load time.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#field BigqueryTable#field}
     */
    readonly field?: string;
    /**
     * If set to true, queries over this table require a partition filter that can be used for partition elimination to be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#require_partition_filter BigqueryTable#require_partition_filter}
     */
    readonly requirePartitionFilter?: boolean | cdktf.IResolvable;
    /**
     * The supported types are DAY, HOUR, MONTH, and YEAR, which will generate one partition per day, hour, month, and year, respectively.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#type BigqueryTable#type}
     */
    readonly type: string;
}
export declare class BigqueryTableTimePartitioningOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _expirationMs?;
    get expirationMs(): number | undefined;
    set expirationMs(value: number | undefined);
    resetExpirationMs(): void;
    get expirationMsInput(): number | undefined;
    private _field?;
    get field(): string | undefined;
    set field(value: string | undefined);
    resetField(): void;
    get fieldInput(): string | undefined;
    private _requirePartitionFilter?;
    get requirePartitionFilter(): boolean | cdktf.IResolvable | undefined;
    set requirePartitionFilter(value: boolean | cdktf.IResolvable | undefined);
    resetRequirePartitionFilter(): void;
    get requirePartitionFilterInput(): boolean | cdktf.IResolvable | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface BigqueryTableView {
    /**
     * A query that BigQuery executes when the view is referenced.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#query BigqueryTable#query}
     */
    readonly query: string;
    /**
     * Specifies whether to use BigQuery's legacy SQL for this view.
     *
     * The default value is true. If set to false, the view will use BigQuery's standard SQL
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html#use_legacy_sql BigqueryTable#use_legacy_sql}
     */
    readonly useLegacySql?: boolean | cdktf.IResolvable;
}
export declare class BigqueryTableViewOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
    private _useLegacySql?;
    get useLegacySql(): boolean | cdktf.IResolvable | undefined;
    set useLegacySql(value: boolean | cdktf.IResolvable | undefined);
    resetUseLegacySql(): void;
    get useLegacySqlInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html google_bigquery_table}.
 */
export declare class BigqueryTable extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigquery_table.html google_bigquery_table} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: BigqueryTableConfig);
    private _clustering?;
    get clustering(): string[] | undefined;
    set clustering(value: string[] | undefined);
    resetClustering(): void;
    get clusteringInput(): string[] | undefined;
    get creationTime(): number;
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _deletionProtection?;
    get deletionProtection(): boolean | cdktf.IResolvable | undefined;
    set deletionProtection(value: boolean | cdktf.IResolvable | undefined);
    resetDeletionProtection(): void;
    get deletionProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get etag(): string;
    private _expirationTime?;
    get expirationTime(): number | undefined;
    set expirationTime(value: number | undefined);
    resetExpirationTime(): void;
    get expirationTimeInput(): number | undefined;
    private _friendlyName?;
    get friendlyName(): string | undefined;
    set friendlyName(value: string | undefined);
    resetFriendlyName(): void;
    get friendlyNameInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    get lastModifiedTime(): number;
    get location(): string;
    get numBytes(): number;
    get numLongTermBytes(): number;
    get numRows(): number;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _schema?;
    get schema(): string | undefined;
    set schema(value: string | undefined);
    resetSchema(): void;
    get schemaInput(): string | undefined;
    get selfLink(): string;
    private _tableId?;
    get tableId(): string;
    set tableId(value: string);
    get tableIdInput(): string | undefined;
    get type(): string;
    private _encryptionConfiguration?;
    private __encryptionConfigurationOutput;
    get encryptionConfiguration(): BigqueryTableEncryptionConfigurationOutputReference;
    putEncryptionConfiguration(value: BigqueryTableEncryptionConfiguration | undefined): void;
    resetEncryptionConfiguration(): void;
    get encryptionConfigurationInput(): BigqueryTableEncryptionConfiguration | undefined;
    private _externalDataConfiguration?;
    private __externalDataConfigurationOutput;
    get externalDataConfiguration(): BigqueryTableExternalDataConfigurationOutputReference;
    putExternalDataConfiguration(value: BigqueryTableExternalDataConfiguration | undefined): void;
    resetExternalDataConfiguration(): void;
    get externalDataConfigurationInput(): BigqueryTableExternalDataConfiguration | undefined;
    private _materializedView?;
    private __materializedViewOutput;
    get materializedView(): BigqueryTableMaterializedViewOutputReference;
    putMaterializedView(value: BigqueryTableMaterializedView | undefined): void;
    resetMaterializedView(): void;
    get materializedViewInput(): BigqueryTableMaterializedView | undefined;
    private _rangePartitioning?;
    private __rangePartitioningOutput;
    get rangePartitioning(): BigqueryTableRangePartitioningOutputReference;
    putRangePartitioning(value: BigqueryTableRangePartitioning | undefined): void;
    resetRangePartitioning(): void;
    get rangePartitioningInput(): BigqueryTableRangePartitioning | undefined;
    private _timePartitioning?;
    private __timePartitioningOutput;
    get timePartitioning(): BigqueryTableTimePartitioningOutputReference;
    putTimePartitioning(value: BigqueryTableTimePartitioning | undefined): void;
    resetTimePartitioning(): void;
    get timePartitioningInput(): BigqueryTableTimePartitioning | undefined;
    private _view?;
    private __viewOutput;
    get view(): BigqueryTableViewOutputReference;
    putView(value: BigqueryTableView | undefined): void;
    resetView(): void;
    get viewInput(): BigqueryTableView | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
