import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BigqueryReservationConfig extends cdktf.TerraformMetaArguments {
    /**
     * If false, any query using this reservation will use idle slots from other reservations within the same admin project.
     *
     * If true, a query using this reservation will execute with the slot
     * capacity specified above at most.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation.html#ignore_idle_slots BigqueryReservation#ignore_idle_slots}
     */
    readonly ignoreIdleSlots?: boolean | cdktf.IResolvable;
    /**
     * The geographic location where the transfer config should reside. Examples: US, EU, asia-northeast1. The default value is US.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation.html#location BigqueryReservation#location}
     */
    readonly location?: string;
    /**
     * The name of the reservation. This field must only contain alphanumeric characters or dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation.html#name BigqueryReservation#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation.html#project BigqueryReservation#project}.
     */
    readonly project?: string;
    /**
     * Minimum slots available to this reservation.
     *
     * A slot is a unit of computational power in BigQuery, and serves as the
     * unit of parallelism. Queries using this reservation might use more slots during runtime if ignoreIdleSlots is set to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation.html#slot_capacity BigqueryReservation#slot_capacity}
     */
    readonly slotCapacity: number;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation.html#timeouts BigqueryReservation#timeouts}
     */
    readonly timeouts?: BigqueryReservationTimeouts;
}
export interface BigqueryReservationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation.html#create BigqueryReservation#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation.html#delete BigqueryReservation#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation.html#update BigqueryReservation#update}.
     */
    readonly update?: string;
}
export declare class BigqueryReservationTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation.html google_bigquery_reservation}.
 */
export declare class BigqueryReservation extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation.html google_bigquery_reservation} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: BigqueryReservationConfig);
    get id(): string;
    private _ignoreIdleSlots?;
    get ignoreIdleSlots(): boolean | cdktf.IResolvable | undefined;
    set ignoreIdleSlots(value: boolean | cdktf.IResolvable | undefined);
    resetIgnoreIdleSlots(): void;
    get ignoreIdleSlotsInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string | undefined;
    set location(value: string | undefined);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _slotCapacity?;
    get slotCapacity(): number;
    set slotCapacity(value: number);
    get slotCapacityInput(): number | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): BigqueryReservationTimeoutsOutputReference;
    putTimeouts(value: BigqueryReservationTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): BigqueryReservationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
