import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BigqueryJobConfig extends cdktf.TerraformMetaArguments {
    /**
     * The ID of the job.
     *
     * The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-). The maximum length is 1,024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#job_id BigqueryJob#job_id}
     */
    readonly jobId: string;
    /**
     * Job timeout in milliseconds. If this time limit is exceeded, BigQuery may attempt to terminate the job.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#job_timeout_ms BigqueryJob#job_timeout_ms}
     */
    readonly jobTimeoutMs?: string;
    /**
     * The labels associated with this job. You can use these to organize and group your jobs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#labels BigqueryJob#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The geographic location of the job. The default value is US.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#location BigqueryJob#location}
     */
    readonly location?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#project BigqueryJob#project}.
     */
    readonly project?: string;
    /**
     * copy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#copy BigqueryJob#copy}
     */
    readonly copy?: BigqueryJobCopy;
    /**
     * extract block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#extract BigqueryJob#extract}
     */
    readonly extract?: BigqueryJobExtract;
    /**
     * load block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#load BigqueryJob#load}
     */
    readonly load?: BigqueryJobLoad;
    /**
     * query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#query BigqueryJob#query}
     */
    readonly query?: BigqueryJobQuery;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#timeouts BigqueryJob#timeouts}
     */
    readonly timeouts?: BigqueryJobTimeouts;
}
export declare class BigqueryJobStatusErrorResult extends cdktf.ComplexComputedList {
    get location(): string;
    get message(): string;
    get reason(): string;
}
export declare class BigqueryJobStatusErrors extends cdktf.ComplexComputedList {
    get location(): string;
    get message(): string;
    get reason(): string;
}
export declare class BigqueryJobStatus extends cdktf.ComplexComputedList {
    get errorResult(): any;
    get errors(): any;
    get state(): string;
}
export interface BigqueryJobCopyDestinationEncryptionConfiguration {
    /**
     * Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.
     *
     * The BigQuery Service Account associated with your project requires access to this encryption key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#kms_key_name BigqueryJob#kms_key_name}
     */
    readonly kmsKeyName: string;
}
export declare class BigqueryJobCopyDestinationEncryptionConfigurationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
}
export interface BigqueryJobCopyDestinationTable {
    /**
     * The ID of the dataset containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#dataset_id BigqueryJob#dataset_id}
     */
    readonly datasetId?: string;
    /**
     * The ID of the project containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#project_id BigqueryJob#project_id}
     */
    readonly projectId?: string;
    /**
     * The table. Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set, or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#table_id BigqueryJob#table_id}
     */
    readonly tableId: string;
}
export declare class BigqueryJobCopyDestinationTableOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _datasetId?;
    get datasetId(): string | undefined;
    set datasetId(value: string | undefined);
    resetDatasetId(): void;
    get datasetIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string | undefined;
    set projectId(value: string | undefined);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
    private _tableId?;
    get tableId(): string;
    set tableId(value: string);
    get tableIdInput(): string | undefined;
}
export interface BigqueryJobCopySourceTables {
    /**
     * The ID of the dataset containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#dataset_id BigqueryJob#dataset_id}
     */
    readonly datasetId?: string;
    /**
     * The ID of the project containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#project_id BigqueryJob#project_id}
     */
    readonly projectId?: string;
    /**
     * The table. Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set, or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#table_id BigqueryJob#table_id}
     */
    readonly tableId: string;
}
export interface BigqueryJobCopy {
    /**
     * Specifies whether the job is allowed to create new tables.
     *
     * The following values are supported:
     * CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
     * CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result.
     * Creation, truncation and append actions occur as one atomic update upon job completion Default value: "CREATE_IF_NEEDED" Possible values: ["CREATE_IF_NEEDED", "CREATE_NEVER"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#create_disposition BigqueryJob#create_disposition}
     */
    readonly createDisposition?: string;
    /**
     * Specifies the action that occurs if the destination table already exists.
     *
     * The following values are supported:
     * WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result.
     * WRITE_APPEND: If the table already exists, BigQuery appends the data to the table.
     * WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result.
     * Each action is atomic and only occurs if BigQuery is able to complete the job successfully.
     * Creation, truncation and append actions occur as one atomic update upon job completion. Default value: "WRITE_EMPTY" Possible values: ["WRITE_TRUNCATE", "WRITE_APPEND", "WRITE_EMPTY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#write_disposition BigqueryJob#write_disposition}
     */
    readonly writeDisposition?: string;
    /**
     * destination_encryption_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#destination_encryption_configuration BigqueryJob#destination_encryption_configuration}
     */
    readonly destinationEncryptionConfiguration?: BigqueryJobCopyDestinationEncryptionConfiguration;
    /**
     * destination_table block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#destination_table BigqueryJob#destination_table}
     */
    readonly destinationTable?: BigqueryJobCopyDestinationTable;
    /**
     * source_tables block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#source_tables BigqueryJob#source_tables}
     */
    readonly sourceTables: BigqueryJobCopySourceTables[];
}
export declare class BigqueryJobCopyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _createDisposition?;
    get createDisposition(): string | undefined;
    set createDisposition(value: string | undefined);
    resetCreateDisposition(): void;
    get createDispositionInput(): string | undefined;
    private _writeDisposition?;
    get writeDisposition(): string | undefined;
    set writeDisposition(value: string | undefined);
    resetWriteDisposition(): void;
    get writeDispositionInput(): string | undefined;
    private _destinationEncryptionConfiguration?;
    private __destinationEncryptionConfigurationOutput;
    get destinationEncryptionConfiguration(): BigqueryJobCopyDestinationEncryptionConfigurationOutputReference;
    putDestinationEncryptionConfiguration(value: BigqueryJobCopyDestinationEncryptionConfiguration | undefined): void;
    resetDestinationEncryptionConfiguration(): void;
    get destinationEncryptionConfigurationInput(): BigqueryJobCopyDestinationEncryptionConfiguration | undefined;
    private _destinationTable?;
    private __destinationTableOutput;
    get destinationTable(): BigqueryJobCopyDestinationTableOutputReference;
    putDestinationTable(value: BigqueryJobCopyDestinationTable | undefined): void;
    resetDestinationTable(): void;
    get destinationTableInput(): BigqueryJobCopyDestinationTable | undefined;
    private _sourceTables?;
    get sourceTables(): BigqueryJobCopySourceTables[];
    set sourceTables(value: BigqueryJobCopySourceTables[]);
    get sourceTablesInput(): BigqueryJobCopySourceTables[] | undefined;
}
export interface BigqueryJobExtractSourceModel {
    /**
     * The ID of the dataset containing this model.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#dataset_id BigqueryJob#dataset_id}
     */
    readonly datasetId: string;
    /**
     * The ID of the model.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#model_id BigqueryJob#model_id}
     */
    readonly modelId: string;
    /**
     * The ID of the project containing this model.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#project_id BigqueryJob#project_id}
     */
    readonly projectId: string;
}
export declare class BigqueryJobExtractSourceModelOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _modelId?;
    get modelId(): string;
    set modelId(value: string);
    get modelIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
}
export interface BigqueryJobExtractSourceTable {
    /**
     * The ID of the dataset containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#dataset_id BigqueryJob#dataset_id}
     */
    readonly datasetId?: string;
    /**
     * The ID of the project containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#project_id BigqueryJob#project_id}
     */
    readonly projectId?: string;
    /**
     * The table. Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set, or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#table_id BigqueryJob#table_id}
     */
    readonly tableId: string;
}
export declare class BigqueryJobExtractSourceTableOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _datasetId?;
    get datasetId(): string | undefined;
    set datasetId(value: string | undefined);
    resetDatasetId(): void;
    get datasetIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string | undefined;
    set projectId(value: string | undefined);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
    private _tableId?;
    get tableId(): string;
    set tableId(value: string);
    get tableIdInput(): string | undefined;
}
export interface BigqueryJobExtract {
    /**
     * The compression type to use for exported files.
     *
     * Possible values include GZIP, DEFLATE, SNAPPY, and NONE.
     * The default value is NONE. DEFLATE and SNAPPY are only supported for Avro.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#compression BigqueryJob#compression}
     */
    readonly compression?: string;
    /**
     * The exported file format.
     *
     * Possible values include CSV, NEWLINE_DELIMITED_JSON and AVRO for tables and SAVED_MODEL for models.
     * The default value for tables is CSV. Tables with nested or repeated fields cannot be exported as CSV.
     * The default value for models is SAVED_MODEL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#destination_format BigqueryJob#destination_format}
     */
    readonly destinationFormat?: string;
    /**
     * A list of fully-qualified Google Cloud Storage URIs where the extracted table should be written.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#destination_uris BigqueryJob#destination_uris}
     */
    readonly destinationUris: string[];
    /**
     * When extracting data in CSV format, this defines the delimiter to use between fields in the exported data.
     *
     * Default is ','
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#field_delimiter BigqueryJob#field_delimiter}
     */
    readonly fieldDelimiter?: string;
    /**
     * Whether to print out a header row in the results. Default is true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#print_header BigqueryJob#print_header}
     */
    readonly printHeader?: boolean | cdktf.IResolvable;
    /**
     * Whether to use logical types when extracting to AVRO format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#use_avro_logical_types BigqueryJob#use_avro_logical_types}
     */
    readonly useAvroLogicalTypes?: boolean | cdktf.IResolvable;
    /**
     * source_model block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#source_model BigqueryJob#source_model}
     */
    readonly sourceModel?: BigqueryJobExtractSourceModel;
    /**
     * source_table block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#source_table BigqueryJob#source_table}
     */
    readonly sourceTable?: BigqueryJobExtractSourceTable;
}
export declare class BigqueryJobExtractOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _compression?;
    get compression(): string | undefined;
    set compression(value: string | undefined);
    resetCompression(): void;
    get compressionInput(): string | undefined;
    private _destinationFormat?;
    get destinationFormat(): string | undefined;
    set destinationFormat(value: string | undefined);
    resetDestinationFormat(): void;
    get destinationFormatInput(): string | undefined;
    private _destinationUris?;
    get destinationUris(): string[];
    set destinationUris(value: string[]);
    get destinationUrisInput(): string[] | undefined;
    private _fieldDelimiter?;
    get fieldDelimiter(): string | undefined;
    set fieldDelimiter(value: string | undefined);
    resetFieldDelimiter(): void;
    get fieldDelimiterInput(): string | undefined;
    private _printHeader?;
    get printHeader(): boolean | cdktf.IResolvable | undefined;
    set printHeader(value: boolean | cdktf.IResolvable | undefined);
    resetPrintHeader(): void;
    get printHeaderInput(): boolean | cdktf.IResolvable | undefined;
    private _useAvroLogicalTypes?;
    get useAvroLogicalTypes(): boolean | cdktf.IResolvable | undefined;
    set useAvroLogicalTypes(value: boolean | cdktf.IResolvable | undefined);
    resetUseAvroLogicalTypes(): void;
    get useAvroLogicalTypesInput(): boolean | cdktf.IResolvable | undefined;
    private _sourceModel?;
    private __sourceModelOutput;
    get sourceModel(): BigqueryJobExtractSourceModelOutputReference;
    putSourceModel(value: BigqueryJobExtractSourceModel | undefined): void;
    resetSourceModel(): void;
    get sourceModelInput(): BigqueryJobExtractSourceModel | undefined;
    private _sourceTable?;
    private __sourceTableOutput;
    get sourceTable(): BigqueryJobExtractSourceTableOutputReference;
    putSourceTable(value: BigqueryJobExtractSourceTable | undefined): void;
    resetSourceTable(): void;
    get sourceTableInput(): BigqueryJobExtractSourceTable | undefined;
}
export interface BigqueryJobLoadDestinationEncryptionConfiguration {
    /**
     * Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.
     *
     * The BigQuery Service Account associated with your project requires access to this encryption key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#kms_key_name BigqueryJob#kms_key_name}
     */
    readonly kmsKeyName: string;
}
export declare class BigqueryJobLoadDestinationEncryptionConfigurationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
}
export interface BigqueryJobLoadDestinationTable {
    /**
     * The ID of the dataset containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#dataset_id BigqueryJob#dataset_id}
     */
    readonly datasetId?: string;
    /**
     * The ID of the project containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#project_id BigqueryJob#project_id}
     */
    readonly projectId?: string;
    /**
     * The table. Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set, or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#table_id BigqueryJob#table_id}
     */
    readonly tableId: string;
}
export declare class BigqueryJobLoadDestinationTableOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _datasetId?;
    get datasetId(): string | undefined;
    set datasetId(value: string | undefined);
    resetDatasetId(): void;
    get datasetIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string | undefined;
    set projectId(value: string | undefined);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
    private _tableId?;
    get tableId(): string;
    set tableId(value: string);
    get tableIdInput(): string | undefined;
}
export interface BigqueryJobLoadTimePartitioning {
    /**
     * Number of milliseconds for which to keep the storage for a partition.
     *
     * A wrapper is used here because 0 is an invalid value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#expiration_ms BigqueryJob#expiration_ms}
     */
    readonly expirationMs?: string;
    /**
     * If not set, the table is partitioned by pseudo column '_PARTITIONTIME';
     *
     * if set, the table is partitioned by this field.
     * The field must be a top-level TIMESTAMP or DATE field. Its mode must be NULLABLE or REQUIRED.
     * A wrapper is used here because an empty string is an invalid value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#field BigqueryJob#field}
     */
    readonly field?: string;
    /**
     * The only type supported is DAY, which will generate one partition per day.
     *
     * Providing an empty string used to cause an error,
     * but in OnePlatform the field will be treated as unset.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#type BigqueryJob#type}
     */
    readonly type: string;
}
export declare class BigqueryJobLoadTimePartitioningOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _expirationMs?;
    get expirationMs(): string | undefined;
    set expirationMs(value: string | undefined);
    resetExpirationMs(): void;
    get expirationMsInput(): string | undefined;
    private _field?;
    get field(): string | undefined;
    set field(value: string | undefined);
    resetField(): void;
    get fieldInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface BigqueryJobLoad {
    /**
     * Accept rows that are missing trailing optional columns.
     *
     * The missing values are treated as nulls.
     * If false, records with missing trailing columns are treated as bad records, and if there are too many bad records,
     * an invalid error is returned in the job result. The default value is false. Only applicable to CSV, ignored for other formats.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#allow_jagged_rows BigqueryJob#allow_jagged_rows}
     */
    readonly allowJaggedRows?: boolean | cdktf.IResolvable;
    /**
     * Indicates if BigQuery should allow quoted data sections that contain newline characters in a CSV file.
     *
     * The default value is false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#allow_quoted_newlines BigqueryJob#allow_quoted_newlines}
     */
    readonly allowQuotedNewlines?: boolean | cdktf.IResolvable;
    /**
     * Indicates if we should automatically infer the options and schema for CSV and JSON sources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#autodetect BigqueryJob#autodetect}
     */
    readonly autodetect?: boolean | cdktf.IResolvable;
    /**
     * Specifies whether the job is allowed to create new tables.
     *
     * The following values are supported:
     * CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
     * CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result.
     * Creation, truncation and append actions occur as one atomic update upon job completion Default value: "CREATE_IF_NEEDED" Possible values: ["CREATE_IF_NEEDED", "CREATE_NEVER"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#create_disposition BigqueryJob#create_disposition}
     */
    readonly createDisposition?: string;
    /**
     * The character encoding of the data.
     *
     * The supported values are UTF-8 or ISO-8859-1.
     * The default value is UTF-8. BigQuery decodes the data after the raw, binary data
     * has been split using the values of the quote and fieldDelimiter properties.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#encoding BigqueryJob#encoding}
     */
    readonly encoding?: string;
    /**
     * The separator for fields in a CSV file.
     *
     * The separator can be any ISO-8859-1 single-byte character.
     * To use a character in the range 128-255, you must encode the character as UTF8. BigQuery converts
     * the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the
     * data in its raw, binary state. BigQuery also supports the escape sequence "\t" to specify a tab separator.
     * The default value is a comma (',').
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#field_delimiter BigqueryJob#field_delimiter}
     */
    readonly fieldDelimiter?: string;
    /**
     * Indicates if BigQuery should allow extra values that are not represented in the table schema.
     *
     * If true, the extra values are ignored. If false, records with extra columns are treated as bad records,
     * and if there are too many bad records, an invalid error is returned in the job result.
     * The default value is false. The sourceFormat property determines what BigQuery treats as an extra value:
     * CSV: Trailing columns
     * JSON: Named values that don't match any column names
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#ignore_unknown_values BigqueryJob#ignore_unknown_values}
     */
    readonly ignoreUnknownValues?: boolean | cdktf.IResolvable;
    /**
     * The maximum number of bad records that BigQuery can ignore when running the job.
     *
     * If the number of bad records exceeds this value,
     * an invalid error is returned in the job result. The default value is 0, which requires that all records are valid.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#max_bad_records BigqueryJob#max_bad_records}
     */
    readonly maxBadRecords?: number;
    /**
     * Specifies a string that represents a null value in a CSV file.
     *
     * For example, if you specify "\N", BigQuery interprets "\N" as a null value
     * when loading a CSV file. The default value is the empty string. If you set this property to a custom value, BigQuery throws an error if an
     * empty string is present for all data types except for STRING and BYTE. For STRING and BYTE columns, BigQuery interprets the empty string as
     * an empty value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#null_marker BigqueryJob#null_marker}
     */
    readonly nullMarker?: string;
    /**
     * If sourceFormat is set to "DATASTORE_BACKUP", indicates which entity properties to load into BigQuery from a Cloud Datastore backup.
     *
     * Property names are case sensitive and must be top-level properties. If no properties are specified, BigQuery loads all properties.
     * If any named property isn't found in the Cloud Datastore backup, an invalid error is returned in the job result.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#projection_fields BigqueryJob#projection_fields}
     */
    readonly projectionFields?: string[];
    /**
     * The value that is used to quote data sections in a CSV file.
     *
     * BigQuery converts the string to ISO-8859-1 encoding,
     * and then uses the first byte of the encoded string to split the data in its raw, binary state.
     * The default value is a double-quote ('"'). If your data does not contain quoted sections, set the property value to an empty string.
     * If your data contains quoted newline characters, you must also set the allowQuotedNewlines property to true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#quote BigqueryJob#quote}
     */
    readonly quote?: string;
    /**
     * Allows the schema of the destination table to be updated as a side effect of the load job if a schema is autodetected or supplied in the job configuration.
     *
     * Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND;
     * when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table, specified by partition decorators.
     * For normal tables, WRITE_TRUNCATE will always overwrite the schema. One or more of the following values are specified:
     * ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema.
     * ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#schema_update_options BigqueryJob#schema_update_options}
     */
    readonly schemaUpdateOptions?: string[];
    /**
     * The number of rows at the top of a CSV file that BigQuery will skip when loading the data.
     *
     * The default value is 0. This property is useful if you have header rows in the file that should be skipped.
     * When autodetect is on, the behavior is the following:
     * skipLeadingRows unspecified - Autodetect tries to detect headers in the first row. If they are not detected,
     * the row is read as data. Otherwise data is read starting from the second row.
     * skipLeadingRows is 0 - Instructs autodetect that there are no headers and data should be read starting from the first row.
     * skipLeadingRows = N > 0 - Autodetect skips N-1 rows and tries to detect headers in row N. If headers are not detected,
     * row N is just skipped. Otherwise row N is used to extract column names for the detected schema.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#skip_leading_rows BigqueryJob#skip_leading_rows}
     */
    readonly skipLeadingRows?: number;
    /**
     * The format of the data files.
     *
     * For CSV files, specify "CSV". For datastore backups, specify "DATASTORE_BACKUP".
     * For newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON". For Avro, specify "AVRO". For parquet, specify "PARQUET".
     * For orc, specify "ORC". [Beta] For Bigtable, specify "BIGTABLE".
     * The default value is CSV.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#source_format BigqueryJob#source_format}
     */
    readonly sourceFormat?: string;
    /**
     * The fully-qualified URIs that point to your data in Google Cloud.
     *
     * For Google Cloud Storage URIs: Each URI can contain one '*' wildcard character
     * and it must come after the 'bucket' name. Size limits related to load jobs apply
     * to external data sources. For Google Cloud Bigtable URIs: Exactly one URI can be
     * specified and it has be a fully specified and valid HTTPS URL for a Google Cloud Bigtable table.
     * For Google Cloud Datastore backups: Exactly one URI can be specified. Also, the '*' wildcard character is not allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#source_uris BigqueryJob#source_uris}
     */
    readonly sourceUris: string[];
    /**
     * Specifies the action that occurs if the destination table already exists.
     *
     * The following values are supported:
     * WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result.
     * WRITE_APPEND: If the table already exists, BigQuery appends the data to the table.
     * WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result.
     * Each action is atomic and only occurs if BigQuery is able to complete the job successfully.
     * Creation, truncation and append actions occur as one atomic update upon job completion. Default value: "WRITE_EMPTY" Possible values: ["WRITE_TRUNCATE", "WRITE_APPEND", "WRITE_EMPTY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#write_disposition BigqueryJob#write_disposition}
     */
    readonly writeDisposition?: string;
    /**
     * destination_encryption_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#destination_encryption_configuration BigqueryJob#destination_encryption_configuration}
     */
    readonly destinationEncryptionConfiguration?: BigqueryJobLoadDestinationEncryptionConfiguration;
    /**
     * destination_table block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#destination_table BigqueryJob#destination_table}
     */
    readonly destinationTable: BigqueryJobLoadDestinationTable;
    /**
     * time_partitioning block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#time_partitioning BigqueryJob#time_partitioning}
     */
    readonly timePartitioning?: BigqueryJobLoadTimePartitioning;
}
export declare class BigqueryJobLoadOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _allowJaggedRows?;
    get allowJaggedRows(): boolean | cdktf.IResolvable | undefined;
    set allowJaggedRows(value: boolean | cdktf.IResolvable | undefined);
    resetAllowJaggedRows(): void;
    get allowJaggedRowsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowQuotedNewlines?;
    get allowQuotedNewlines(): boolean | cdktf.IResolvable | undefined;
    set allowQuotedNewlines(value: boolean | cdktf.IResolvable | undefined);
    resetAllowQuotedNewlines(): void;
    get allowQuotedNewlinesInput(): boolean | cdktf.IResolvable | undefined;
    private _autodetect?;
    get autodetect(): boolean | cdktf.IResolvable | undefined;
    set autodetect(value: boolean | cdktf.IResolvable | undefined);
    resetAutodetect(): void;
    get autodetectInput(): boolean | cdktf.IResolvable | undefined;
    private _createDisposition?;
    get createDisposition(): string | undefined;
    set createDisposition(value: string | undefined);
    resetCreateDisposition(): void;
    get createDispositionInput(): string | undefined;
    private _encoding?;
    get encoding(): string | undefined;
    set encoding(value: string | undefined);
    resetEncoding(): void;
    get encodingInput(): string | undefined;
    private _fieldDelimiter?;
    get fieldDelimiter(): string | undefined;
    set fieldDelimiter(value: string | undefined);
    resetFieldDelimiter(): void;
    get fieldDelimiterInput(): string | undefined;
    private _ignoreUnknownValues?;
    get ignoreUnknownValues(): boolean | cdktf.IResolvable | undefined;
    set ignoreUnknownValues(value: boolean | cdktf.IResolvable | undefined);
    resetIgnoreUnknownValues(): void;
    get ignoreUnknownValuesInput(): boolean | cdktf.IResolvable | undefined;
    private _maxBadRecords?;
    get maxBadRecords(): number | undefined;
    set maxBadRecords(value: number | undefined);
    resetMaxBadRecords(): void;
    get maxBadRecordsInput(): number | undefined;
    private _nullMarker?;
    get nullMarker(): string | undefined;
    set nullMarker(value: string | undefined);
    resetNullMarker(): void;
    get nullMarkerInput(): string | undefined;
    private _projectionFields?;
    get projectionFields(): string[] | undefined;
    set projectionFields(value: string[] | undefined);
    resetProjectionFields(): void;
    get projectionFieldsInput(): string[] | undefined;
    private _quote?;
    get quote(): string | undefined;
    set quote(value: string | undefined);
    resetQuote(): void;
    get quoteInput(): string | undefined;
    private _schemaUpdateOptions?;
    get schemaUpdateOptions(): string[] | undefined;
    set schemaUpdateOptions(value: string[] | undefined);
    resetSchemaUpdateOptions(): void;
    get schemaUpdateOptionsInput(): string[] | undefined;
    private _skipLeadingRows?;
    get skipLeadingRows(): number | undefined;
    set skipLeadingRows(value: number | undefined);
    resetSkipLeadingRows(): void;
    get skipLeadingRowsInput(): number | undefined;
    private _sourceFormat?;
    get sourceFormat(): string | undefined;
    set sourceFormat(value: string | undefined);
    resetSourceFormat(): void;
    get sourceFormatInput(): string | undefined;
    private _sourceUris?;
    get sourceUris(): string[];
    set sourceUris(value: string[]);
    get sourceUrisInput(): string[] | undefined;
    private _writeDisposition?;
    get writeDisposition(): string | undefined;
    set writeDisposition(value: string | undefined);
    resetWriteDisposition(): void;
    get writeDispositionInput(): string | undefined;
    private _destinationEncryptionConfiguration?;
    private __destinationEncryptionConfigurationOutput;
    get destinationEncryptionConfiguration(): BigqueryJobLoadDestinationEncryptionConfigurationOutputReference;
    putDestinationEncryptionConfiguration(value: BigqueryJobLoadDestinationEncryptionConfiguration | undefined): void;
    resetDestinationEncryptionConfiguration(): void;
    get destinationEncryptionConfigurationInput(): BigqueryJobLoadDestinationEncryptionConfiguration | undefined;
    private _destinationTable?;
    private __destinationTableOutput;
    get destinationTable(): BigqueryJobLoadDestinationTableOutputReference;
    putDestinationTable(value: BigqueryJobLoadDestinationTable): void;
    get destinationTableInput(): BigqueryJobLoadDestinationTable | undefined;
    private _timePartitioning?;
    private __timePartitioningOutput;
    get timePartitioning(): BigqueryJobLoadTimePartitioningOutputReference;
    putTimePartitioning(value: BigqueryJobLoadTimePartitioning | undefined): void;
    resetTimePartitioning(): void;
    get timePartitioningInput(): BigqueryJobLoadTimePartitioning | undefined;
}
export interface BigqueryJobQueryDefaultDataset {
    /**
     * The dataset. Can be specified '{{dataset_id}}' if 'project_id' is also set, or of the form 'projects/{{project}}/datasets/{{dataset_id}}' if not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#dataset_id BigqueryJob#dataset_id}
     */
    readonly datasetId: string;
    /**
     * The ID of the project containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#project_id BigqueryJob#project_id}
     */
    readonly projectId?: string;
}
export declare class BigqueryJobQueryDefaultDatasetOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string | undefined;
    set projectId(value: string | undefined);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
}
export interface BigqueryJobQueryDestinationEncryptionConfiguration {
    /**
     * Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.
     *
     * The BigQuery Service Account associated with your project requires access to this encryption key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#kms_key_name BigqueryJob#kms_key_name}
     */
    readonly kmsKeyName: string;
}
export declare class BigqueryJobQueryDestinationEncryptionConfigurationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
}
export interface BigqueryJobQueryDestinationTable {
    /**
     * The ID of the dataset containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#dataset_id BigqueryJob#dataset_id}
     */
    readonly datasetId?: string;
    /**
     * The ID of the project containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#project_id BigqueryJob#project_id}
     */
    readonly projectId?: string;
    /**
     * The table. Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set, or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#table_id BigqueryJob#table_id}
     */
    readonly tableId: string;
}
export declare class BigqueryJobQueryDestinationTableOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _datasetId?;
    get datasetId(): string | undefined;
    set datasetId(value: string | undefined);
    resetDatasetId(): void;
    get datasetIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string | undefined;
    set projectId(value: string | undefined);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
    private _tableId?;
    get tableId(): string;
    set tableId(value: string);
    get tableIdInput(): string | undefined;
}
export interface BigqueryJobQueryScriptOptions {
    /**
     * Determines which statement in the script represents the "key result", used to populate the schema and query results of the script job.
     *
     * Possible values: ["LAST", "FIRST_SELECT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#key_result_statement BigqueryJob#key_result_statement}
     */
    readonly keyResultStatement?: string;
    /**
     * Limit on the number of bytes billed per statement. Exceeding this budget results in an error.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#statement_byte_budget BigqueryJob#statement_byte_budget}
     */
    readonly statementByteBudget?: string;
    /**
     * Timeout period for each statement in a script.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#statement_timeout_ms BigqueryJob#statement_timeout_ms}
     */
    readonly statementTimeoutMs?: string;
}
export declare class BigqueryJobQueryScriptOptionsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _keyResultStatement?;
    get keyResultStatement(): string | undefined;
    set keyResultStatement(value: string | undefined);
    resetKeyResultStatement(): void;
    get keyResultStatementInput(): string | undefined;
    private _statementByteBudget?;
    get statementByteBudget(): string | undefined;
    set statementByteBudget(value: string | undefined);
    resetStatementByteBudget(): void;
    get statementByteBudgetInput(): string | undefined;
    private _statementTimeoutMs?;
    get statementTimeoutMs(): string | undefined;
    set statementTimeoutMs(value: string | undefined);
    resetStatementTimeoutMs(): void;
    get statementTimeoutMsInput(): string | undefined;
}
export interface BigqueryJobQueryUserDefinedFunctionResources {
    /**
     * An inline resource that contains code for a user-defined function (UDF).
     *
     * Providing a inline code resource is equivalent to providing a URI for a file containing the same code.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#inline_code BigqueryJob#inline_code}
     */
    readonly inlineCode?: string;
    /**
     * A code resource to load from a Google Cloud Storage URI (gs://bucket/path).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#resource_uri BigqueryJob#resource_uri}
     */
    readonly resourceUri?: string;
}
export interface BigqueryJobQuery {
    /**
     * If true and query uses legacy SQL dialect, allows the query to produce arbitrarily large result tables at a slight cost in performance.
     *
     * Requires destinationTable to be set. For standard SQL queries, this flag is ignored and large results are always allowed.
     * However, you must still set destinationTable when result size exceeds the allowed maximum response size.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#allow_large_results BigqueryJob#allow_large_results}
     */
    readonly allowLargeResults?: boolean | cdktf.IResolvable;
    /**
     * Specifies whether the job is allowed to create new tables.
     *
     * The following values are supported:
     * CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
     * CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result.
     * Creation, truncation and append actions occur as one atomic update upon job completion Default value: "CREATE_IF_NEEDED" Possible values: ["CREATE_IF_NEEDED", "CREATE_NEVER"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#create_disposition BigqueryJob#create_disposition}
     */
    readonly createDisposition?: string;
    /**
     * If true and query uses legacy SQL dialect, flattens all nested and repeated fields in the query results.
     *
     * allowLargeResults must be true if this is set to false. For standard SQL queries, this flag is ignored and results are never flattened.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#flatten_results BigqueryJob#flatten_results}
     */
    readonly flattenResults?: boolean | cdktf.IResolvable;
    /**
     * Limits the billing tier for this job.
     *
     * Queries that have resource usage beyond this tier will fail (without incurring a charge).
     * If unspecified, this will be set to your project default.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#maximum_billing_tier BigqueryJob#maximum_billing_tier}
     */
    readonly maximumBillingTier?: number;
    /**
     * Limits the bytes billed for this job.
     *
     * Queries that will have bytes billed beyond this limit will fail (without incurring a charge).
     * If unspecified, this will be set to your project default.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#maximum_bytes_billed BigqueryJob#maximum_bytes_billed}
     */
    readonly maximumBytesBilled?: string;
    /**
     * Standard SQL only.
     *
     * Set to POSITIONAL to use positional (?) query parameters or to NAMED to use named (@myparam) query parameters in this query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#parameter_mode BigqueryJob#parameter_mode}
     */
    readonly parameterMode?: string;
    /**
     * Specifies a priority for the query. Default value: "INTERACTIVE" Possible values: ["INTERACTIVE", "BATCH"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#priority BigqueryJob#priority}
     */
    readonly priority?: string;
    /**
     * SQL query text to execute.
     *
     * The useLegacySql field can be used to indicate whether the query uses legacy SQL or standard SQL.
     * NOTE*: queries containing [DML language](https://cloud.google.com/bigquery/docs/reference/standard-sql/data-manipulation-language)
     * ('DELETE', 'UPDATE', 'MERGE', 'INSERT') must specify 'create_disposition = ""' and 'write_disposition = ""'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#query BigqueryJob#query}
     */
    readonly query: string;
    /**
     * Allows the schema of the destination table to be updated as a side effect of the query job.
     *
     * Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND;
     * when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table,
     * specified by partition decorators. For normal tables, WRITE_TRUNCATE will always overwrite the schema.
     * One or more of the following values are specified:
     * ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema.
     * ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#schema_update_options BigqueryJob#schema_update_options}
     */
    readonly schemaUpdateOptions?: string[];
    /**
     * Specifies whether to use BigQuery's legacy SQL dialect for this query.
     *
     * The default value is true.
     * If set to false, the query will use BigQuery's standard SQL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#use_legacy_sql BigqueryJob#use_legacy_sql}
     */
    readonly useLegacySql?: boolean | cdktf.IResolvable;
    /**
     * Whether to look for the result in the query cache.
     *
     * The query cache is a best-effort cache that will be flushed whenever
     * tables in the query are modified. Moreover, the query cache is only available when a query does not have a destination table specified.
     * The default value is true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#use_query_cache BigqueryJob#use_query_cache}
     */
    readonly useQueryCache?: boolean | cdktf.IResolvable;
    /**
     * Specifies the action that occurs if the destination table already exists.
     *
     * The following values are supported:
     * WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result.
     * WRITE_APPEND: If the table already exists, BigQuery appends the data to the table.
     * WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result.
     * Each action is atomic and only occurs if BigQuery is able to complete the job successfully.
     * Creation, truncation and append actions occur as one atomic update upon job completion. Default value: "WRITE_EMPTY" Possible values: ["WRITE_TRUNCATE", "WRITE_APPEND", "WRITE_EMPTY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#write_disposition BigqueryJob#write_disposition}
     */
    readonly writeDisposition?: string;
    /**
     * default_dataset block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#default_dataset BigqueryJob#default_dataset}
     */
    readonly defaultDataset?: BigqueryJobQueryDefaultDataset;
    /**
     * destination_encryption_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#destination_encryption_configuration BigqueryJob#destination_encryption_configuration}
     */
    readonly destinationEncryptionConfiguration?: BigqueryJobQueryDestinationEncryptionConfiguration;
    /**
     * destination_table block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#destination_table BigqueryJob#destination_table}
     */
    readonly destinationTable?: BigqueryJobQueryDestinationTable;
    /**
     * script_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#script_options BigqueryJob#script_options}
     */
    readonly scriptOptions?: BigqueryJobQueryScriptOptions;
    /**
     * user_defined_function_resources block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#user_defined_function_resources BigqueryJob#user_defined_function_resources}
     */
    readonly userDefinedFunctionResources?: BigqueryJobQueryUserDefinedFunctionResources[];
}
export declare class BigqueryJobQueryOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _allowLargeResults?;
    get allowLargeResults(): boolean | cdktf.IResolvable | undefined;
    set allowLargeResults(value: boolean | cdktf.IResolvable | undefined);
    resetAllowLargeResults(): void;
    get allowLargeResultsInput(): boolean | cdktf.IResolvable | undefined;
    private _createDisposition?;
    get createDisposition(): string | undefined;
    set createDisposition(value: string | undefined);
    resetCreateDisposition(): void;
    get createDispositionInput(): string | undefined;
    private _flattenResults?;
    get flattenResults(): boolean | cdktf.IResolvable | undefined;
    set flattenResults(value: boolean | cdktf.IResolvable | undefined);
    resetFlattenResults(): void;
    get flattenResultsInput(): boolean | cdktf.IResolvable | undefined;
    private _maximumBillingTier?;
    get maximumBillingTier(): number | undefined;
    set maximumBillingTier(value: number | undefined);
    resetMaximumBillingTier(): void;
    get maximumBillingTierInput(): number | undefined;
    private _maximumBytesBilled?;
    get maximumBytesBilled(): string | undefined;
    set maximumBytesBilled(value: string | undefined);
    resetMaximumBytesBilled(): void;
    get maximumBytesBilledInput(): string | undefined;
    private _parameterMode?;
    get parameterMode(): string | undefined;
    set parameterMode(value: string | undefined);
    resetParameterMode(): void;
    get parameterModeInput(): string | undefined;
    private _priority?;
    get priority(): string | undefined;
    set priority(value: string | undefined);
    resetPriority(): void;
    get priorityInput(): string | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
    private _schemaUpdateOptions?;
    get schemaUpdateOptions(): string[] | undefined;
    set schemaUpdateOptions(value: string[] | undefined);
    resetSchemaUpdateOptions(): void;
    get schemaUpdateOptionsInput(): string[] | undefined;
    private _useLegacySql?;
    get useLegacySql(): boolean | cdktf.IResolvable | undefined;
    set useLegacySql(value: boolean | cdktf.IResolvable | undefined);
    resetUseLegacySql(): void;
    get useLegacySqlInput(): boolean | cdktf.IResolvable | undefined;
    private _useQueryCache?;
    get useQueryCache(): boolean | cdktf.IResolvable | undefined;
    set useQueryCache(value: boolean | cdktf.IResolvable | undefined);
    resetUseQueryCache(): void;
    get useQueryCacheInput(): boolean | cdktf.IResolvable | undefined;
    private _writeDisposition?;
    get writeDisposition(): string | undefined;
    set writeDisposition(value: string | undefined);
    resetWriteDisposition(): void;
    get writeDispositionInput(): string | undefined;
    private _defaultDataset?;
    private __defaultDatasetOutput;
    get defaultDataset(): BigqueryJobQueryDefaultDatasetOutputReference;
    putDefaultDataset(value: BigqueryJobQueryDefaultDataset | undefined): void;
    resetDefaultDataset(): void;
    get defaultDatasetInput(): BigqueryJobQueryDefaultDataset | undefined;
    private _destinationEncryptionConfiguration?;
    private __destinationEncryptionConfigurationOutput;
    get destinationEncryptionConfiguration(): BigqueryJobQueryDestinationEncryptionConfigurationOutputReference;
    putDestinationEncryptionConfiguration(value: BigqueryJobQueryDestinationEncryptionConfiguration | undefined): void;
    resetDestinationEncryptionConfiguration(): void;
    get destinationEncryptionConfigurationInput(): BigqueryJobQueryDestinationEncryptionConfiguration | undefined;
    private _destinationTable?;
    private __destinationTableOutput;
    get destinationTable(): BigqueryJobQueryDestinationTableOutputReference;
    putDestinationTable(value: BigqueryJobQueryDestinationTable | undefined): void;
    resetDestinationTable(): void;
    get destinationTableInput(): BigqueryJobQueryDestinationTable | undefined;
    private _scriptOptions?;
    private __scriptOptionsOutput;
    get scriptOptions(): BigqueryJobQueryScriptOptionsOutputReference;
    putScriptOptions(value: BigqueryJobQueryScriptOptions | undefined): void;
    resetScriptOptions(): void;
    get scriptOptionsInput(): BigqueryJobQueryScriptOptions | undefined;
    private _userDefinedFunctionResources?;
    get userDefinedFunctionResources(): BigqueryJobQueryUserDefinedFunctionResources[] | undefined;
    set userDefinedFunctionResources(value: BigqueryJobQueryUserDefinedFunctionResources[] | undefined);
    resetUserDefinedFunctionResources(): void;
    get userDefinedFunctionResourcesInput(): BigqueryJobQueryUserDefinedFunctionResources[] | undefined;
}
export interface BigqueryJobTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#create BigqueryJob#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html#delete BigqueryJob#delete}.
     */
    readonly delete?: string;
}
export declare class BigqueryJobTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html google_bigquery_job}.
 */
export declare class BigqueryJob extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigquery_job.html google_bigquery_job} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: BigqueryJobConfig);
    get id(): string;
    private _jobId?;
    get jobId(): string;
    set jobId(value: string);
    get jobIdInput(): string | undefined;
    private _jobTimeoutMs?;
    get jobTimeoutMs(): string | undefined;
    set jobTimeoutMs(value: string | undefined);
    resetJobTimeoutMs(): void;
    get jobTimeoutMsInput(): string | undefined;
    get jobType(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string | undefined;
    set location(value: string | undefined);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    status(index: string): BigqueryJobStatus;
    get userEmail(): string;
    private _copy?;
    private __copyOutput;
    get copy(): BigqueryJobCopyOutputReference;
    putCopy(value: BigqueryJobCopy | undefined): void;
    resetCopy(): void;
    get copyInput(): BigqueryJobCopy | undefined;
    private _extract?;
    private __extractOutput;
    get extract(): BigqueryJobExtractOutputReference;
    putExtract(value: BigqueryJobExtract | undefined): void;
    resetExtract(): void;
    get extractInput(): BigqueryJobExtract | undefined;
    private _load?;
    private __loadOutput;
    get load(): BigqueryJobLoadOutputReference;
    putLoad(value: BigqueryJobLoad | undefined): void;
    resetLoad(): void;
    get loadInput(): BigqueryJobLoad | undefined;
    private _query?;
    private __queryOutput;
    get query(): BigqueryJobQueryOutputReference;
    putQuery(value: BigqueryJobQuery | undefined): void;
    resetQuery(): void;
    get queryInput(): BigqueryJobQuery | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): BigqueryJobTimeoutsOutputReference;
    putTimeouts(value: BigqueryJobTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): BigqueryJobTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
