import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BigqueryDatasetConfig extends cdktf.TerraformMetaArguments {
    /**
     * A unique ID for this dataset, without the project name.
     *
     * The ID
     * must contain only letters (a-z, A-Z), numbers (0-9), or
     * underscores (_). The maximum length is 1,024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset.html#dataset_id BigqueryDataset#dataset_id}
     */
    readonly datasetId: string;
    /**
     * The default partition expiration for all partitioned tables in the dataset, in milliseconds.
     *
     * Once this property is set, all newly-created partitioned tables in
     * the dataset will have an 'expirationMs' property in the 'timePartitioning'
     * settings set to this value, and changing the value will only
     * affect new tables, not existing ones. The storage in a partition will
     * have an expiration time of its partition time plus this value.
     * Setting this property overrides the use of 'defaultTableExpirationMs'
     * for partitioned tables: only one of 'defaultTableExpirationMs' and
     * 'defaultPartitionExpirationMs' will be used for any new partitioned
     * table. If you provide an explicit 'timePartitioning.expirationMs' when
     * creating or updating a partitioned table, that value takes precedence
     * over the default partition expiration time indicated by this property.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset.html#default_partition_expiration_ms BigqueryDataset#default_partition_expiration_ms}
     */
    readonly defaultPartitionExpirationMs?: number;
    /**
     * The default lifetime of all tables in the dataset, in milliseconds. The minimum value is 3600000 milliseconds (one hour).
     *
     * Once this property is set, all newly-created tables in the dataset
     * will have an 'expirationTime' property set to the creation time plus
     * the value in this property, and changing the value will only affect
     * new tables, not existing ones. When the 'expirationTime' for a given
     * table is reached, that table will be deleted automatically.
     * If a table's 'expirationTime' is modified or removed before the
     * table expires, or if you provide an explicit 'expirationTime' when
     * creating a table, that value takes precedence over the default
     * expiration time indicated by this property.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset.html#default_table_expiration_ms BigqueryDataset#default_table_expiration_ms}
     */
    readonly defaultTableExpirationMs?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset.html#delete_contents_on_destroy BigqueryDataset#delete_contents_on_destroy}.
     */
    readonly deleteContentsOnDestroy?: boolean | cdktf.IResolvable;
    /**
     * A user-friendly description of the dataset.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset.html#description BigqueryDataset#description}
     */
    readonly description?: string;
    /**
     * A descriptive name for the dataset.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset.html#friendly_name BigqueryDataset#friendly_name}
     */
    readonly friendlyName?: string;
    /**
     * The labels associated with this dataset. You can use these to organize and group your datasets.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset.html#labels BigqueryDataset#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The geographic location where the dataset should reside. See [official docs](https://cloud.google.com/bigquery/docs/dataset-locations).
     *
     * There are two types of locations, regional or multi-regional. A regional
     * location is a specific geographic place, such as Tokyo, and a multi-regional
     * location is a large geographic area, such as the United States, that
     * contains at least two geographic places.
     *
     *
     * The default value is multi-regional location 'US'.
     * Changing this forces a new resource to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset.html#location BigqueryDataset#location}
     */
    readonly location?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset.html#project BigqueryDataset#project}.
     */
    readonly project?: string;
    /**
     * access block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset.html#access BigqueryDataset#access}
     */
    readonly access?: BigqueryDatasetAccess[];
    /**
     * default_encryption_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset.html#default_encryption_configuration BigqueryDataset#default_encryption_configuration}
     */
    readonly defaultEncryptionConfiguration?: BigqueryDatasetDefaultEncryptionConfiguration;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset.html#timeouts BigqueryDataset#timeouts}
     */
    readonly timeouts?: BigqueryDatasetTimeouts;
}
export interface BigqueryDatasetAccessView {
    /**
     * The ID of the dataset containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset.html#dataset_id BigqueryDataset#dataset_id}
     */
    readonly datasetId: string;
    /**
     * The ID of the project containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset.html#project_id BigqueryDataset#project_id}
     */
    readonly projectId: string;
    /**
     * The ID of the table.
     *
     * The ID must contain only letters (a-z,
     * A-Z), numbers (0-9), or underscores (_). The maximum length
     * is 1,024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset.html#table_id BigqueryDataset#table_id}
     */
    readonly tableId: string;
}
export declare class BigqueryDatasetAccessViewOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _tableId?;
    get tableId(): string;
    set tableId(value: string);
    get tableIdInput(): string | undefined;
}
export interface BigqueryDatasetAccess {
    /**
     * A domain to grant access to. Any users signed in with the domain specified will be granted the specified access.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset.html#domain BigqueryDataset#domain}
     */
    readonly domain?: string;
    /**
     * An email address of a Google Group to grant access to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset.html#group_by_email BigqueryDataset#group_by_email}
     */
    readonly groupByEmail?: string;
    /**
     * Describes the rights granted to the user specified by the other member of the access object.
     *
     * Basic, predefined, and custom roles
     * are supported. Predefined roles that have equivalent basic roles
     * are swapped by the API to their basic counterparts. See
     * [official docs](https://cloud.google.com/bigquery/docs/access-control).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset.html#role BigqueryDataset#role}
     */
    readonly role?: string;
    /**
     * A special group to grant access to. Possible values include:.
     *
     * 'projectOwners': Owners of the enclosing project.
     *
     *
     * 'projectReaders': Readers of the enclosing project.
     *
     *
     * 'projectWriters': Writers of the enclosing project.
     *
     *
     * 'allAuthenticatedUsers': All authenticated BigQuery users.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset.html#special_group BigqueryDataset#special_group}
     */
    readonly specialGroup?: string;
    /**
     * An email address of a user to grant access to. For example: fred@example.com.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset.html#user_by_email BigqueryDataset#user_by_email}
     */
    readonly userByEmail?: string;
    /**
     * view block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset.html#view BigqueryDataset#view}
     */
    readonly view?: BigqueryDatasetAccessView;
}
export interface BigqueryDatasetDefaultEncryptionConfiguration {
    /**
     * Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.
     *
     * The BigQuery Service Account associated with your project requires
     * access to this encryption key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset.html#kms_key_name BigqueryDataset#kms_key_name}
     */
    readonly kmsKeyName: string;
}
export declare class BigqueryDatasetDefaultEncryptionConfigurationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
}
export interface BigqueryDatasetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset.html#create BigqueryDataset#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset.html#delete BigqueryDataset#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset.html#update BigqueryDataset#update}.
     */
    readonly update?: string;
}
export declare class BigqueryDatasetTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset.html google_bigquery_dataset}.
 */
export declare class BigqueryDataset extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset.html google_bigquery_dataset} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: BigqueryDatasetConfig);
    get creationTime(): number;
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _defaultPartitionExpirationMs?;
    get defaultPartitionExpirationMs(): number | undefined;
    set defaultPartitionExpirationMs(value: number | undefined);
    resetDefaultPartitionExpirationMs(): void;
    get defaultPartitionExpirationMsInput(): number | undefined;
    private _defaultTableExpirationMs?;
    get defaultTableExpirationMs(): number | undefined;
    set defaultTableExpirationMs(value: number | undefined);
    resetDefaultTableExpirationMs(): void;
    get defaultTableExpirationMsInput(): number | undefined;
    private _deleteContentsOnDestroy?;
    get deleteContentsOnDestroy(): boolean | cdktf.IResolvable | undefined;
    set deleteContentsOnDestroy(value: boolean | cdktf.IResolvable | undefined);
    resetDeleteContentsOnDestroy(): void;
    get deleteContentsOnDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get etag(): string;
    private _friendlyName?;
    get friendlyName(): string | undefined;
    set friendlyName(value: string | undefined);
    resetFriendlyName(): void;
    get friendlyNameInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    get lastModifiedTime(): number;
    private _location?;
    get location(): string | undefined;
    set location(value: string | undefined);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _access?;
    get access(): BigqueryDatasetAccess[] | undefined;
    set access(value: BigqueryDatasetAccess[] | undefined);
    resetAccess(): void;
    get accessInput(): BigqueryDatasetAccess[] | undefined;
    private _defaultEncryptionConfiguration?;
    private __defaultEncryptionConfigurationOutput;
    get defaultEncryptionConfiguration(): BigqueryDatasetDefaultEncryptionConfigurationOutputReference;
    putDefaultEncryptionConfiguration(value: BigqueryDatasetDefaultEncryptionConfiguration | undefined): void;
    resetDefaultEncryptionConfiguration(): void;
    get defaultEncryptionConfigurationInput(): BigqueryDatasetDefaultEncryptionConfiguration | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): BigqueryDatasetTimeoutsOutputReference;
    putTimeouts(value: BigqueryDatasetTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): BigqueryDatasetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
