import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BigqueryDatasetIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_iam_binding.html#dataset_id BigqueryDatasetIamBinding#dataset_id}.
     */
    readonly datasetId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_iam_binding.html#members BigqueryDatasetIamBinding#members}.
     */
    readonly members: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_iam_binding.html#project BigqueryDatasetIamBinding#project}.
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_iam_binding.html#role BigqueryDatasetIamBinding#role}.
     */
    readonly role: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_iam_binding.html#condition BigqueryDatasetIamBinding#condition}
     */
    readonly condition?: BigqueryDatasetIamBindingCondition;
}
export interface BigqueryDatasetIamBindingCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_iam_binding.html#description BigqueryDatasetIamBinding#description}.
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_iam_binding.html#expression BigqueryDatasetIamBinding#expression}.
     */
    readonly expression: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_iam_binding.html#title BigqueryDatasetIamBinding#title}.
     */
    readonly title: string;
}
export declare class BigqueryDatasetIamBindingConditionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_iam_binding.html google_bigquery_dataset_iam_binding}.
 */
export declare class BigqueryDatasetIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_iam_binding.html google_bigquery_dataset_iam_binding} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: BigqueryDatasetIamBindingConfig);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition?;
    private __conditionOutput;
    get condition(): BigqueryDatasetIamBindingConditionOutputReference;
    putCondition(value: BigqueryDatasetIamBindingCondition | undefined): void;
    resetCondition(): void;
    get conditionInput(): BigqueryDatasetIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
