import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BigqueryDatasetAccessAConfig extends cdktf.TerraformMetaArguments {
    /**
     * A unique ID for this dataset, without the project name.
     *
     * The ID
     * must contain only letters (a-z, A-Z), numbers (0-9), or
     * underscores (_). The maximum length is 1,024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#dataset_id BigqueryDatasetAccessA#dataset_id}
     */
    readonly datasetId: string;
    /**
     * A domain to grant access to. Any users signed in with the domain specified will be granted the specified access.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#domain BigqueryDatasetAccessA#domain}
     */
    readonly domain?: string;
    /**
     * An email address of a Google Group to grant access to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#group_by_email BigqueryDatasetAccessA#group_by_email}
     */
    readonly groupByEmail?: string;
    /**
     * Some other type of member that appears in the IAM Policy but isn't a user, group, domain, or special group.
     *
     * For example: 'allUsers'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#iam_member BigqueryDatasetAccessA#iam_member}
     */
    readonly iamMember?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#project BigqueryDatasetAccessA#project}.
     */
    readonly project?: string;
    /**
     * Describes the rights granted to the user specified by the other member of the access object.
     *
     * Basic, predefined, and custom roles are
     * supported. Predefined roles that have equivalent basic roles are
     * swapped by the API to their basic counterparts, and will show a diff
     * post-create. See
     * [official docs](https://cloud.google.com/bigquery/docs/access-control).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#role BigqueryDatasetAccessA#role}
     */
    readonly role?: string;
    /**
     * A special group to grant access to. Possible values include:.
     *
     * 'projectOwners': Owners of the enclosing project.
     *
     *
     * 'projectReaders': Readers of the enclosing project.
     *
     *
     * 'projectWriters': Writers of the enclosing project.
     *
     *
     * 'allAuthenticatedUsers': All authenticated BigQuery users.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#special_group BigqueryDatasetAccessA#special_group}
     */
    readonly specialGroup?: string;
    /**
     * An email address of a user to grant access to. For example: fred@example.com.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#user_by_email BigqueryDatasetAccessA#user_by_email}
     */
    readonly userByEmail?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#timeouts BigqueryDatasetAccessA#timeouts}
     */
    readonly timeouts?: BigqueryDatasetAccessTimeouts;
    /**
     * view block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#view BigqueryDatasetAccessA#view}
     */
    readonly view?: BigqueryDatasetAccessViewA;
}
export interface BigqueryDatasetAccessTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#create BigqueryDatasetAccessA#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#delete BigqueryDatasetAccessA#delete}.
     */
    readonly delete?: string;
}
export declare class BigqueryDatasetAccessTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
export interface BigqueryDatasetAccessViewA {
    /**
     * The ID of the dataset containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#dataset_id BigqueryDatasetAccessA#dataset_id}
     */
    readonly datasetId: string;
    /**
     * The ID of the project containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#project_id BigqueryDatasetAccessA#project_id}
     */
    readonly projectId: string;
    /**
     * The ID of the table.
     *
     * The ID must contain only letters (a-z,
     * A-Z), numbers (0-9), or underscores (_). The maximum length
     * is 1,024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html#table_id BigqueryDatasetAccessA#table_id}
     */
    readonly tableId: string;
}
export declare class BigqueryDatasetAccessViewAOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _tableId?;
    get tableId(): string;
    set tableId(value: string);
    get tableIdInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html google_bigquery_dataset_access}.
 */
export declare class BigqueryDatasetAccessA extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access.html google_bigquery_dataset_access} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: BigqueryDatasetAccessAConfig);
    get apiUpdatedMember(): any;
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _domain?;
    get domain(): string | undefined;
    set domain(value: string | undefined);
    resetDomain(): void;
    get domainInput(): string | undefined;
    private _groupByEmail?;
    get groupByEmail(): string | undefined;
    set groupByEmail(value: string | undefined);
    resetGroupByEmail(): void;
    get groupByEmailInput(): string | undefined;
    private _iamMember?;
    get iamMember(): string | undefined;
    set iamMember(value: string | undefined);
    resetIamMember(): void;
    get iamMemberInput(): string | undefined;
    get id(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string | undefined;
    set role(value: string | undefined);
    resetRole(): void;
    get roleInput(): string | undefined;
    private _specialGroup?;
    get specialGroup(): string | undefined;
    set specialGroup(value: string | undefined);
    resetSpecialGroup(): void;
    get specialGroupInput(): string | undefined;
    private _userByEmail?;
    get userByEmail(): string | undefined;
    set userByEmail(value: string | undefined);
    resetUserByEmail(): void;
    get userByEmailInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): BigqueryDatasetAccessTimeoutsOutputReference;
    putTimeouts(value: BigqueryDatasetAccessTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): BigqueryDatasetAccessTimeouts | undefined;
    private _view?;
    private __viewOutput;
    get view(): BigqueryDatasetAccessViewAOutputReference;
    putView(value: BigqueryDatasetAccessViewA | undefined): void;
    resetView(): void;
    get viewInput(): BigqueryDatasetAccessViewA | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
