import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BigqueryDataTransferConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * The number of days to look back to automatically refresh the data.
     *
     * For example, if dataRefreshWindowDays = 10, then every day BigQuery
     * reingests data for [today-10, today-1], rather than ingesting data for
     * just [today-1]. Only valid if the data source supports the feature.
     * Set the value to 0 to use the default value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#data_refresh_window_days BigqueryDataTransferConfig#data_refresh_window_days}
     */
    readonly dataRefreshWindowDays?: number;
    /**
     * The data source id. Cannot be changed once the transfer config is created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#data_source_id BigqueryDataTransferConfig#data_source_id}
     */
    readonly dataSourceId: string;
    /**
     * The BigQuery target dataset id.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#destination_dataset_id BigqueryDataTransferConfig#destination_dataset_id}
     */
    readonly destinationDatasetId?: string;
    /**
     * When set to true, no runs are scheduled for a given transfer.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#disabled BigqueryDataTransferConfig#disabled}
     */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
     * The user specified display name for the transfer config.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#display_name BigqueryDataTransferConfig#display_name}
     */
    readonly displayName: string;
    /**
     * The geographic location where the transfer config should reside. Examples: US, EU, asia-northeast1. The default value is US.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#location BigqueryDataTransferConfig#location}
     */
    readonly location?: string;
    /**
     * Pub/Sub topic where notifications will be sent after transfer runs associated with this transfer config finish.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#notification_pubsub_topic BigqueryDataTransferConfig#notification_pubsub_topic}
     */
    readonly notificationPubsubTopic?: string;
    /**
     * These parameters are specific to each data source.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#params BigqueryDataTransferConfig#params}
     */
    readonly params: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#project BigqueryDataTransferConfig#project}.
     */
    readonly project?: string;
    /**
     * Data transfer schedule.
     *
     * If the data source does not support a custom
     * schedule, this should be empty. If it is empty, the default value for
     * the data source will be used. The specified times are in UTC. Examples
     * of valid format: 1st,3rd monday of month 15:30, every wed,fri of jan,
     * jun 13:15, and first sunday of quarter 00:00. See more explanation
     * about the format here:
     * https://cloud.google.com/appengine/docs/flexible/python/scheduling-jobs-with-cron-yaml#the_schedule_format
     * NOTE: the granularity should be at least 8 hours, or less frequent.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#schedule BigqueryDataTransferConfig#schedule}
     */
    readonly schedule?: string;
    /**
     * Optional service account name.
     *
     * If this field is set, transfer config will
     * be created with this service account credentials. It requires that
     * requesting user calling this API has permissions to act as this service account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#service_account_name BigqueryDataTransferConfig#service_account_name}
     */
    readonly serviceAccountName?: string;
    /**
     * email_preferences block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#email_preferences BigqueryDataTransferConfig#email_preferences}
     */
    readonly emailPreferences?: BigqueryDataTransferConfigEmailPreferences;
    /**
     * schedule_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#schedule_options BigqueryDataTransferConfig#schedule_options}
     */
    readonly scheduleOptions?: BigqueryDataTransferConfigScheduleOptions;
    /**
     * sensitive_params block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#sensitive_params BigqueryDataTransferConfig#sensitive_params}
     */
    readonly sensitiveParams?: BigqueryDataTransferConfigSensitiveParams;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#timeouts BigqueryDataTransferConfig#timeouts}
     */
    readonly timeouts?: BigqueryDataTransferConfigTimeouts;
}
export interface BigqueryDataTransferConfigEmailPreferences {
    /**
     * If true, email notifications will be sent on transfer run failures.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#enable_failure_email BigqueryDataTransferConfig#enable_failure_email}
     */
    readonly enableFailureEmail: boolean | cdktf.IResolvable;
}
export declare class BigqueryDataTransferConfigEmailPreferencesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enableFailureEmail?;
    get enableFailureEmail(): boolean | cdktf.IResolvable;
    set enableFailureEmail(value: boolean | cdktf.IResolvable);
    get enableFailureEmailInput(): boolean | cdktf.IResolvable | undefined;
}
export interface BigqueryDataTransferConfigScheduleOptions {
    /**
     * If true, automatic scheduling of data transfer runs for this configuration will be disabled.
     *
     * The runs can be started on ad-hoc
     * basis using transferConfigs.startManualRuns API. When automatic
     * scheduling is disabled, the TransferConfig.schedule field will
     * be ignored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#disable_auto_scheduling BigqueryDataTransferConfig#disable_auto_scheduling}
     */
    readonly disableAutoScheduling?: boolean | cdktf.IResolvable;
    /**
     * Defines time to stop scheduling transfer runs.
     *
     * A transfer run cannot be
     * scheduled at or after the end time. The end time can be changed at any
     * moment. The time when a data transfer can be triggered manually is not
     * limited by this option.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#end_time BigqueryDataTransferConfig#end_time}
     */
    readonly endTime?: string;
    /**
     * Specifies time to start scheduling transfer runs.
     *
     * The first run will be
     * scheduled at or after the start time according to a recurrence pattern
     * defined in the schedule string. The start time can be changed at any
     * moment. The time when a data transfer can be triggered manually is not
     * limited by this option.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#start_time BigqueryDataTransferConfig#start_time}
     */
    readonly startTime?: string;
}
export declare class BigqueryDataTransferConfigScheduleOptionsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _disableAutoScheduling?;
    get disableAutoScheduling(): boolean | cdktf.IResolvable | undefined;
    set disableAutoScheduling(value: boolean | cdktf.IResolvable | undefined);
    resetDisableAutoScheduling(): void;
    get disableAutoSchedulingInput(): boolean | cdktf.IResolvable | undefined;
    private _endTime?;
    get endTime(): string | undefined;
    set endTime(value: string | undefined);
    resetEndTime(): void;
    get endTimeInput(): string | undefined;
    private _startTime?;
    get startTime(): string | undefined;
    set startTime(value: string | undefined);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
}
export interface BigqueryDataTransferConfigSensitiveParams {
    /**
     * The Secret Access Key of the AWS account transferring data from.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#secret_access_key BigqueryDataTransferConfig#secret_access_key}
     */
    readonly secretAccessKey: string;
}
export declare class BigqueryDataTransferConfigSensitiveParamsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _secretAccessKey?;
    get secretAccessKey(): string;
    set secretAccessKey(value: string);
    get secretAccessKeyInput(): string | undefined;
}
export interface BigqueryDataTransferConfigTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#create BigqueryDataTransferConfig#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#delete BigqueryDataTransferConfig#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html#update BigqueryDataTransferConfig#update}.
     */
    readonly update?: string;
}
export declare class BigqueryDataTransferConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html google_bigquery_data_transfer_config}.
 */
export declare class BigqueryDataTransferConfig extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigquery_data_transfer_config.html google_bigquery_data_transfer_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: BigqueryDataTransferConfigConfig);
    private _dataRefreshWindowDays?;
    get dataRefreshWindowDays(): number | undefined;
    set dataRefreshWindowDays(value: number | undefined);
    resetDataRefreshWindowDays(): void;
    get dataRefreshWindowDaysInput(): number | undefined;
    private _dataSourceId?;
    get dataSourceId(): string;
    set dataSourceId(value: string);
    get dataSourceIdInput(): string | undefined;
    private _destinationDatasetId?;
    get destinationDatasetId(): string | undefined;
    set destinationDatasetId(value: string | undefined);
    resetDestinationDatasetId(): void;
    get destinationDatasetIdInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable | undefined;
    set disabled(value: boolean | cdktf.IResolvable | undefined);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get id(): string;
    private _location?;
    get location(): string | undefined;
    set location(value: string | undefined);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get name(): string;
    private _notificationPubsubTopic?;
    get notificationPubsubTopic(): string | undefined;
    set notificationPubsubTopic(value: string | undefined);
    resetNotificationPubsubTopic(): void;
    get notificationPubsubTopicInput(): string | undefined;
    private _params?;
    get params(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    set params(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    get paramsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _schedule?;
    get schedule(): string | undefined;
    set schedule(value: string | undefined);
    resetSchedule(): void;
    get scheduleInput(): string | undefined;
    private _serviceAccountName?;
    get serviceAccountName(): string | undefined;
    set serviceAccountName(value: string | undefined);
    resetServiceAccountName(): void;
    get serviceAccountNameInput(): string | undefined;
    private _emailPreferences?;
    private __emailPreferencesOutput;
    get emailPreferences(): BigqueryDataTransferConfigEmailPreferencesOutputReference;
    putEmailPreferences(value: BigqueryDataTransferConfigEmailPreferences | undefined): void;
    resetEmailPreferences(): void;
    get emailPreferencesInput(): BigqueryDataTransferConfigEmailPreferences | undefined;
    private _scheduleOptions?;
    private __scheduleOptionsOutput;
    get scheduleOptions(): BigqueryDataTransferConfigScheduleOptionsOutputReference;
    putScheduleOptions(value: BigqueryDataTransferConfigScheduleOptions | undefined): void;
    resetScheduleOptions(): void;
    get scheduleOptionsInput(): BigqueryDataTransferConfigScheduleOptions | undefined;
    private _sensitiveParams?;
    private __sensitiveParamsOutput;
    get sensitiveParams(): BigqueryDataTransferConfigSensitiveParamsOutputReference;
    putSensitiveParams(value: BigqueryDataTransferConfigSensitiveParams | undefined): void;
    resetSensitiveParams(): void;
    get sensitiveParamsInput(): BigqueryDataTransferConfigSensitiveParams | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): BigqueryDataTransferConfigTimeoutsOutputReference;
    putTimeouts(value: BigqueryDataTransferConfigTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): BigqueryDataTransferConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
