import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppEngineServiceSplitTrafficConfig extends cdktf.TerraformMetaArguments {
    /**
     * If set to true traffic will be migrated to this version.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic.html#migrate_traffic AppEngineServiceSplitTraffic#migrate_traffic}
     */
    readonly migrateTraffic?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic.html#project AppEngineServiceSplitTraffic#project}.
     */
    readonly project?: string;
    /**
     * The name of the service these settings apply to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic.html#service AppEngineServiceSplitTraffic#service}
     */
    readonly service: string;
    /**
     * split block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic.html#split AppEngineServiceSplitTraffic#split}
     */
    readonly split: AppEngineServiceSplitTrafficSplit;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic.html#timeouts AppEngineServiceSplitTraffic#timeouts}
     */
    readonly timeouts?: AppEngineServiceSplitTrafficTimeouts;
}
export interface AppEngineServiceSplitTrafficSplit {
    /**
     * Mapping from version IDs within the service to fractional (0.000, 1] allocations of traffic for that version. Each version can be specified only once, but some versions in the service may not have any traffic allocation. Services that have traffic allocated cannot be deleted until either the service is deleted or their traffic allocation is removed. Allocations must sum to 1. Up to two decimal place precision is supported for IP-based splits and up to three decimal places is supported for cookie-based splits.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic.html#allocations AppEngineServiceSplitTraffic#allocations}
     */
    readonly allocations: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Mechanism used to determine which version a request is sent to.
     *
     * The traffic selection algorithm will be stable for either type until allocations are changed. Possible values: ["UNSPECIFIED", "COOKIE", "IP", "RANDOM"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic.html#shard_by AppEngineServiceSplitTraffic#shard_by}
     */
    readonly shardBy?: string;
}
export declare class AppEngineServiceSplitTrafficSplitOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _allocations?;
    get allocations(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    set allocations(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    get allocationsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _shardBy?;
    get shardBy(): string | undefined;
    set shardBy(value: string | undefined);
    resetShardBy(): void;
    get shardByInput(): string | undefined;
}
export interface AppEngineServiceSplitTrafficTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic.html#create AppEngineServiceSplitTraffic#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic.html#delete AppEngineServiceSplitTraffic#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic.html#update AppEngineServiceSplitTraffic#update}.
     */
    readonly update?: string;
}
export declare class AppEngineServiceSplitTrafficTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic.html google_app_engine_service_split_traffic}.
 */
export declare class AppEngineServiceSplitTraffic extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic.html google_app_engine_service_split_traffic} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: AppEngineServiceSplitTrafficConfig);
    get id(): string;
    private _migrateTraffic?;
    get migrateTraffic(): boolean | cdktf.IResolvable | undefined;
    set migrateTraffic(value: boolean | cdktf.IResolvable | undefined);
    resetMigrateTraffic(): void;
    get migrateTrafficInput(): boolean | cdktf.IResolvable | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _split?;
    private __splitOutput;
    get split(): AppEngineServiceSplitTrafficSplitOutputReference;
    putSplit(value: AppEngineServiceSplitTrafficSplit): void;
    get splitInput(): AppEngineServiceSplitTrafficSplit | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): AppEngineServiceSplitTrafficTimeoutsOutputReference;
    putTimeouts(value: AppEngineServiceSplitTrafficTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): AppEngineServiceSplitTrafficTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
