import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppEngineServiceNetworkSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings.html#project AppEngineServiceNetworkSettings#project}.
     */
    readonly project?: string;
    /**
     * The name of the service these settings apply to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings.html#service AppEngineServiceNetworkSettings#service}
     */
    readonly service: string;
    /**
     * network_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings.html#network_settings AppEngineServiceNetworkSettings#network_settings}
     */
    readonly networkSettings: AppEngineServiceNetworkSettingsNetworkSettings;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings.html#timeouts AppEngineServiceNetworkSettings#timeouts}
     */
    readonly timeouts?: AppEngineServiceNetworkSettingsTimeouts;
}
export interface AppEngineServiceNetworkSettingsNetworkSettings {
    /**
     * The ingress settings for version or service. Default value: "INGRESS_TRAFFIC_ALLOWED_UNSPECIFIED" Possible values: ["INGRESS_TRAFFIC_ALLOWED_UNSPECIFIED", "INGRESS_TRAFFIC_ALLOWED_ALL", "INGRESS_TRAFFIC_ALLOWED_INTERNAL_ONLY", "INGRESS_TRAFFIC_ALLOWED_INTERNAL_AND_LB"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings.html#ingress_traffic_allowed AppEngineServiceNetworkSettings#ingress_traffic_allowed}
     */
    readonly ingressTrafficAllowed?: string;
}
export declare class AppEngineServiceNetworkSettingsNetworkSettingsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _ingressTrafficAllowed?;
    get ingressTrafficAllowed(): string | undefined;
    set ingressTrafficAllowed(value: string | undefined);
    resetIngressTrafficAllowed(): void;
    get ingressTrafficAllowedInput(): string | undefined;
}
export interface AppEngineServiceNetworkSettingsTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings.html#create AppEngineServiceNetworkSettings#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings.html#delete AppEngineServiceNetworkSettings#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings.html#update AppEngineServiceNetworkSettings#update}.
     */
    readonly update?: string;
}
export declare class AppEngineServiceNetworkSettingsTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings.html google_app_engine_service_network_settings}.
 */
export declare class AppEngineServiceNetworkSettings extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings.html google_app_engine_service_network_settings} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: AppEngineServiceNetworkSettingsConfig);
    get id(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _networkSettings?;
    private __networkSettingsOutput;
    get networkSettings(): AppEngineServiceNetworkSettingsNetworkSettingsOutputReference;
    putNetworkSettings(value: AppEngineServiceNetworkSettingsNetworkSettings): void;
    get networkSettingsInput(): AppEngineServiceNetworkSettingsNetworkSettings | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): AppEngineServiceNetworkSettingsTimeoutsOutputReference;
    putTimeouts(value: AppEngineServiceNetworkSettingsTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): AppEngineServiceNetworkSettingsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
