import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppEngineDomainMappingConfig extends cdktf.TerraformMetaArguments {
    /**
     * Relative name of the domain serving the application. Example: example.com.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_domain_mapping.html#domain_name AppEngineDomainMapping#domain_name}
     */
    readonly domainName: string;
    /**
     * Whether the domain creation should override any existing mappings for this domain.
     *
     * By default, overrides are rejected. Default value: "STRICT" Possible values: ["STRICT", "OVERRIDE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_domain_mapping.html#override_strategy AppEngineDomainMapping#override_strategy}
     */
    readonly overrideStrategy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_domain_mapping.html#project AppEngineDomainMapping#project}.
     */
    readonly project?: string;
    /**
     * ssl_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_domain_mapping.html#ssl_settings AppEngineDomainMapping#ssl_settings}
     */
    readonly sslSettings?: AppEngineDomainMappingSslSettings;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_domain_mapping.html#timeouts AppEngineDomainMapping#timeouts}
     */
    readonly timeouts?: AppEngineDomainMappingTimeouts;
}
export declare class AppEngineDomainMappingResourceRecords extends cdktf.ComplexComputedList {
    get name(): string;
    get rrdata(): string;
    get type(): string;
}
export interface AppEngineDomainMappingSslSettings {
    /**
     * ID of the AuthorizedCertificate resource configuring SSL for the application.
     *
     * Clearing this field will
     * remove SSL support.
     * By default, a managed certificate is automatically created for every domain mapping. To omit SSL support
     * or to configure SSL manually, specify 'SslManagementType.MANUAL' on a 'CREATE' or 'UPDATE' request. You must be
     * authorized to administer the 'AuthorizedCertificate' resource to manually map it to a DomainMapping resource.
     * Example: 12345.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_domain_mapping.html#certificate_id AppEngineDomainMapping#certificate_id}
     */
    readonly certificateId?: string;
    /**
     * SSL management type for this domain.
     *
     * If 'AUTOMATIC', a managed certificate is automatically provisioned.
     * If 'MANUAL', 'certificateId' must be manually specified in order to configure SSL for this domain. Possible values: ["AUTOMATIC", "MANUAL"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_domain_mapping.html#ssl_management_type AppEngineDomainMapping#ssl_management_type}
     */
    readonly sslManagementType: string;
}
export declare class AppEngineDomainMappingSslSettingsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _certificateId?;
    get certificateId(): string | undefined;
    set certificateId(value: string | undefined);
    resetCertificateId(): void;
    get certificateIdInput(): string | undefined;
    private _sslManagementType?;
    get sslManagementType(): string;
    set sslManagementType(value: string);
    get sslManagementTypeInput(): string | undefined;
}
export interface AppEngineDomainMappingTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_domain_mapping.html#create AppEngineDomainMapping#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_domain_mapping.html#delete AppEngineDomainMapping#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_domain_mapping.html#update AppEngineDomainMapping#update}.
     */
    readonly update?: string;
}
export declare class AppEngineDomainMappingTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/app_engine_domain_mapping.html google_app_engine_domain_mapping}.
 */
export declare class AppEngineDomainMapping extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/app_engine_domain_mapping.html google_app_engine_domain_mapping} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: AppEngineDomainMappingConfig);
    private _domainName?;
    get domainName(): string;
    set domainName(value: string);
    get domainNameInput(): string | undefined;
    get id(): string;
    get name(): string;
    private _overrideStrategy?;
    get overrideStrategy(): string | undefined;
    set overrideStrategy(value: string | undefined);
    resetOverrideStrategy(): void;
    get overrideStrategyInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    resourceRecords(index: string): AppEngineDomainMappingResourceRecords;
    private _sslSettings?;
    private __sslSettingsOutput;
    get sslSettings(): AppEngineDomainMappingSslSettingsOutputReference;
    putSslSettings(value: AppEngineDomainMappingSslSettings | undefined): void;
    resetSslSettings(): void;
    get sslSettingsInput(): AppEngineDomainMappingSslSettings | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): AppEngineDomainMappingTimeoutsOutputReference;
    putTimeouts(value: AppEngineDomainMappingTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): AppEngineDomainMappingTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
