import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppEngineApplicationConfig extends cdktf.TerraformMetaArguments {
    /**
     * The domain to authenticate users with when using App Engine's User API.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#auth_domain AppEngineApplication#auth_domain}
     */
    readonly authDomain?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#database_type AppEngineApplication#database_type}.
     */
    readonly databaseType?: string;
    /**
     * The location to serve the app from.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#location_id AppEngineApplication#location_id}
     */
    readonly locationId: string;
    /**
     * The project ID to create the application under.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#project AppEngineApplication#project}
     */
    readonly project?: string;
    /**
     * The serving status of the app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#serving_status AppEngineApplication#serving_status}
     */
    readonly servingStatus?: string;
    /**
     * feature_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#feature_settings AppEngineApplication#feature_settings}
     */
    readonly featureSettings?: AppEngineApplicationFeatureSettings;
    /**
     * iap block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#iap AppEngineApplication#iap}
     */
    readonly iap?: AppEngineApplicationIap;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#timeouts AppEngineApplication#timeouts}
     */
    readonly timeouts?: AppEngineApplicationTimeouts;
}
export declare class AppEngineApplicationUrlDispatchRule extends cdktf.ComplexComputedList {
    get domain(): string;
    get path(): string;
    get service(): string;
}
export interface AppEngineApplicationFeatureSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#split_health_checks AppEngineApplication#split_health_checks}.
     */
    readonly splitHealthChecks: boolean | cdktf.IResolvable;
}
export declare class AppEngineApplicationFeatureSettingsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _splitHealthChecks?;
    get splitHealthChecks(): boolean | cdktf.IResolvable;
    set splitHealthChecks(value: boolean | cdktf.IResolvable);
    get splitHealthChecksInput(): boolean | cdktf.IResolvable | undefined;
}
export interface AppEngineApplicationIap {
    /**
     * Adapted for use with the app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#enabled AppEngineApplication#enabled}
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * OAuth2 client ID to use for the authentication flow.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#oauth2_client_id AppEngineApplication#oauth2_client_id}
     */
    readonly oauth2ClientId: string;
    /**
     * OAuth2 client secret to use for the authentication flow.
     *
     * The SHA-256 hash of the value is returned in the oauth2ClientSecretSha256 field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#oauth2_client_secret AppEngineApplication#oauth2_client_secret}
     */
    readonly oauth2ClientSecret: string;
}
export declare class AppEngineApplicationIapOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable | undefined;
    set enabled(value: boolean | cdktf.IResolvable | undefined);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _oauth2ClientId?;
    get oauth2ClientId(): string;
    set oauth2ClientId(value: string);
    get oauth2ClientIdInput(): string | undefined;
    private _oauth2ClientSecret?;
    get oauth2ClientSecret(): string;
    set oauth2ClientSecret(value: string);
    get oauth2ClientSecretInput(): string | undefined;
}
export interface AppEngineApplicationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#create AppEngineApplication#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#update AppEngineApplication#update}.
     */
    readonly update?: string;
}
export declare class AppEngineApplicationTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html google_app_engine_application}.
 */
export declare class AppEngineApplication extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html google_app_engine_application} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: AppEngineApplicationConfig);
    get appId(): string;
    private _authDomain?;
    get authDomain(): string | undefined;
    set authDomain(value: string | undefined);
    resetAuthDomain(): void;
    get authDomainInput(): string | undefined;
    get codeBucket(): string;
    private _databaseType?;
    get databaseType(): string | undefined;
    set databaseType(value: string | undefined);
    resetDatabaseType(): void;
    get databaseTypeInput(): string | undefined;
    get defaultBucket(): string;
    get defaultHostname(): string;
    get gcrDomain(): string;
    get id(): string;
    private _locationId?;
    get locationId(): string;
    set locationId(value: string);
    get locationIdInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _servingStatus?;
    get servingStatus(): string | undefined;
    set servingStatus(value: string | undefined);
    resetServingStatus(): void;
    get servingStatusInput(): string | undefined;
    urlDispatchRule(index: string): AppEngineApplicationUrlDispatchRule;
    private _featureSettings?;
    private __featureSettingsOutput;
    get featureSettings(): AppEngineApplicationFeatureSettingsOutputReference;
    putFeatureSettings(value: AppEngineApplicationFeatureSettings | undefined): void;
    resetFeatureSettings(): void;
    get featureSettingsInput(): AppEngineApplicationFeatureSettings | undefined;
    private _iap?;
    private __iapOutput;
    get iap(): AppEngineApplicationIapOutputReference;
    putIap(value: AppEngineApplicationIap | undefined): void;
    resetIap(): void;
    get iapInput(): AppEngineApplicationIap | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): AppEngineApplicationTimeoutsOutputReference;
    putTimeouts(value: AppEngineApplicationTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): AppEngineApplicationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
