import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppEngineApplicationUrlDispatchRulesConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application_url_dispatch_rules.html#project AppEngineApplicationUrlDispatchRules#project}.
     */
    readonly project?: string;
    /**
     * dispatch_rules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application_url_dispatch_rules.html#dispatch_rules AppEngineApplicationUrlDispatchRules#dispatch_rules}
     */
    readonly dispatchRules: AppEngineApplicationUrlDispatchRulesDispatchRules[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application_url_dispatch_rules.html#timeouts AppEngineApplicationUrlDispatchRules#timeouts}
     */
    readonly timeouts?: AppEngineApplicationUrlDispatchRulesTimeouts;
}
export interface AppEngineApplicationUrlDispatchRulesDispatchRules {
    /**
     * Domain name to match against.
     *
     * The wildcard "*" is supported if specified before a period: "*.".
     * Defaults to matching all domains: "*".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application_url_dispatch_rules.html#domain AppEngineApplicationUrlDispatchRules#domain}
     */
    readonly domain?: string;
    /**
     * Pathname within the host.
     *
     * Must start with a "/". A single "*" can be included at the end of the path.
     * The sum of the lengths of the domain and path may not exceed 100 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application_url_dispatch_rules.html#path AppEngineApplicationUrlDispatchRules#path}
     */
    readonly path: string;
    /**
     * Pathname within the host.
     *
     * Must start with a "/". A single "*" can be included at the end of the path.
     * The sum of the lengths of the domain and path may not exceed 100 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application_url_dispatch_rules.html#service AppEngineApplicationUrlDispatchRules#service}
     */
    readonly service: string;
}
export interface AppEngineApplicationUrlDispatchRulesTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application_url_dispatch_rules.html#create AppEngineApplicationUrlDispatchRules#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application_url_dispatch_rules.html#delete AppEngineApplicationUrlDispatchRules#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application_url_dispatch_rules.html#update AppEngineApplicationUrlDispatchRules#update}.
     */
    readonly update?: string;
}
export declare class AppEngineApplicationUrlDispatchRulesTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/app_engine_application_url_dispatch_rules.html google_app_engine_application_url_dispatch_rules}.
 */
export declare class AppEngineApplicationUrlDispatchRules extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/app_engine_application_url_dispatch_rules.html google_app_engine_application_url_dispatch_rules} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: AppEngineApplicationUrlDispatchRulesConfig);
    get id(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _dispatchRules?;
    get dispatchRules(): AppEngineApplicationUrlDispatchRulesDispatchRules[];
    set dispatchRules(value: AppEngineApplicationUrlDispatchRulesDispatchRules[]);
    get dispatchRulesInput(): AppEngineApplicationUrlDispatchRulesDispatchRules[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): AppEngineApplicationUrlDispatchRulesTimeoutsOutputReference;
    putTimeouts(value: AppEngineApplicationUrlDispatchRulesTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): AppEngineApplicationUrlDispatchRulesTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
