import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApigeeOrganizationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Primary GCP region for analytics data storage. For valid values, see [Create an Apigee organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization.html#analytics_region ApigeeOrganization#analytics_region}
     */
    readonly analyticsRegion?: string;
    /**
     * Compute Engine network used for Service Networking to be peered with Apigee runtime instances.
     *
     * See [Getting started with the Service Networking API](https://cloud.google.com/service-infrastructure/docs/service-networking/getting-started).
     * Valid only when 'RuntimeType' is set to CLOUD. The value can be updated only when there are no runtime instances. For example: "default".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization.html#authorized_network ApigeeOrganization#authorized_network}
     */
    readonly authorizedNetwork?: string;
    /**
     * Description of the Apigee organization.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization.html#description ApigeeOrganization#description}
     */
    readonly description?: string;
    /**
     * The display name of the Apigee organization.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization.html#display_name ApigeeOrganization#display_name}
     */
    readonly displayName?: string;
    /**
     * The project ID associated with the Apigee organization.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization.html#project_id ApigeeOrganization#project_id}
     */
    readonly projectId: string;
    /**
     * Cloud KMS key name used for encrypting the data that is stored and replicated across runtime instances.
     *
     * Update is not allowed after the organization is created.
     * If not specified, a Google-Managed encryption key will be used.
     * Valid only when 'RuntimeType' is CLOUD. For example: 'projects/foo/locations/us/keyRings/bar/cryptoKeys/baz'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization.html#runtime_database_encryption_key_name ApigeeOrganization#runtime_database_encryption_key_name}
     */
    readonly runtimeDatabaseEncryptionKeyName?: string;
    /**
     * Runtime type of the Apigee organization based on the Apigee subscription purchased. Default value: "CLOUD" Possible values: ["CLOUD", "HYBRID"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization.html#runtime_type ApigeeOrganization#runtime_type}
     */
    readonly runtimeType?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization.html#timeouts ApigeeOrganization#timeouts}
     */
    readonly timeouts?: ApigeeOrganizationTimeouts;
}
export interface ApigeeOrganizationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization.html#create ApigeeOrganization#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization.html#delete ApigeeOrganization#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization.html#update ApigeeOrganization#update}.
     */
    readonly update?: string;
}
export declare class ApigeeOrganizationTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/apigee_organization.html google_apigee_organization}.
 */
export declare class ApigeeOrganization extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/apigee_organization.html google_apigee_organization} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ApigeeOrganizationConfig);
    private _analyticsRegion?;
    get analyticsRegion(): string | undefined;
    set analyticsRegion(value: string | undefined);
    resetAnalyticsRegion(): void;
    get analyticsRegionInput(): string | undefined;
    private _authorizedNetwork?;
    get authorizedNetwork(): string | undefined;
    set authorizedNetwork(value: string | undefined);
    resetAuthorizedNetwork(): void;
    get authorizedNetworkInput(): string | undefined;
    get caCertificate(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string | undefined;
    set displayName(value: string | undefined);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get id(): string;
    get name(): string;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _runtimeDatabaseEncryptionKeyName?;
    get runtimeDatabaseEncryptionKeyName(): string | undefined;
    set runtimeDatabaseEncryptionKeyName(value: string | undefined);
    resetRuntimeDatabaseEncryptionKeyName(): void;
    get runtimeDatabaseEncryptionKeyNameInput(): string | undefined;
    private _runtimeType?;
    get runtimeType(): string | undefined;
    set runtimeType(value: string | undefined);
    resetRuntimeType(): void;
    get runtimeTypeInput(): string | undefined;
    get subscriptionType(): string;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ApigeeOrganizationTimeoutsOutputReference;
    putTimeouts(value: ApigeeOrganizationTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ApigeeOrganizationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
