import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApigeeInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Description of the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance.html#description ApigeeInstance#description}
     */
    readonly description?: string;
    /**
     * Customer Managed Encryption Key (CMEK) used for disk and volume encryption.
     *
     * Required for Apigee paid subscriptions only.
     * Use the following format: 'projects/([^/]+)/locations/([^/]+)/keyRings/([^/]+)/cryptoKeys/([^/]+)'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance.html#disk_encryption_key_name ApigeeInstance#disk_encryption_key_name}
     */
    readonly diskEncryptionKeyName?: string;
    /**
     * Display name of the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance.html#display_name ApigeeInstance#display_name}
     */
    readonly displayName?: string;
    /**
     * Compute Engine location where the instance resides.
     *
     * For trial organization
     * subscriptions, the location must be a Compute Engine zone. For paid organization
     * subscriptions, it should correspond to a Compute Engine region.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance.html#location ApigeeInstance#location}
     */
    readonly location: string;
    /**
     * Resource ID of the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance.html#name ApigeeInstance#name}
     */
    readonly name: string;
    /**
     * The Apigee Organization associated with the Apigee instance, in the format 'organizations/{{org_name}}'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance.html#org_id ApigeeInstance#org_id}
     */
    readonly orgId: string;
    /**
     * The size of the CIDR block range that will be reserved by the instance. Possible values: ["SLASH_16", "SLASH_20", "SLASH_22"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance.html#peering_cidr_range ApigeeInstance#peering_cidr_range}
     */
    readonly peeringCidrRange?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance.html#timeouts ApigeeInstance#timeouts}
     */
    readonly timeouts?: ApigeeInstanceTimeouts;
}
export interface ApigeeInstanceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance.html#create ApigeeInstance#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance.html#delete ApigeeInstance#delete}.
     */
    readonly delete?: string;
}
export declare class ApigeeInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/apigee_instance.html google_apigee_instance}.
 */
export declare class ApigeeInstance extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/apigee_instance.html google_apigee_instance} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ApigeeInstanceConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _diskEncryptionKeyName?;
    get diskEncryptionKeyName(): string | undefined;
    set diskEncryptionKeyName(value: string | undefined);
    resetDiskEncryptionKeyName(): void;
    get diskEncryptionKeyNameInput(): string | undefined;
    private _displayName?;
    get displayName(): string | undefined;
    set displayName(value: string | undefined);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get host(): string;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _peeringCidrRange?;
    get peeringCidrRange(): string | undefined;
    set peeringCidrRange(value: string | undefined);
    resetPeeringCidrRange(): void;
    get peeringCidrRangeInput(): string | undefined;
    get port(): string;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ApigeeInstanceTimeoutsOutputReference;
    putTimeouts(value: ApigeeInstanceTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ApigeeInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
