import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApigeeInstanceAttachmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * The resource ID of the environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance_attachment.html#environment ApigeeInstanceAttachment#environment}
     */
    readonly environment: string;
    /**
     * The Apigee instance associated with the Apigee environment, in the format 'organisations/{{org_name}}/instances/{{instance_name}}'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance_attachment.html#instance_id ApigeeInstanceAttachment#instance_id}
     */
    readonly instanceId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance_attachment.html#timeouts ApigeeInstanceAttachment#timeouts}
     */
    readonly timeouts?: ApigeeInstanceAttachmentTimeouts;
}
export interface ApigeeInstanceAttachmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance_attachment.html#create ApigeeInstanceAttachment#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance_attachment.html#delete ApigeeInstanceAttachment#delete}.
     */
    readonly delete?: string;
}
export declare class ApigeeInstanceAttachmentTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/apigee_instance_attachment.html google_apigee_instance_attachment}.
 */
export declare class ApigeeInstanceAttachment extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/apigee_instance_attachment.html google_apigee_instance_attachment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ApigeeInstanceAttachmentConfig);
    private _environment?;
    get environment(): string;
    set environment(value: string);
    get environmentInput(): string | undefined;
    get id(): string;
    private _instanceId?;
    get instanceId(): string;
    set instanceId(value: string);
    get instanceIdInput(): string | undefined;
    get name(): string;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ApigeeInstanceAttachmentTimeoutsOutputReference;
    putTimeouts(value: ApigeeInstanceAttachmentTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ApigeeInstanceAttachmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
