import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApigeeEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Description of the environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_environment.html#description ApigeeEnvironment#description}
     */
    readonly description?: string;
    /**
     * Display name of the environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_environment.html#display_name ApigeeEnvironment#display_name}
     */
    readonly displayName?: string;
    /**
     * The resource ID of the environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_environment.html#name ApigeeEnvironment#name}
     */
    readonly name: string;
    /**
     * The Apigee Organization associated with the Apigee environment, in the format 'organizations/{{org_name}}'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_environment.html#org_id ApigeeEnvironment#org_id}
     */
    readonly orgId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_environment.html#timeouts ApigeeEnvironment#timeouts}
     */
    readonly timeouts?: ApigeeEnvironmentTimeouts;
}
export interface ApigeeEnvironmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_environment.html#create ApigeeEnvironment#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_environment.html#delete ApigeeEnvironment#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_environment.html#update ApigeeEnvironment#update}.
     */
    readonly update?: string;
}
export declare class ApigeeEnvironmentTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/apigee_environment.html google_apigee_environment}.
 */
export declare class ApigeeEnvironment extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/apigee_environment.html google_apigee_environment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ApigeeEnvironmentConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string | undefined;
    set displayName(value: string | undefined);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ApigeeEnvironmentTimeoutsOutputReference;
    putTimeouts(value: ApigeeEnvironmentTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ApigeeEnvironmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
