import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ActiveDirectoryDomainConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of delegated administrator account used to perform Active Directory operations.  If not specified, setupadmin will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain.html#admin ActiveDirectoryDomain#admin}
     */
    readonly admin?: string;
    /**
     * The full names of the Google Compute Engine networks the domain instance is connected to.
     *
     * The domain is only available on networks listed in authorizedNetworks.
     * If CIDR subnets overlap between networks, domain creation will fail.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain.html#authorized_networks ActiveDirectoryDomain#authorized_networks}
     */
    readonly authorizedNetworks?: string[];
    /**
     * The fully qualified domain name. e.g. mydomain.myorganization.com, with the restrictions,  https://cloud.google.com/managed-microsoft-ad/reference/rest/v1/projects.locations.global.domains.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain.html#domain_name ActiveDirectoryDomain#domain_name}
     */
    readonly domainName: string;
    /**
     * Resource labels that can contain user-provided metadata.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain.html#labels ActiveDirectoryDomain#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Locations where domain needs to be provisioned.
     *
     * [regions][compute/docs/regions-zones/]
     * e.g. us-west1 or us-east4 Service supports up to 4 locations at once. Each location will use a /26 block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain.html#locations ActiveDirectoryDomain#locations}
     */
    readonly locations: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain.html#project ActiveDirectoryDomain#project}.
     */
    readonly project?: string;
    /**
     * The CIDR range of internal addresses that are reserved for this domain.
     *
     * Reserved networks must be /24 or larger.
     * Ranges must be unique and non-overlapping with existing subnets in authorizedNetworks
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain.html#reserved_ip_range ActiveDirectoryDomain#reserved_ip_range}
     */
    readonly reservedIpRange: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain.html#timeouts ActiveDirectoryDomain#timeouts}
     */
    readonly timeouts?: ActiveDirectoryDomainTimeouts;
}
export interface ActiveDirectoryDomainTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain.html#create ActiveDirectoryDomain#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain.html#delete ActiveDirectoryDomain#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain.html#update ActiveDirectoryDomain#update}.
     */
    readonly update?: string;
}
export declare class ActiveDirectoryDomainTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain.html google_active_directory_domain}.
 */
export declare class ActiveDirectoryDomain extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain.html google_active_directory_domain} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ActiveDirectoryDomainConfig);
    private _admin?;
    get admin(): string | undefined;
    set admin(value: string | undefined);
    resetAdmin(): void;
    get adminInput(): string | undefined;
    private _authorizedNetworks?;
    get authorizedNetworks(): string[] | undefined;
    set authorizedNetworks(value: string[] | undefined);
    resetAuthorizedNetworks(): void;
    get authorizedNetworksInput(): string[] | undefined;
    private _domainName?;
    get domainName(): string;
    set domainName(value: string);
    get domainNameInput(): string | undefined;
    get fqdn(): string;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _locations?;
    get locations(): string[];
    set locations(value: string[]);
    get locationsInput(): string[] | undefined;
    get name(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _reservedIpRange?;
    get reservedIpRange(): string;
    set reservedIpRange(value: string);
    get reservedIpRangeInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ActiveDirectoryDomainTimeoutsOutputReference;
    putTimeouts(value: ActiveDirectoryDomainTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ActiveDirectoryDomainTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
