import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ActiveDirectoryDomainTrustConfig extends cdktf.TerraformMetaArguments {
    /**
     * The fully qualified domain name. e.g. mydomain.myorganization.com, with the restrictions,  https://cloud.google.com/managed-microsoft-ad/reference/rest/v1/projects.locations.global.domains.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust.html#domain ActiveDirectoryDomainTrust#domain}
     */
    readonly domain: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust.html#project ActiveDirectoryDomainTrust#project}.
     */
    readonly project?: string;
    /**
     * Whether the trusted side has forest/domain wide access or selective access to an approved set of resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust.html#selective_authentication ActiveDirectoryDomainTrust#selective_authentication}
     */
    readonly selectiveAuthentication?: boolean | cdktf.IResolvable;
    /**
     * The target DNS server IP addresses which can resolve the remote domain involved in the trust.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust.html#target_dns_ip_addresses ActiveDirectoryDomainTrust#target_dns_ip_addresses}
     */
    readonly targetDnsIpAddresses: string[];
    /**
     * The fully qualified target domain name which will be in trust with the current domain.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust.html#target_domain_name ActiveDirectoryDomainTrust#target_domain_name}
     */
    readonly targetDomainName: string;
    /**
     * The trust direction, which decides if the current domain is trusted, trusting, or both. Possible values: ["INBOUND", "OUTBOUND", "BIDIRECTIONAL"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust.html#trust_direction ActiveDirectoryDomainTrust#trust_direction}
     */
    readonly trustDirection: string;
    /**
     * The trust secret used for the handshake with the target domain. This will not be stored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust.html#trust_handshake_secret ActiveDirectoryDomainTrust#trust_handshake_secret}
     */
    readonly trustHandshakeSecret: string;
    /**
     * The type of trust represented by the trust resource. Possible values: ["FOREST", "EXTERNAL"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust.html#trust_type ActiveDirectoryDomainTrust#trust_type}
     */
    readonly trustType: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust.html#timeouts ActiveDirectoryDomainTrust#timeouts}
     */
    readonly timeouts?: ActiveDirectoryDomainTrustTimeouts;
}
export interface ActiveDirectoryDomainTrustTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust.html#create ActiveDirectoryDomainTrust#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust.html#delete ActiveDirectoryDomainTrust#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust.html#update ActiveDirectoryDomainTrust#update}.
     */
    readonly update?: string;
}
export declare class ActiveDirectoryDomainTrustTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust.html google_active_directory_domain_trust}.
 */
export declare class ActiveDirectoryDomainTrust extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust.html google_active_directory_domain_trust} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ActiveDirectoryDomainTrustConfig);
    private _domain?;
    get domain(): string;
    set domain(value: string);
    get domainInput(): string | undefined;
    get id(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _selectiveAuthentication?;
    get selectiveAuthentication(): boolean | cdktf.IResolvable | undefined;
    set selectiveAuthentication(value: boolean | cdktf.IResolvable | undefined);
    resetSelectiveAuthentication(): void;
    get selectiveAuthenticationInput(): boolean | cdktf.IResolvable | undefined;
    private _targetDnsIpAddresses?;
    get targetDnsIpAddresses(): string[];
    set targetDnsIpAddresses(value: string[]);
    get targetDnsIpAddressesInput(): string[] | undefined;
    private _targetDomainName?;
    get targetDomainName(): string;
    set targetDomainName(value: string);
    get targetDomainNameInput(): string | undefined;
    private _trustDirection?;
    get trustDirection(): string;
    set trustDirection(value: string);
    get trustDirectionInput(): string | undefined;
    private _trustHandshakeSecret?;
    get trustHandshakeSecret(): string;
    set trustHandshakeSecret(value: string);
    get trustHandshakeSecretInput(): string | undefined;
    private _trustType?;
    get trustType(): string;
    set trustType(value: string);
    get trustTypeInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ActiveDirectoryDomainTrustTimeoutsOutputReference;
    putTimeouts(value: ActiveDirectoryDomainTrustTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ActiveDirectoryDomainTrustTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
