import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AccessContextManagerServicePerimetersConfig extends cdktf.TerraformMetaArguments {
    /**
     * The AccessPolicy this ServicePerimeter lives in. Format: accessPolicies/{policy_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#parent AccessContextManagerServicePerimeters#parent}
     */
    readonly parent: string;
    /**
     * service_perimeters block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#service_perimeters AccessContextManagerServicePerimeters#service_perimeters}
     */
    readonly servicePerimeters?: AccessContextManagerServicePerimetersServicePerimeters[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#timeouts AccessContextManagerServicePerimeters#timeouts}
     */
    readonly timeouts?: AccessContextManagerServicePerimetersTimeouts;
}
export interface AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressFrom {
    /**
     * A list of identities that are allowed access through this 'EgressPolicy'.
     *
     * Should be in the format of email address. The email address should
     * represent individual user or service account only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#identities AccessContextManagerServicePerimeters#identities}
     */
    readonly identities?: string[];
    /**
     * Specifies the type of identities that are allowed access to outside the  perimeter.
     *
     * If left unspecified, then members of 'identities' field will
     * be allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#identity_type AccessContextManagerServicePerimeters#identity_type}
     */
    readonly identityType?: string;
}
export declare class AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressFromOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _identities?;
    get identities(): string[] | undefined;
    set identities(value: string[] | undefined);
    resetIdentities(): void;
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    get identityType(): string | undefined;
    set identityType(value: string | undefined);
    resetIdentityType(): void;
    get identityTypeInput(): string | undefined;
}
export interface AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressToOperationsMethodSelectors {
    /**
     * Value for 'method' should be a valid method name for the corresponding  'serviceName' in 'ApiOperation'.
     *
     * If '*' used as value for method,
     * then ALL methods and permissions are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#method AccessContextManagerServicePerimeters#method}
     */
    readonly method?: string;
    /**
     * Value for permission should be a valid Cloud IAM permission for the  corresponding 'serviceName' in 'ApiOperation'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#permission AccessContextManagerServicePerimeters#permission}
     */
    readonly permission?: string;
}
export interface AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressToOperations {
    /**
     * The name of the API whose methods or permissions the 'IngressPolicy' or  'EgressPolicy' want to allow.
     *
     * A single 'ApiOperation' with serviceName
     * field set to '*' will allow all methods AND permissions for all services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#service_name AccessContextManagerServicePerimeters#service_name}
     */
    readonly serviceName?: string;
    /**
     * method_selectors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#method_selectors AccessContextManagerServicePerimeters#method_selectors}
     */
    readonly methodSelectors?: AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressToOperationsMethodSelectors[];
}
export interface AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressTo {
    /**
     * A list of resources, currently only projects in the form  'projects/<projectnumber>', that match this to stanza.
     *
     * A request matches
     * if it contains a resource in this list. If * is specified for resources,
     * then this 'EgressTo' rule will authorize access to all resources outside
     * the perimeter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#resources AccessContextManagerServicePerimeters#resources}
     */
    readonly resources?: string[];
    /**
     * operations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#operations AccessContextManagerServicePerimeters#operations}
     */
    readonly operations?: AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressToOperations[];
}
export declare class AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressToOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _resources?;
    get resources(): string[] | undefined;
    set resources(value: string[] | undefined);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _operations?;
    get operations(): AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressToOperations[] | undefined;
    set operations(value: AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressToOperations[] | undefined);
    resetOperations(): void;
    get operationsInput(): AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressToOperations[] | undefined;
}
export interface AccessContextManagerServicePerimetersServicePerimetersSpecEgressPolicies {
    /**
     * egress_from block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#egress_from AccessContextManagerServicePerimeters#egress_from}
     */
    readonly egressFrom?: AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressFrom;
    /**
     * egress_to block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#egress_to AccessContextManagerServicePerimeters#egress_to}
     */
    readonly egressTo?: AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressTo;
}
export interface AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressFromSources {
    /**
     * An 'AccessLevel' resource name that allow resources within the  'ServicePerimeters' to be accessed from the internet.
     *
     * 'AccessLevels' listed
     * must be in the same policy as this 'ServicePerimeter'. Referencing a nonexistent
     * 'AccessLevel' will cause an error. If no 'AccessLevel' names are listed,
     * resources within the perimeter can only be accessed via Google Cloud calls
     * with request origins within the perimeter.
     * Example 'accessPolicies/MY_POLICY/accessLevels/MY_LEVEL.'
     * If * is specified, then all IngressSources will be allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#access_level AccessContextManagerServicePerimeters#access_level}
     */
    readonly accessLevel?: string;
    /**
     * A Google Cloud resource that is allowed to ingress the perimeter.
     *
     * Requests from these resources will be allowed to access perimeter data.
     * Currently only projects are allowed. Format 'projects/{project_number}'
     * The project may be in any Google Cloud organization, not just the
     * organization that the perimeter is defined in. '*' is not allowed, the case
     * of allowing all Google Cloud resources only is not supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#resource AccessContextManagerServicePerimeters#resource}
     */
    readonly resource?: string;
}
export interface AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressFrom {
    /**
     * A list of identities that are allowed access through this ingress policy.
     *
     * Should be in the format of email address. The email address should represent
     * individual user or service account only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#identities AccessContextManagerServicePerimeters#identities}
     */
    readonly identities?: string[];
    /**
     * Specifies the type of identities that are allowed access from outside the  perimeter.
     *
     * If left unspecified, then members of 'identities' field will be
     * allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#identity_type AccessContextManagerServicePerimeters#identity_type}
     */
    readonly identityType?: string;
    /**
     * sources block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#sources AccessContextManagerServicePerimeters#sources}
     */
    readonly sources?: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressFromSources[];
}
export declare class AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressFromOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _identities?;
    get identities(): string[] | undefined;
    set identities(value: string[] | undefined);
    resetIdentities(): void;
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    get identityType(): string | undefined;
    set identityType(value: string | undefined);
    resetIdentityType(): void;
    get identityTypeInput(): string | undefined;
    private _sources?;
    get sources(): AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressFromSources[] | undefined;
    set sources(value: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressFromSources[] | undefined);
    resetSources(): void;
    get sourcesInput(): AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressFromSources[] | undefined;
}
export interface AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressToOperationsMethodSelectors {
    /**
     * Value for method should be a valid method name for the corresponding  serviceName in 'ApiOperation'.
     *
     * If '*' used as value for 'method', then
     * ALL methods and permissions are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#method AccessContextManagerServicePerimeters#method}
     */
    readonly method?: string;
    /**
     * Value for permission should be a valid Cloud IAM permission for the  corresponding 'serviceName' in 'ApiOperation'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#permission AccessContextManagerServicePerimeters#permission}
     */
    readonly permission?: string;
}
export interface AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressToOperations {
    /**
     * The name of the API whose methods or permissions the 'IngressPolicy' or  'EgressPolicy' want to allow.
     *
     * A single 'ApiOperation' with 'serviceName'
     * field set to '*' will allow all methods AND permissions for all services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#service_name AccessContextManagerServicePerimeters#service_name}
     */
    readonly serviceName?: string;
    /**
     * method_selectors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#method_selectors AccessContextManagerServicePerimeters#method_selectors}
     */
    readonly methodSelectors?: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressToOperationsMethodSelectors[];
}
export interface AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressTo {
    /**
     * A list of resources, currently only projects in the form  'projects/<projectnumber>', protected by this 'ServicePerimeter' that are allowed to be accessed by sources defined in the corresponding 'IngressFrom'.
     *
     * A request matches if it contains
     * a resource in this list. If '*' is specified for resources,
     * then this 'IngressTo' rule will authorize access to all
     * resources inside the perimeter, provided that the request
     * also matches the 'operations' field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#resources AccessContextManagerServicePerimeters#resources}
     */
    readonly resources?: string[];
    /**
     * operations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#operations AccessContextManagerServicePerimeters#operations}
     */
    readonly operations?: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressToOperations[];
}
export declare class AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressToOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _resources?;
    get resources(): string[] | undefined;
    set resources(value: string[] | undefined);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _operations?;
    get operations(): AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressToOperations[] | undefined;
    set operations(value: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressToOperations[] | undefined);
    resetOperations(): void;
    get operationsInput(): AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressToOperations[] | undefined;
}
export interface AccessContextManagerServicePerimetersServicePerimetersSpecIngressPolicies {
    /**
     * ingress_from block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#ingress_from AccessContextManagerServicePerimeters#ingress_from}
     */
    readonly ingressFrom?: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressFrom;
    /**
     * ingress_to block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#ingress_to AccessContextManagerServicePerimeters#ingress_to}
     */
    readonly ingressTo?: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressTo;
}
export interface AccessContextManagerServicePerimetersServicePerimetersSpecVpcAccessibleServices {
    /**
     * The list of APIs usable within the Service Perimeter. Must be empty unless 'enableRestriction' is True.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#allowed_services AccessContextManagerServicePerimeters#allowed_services}
     */
    readonly allowedServices?: string[];
    /**
     * Whether to restrict API calls within the Service Perimeter to the list of APIs specified in 'allowedServices'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#enable_restriction AccessContextManagerServicePerimeters#enable_restriction}
     */
    readonly enableRestriction?: boolean | cdktf.IResolvable;
}
export declare class AccessContextManagerServicePerimetersServicePerimetersSpecVpcAccessibleServicesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _allowedServices?;
    get allowedServices(): string[] | undefined;
    set allowedServices(value: string[] | undefined);
    resetAllowedServices(): void;
    get allowedServicesInput(): string[] | undefined;
    private _enableRestriction?;
    get enableRestriction(): boolean | cdktf.IResolvable | undefined;
    set enableRestriction(value: boolean | cdktf.IResolvable | undefined);
    resetEnableRestriction(): void;
    get enableRestrictionInput(): boolean | cdktf.IResolvable | undefined;
}
export interface AccessContextManagerServicePerimetersServicePerimetersSpec {
    /**
     * A list of AccessLevel resource names that allow resources within the ServicePerimeter to be accessed from the internet.
     *
     * AccessLevels listed must be in the same policy as this
     * ServicePerimeter. Referencing a nonexistent AccessLevel is a
     * syntax error. If no AccessLevel names are listed, resources within
     * the perimeter can only be accessed via GCP calls with request
     * origins within the perimeter. For Service Perimeter Bridge, must
     * be empty.
     *
     * Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#access_levels AccessContextManagerServicePerimeters#access_levels}
     */
    readonly accessLevels?: string[];
    /**
     * A list of GCP resources that are inside of the service perimeter. Currently only projects are allowed. Format: projects/{project_number}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#resources AccessContextManagerServicePerimeters#resources}
     */
    readonly resources?: string[];
    /**
     * GCP services that are subject to the Service Perimeter restrictions.
     *
     * Must contain a list of services. For example, if
     * 'storage.googleapis.com' is specified, access to the storage
     * buckets inside the perimeter must meet the perimeter's access
     * restrictions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#restricted_services AccessContextManagerServicePerimeters#restricted_services}
     */
    readonly restrictedServices?: string[];
    /**
     * egress_policies block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#egress_policies AccessContextManagerServicePerimeters#egress_policies}
     */
    readonly egressPolicies?: AccessContextManagerServicePerimetersServicePerimetersSpecEgressPolicies[];
    /**
     * ingress_policies block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#ingress_policies AccessContextManagerServicePerimeters#ingress_policies}
     */
    readonly ingressPolicies?: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPolicies[];
    /**
     * vpc_accessible_services block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#vpc_accessible_services AccessContextManagerServicePerimeters#vpc_accessible_services}
     */
    readonly vpcAccessibleServices?: AccessContextManagerServicePerimetersServicePerimetersSpecVpcAccessibleServices;
}
export declare class AccessContextManagerServicePerimetersServicePerimetersSpecOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _accessLevels?;
    get accessLevels(): string[] | undefined;
    set accessLevels(value: string[] | undefined);
    resetAccessLevels(): void;
    get accessLevelsInput(): string[] | undefined;
    private _resources?;
    get resources(): string[] | undefined;
    set resources(value: string[] | undefined);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _restrictedServices?;
    get restrictedServices(): string[] | undefined;
    set restrictedServices(value: string[] | undefined);
    resetRestrictedServices(): void;
    get restrictedServicesInput(): string[] | undefined;
    private _egressPolicies?;
    get egressPolicies(): AccessContextManagerServicePerimetersServicePerimetersSpecEgressPolicies[] | undefined;
    set egressPolicies(value: AccessContextManagerServicePerimetersServicePerimetersSpecEgressPolicies[] | undefined);
    resetEgressPolicies(): void;
    get egressPoliciesInput(): AccessContextManagerServicePerimetersServicePerimetersSpecEgressPolicies[] | undefined;
    private _ingressPolicies?;
    get ingressPolicies(): AccessContextManagerServicePerimetersServicePerimetersSpecIngressPolicies[] | undefined;
    set ingressPolicies(value: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPolicies[] | undefined);
    resetIngressPolicies(): void;
    get ingressPoliciesInput(): AccessContextManagerServicePerimetersServicePerimetersSpecIngressPolicies[] | undefined;
    private _vpcAccessibleServices?;
    private __vpcAccessibleServicesOutput;
    get vpcAccessibleServices(): AccessContextManagerServicePerimetersServicePerimetersSpecVpcAccessibleServicesOutputReference;
    putVpcAccessibleServices(value: AccessContextManagerServicePerimetersServicePerimetersSpecVpcAccessibleServices | undefined): void;
    resetVpcAccessibleServices(): void;
    get vpcAccessibleServicesInput(): AccessContextManagerServicePerimetersServicePerimetersSpecVpcAccessibleServices | undefined;
}
export interface AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressFrom {
    /**
     * A list of identities that are allowed access through this 'EgressPolicy'.
     *
     * Should be in the format of email address. The email address should
     * represent individual user or service account only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#identities AccessContextManagerServicePerimeters#identities}
     */
    readonly identities?: string[];
    /**
     * Specifies the type of identities that are allowed access to outside the  perimeter.
     *
     * If left unspecified, then members of 'identities' field will
     * be allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#identity_type AccessContextManagerServicePerimeters#identity_type}
     */
    readonly identityType?: string;
}
export declare class AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressFromOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _identities?;
    get identities(): string[] | undefined;
    set identities(value: string[] | undefined);
    resetIdentities(): void;
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    get identityType(): string | undefined;
    set identityType(value: string | undefined);
    resetIdentityType(): void;
    get identityTypeInput(): string | undefined;
}
export interface AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressToOperationsMethodSelectors {
    /**
     * Value for 'method' should be a valid method name for the corresponding  'serviceName' in 'ApiOperation'.
     *
     * If '*' used as value for method,
     * then ALL methods and permissions are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#method AccessContextManagerServicePerimeters#method}
     */
    readonly method?: string;
    /**
     * Value for permission should be a valid Cloud IAM permission for the  corresponding 'serviceName' in 'ApiOperation'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#permission AccessContextManagerServicePerimeters#permission}
     */
    readonly permission?: string;
}
export interface AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressToOperations {
    /**
     * The name of the API whose methods or permissions the 'IngressPolicy' or  'EgressPolicy' want to allow.
     *
     * A single 'ApiOperation' with serviceName
     * field set to '*' will allow all methods AND permissions for all services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#service_name AccessContextManagerServicePerimeters#service_name}
     */
    readonly serviceName?: string;
    /**
     * method_selectors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#method_selectors AccessContextManagerServicePerimeters#method_selectors}
     */
    readonly methodSelectors?: AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressToOperationsMethodSelectors[];
}
export interface AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressTo {
    /**
     * A list of resources, currently only projects in the form  'projects/<projectnumber>', that match this to stanza.
     *
     * A request matches
     * if it contains a resource in this list. If * is specified for resources,
     * then this 'EgressTo' rule will authorize access to all resources outside
     * the perimeter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#resources AccessContextManagerServicePerimeters#resources}
     */
    readonly resources?: string[];
    /**
     * operations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#operations AccessContextManagerServicePerimeters#operations}
     */
    readonly operations?: AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressToOperations[];
}
export declare class AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressToOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _resources?;
    get resources(): string[] | undefined;
    set resources(value: string[] | undefined);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _operations?;
    get operations(): AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressToOperations[] | undefined;
    set operations(value: AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressToOperations[] | undefined);
    resetOperations(): void;
    get operationsInput(): AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressToOperations[] | undefined;
}
export interface AccessContextManagerServicePerimetersServicePerimetersStatusEgressPolicies {
    /**
     * egress_from block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#egress_from AccessContextManagerServicePerimeters#egress_from}
     */
    readonly egressFrom?: AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressFrom;
    /**
     * egress_to block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#egress_to AccessContextManagerServicePerimeters#egress_to}
     */
    readonly egressTo?: AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressTo;
}
export interface AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressFromSources {
    /**
     * An 'AccessLevel' resource name that allow resources within the  'ServicePerimeters' to be accessed from the internet.
     *
     * 'AccessLevels' listed
     * must be in the same policy as this 'ServicePerimeter'. Referencing a nonexistent
     * 'AccessLevel' will cause an error. If no 'AccessLevel' names are listed,
     * resources within the perimeter can only be accessed via Google Cloud calls
     * with request origins within the perimeter.
     * Example 'accessPolicies/MY_POLICY/accessLevels/MY_LEVEL.'
     * If * is specified, then all IngressSources will be allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#access_level AccessContextManagerServicePerimeters#access_level}
     */
    readonly accessLevel?: string;
    /**
     * A Google Cloud resource that is allowed to ingress the perimeter.
     *
     * Requests from these resources will be allowed to access perimeter data.
     * Currently only projects are allowed. Format 'projects/{project_number}'
     * The project may be in any Google Cloud organization, not just the
     * organization that the perimeter is defined in. '*' is not allowed, the case
     * of allowing all Google Cloud resources only is not supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#resource AccessContextManagerServicePerimeters#resource}
     */
    readonly resource?: string;
}
export interface AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressFrom {
    /**
     * A list of identities that are allowed access through this ingress policy.
     *
     * Should be in the format of email address. The email address should represent
     * individual user or service account only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#identities AccessContextManagerServicePerimeters#identities}
     */
    readonly identities?: string[];
    /**
     * Specifies the type of identities that are allowed access from outside the  perimeter.
     *
     * If left unspecified, then members of 'identities' field will be
     * allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#identity_type AccessContextManagerServicePerimeters#identity_type}
     */
    readonly identityType?: string;
    /**
     * sources block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#sources AccessContextManagerServicePerimeters#sources}
     */
    readonly sources?: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressFromSources[];
}
export declare class AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressFromOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _identities?;
    get identities(): string[] | undefined;
    set identities(value: string[] | undefined);
    resetIdentities(): void;
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    get identityType(): string | undefined;
    set identityType(value: string | undefined);
    resetIdentityType(): void;
    get identityTypeInput(): string | undefined;
    private _sources?;
    get sources(): AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressFromSources[] | undefined;
    set sources(value: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressFromSources[] | undefined);
    resetSources(): void;
    get sourcesInput(): AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressFromSources[] | undefined;
}
export interface AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressToOperationsMethodSelectors {
    /**
     * Value for method should be a valid method name for the corresponding  serviceName in 'ApiOperation'.
     *
     * If '*' used as value for 'method', then
     * ALL methods and permissions are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#method AccessContextManagerServicePerimeters#method}
     */
    readonly method?: string;
    /**
     * Value for permission should be a valid Cloud IAM permission for the  corresponding 'serviceName' in 'ApiOperation'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#permission AccessContextManagerServicePerimeters#permission}
     */
    readonly permission?: string;
}
export interface AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressToOperations {
    /**
     * The name of the API whose methods or permissions the 'IngressPolicy' or  'EgressPolicy' want to allow.
     *
     * A single 'ApiOperation' with 'serviceName'
     * field set to '*' will allow all methods AND permissions for all services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#service_name AccessContextManagerServicePerimeters#service_name}
     */
    readonly serviceName?: string;
    /**
     * method_selectors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#method_selectors AccessContextManagerServicePerimeters#method_selectors}
     */
    readonly methodSelectors?: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressToOperationsMethodSelectors[];
}
export interface AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressTo {
    /**
     * A list of resources, currently only projects in the form  'projects/<projectnumber>', protected by this 'ServicePerimeter' that are allowed to be accessed by sources defined in the corresponding 'IngressFrom'.
     *
     * A request matches if it contains
     * a resource in this list. If '*' is specified for resources,
     * then this 'IngressTo' rule will authorize access to all
     * resources inside the perimeter, provided that the request
     * also matches the 'operations' field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#resources AccessContextManagerServicePerimeters#resources}
     */
    readonly resources?: string[];
    /**
     * operations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#operations AccessContextManagerServicePerimeters#operations}
     */
    readonly operations?: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressToOperations[];
}
export declare class AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressToOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _resources?;
    get resources(): string[] | undefined;
    set resources(value: string[] | undefined);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _operations?;
    get operations(): AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressToOperations[] | undefined;
    set operations(value: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressToOperations[] | undefined);
    resetOperations(): void;
    get operationsInput(): AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressToOperations[] | undefined;
}
export interface AccessContextManagerServicePerimetersServicePerimetersStatusIngressPolicies {
    /**
     * ingress_from block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#ingress_from AccessContextManagerServicePerimeters#ingress_from}
     */
    readonly ingressFrom?: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressFrom;
    /**
     * ingress_to block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#ingress_to AccessContextManagerServicePerimeters#ingress_to}
     */
    readonly ingressTo?: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressTo;
}
export interface AccessContextManagerServicePerimetersServicePerimetersStatusVpcAccessibleServices {
    /**
     * The list of APIs usable within the Service Perimeter. Must be empty unless 'enableRestriction' is True.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#allowed_services AccessContextManagerServicePerimeters#allowed_services}
     */
    readonly allowedServices?: string[];
    /**
     * Whether to restrict API calls within the Service Perimeter to the list of APIs specified in 'allowedServices'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#enable_restriction AccessContextManagerServicePerimeters#enable_restriction}
     */
    readonly enableRestriction?: boolean | cdktf.IResolvable;
}
export declare class AccessContextManagerServicePerimetersServicePerimetersStatusVpcAccessibleServicesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _allowedServices?;
    get allowedServices(): string[] | undefined;
    set allowedServices(value: string[] | undefined);
    resetAllowedServices(): void;
    get allowedServicesInput(): string[] | undefined;
    private _enableRestriction?;
    get enableRestriction(): boolean | cdktf.IResolvable | undefined;
    set enableRestriction(value: boolean | cdktf.IResolvable | undefined);
    resetEnableRestriction(): void;
    get enableRestrictionInput(): boolean | cdktf.IResolvable | undefined;
}
export interface AccessContextManagerServicePerimetersServicePerimetersStatus {
    /**
     * A list of AccessLevel resource names that allow resources within the ServicePerimeter to be accessed from the internet.
     *
     * AccessLevels listed must be in the same policy as this
     * ServicePerimeter. Referencing a nonexistent AccessLevel is a
     * syntax error. If no AccessLevel names are listed, resources within
     * the perimeter can only be accessed via GCP calls with request
     * origins within the perimeter. For Service Perimeter Bridge, must
     * be empty.
     *
     * Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#access_levels AccessContextManagerServicePerimeters#access_levels}
     */
    readonly accessLevels?: string[];
    /**
     * A list of GCP resources that are inside of the service perimeter. Currently only projects are allowed. Format: projects/{project_number}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#resources AccessContextManagerServicePerimeters#resources}
     */
    readonly resources?: string[];
    /**
     * GCP services that are subject to the Service Perimeter restrictions.
     *
     * Must contain a list of services. For example, if
     * 'storage.googleapis.com' is specified, access to the storage
     * buckets inside the perimeter must meet the perimeter's access
     * restrictions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#restricted_services AccessContextManagerServicePerimeters#restricted_services}
     */
    readonly restrictedServices?: string[];
    /**
     * egress_policies block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#egress_policies AccessContextManagerServicePerimeters#egress_policies}
     */
    readonly egressPolicies?: AccessContextManagerServicePerimetersServicePerimetersStatusEgressPolicies[];
    /**
     * ingress_policies block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#ingress_policies AccessContextManagerServicePerimeters#ingress_policies}
     */
    readonly ingressPolicies?: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPolicies[];
    /**
     * vpc_accessible_services block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#vpc_accessible_services AccessContextManagerServicePerimeters#vpc_accessible_services}
     */
    readonly vpcAccessibleServices?: AccessContextManagerServicePerimetersServicePerimetersStatusVpcAccessibleServices;
}
export declare class AccessContextManagerServicePerimetersServicePerimetersStatusOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _accessLevels?;
    get accessLevels(): string[] | undefined;
    set accessLevels(value: string[] | undefined);
    resetAccessLevels(): void;
    get accessLevelsInput(): string[] | undefined;
    private _resources?;
    get resources(): string[] | undefined;
    set resources(value: string[] | undefined);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _restrictedServices?;
    get restrictedServices(): string[] | undefined;
    set restrictedServices(value: string[] | undefined);
    resetRestrictedServices(): void;
    get restrictedServicesInput(): string[] | undefined;
    private _egressPolicies?;
    get egressPolicies(): AccessContextManagerServicePerimetersServicePerimetersStatusEgressPolicies[] | undefined;
    set egressPolicies(value: AccessContextManagerServicePerimetersServicePerimetersStatusEgressPolicies[] | undefined);
    resetEgressPolicies(): void;
    get egressPoliciesInput(): AccessContextManagerServicePerimetersServicePerimetersStatusEgressPolicies[] | undefined;
    private _ingressPolicies?;
    get ingressPolicies(): AccessContextManagerServicePerimetersServicePerimetersStatusIngressPolicies[] | undefined;
    set ingressPolicies(value: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPolicies[] | undefined);
    resetIngressPolicies(): void;
    get ingressPoliciesInput(): AccessContextManagerServicePerimetersServicePerimetersStatusIngressPolicies[] | undefined;
    private _vpcAccessibleServices?;
    private __vpcAccessibleServicesOutput;
    get vpcAccessibleServices(): AccessContextManagerServicePerimetersServicePerimetersStatusVpcAccessibleServicesOutputReference;
    putVpcAccessibleServices(value: AccessContextManagerServicePerimetersServicePerimetersStatusVpcAccessibleServices | undefined): void;
    resetVpcAccessibleServices(): void;
    get vpcAccessibleServicesInput(): AccessContextManagerServicePerimetersServicePerimetersStatusVpcAccessibleServices | undefined;
}
export interface AccessContextManagerServicePerimetersServicePerimeters {
    /**
     * Description of the ServicePerimeter and its use. Does not affect behavior.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#description AccessContextManagerServicePerimeters#description}
     */
    readonly description?: string;
    /**
     * Resource name for the ServicePerimeter. The short_name component must begin with a letter and only include alphanumeric and '_'. Format: accessPolicies/{policy_id}/servicePerimeters/{short_name}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#name AccessContextManagerServicePerimeters#name}
     */
    readonly name: string;
    /**
     * Specifies the type of the Perimeter.
     *
     * There are two types: regular and
     * bridge. Regular Service Perimeter contains resources, access levels,
     * and restricted services. Every resource can be in at most
     * ONE regular Service Perimeter.
     *
     * In addition to being in a regular service perimeter, a resource can also
     * be in zero or more perimeter bridges. A perimeter bridge only contains
     * resources. Cross project operations are permitted if all effected
     * resources share some perimeter (whether bridge or regular). Perimeter
     * Bridge does not contain access levels or services: those are governed
     * entirely by the regular perimeter that resource is in.
     *
     * Perimeter Bridges are typically useful when building more complex
     * topologies with many independent perimeters that need to share some data
     * with a common perimeter, but should not be able to share data among
     * themselves. Default value: "PERIMETER_TYPE_REGULAR" Possible values: ["PERIMETER_TYPE_REGULAR", "PERIMETER_TYPE_BRIDGE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#perimeter_type AccessContextManagerServicePerimeters#perimeter_type}
     */
    readonly perimeterType?: string;
    /**
     * Human readable title. Must be unique within the Policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#title AccessContextManagerServicePerimeters#title}
     */
    readonly title: string;
    /**
     * Use explicit dry run spec flag.
     *
     * Ordinarily, a dry-run spec implicitly exists
     * for all Service Perimeters, and that spec is identical to the status for those
     * Service Perimeters. When this flag is set, it inhibits the generation of the
     * implicit spec, thereby allowing the user to explicitly provide a
     * configuration ("spec") to use in a dry-run version of the Service Perimeter.
     * This allows the user to test changes to the enforced config ("status") without
     * actually enforcing them. This testing is done through analyzing the differences
     * between currently enforced and suggested restrictions. useExplicitDryRunSpec must
     * bet set to True if any of the fields in the spec are set to non-default values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#use_explicit_dry_run_spec AccessContextManagerServicePerimeters#use_explicit_dry_run_spec}
     */
    readonly useExplicitDryRunSpec?: boolean | cdktf.IResolvable;
    /**
     * spec block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#spec AccessContextManagerServicePerimeters#spec}
     */
    readonly spec?: AccessContextManagerServicePerimetersServicePerimetersSpec;
    /**
     * status block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#status AccessContextManagerServicePerimeters#status}
     */
    readonly status?: AccessContextManagerServicePerimetersServicePerimetersStatus;
}
export interface AccessContextManagerServicePerimetersTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#create AccessContextManagerServicePerimeters#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#delete AccessContextManagerServicePerimeters#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#update AccessContextManagerServicePerimeters#update}.
     */
    readonly update?: string;
}
export declare class AccessContextManagerServicePerimetersTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html google_access_context_manager_service_perimeters}.
 */
export declare class AccessContextManagerServicePerimeters extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html google_access_context_manager_service_perimeters} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: AccessContextManagerServicePerimetersConfig);
    get id(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _servicePerimeters?;
    get servicePerimeters(): AccessContextManagerServicePerimetersServicePerimeters[] | undefined;
    set servicePerimeters(value: AccessContextManagerServicePerimetersServicePerimeters[] | undefined);
    resetServicePerimeters(): void;
    get servicePerimetersInput(): AccessContextManagerServicePerimetersServicePerimeters[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): AccessContextManagerServicePerimetersTimeoutsOutputReference;
    putTimeouts(value: AccessContextManagerServicePerimetersTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): AccessContextManagerServicePerimetersTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
