import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AccessContextManagerServicePerimeterConfig extends cdktf.TerraformMetaArguments {
    /**
     * Description of the ServicePerimeter and its use. Does not affect behavior.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#description AccessContextManagerServicePerimeter#description}
     */
    readonly description?: string;
    /**
     * Resource name for the ServicePerimeter. The short_name component must begin with a letter and only include alphanumeric and '_'. Format: accessPolicies/{policy_id}/servicePerimeters/{short_name}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#name AccessContextManagerServicePerimeter#name}
     */
    readonly name: string;
    /**
     * The AccessPolicy this ServicePerimeter lives in. Format: accessPolicies/{policy_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#parent AccessContextManagerServicePerimeter#parent}
     */
    readonly parent: string;
    /**
     * Specifies the type of the Perimeter.
     *
     * There are two types: regular and
     * bridge. Regular Service Perimeter contains resources, access levels,
     * and restricted services. Every resource can be in at most
     * ONE regular Service Perimeter.
     *
     * In addition to being in a regular service perimeter, a resource can also
     * be in zero or more perimeter bridges. A perimeter bridge only contains
     * resources. Cross project operations are permitted if all effected
     * resources share some perimeter (whether bridge or regular). Perimeter
     * Bridge does not contain access levels or services: those are governed
     * entirely by the regular perimeter that resource is in.
     *
     * Perimeter Bridges are typically useful when building more complex
     * topologies with many independent perimeters that need to share some data
     * with a common perimeter, but should not be able to share data among
     * themselves. Default value: "PERIMETER_TYPE_REGULAR" Possible values: ["PERIMETER_TYPE_REGULAR", "PERIMETER_TYPE_BRIDGE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#perimeter_type AccessContextManagerServicePerimeter#perimeter_type}
     */
    readonly perimeterType?: string;
    /**
     * Human readable title. Must be unique within the Policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#title AccessContextManagerServicePerimeter#title}
     */
    readonly title: string;
    /**
     * Use explicit dry run spec flag.
     *
     * Ordinarily, a dry-run spec implicitly exists
     * for all Service Perimeters, and that spec is identical to the status for those
     * Service Perimeters. When this flag is set, it inhibits the generation of the
     * implicit spec, thereby allowing the user to explicitly provide a
     * configuration ("spec") to use in a dry-run version of the Service Perimeter.
     * This allows the user to test changes to the enforced config ("status") without
     * actually enforcing them. This testing is done through analyzing the differences
     * between currently enforced and suggested restrictions. useExplicitDryRunSpec must
     * bet set to True if any of the fields in the spec are set to non-default values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#use_explicit_dry_run_spec AccessContextManagerServicePerimeter#use_explicit_dry_run_spec}
     */
    readonly useExplicitDryRunSpec?: boolean | cdktf.IResolvable;
    /**
     * spec block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#spec AccessContextManagerServicePerimeter#spec}
     */
    readonly spec?: AccessContextManagerServicePerimeterSpec;
    /**
     * status block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#status AccessContextManagerServicePerimeter#status}
     */
    readonly status?: AccessContextManagerServicePerimeterStatus;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#timeouts AccessContextManagerServicePerimeter#timeouts}
     */
    readonly timeouts?: AccessContextManagerServicePerimeterTimeouts;
}
export interface AccessContextManagerServicePerimeterSpecEgressPoliciesEgressFrom {
    /**
     * A list of identities that are allowed access through this 'EgressPolicy'.
     *
     * Should be in the format of email address. The email address should
     * represent individual user or service account only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#identities AccessContextManagerServicePerimeter#identities}
     */
    readonly identities?: string[];
    /**
     * Specifies the type of identities that are allowed access to outside the  perimeter.
     *
     * If left unspecified, then members of 'identities' field will
     * be allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#identity_type AccessContextManagerServicePerimeter#identity_type}
     */
    readonly identityType?: string;
}
export declare class AccessContextManagerServicePerimeterSpecEgressPoliciesEgressFromOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _identities?;
    get identities(): string[] | undefined;
    set identities(value: string[] | undefined);
    resetIdentities(): void;
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    get identityType(): string | undefined;
    set identityType(value: string | undefined);
    resetIdentityType(): void;
    get identityTypeInput(): string | undefined;
}
export interface AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectors {
    /**
     * Value for 'method' should be a valid method name for the corresponding  'serviceName' in 'ApiOperation'.
     *
     * If '*' used as value for method,
     * then ALL methods and permissions are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#method AccessContextManagerServicePerimeter#method}
     */
    readonly method?: string;
    /**
     * Value for permission should be a valid Cloud IAM permission for the  corresponding 'serviceName' in 'ApiOperation'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#permission AccessContextManagerServicePerimeter#permission}
     */
    readonly permission?: string;
}
export interface AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations {
    /**
     * The name of the API whose methods or permissions the 'IngressPolicy' or  'EgressPolicy' want to allow.
     *
     * A single 'ApiOperation' with serviceName
     * field set to '*' will allow all methods AND permissions for all services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#service_name AccessContextManagerServicePerimeter#service_name}
     */
    readonly serviceName?: string;
    /**
     * method_selectors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#method_selectors AccessContextManagerServicePerimeter#method_selectors}
     */
    readonly methodSelectors?: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectors[];
}
export interface AccessContextManagerServicePerimeterSpecEgressPoliciesEgressTo {
    /**
     * A list of resources, currently only projects in the form  'projects/<projectnumber>', that match this to stanza.
     *
     * A request matches
     * if it contains a resource in this list. If * is specified for resources,
     * then this 'EgressTo' rule will authorize access to all resources outside
     * the perimeter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#resources AccessContextManagerServicePerimeter#resources}
     */
    readonly resources?: string[];
    /**
     * operations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#operations AccessContextManagerServicePerimeter#operations}
     */
    readonly operations?: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations[];
}
export declare class AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _resources?;
    get resources(): string[] | undefined;
    set resources(value: string[] | undefined);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _operations?;
    get operations(): AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations[] | undefined;
    set operations(value: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations[] | undefined);
    resetOperations(): void;
    get operationsInput(): AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations[] | undefined;
}
export interface AccessContextManagerServicePerimeterSpecEgressPolicies {
    /**
     * egress_from block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#egress_from AccessContextManagerServicePerimeter#egress_from}
     */
    readonly egressFrom?: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressFrom;
    /**
     * egress_to block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#egress_to AccessContextManagerServicePerimeter#egress_to}
     */
    readonly egressTo?: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressTo;
}
export interface AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources {
    /**
     * An 'AccessLevel' resource name that allow resources within the  'ServicePerimeters' to be accessed from the internet.
     *
     * 'AccessLevels' listed
     * must be in the same policy as this 'ServicePerimeter'. Referencing a nonexistent
     * 'AccessLevel' will cause an error. If no 'AccessLevel' names are listed,
     * resources within the perimeter can only be accessed via Google Cloud calls
     * with request origins within the perimeter.
     * Example 'accessPolicies/MY_POLICY/accessLevels/MY_LEVEL.'
     * If * is specified, then all IngressSources will be allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#access_level AccessContextManagerServicePerimeter#access_level}
     */
    readonly accessLevel?: string;
    /**
     * A Google Cloud resource that is allowed to ingress the perimeter.
     *
     * Requests from these resources will be allowed to access perimeter data.
     * Currently only projects are allowed. Format 'projects/{project_number}'
     * The project may be in any Google Cloud organization, not just the
     * organization that the perimeter is defined in. '*' is not allowed, the case
     * of allowing all Google Cloud resources only is not supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#resource AccessContextManagerServicePerimeter#resource}
     */
    readonly resource?: string;
}
export interface AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFrom {
    /**
     * A list of identities that are allowed access through this ingress policy.
     *
     * Should be in the format of email address. The email address should represent
     * individual user or service account only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#identities AccessContextManagerServicePerimeter#identities}
     */
    readonly identities?: string[];
    /**
     * Specifies the type of identities that are allowed access from outside the  perimeter.
     *
     * If left unspecified, then members of 'identities' field will be
     * allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#identity_type AccessContextManagerServicePerimeter#identity_type}
     */
    readonly identityType?: string;
    /**
     * sources block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#sources AccessContextManagerServicePerimeter#sources}
     */
    readonly sources?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources[];
}
export declare class AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _identities?;
    get identities(): string[] | undefined;
    set identities(value: string[] | undefined);
    resetIdentities(): void;
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    get identityType(): string | undefined;
    set identityType(value: string | undefined);
    resetIdentityType(): void;
    get identityTypeInput(): string | undefined;
    private _sources?;
    get sources(): AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources[] | undefined;
    set sources(value: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources[] | undefined);
    resetSources(): void;
    get sourcesInput(): AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources[] | undefined;
}
export interface AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectors {
    /**
     * Value for method should be a valid method name for the corresponding  serviceName in 'ApiOperation'.
     *
     * If '*' used as value for 'method', then
     * ALL methods and permissions are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#method AccessContextManagerServicePerimeter#method}
     */
    readonly method?: string;
    /**
     * Value for permission should be a valid Cloud IAM permission for the  corresponding 'serviceName' in 'ApiOperation'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#permission AccessContextManagerServicePerimeter#permission}
     */
    readonly permission?: string;
}
export interface AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations {
    /**
     * The name of the API whose methods or permissions the 'IngressPolicy' or  'EgressPolicy' want to allow.
     *
     * A single 'ApiOperation' with 'serviceName'
     * field set to '*' will allow all methods AND permissions for all services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#service_name AccessContextManagerServicePerimeter#service_name}
     */
    readonly serviceName?: string;
    /**
     * method_selectors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#method_selectors AccessContextManagerServicePerimeter#method_selectors}
     */
    readonly methodSelectors?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectors[];
}
export interface AccessContextManagerServicePerimeterSpecIngressPoliciesIngressTo {
    /**
     * A list of resources, currently only projects in the form  'projects/<projectnumber>', protected by this 'ServicePerimeter' that are allowed to be accessed by sources defined in the corresponding 'IngressFrom'.
     *
     * A request matches if it contains
     * a resource in this list. If '*' is specified for resources,
     * then this 'IngressTo' rule will authorize access to all
     * resources inside the perimeter, provided that the request
     * also matches the 'operations' field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#resources AccessContextManagerServicePerimeter#resources}
     */
    readonly resources?: string[];
    /**
     * operations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#operations AccessContextManagerServicePerimeter#operations}
     */
    readonly operations?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations[];
}
export declare class AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _resources?;
    get resources(): string[] | undefined;
    set resources(value: string[] | undefined);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _operations?;
    get operations(): AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations[] | undefined;
    set operations(value: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations[] | undefined);
    resetOperations(): void;
    get operationsInput(): AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations[] | undefined;
}
export interface AccessContextManagerServicePerimeterSpecIngressPolicies {
    /**
     * ingress_from block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#ingress_from AccessContextManagerServicePerimeter#ingress_from}
     */
    readonly ingressFrom?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFrom;
    /**
     * ingress_to block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#ingress_to AccessContextManagerServicePerimeter#ingress_to}
     */
    readonly ingressTo?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressTo;
}
export interface AccessContextManagerServicePerimeterSpecVpcAccessibleServices {
    /**
     * The list of APIs usable within the Service Perimeter. Must be empty unless 'enableRestriction' is True.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#allowed_services AccessContextManagerServicePerimeter#allowed_services}
     */
    readonly allowedServices?: string[];
    /**
     * Whether to restrict API calls within the Service Perimeter to the list of APIs specified in 'allowedServices'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#enable_restriction AccessContextManagerServicePerimeter#enable_restriction}
     */
    readonly enableRestriction?: boolean | cdktf.IResolvable;
}
export declare class AccessContextManagerServicePerimeterSpecVpcAccessibleServicesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _allowedServices?;
    get allowedServices(): string[] | undefined;
    set allowedServices(value: string[] | undefined);
    resetAllowedServices(): void;
    get allowedServicesInput(): string[] | undefined;
    private _enableRestriction?;
    get enableRestriction(): boolean | cdktf.IResolvable | undefined;
    set enableRestriction(value: boolean | cdktf.IResolvable | undefined);
    resetEnableRestriction(): void;
    get enableRestrictionInput(): boolean | cdktf.IResolvable | undefined;
}
export interface AccessContextManagerServicePerimeterSpec {
    /**
     * A list of AccessLevel resource names that allow resources within the ServicePerimeter to be accessed from the internet.
     *
     * AccessLevels listed must be in the same policy as this
     * ServicePerimeter. Referencing a nonexistent AccessLevel is a
     * syntax error. If no AccessLevel names are listed, resources within
     * the perimeter can only be accessed via GCP calls with request
     * origins within the perimeter. For Service Perimeter Bridge, must
     * be empty.
     *
     * Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#access_levels AccessContextManagerServicePerimeter#access_levels}
     */
    readonly accessLevels?: string[];
    /**
     * A list of GCP resources that are inside of the service perimeter. Currently only projects are allowed. Format: projects/{project_number}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#resources AccessContextManagerServicePerimeter#resources}
     */
    readonly resources?: string[];
    /**
     * GCP services that are subject to the Service Perimeter restrictions.
     *
     * Must contain a list of services. For example, if
     * 'storage.googleapis.com' is specified, access to the storage
     * buckets inside the perimeter must meet the perimeter's access
     * restrictions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#restricted_services AccessContextManagerServicePerimeter#restricted_services}
     */
    readonly restrictedServices?: string[];
    /**
     * egress_policies block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#egress_policies AccessContextManagerServicePerimeter#egress_policies}
     */
    readonly egressPolicies?: AccessContextManagerServicePerimeterSpecEgressPolicies[];
    /**
     * ingress_policies block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#ingress_policies AccessContextManagerServicePerimeter#ingress_policies}
     */
    readonly ingressPolicies?: AccessContextManagerServicePerimeterSpecIngressPolicies[];
    /**
     * vpc_accessible_services block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#vpc_accessible_services AccessContextManagerServicePerimeter#vpc_accessible_services}
     */
    readonly vpcAccessibleServices?: AccessContextManagerServicePerimeterSpecVpcAccessibleServices;
}
export declare class AccessContextManagerServicePerimeterSpecOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _accessLevels?;
    get accessLevels(): string[] | undefined;
    set accessLevels(value: string[] | undefined);
    resetAccessLevels(): void;
    get accessLevelsInput(): string[] | undefined;
    private _resources?;
    get resources(): string[] | undefined;
    set resources(value: string[] | undefined);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _restrictedServices?;
    get restrictedServices(): string[] | undefined;
    set restrictedServices(value: string[] | undefined);
    resetRestrictedServices(): void;
    get restrictedServicesInput(): string[] | undefined;
    private _egressPolicies?;
    get egressPolicies(): AccessContextManagerServicePerimeterSpecEgressPolicies[] | undefined;
    set egressPolicies(value: AccessContextManagerServicePerimeterSpecEgressPolicies[] | undefined);
    resetEgressPolicies(): void;
    get egressPoliciesInput(): AccessContextManagerServicePerimeterSpecEgressPolicies[] | undefined;
    private _ingressPolicies?;
    get ingressPolicies(): AccessContextManagerServicePerimeterSpecIngressPolicies[] | undefined;
    set ingressPolicies(value: AccessContextManagerServicePerimeterSpecIngressPolicies[] | undefined);
    resetIngressPolicies(): void;
    get ingressPoliciesInput(): AccessContextManagerServicePerimeterSpecIngressPolicies[] | undefined;
    private _vpcAccessibleServices?;
    private __vpcAccessibleServicesOutput;
    get vpcAccessibleServices(): AccessContextManagerServicePerimeterSpecVpcAccessibleServicesOutputReference;
    putVpcAccessibleServices(value: AccessContextManagerServicePerimeterSpecVpcAccessibleServices | undefined): void;
    resetVpcAccessibleServices(): void;
    get vpcAccessibleServicesInput(): AccessContextManagerServicePerimeterSpecVpcAccessibleServices | undefined;
}
export interface AccessContextManagerServicePerimeterStatusEgressPoliciesEgressFrom {
    /**
     * A list of identities that are allowed access through this 'EgressPolicy'.
     *
     * Should be in the format of email address. The email address should
     * represent individual user or service account only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#identities AccessContextManagerServicePerimeter#identities}
     */
    readonly identities?: string[];
    /**
     * Specifies the type of identities that are allowed access to outside the  perimeter.
     *
     * If left unspecified, then members of 'identities' field will
     * be allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#identity_type AccessContextManagerServicePerimeter#identity_type}
     */
    readonly identityType?: string;
}
export declare class AccessContextManagerServicePerimeterStatusEgressPoliciesEgressFromOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _identities?;
    get identities(): string[] | undefined;
    set identities(value: string[] | undefined);
    resetIdentities(): void;
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    get identityType(): string | undefined;
    set identityType(value: string | undefined);
    resetIdentityType(): void;
    get identityTypeInput(): string | undefined;
}
export interface AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectors {
    /**
     * Value for 'method' should be a valid method name for the corresponding  'serviceName' in 'ApiOperation'.
     *
     * If '*' used as value for method,
     * then ALL methods and permissions are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#method AccessContextManagerServicePerimeter#method}
     */
    readonly method?: string;
    /**
     * Value for permission should be a valid Cloud IAM permission for the  corresponding 'serviceName' in 'ApiOperation'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#permission AccessContextManagerServicePerimeter#permission}
     */
    readonly permission?: string;
}
export interface AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations {
    /**
     * The name of the API whose methods or permissions the 'IngressPolicy' or  'EgressPolicy' want to allow.
     *
     * A single 'ApiOperation' with serviceName
     * field set to '*' will allow all methods AND permissions for all services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#service_name AccessContextManagerServicePerimeter#service_name}
     */
    readonly serviceName?: string;
    /**
     * method_selectors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#method_selectors AccessContextManagerServicePerimeter#method_selectors}
     */
    readonly methodSelectors?: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectors[];
}
export interface AccessContextManagerServicePerimeterStatusEgressPoliciesEgressTo {
    /**
     * A list of resources, currently only projects in the form  'projects/<projectnumber>', that match this to stanza.
     *
     * A request matches
     * if it contains a resource in this list. If * is specified for resources,
     * then this 'EgressTo' rule will authorize access to all resources outside
     * the perimeter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#resources AccessContextManagerServicePerimeter#resources}
     */
    readonly resources?: string[];
    /**
     * operations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#operations AccessContextManagerServicePerimeter#operations}
     */
    readonly operations?: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations[];
}
export declare class AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _resources?;
    get resources(): string[] | undefined;
    set resources(value: string[] | undefined);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _operations?;
    get operations(): AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations[] | undefined;
    set operations(value: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations[] | undefined);
    resetOperations(): void;
    get operationsInput(): AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations[] | undefined;
}
export interface AccessContextManagerServicePerimeterStatusEgressPolicies {
    /**
     * egress_from block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#egress_from AccessContextManagerServicePerimeter#egress_from}
     */
    readonly egressFrom?: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressFrom;
    /**
     * egress_to block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#egress_to AccessContextManagerServicePerimeter#egress_to}
     */
    readonly egressTo?: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressTo;
}
export interface AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources {
    /**
     * An 'AccessLevel' resource name that allow resources within the  'ServicePerimeters' to be accessed from the internet.
     *
     * 'AccessLevels' listed
     * must be in the same policy as this 'ServicePerimeter'. Referencing a nonexistent
     * 'AccessLevel' will cause an error. If no 'AccessLevel' names are listed,
     * resources within the perimeter can only be accessed via Google Cloud calls
     * with request origins within the perimeter.
     * Example 'accessPolicies/MY_POLICY/accessLevels/MY_LEVEL.'
     * If * is specified, then all IngressSources will be allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#access_level AccessContextManagerServicePerimeter#access_level}
     */
    readonly accessLevel?: string;
    /**
     * A Google Cloud resource that is allowed to ingress the perimeter.
     *
     * Requests from these resources will be allowed to access perimeter data.
     * Currently only projects are allowed. Format 'projects/{project_number}'
     * The project may be in any Google Cloud organization, not just the
     * organization that the perimeter is defined in. '*' is not allowed, the case
     * of allowing all Google Cloud resources only is not supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#resource AccessContextManagerServicePerimeter#resource}
     */
    readonly resource?: string;
}
export interface AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFrom {
    /**
     * A list of identities that are allowed access through this ingress policy.
     *
     * Should be in the format of email address. The email address should represent
     * individual user or service account only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#identities AccessContextManagerServicePerimeter#identities}
     */
    readonly identities?: string[];
    /**
     * Specifies the type of identities that are allowed access from outside the  perimeter.
     *
     * If left unspecified, then members of 'identities' field will be
     * allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#identity_type AccessContextManagerServicePerimeter#identity_type}
     */
    readonly identityType?: string;
    /**
     * sources block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#sources AccessContextManagerServicePerimeter#sources}
     */
    readonly sources?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources[];
}
export declare class AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _identities?;
    get identities(): string[] | undefined;
    set identities(value: string[] | undefined);
    resetIdentities(): void;
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    get identityType(): string | undefined;
    set identityType(value: string | undefined);
    resetIdentityType(): void;
    get identityTypeInput(): string | undefined;
    private _sources?;
    get sources(): AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources[] | undefined;
    set sources(value: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources[] | undefined);
    resetSources(): void;
    get sourcesInput(): AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources[] | undefined;
}
export interface AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectors {
    /**
     * Value for method should be a valid method name for the corresponding  serviceName in 'ApiOperation'.
     *
     * If '*' used as value for 'method', then
     * ALL methods and permissions are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#method AccessContextManagerServicePerimeter#method}
     */
    readonly method?: string;
    /**
     * Value for permission should be a valid Cloud IAM permission for the  corresponding 'serviceName' in 'ApiOperation'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#permission AccessContextManagerServicePerimeter#permission}
     */
    readonly permission?: string;
}
export interface AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations {
    /**
     * The name of the API whose methods or permissions the 'IngressPolicy' or  'EgressPolicy' want to allow.
     *
     * A single 'ApiOperation' with 'serviceName'
     * field set to '*' will allow all methods AND permissions for all services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#service_name AccessContextManagerServicePerimeter#service_name}
     */
    readonly serviceName?: string;
    /**
     * method_selectors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#method_selectors AccessContextManagerServicePerimeter#method_selectors}
     */
    readonly methodSelectors?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectors[];
}
export interface AccessContextManagerServicePerimeterStatusIngressPoliciesIngressTo {
    /**
     * A list of resources, currently only projects in the form  'projects/<projectnumber>', protected by this 'ServicePerimeter' that are allowed to be accessed by sources defined in the corresponding 'IngressFrom'.
     *
     * A request matches if it contains
     * a resource in this list. If '*' is specified for resources,
     * then this 'IngressTo' rule will authorize access to all
     * resources inside the perimeter, provided that the request
     * also matches the 'operations' field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#resources AccessContextManagerServicePerimeter#resources}
     */
    readonly resources?: string[];
    /**
     * operations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#operations AccessContextManagerServicePerimeter#operations}
     */
    readonly operations?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations[];
}
export declare class AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _resources?;
    get resources(): string[] | undefined;
    set resources(value: string[] | undefined);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _operations?;
    get operations(): AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations[] | undefined;
    set operations(value: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations[] | undefined);
    resetOperations(): void;
    get operationsInput(): AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations[] | undefined;
}
export interface AccessContextManagerServicePerimeterStatusIngressPolicies {
    /**
     * ingress_from block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#ingress_from AccessContextManagerServicePerimeter#ingress_from}
     */
    readonly ingressFrom?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFrom;
    /**
     * ingress_to block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#ingress_to AccessContextManagerServicePerimeter#ingress_to}
     */
    readonly ingressTo?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressTo;
}
export interface AccessContextManagerServicePerimeterStatusVpcAccessibleServices {
    /**
     * The list of APIs usable within the Service Perimeter. Must be empty unless 'enableRestriction' is True.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#allowed_services AccessContextManagerServicePerimeter#allowed_services}
     */
    readonly allowedServices?: string[];
    /**
     * Whether to restrict API calls within the Service Perimeter to the list of APIs specified in 'allowedServices'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#enable_restriction AccessContextManagerServicePerimeter#enable_restriction}
     */
    readonly enableRestriction?: boolean | cdktf.IResolvable;
}
export declare class AccessContextManagerServicePerimeterStatusVpcAccessibleServicesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _allowedServices?;
    get allowedServices(): string[] | undefined;
    set allowedServices(value: string[] | undefined);
    resetAllowedServices(): void;
    get allowedServicesInput(): string[] | undefined;
    private _enableRestriction?;
    get enableRestriction(): boolean | cdktf.IResolvable | undefined;
    set enableRestriction(value: boolean | cdktf.IResolvable | undefined);
    resetEnableRestriction(): void;
    get enableRestrictionInput(): boolean | cdktf.IResolvable | undefined;
}
export interface AccessContextManagerServicePerimeterStatus {
    /**
     * A list of AccessLevel resource names that allow resources within the ServicePerimeter to be accessed from the internet.
     *
     * AccessLevels listed must be in the same policy as this
     * ServicePerimeter. Referencing a nonexistent AccessLevel is a
     * syntax error. If no AccessLevel names are listed, resources within
     * the perimeter can only be accessed via GCP calls with request
     * origins within the perimeter. For Service Perimeter Bridge, must
     * be empty.
     *
     * Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#access_levels AccessContextManagerServicePerimeter#access_levels}
     */
    readonly accessLevels?: string[];
    /**
     * A list of GCP resources that are inside of the service perimeter. Currently only projects are allowed. Format: projects/{project_number}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#resources AccessContextManagerServicePerimeter#resources}
     */
    readonly resources?: string[];
    /**
     * GCP services that are subject to the Service Perimeter restrictions.
     *
     * Must contain a list of services. For example, if
     * 'storage.googleapis.com' is specified, access to the storage
     * buckets inside the perimeter must meet the perimeter's access
     * restrictions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#restricted_services AccessContextManagerServicePerimeter#restricted_services}
     */
    readonly restrictedServices?: string[];
    /**
     * egress_policies block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#egress_policies AccessContextManagerServicePerimeter#egress_policies}
     */
    readonly egressPolicies?: AccessContextManagerServicePerimeterStatusEgressPolicies[];
    /**
     * ingress_policies block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#ingress_policies AccessContextManagerServicePerimeter#ingress_policies}
     */
    readonly ingressPolicies?: AccessContextManagerServicePerimeterStatusIngressPolicies[];
    /**
     * vpc_accessible_services block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#vpc_accessible_services AccessContextManagerServicePerimeter#vpc_accessible_services}
     */
    readonly vpcAccessibleServices?: AccessContextManagerServicePerimeterStatusVpcAccessibleServices;
}
export declare class AccessContextManagerServicePerimeterStatusOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _accessLevels?;
    get accessLevels(): string[] | undefined;
    set accessLevels(value: string[] | undefined);
    resetAccessLevels(): void;
    get accessLevelsInput(): string[] | undefined;
    private _resources?;
    get resources(): string[] | undefined;
    set resources(value: string[] | undefined);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _restrictedServices?;
    get restrictedServices(): string[] | undefined;
    set restrictedServices(value: string[] | undefined);
    resetRestrictedServices(): void;
    get restrictedServicesInput(): string[] | undefined;
    private _egressPolicies?;
    get egressPolicies(): AccessContextManagerServicePerimeterStatusEgressPolicies[] | undefined;
    set egressPolicies(value: AccessContextManagerServicePerimeterStatusEgressPolicies[] | undefined);
    resetEgressPolicies(): void;
    get egressPoliciesInput(): AccessContextManagerServicePerimeterStatusEgressPolicies[] | undefined;
    private _ingressPolicies?;
    get ingressPolicies(): AccessContextManagerServicePerimeterStatusIngressPolicies[] | undefined;
    set ingressPolicies(value: AccessContextManagerServicePerimeterStatusIngressPolicies[] | undefined);
    resetIngressPolicies(): void;
    get ingressPoliciesInput(): AccessContextManagerServicePerimeterStatusIngressPolicies[] | undefined;
    private _vpcAccessibleServices?;
    private __vpcAccessibleServicesOutput;
    get vpcAccessibleServices(): AccessContextManagerServicePerimeterStatusVpcAccessibleServicesOutputReference;
    putVpcAccessibleServices(value: AccessContextManagerServicePerimeterStatusVpcAccessibleServices | undefined): void;
    resetVpcAccessibleServices(): void;
    get vpcAccessibleServicesInput(): AccessContextManagerServicePerimeterStatusVpcAccessibleServices | undefined;
}
export interface AccessContextManagerServicePerimeterTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#create AccessContextManagerServicePerimeter#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#delete AccessContextManagerServicePerimeter#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#update AccessContextManagerServicePerimeter#update}.
     */
    readonly update?: string;
}
export declare class AccessContextManagerServicePerimeterTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html google_access_context_manager_service_perimeter}.
 */
export declare class AccessContextManagerServicePerimeter extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html google_access_context_manager_service_perimeter} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: AccessContextManagerServicePerimeterConfig);
    get createTime(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _perimeterType?;
    get perimeterType(): string | undefined;
    set perimeterType(value: string | undefined);
    resetPerimeterType(): void;
    get perimeterTypeInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    get updateTime(): string;
    private _useExplicitDryRunSpec?;
    get useExplicitDryRunSpec(): boolean | cdktf.IResolvable | undefined;
    set useExplicitDryRunSpec(value: boolean | cdktf.IResolvable | undefined);
    resetUseExplicitDryRunSpec(): void;
    get useExplicitDryRunSpecInput(): boolean | cdktf.IResolvable | undefined;
    private _spec?;
    private __specOutput;
    get spec(): AccessContextManagerServicePerimeterSpecOutputReference;
    putSpec(value: AccessContextManagerServicePerimeterSpec | undefined): void;
    resetSpec(): void;
    get specInput(): AccessContextManagerServicePerimeterSpec | undefined;
    private _status?;
    private __statusOutput;
    get status(): AccessContextManagerServicePerimeterStatusOutputReference;
    putStatus(value: AccessContextManagerServicePerimeterStatus | undefined): void;
    resetStatus(): void;
    get statusInput(): AccessContextManagerServicePerimeterStatus | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): AccessContextManagerServicePerimeterTimeoutsOutputReference;
    putTimeouts(value: AccessContextManagerServicePerimeterTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): AccessContextManagerServicePerimeterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
