import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AccessContextManagerAccessPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * The parent of this AccessPolicy in the Cloud Resource Hierarchy. Format: organizations/{organization_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_policy.html#parent AccessContextManagerAccessPolicy#parent}
     */
    readonly parent: string;
    /**
     * Human readable title. Does not affect behavior.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_policy.html#title AccessContextManagerAccessPolicy#title}
     */
    readonly title: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_policy.html#timeouts AccessContextManagerAccessPolicy#timeouts}
     */
    readonly timeouts?: AccessContextManagerAccessPolicyTimeouts;
}
export interface AccessContextManagerAccessPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_policy.html#create AccessContextManagerAccessPolicy#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_policy.html#delete AccessContextManagerAccessPolicy#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_policy.html#update AccessContextManagerAccessPolicy#update}.
     */
    readonly update?: string;
}
export declare class AccessContextManagerAccessPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_policy.html google_access_context_manager_access_policy}.
 */
export declare class AccessContextManagerAccessPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_policy.html google_access_context_manager_access_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: AccessContextManagerAccessPolicyConfig);
    get createTime(): string;
    get id(): string;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    get updateTime(): string;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): AccessContextManagerAccessPolicyTimeoutsOutputReference;
    putTimeouts(value: AccessContextManagerAccessPolicyTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): AccessContextManagerAccessPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
