import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AccessContextManagerAccessLevelsConfig extends cdktf.TerraformMetaArguments {
    /**
     * The AccessPolicy this AccessLevel lives in. Format: accessPolicies/{policy_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#parent AccessContextManagerAccessLevels#parent}
     */
    readonly parent: string;
    /**
     * access_levels block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#access_levels AccessContextManagerAccessLevels#access_levels}
     */
    readonly accessLevels?: AccessContextManagerAccessLevelsAccessLevels[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#timeouts AccessContextManagerAccessLevels#timeouts}
     */
    readonly timeouts?: AccessContextManagerAccessLevelsTimeouts;
}
export interface AccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraints {
    /**
     * The minimum allowed OS version.
     *
     * If not set, any version
     * of this OS satisfies the constraint.
     * Format: "major.minor.patch" such as "10.5.301", "9.2.1".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#minimum_version AccessContextManagerAccessLevels#minimum_version}
     */
    readonly minimumVersion?: string;
    /**
     * The operating system type of the device. Possible values: ["OS_UNSPECIFIED", "DESKTOP_MAC", "DESKTOP_WINDOWS", "DESKTOP_LINUX", "DESKTOP_CHROME_OS", "ANDROID", "IOS"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#os_type AccessContextManagerAccessLevels#os_type}
     */
    readonly osType: string;
}
export interface AccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicy {
    /**
     * A list of allowed device management levels. An empty list allows all management levels. Possible values: ["MANAGEMENT_UNSPECIFIED", "NONE", "BASIC", "COMPLETE"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#allowed_device_management_levels AccessContextManagerAccessLevels#allowed_device_management_levels}
     */
    readonly allowedDeviceManagementLevels?: string[];
    /**
     * A list of allowed encryptions statuses. An empty list allows all statuses. Possible values: ["ENCRYPTION_UNSPECIFIED", "ENCRYPTION_UNSUPPORTED", "UNENCRYPTED", "ENCRYPTED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#allowed_encryption_statuses AccessContextManagerAccessLevels#allowed_encryption_statuses}
     */
    readonly allowedEncryptionStatuses?: string[];
    /**
     * Whether the device needs to be approved by the customer admin.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#require_admin_approval AccessContextManagerAccessLevels#require_admin_approval}
     */
    readonly requireAdminApproval?: boolean | cdktf.IResolvable;
    /**
     * Whether the device needs to be corp owned.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#require_corp_owned AccessContextManagerAccessLevels#require_corp_owned}
     */
    readonly requireCorpOwned?: boolean | cdktf.IResolvable;
    /**
     * Whether or not screenlock is required for the DevicePolicy to be true. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#require_screen_lock AccessContextManagerAccessLevels#require_screen_lock}
     */
    readonly requireScreenLock?: boolean | cdktf.IResolvable;
    /**
     * os_constraints block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#os_constraints AccessContextManagerAccessLevels#os_constraints}
     */
    readonly osConstraints?: AccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraints[];
}
export declare class AccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _allowedDeviceManagementLevels?;
    get allowedDeviceManagementLevels(): string[] | undefined;
    set allowedDeviceManagementLevels(value: string[] | undefined);
    resetAllowedDeviceManagementLevels(): void;
    get allowedDeviceManagementLevelsInput(): string[] | undefined;
    private _allowedEncryptionStatuses?;
    get allowedEncryptionStatuses(): string[] | undefined;
    set allowedEncryptionStatuses(value: string[] | undefined);
    resetAllowedEncryptionStatuses(): void;
    get allowedEncryptionStatusesInput(): string[] | undefined;
    private _requireAdminApproval?;
    get requireAdminApproval(): boolean | cdktf.IResolvable | undefined;
    set requireAdminApproval(value: boolean | cdktf.IResolvable | undefined);
    resetRequireAdminApproval(): void;
    get requireAdminApprovalInput(): boolean | cdktf.IResolvable | undefined;
    private _requireCorpOwned?;
    get requireCorpOwned(): boolean | cdktf.IResolvable | undefined;
    set requireCorpOwned(value: boolean | cdktf.IResolvable | undefined);
    resetRequireCorpOwned(): void;
    get requireCorpOwnedInput(): boolean | cdktf.IResolvable | undefined;
    private _requireScreenLock?;
    get requireScreenLock(): boolean | cdktf.IResolvable | undefined;
    set requireScreenLock(value: boolean | cdktf.IResolvable | undefined);
    resetRequireScreenLock(): void;
    get requireScreenLockInput(): boolean | cdktf.IResolvable | undefined;
    private _osConstraints?;
    get osConstraints(): AccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraints[] | undefined;
    set osConstraints(value: AccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraints[] | undefined);
    resetOsConstraints(): void;
    get osConstraintsInput(): AccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraints[] | undefined;
}
export interface AccessContextManagerAccessLevelsAccessLevelsBasicConditions {
    /**
     * A list of CIDR block IP subnetwork specification.
     *
     * May be IPv4
     * or IPv6.
     * Note that for a CIDR IP address block, the specified IP address
     * portion must be properly truncated (i.e. all the host bits must
     * be zero) or the input is considered malformed. For example,
     * "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly,
     * for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32"
     * is not. The originating IP of a request must be in one of the
     * listed subnets in order for this Condition to be true.
     * If empty, all IP addresses are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#ip_subnetworks AccessContextManagerAccessLevels#ip_subnetworks}
     */
    readonly ipSubnetworks?: string[];
    /**
     * An allowed list of members (users, service accounts). Using groups is not supported yet.
     *
     * The signed-in user originating the request must be a part of one
     * of the provided members. If not specified, a request may come
     * from any user (logged in/not logged in, not present in any
     * groups, etc.).
     * Formats: 'user:{emailid}', 'serviceAccount:{emailid}'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#members AccessContextManagerAccessLevels#members}
     */
    readonly members?: string[];
    /**
     * Whether to negate the Condition.
     *
     * If true, the Condition becomes
     * a NAND over its non-empty fields, each field must be false for
     * the Condition overall to be satisfied. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#negate AccessContextManagerAccessLevels#negate}
     */
    readonly negate?: boolean | cdktf.IResolvable;
    /**
     * The request must originate from one of the provided countries/regions. Format: A valid ISO 3166-1 alpha-2 code.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#regions AccessContextManagerAccessLevels#regions}
     */
    readonly regions?: string[];
    /**
     * A list of other access levels defined in the same Policy, referenced by resource name.
     *
     * Referencing an AccessLevel which
     * does not exist is an error. All access levels listed must be
     * granted for the Condition to be true.
     * Format: accessPolicies/{policy_id}/accessLevels/{short_name}
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#required_access_levels AccessContextManagerAccessLevels#required_access_levels}
     */
    readonly requiredAccessLevels?: string[];
    /**
     * device_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#device_policy AccessContextManagerAccessLevels#device_policy}
     */
    readonly devicePolicy?: AccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicy;
}
export interface AccessContextManagerAccessLevelsAccessLevelsBasic {
    /**
     * How the conditions list should be combined to determine if a request is granted this AccessLevel.
     *
     * If AND is used, each Condition in
     * conditions must be satisfied for the AccessLevel to be applied. If
     * OR is used, at least one Condition in conditions must be satisfied
     * for the AccessLevel to be applied. Default value: "AND" Possible values: ["AND", "OR"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#combining_function AccessContextManagerAccessLevels#combining_function}
     */
    readonly combiningFunction?: string;
    /**
     * conditions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#conditions AccessContextManagerAccessLevels#conditions}
     */
    readonly conditions: AccessContextManagerAccessLevelsAccessLevelsBasicConditions[];
}
export declare class AccessContextManagerAccessLevelsAccessLevelsBasicOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _combiningFunction?;
    get combiningFunction(): string | undefined;
    set combiningFunction(value: string | undefined);
    resetCombiningFunction(): void;
    get combiningFunctionInput(): string | undefined;
    private _conditions?;
    get conditions(): AccessContextManagerAccessLevelsAccessLevelsBasicConditions[];
    set conditions(value: AccessContextManagerAccessLevelsAccessLevelsBasicConditions[]);
    get conditionsInput(): AccessContextManagerAccessLevelsAccessLevelsBasicConditions[] | undefined;
}
export interface AccessContextManagerAccessLevelsAccessLevelsCustomExpr {
    /**
     * Description of the expression.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#description AccessContextManagerAccessLevels#description}
     */
    readonly description?: string;
    /**
     * Textual representation of an expression in Common Expression Language syntax.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#expression AccessContextManagerAccessLevels#expression}
     */
    readonly expression: string;
    /**
     * String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#location AccessContextManagerAccessLevels#location}
     */
    readonly location?: string;
    /**
     * Title for the expression, i.e. a short string describing its purpose.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#title AccessContextManagerAccessLevels#title}
     */
    readonly title?: string;
}
export declare class AccessContextManagerAccessLevelsAccessLevelsCustomExprOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string | undefined;
    set location(value: string | undefined);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string | undefined;
    set title(value: string | undefined);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface AccessContextManagerAccessLevelsAccessLevelsCustom {
    /**
     * expr block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#expr AccessContextManagerAccessLevels#expr}
     */
    readonly expr: AccessContextManagerAccessLevelsAccessLevelsCustomExpr;
}
export declare class AccessContextManagerAccessLevelsAccessLevelsCustomOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _expr?;
    private __exprOutput;
    get expr(): AccessContextManagerAccessLevelsAccessLevelsCustomExprOutputReference;
    putExpr(value: AccessContextManagerAccessLevelsAccessLevelsCustomExpr): void;
    get exprInput(): AccessContextManagerAccessLevelsAccessLevelsCustomExpr | undefined;
}
export interface AccessContextManagerAccessLevelsAccessLevels {
    /**
     * Description of the AccessLevel and its use. Does not affect behavior.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#description AccessContextManagerAccessLevels#description}
     */
    readonly description?: string;
    /**
     * Resource name for the Access Level.
     *
     * The short_name component must begin
     * with a letter and only include alphanumeric and '_'.
     * Format: accessPolicies/{policy_id}/accessLevels/{short_name}
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#name AccessContextManagerAccessLevels#name}
     */
    readonly name: string;
    /**
     * Human readable title. Must be unique within the Policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#title AccessContextManagerAccessLevels#title}
     */
    readonly title: string;
    /**
     * basic block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#basic AccessContextManagerAccessLevels#basic}
     */
    readonly basic?: AccessContextManagerAccessLevelsAccessLevelsBasic;
    /**
     * custom block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#custom AccessContextManagerAccessLevels#custom}
     */
    readonly custom?: AccessContextManagerAccessLevelsAccessLevelsCustom;
}
export interface AccessContextManagerAccessLevelsTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#create AccessContextManagerAccessLevels#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#delete AccessContextManagerAccessLevels#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html#update AccessContextManagerAccessLevels#update}.
     */
    readonly update?: string;
}
export declare class AccessContextManagerAccessLevelsTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html google_access_context_manager_access_levels}.
 */
export declare class AccessContextManagerAccessLevels extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels.html google_access_context_manager_access_levels} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: AccessContextManagerAccessLevelsConfig);
    get id(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _accessLevels?;
    get accessLevels(): AccessContextManagerAccessLevelsAccessLevels[] | undefined;
    set accessLevels(value: AccessContextManagerAccessLevelsAccessLevels[] | undefined);
    resetAccessLevels(): void;
    get accessLevelsInput(): AccessContextManagerAccessLevelsAccessLevels[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): AccessContextManagerAccessLevelsTimeoutsOutputReference;
    putTimeouts(value: AccessContextManagerAccessLevelsTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): AccessContextManagerAccessLevelsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
