import { IConnectable, Connections, SecurityGroup } from '@aws-cdk/aws-ec2';
import { ICluster, LaunchType } from '@aws-cdk/aws-ecs';
import { ITargetGroup } from '@aws-cdk/aws-elasticloadbalancingv2';
import { Construct } from '@aws-cdk/core';
import { DummyTaskDefinition } from './dummy-task-definition';
export interface IEcsService {
    readonly clusterName: string;
    readonly serviceName: string;
}
export interface EcsServiceProps {
    readonly securityGroups?: SecurityGroup[];
    readonly cluster: ICluster;
    readonly serviceName: string;
    readonly launchType?: LaunchType;
    readonly platformVersion?: string;
    readonly desiredCount?: number;
    readonly containerPort?: number;
    readonly prodTargetGroup: ITargetGroup;
    readonly taskDefinition: DummyTaskDefinition;
}
export declare class EcsService extends Construct implements IConnectable, IEcsService {
    readonly clusterName: string;
    readonly serviceName: string;
    readonly connections: Connections;
    constructor(scope: Construct, id: string, props: EcsServiceProps);
}
export declare enum SchedulingStrategy {
    REPLICA = "REPLICA",
    DAEMON = "DAEMON"
}
