# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pytorch_tabnet']

package_data = \
{'': ['*']}

install_requires = \
['numpy>=1.17,<2.0',
 'scikit_learn>0.21',
 'scipy>1.4',
 'torch>=1.2,<2.0',
 'tqdm>=4.36,<5.0']

setup_kwargs = {
    'name': 'pytorch-tabnet',
    'version': '1.2.0',
    'description': 'PyTorch implementation of TabNet',
    'long_description': '# README\n\n# TabNet : Attentive Interpretable Tabular Learning\n\nThis is a pyTorch implementation of Tabnet (Arik, S. O., & Pfister, T. (2019). TabNet: Attentive Interpretable Tabular Learning. arXiv preprint arXiv:1908.07442.) https://arxiv.org/pdf/1908.07442.pdf.\n\n[![CircleCI](https://circleci.com/gh/dreamquark-ai/tabnet.svg?style=svg)](https://circleci.com/gh/dreamquark-ai/tabnet)\n\n[![PyPI version](https://badge.fury.io/py/pytorch-tabnet.svg)](https://badge.fury.io/py/pytorch-tabnet)\n\n![PyPI - Downloads](https://img.shields.io/pypi/dm/pytorch-tabnet)\n\nAny questions ? Want to contribute ? To talk with us ? You can join us on [Slack](https://join.slack.com/t/mltooling/shared_invite/zt-e4y14rbp-IReRxmjoNy27XQFQgh~4ZQ)\n\n# Installation\n\n## Easy installation\nYou can install using pip by running:\n`pip install pytorch-tabnet`\n\n## Source code\nIf you wan to use it locally within a docker container:\n\n- `git clone git@github.com:dreamquark-ai/tabnet.git`\n\n- `cd tabnet` to get inside the repository\n\n-----------------\n#### CPU only\n- `make start` to build and get inside the container\n\n#### GPU\n- `make start-gpu` to build and get inside the GPU container\n\n-----------------\n- `poetry install` to install all the dependencies, including jupyter\n\n- `make notebook` inside the same terminal. You can then follow the link to a jupyter notebook with tabnet installed.\n\n\n# How to use it?\n\nTabNet is now scikit-compatible, training a TabNetClassifier or TabNetRegressor is really easy.\n\n```\nfrom pytorch_tabnet.tab_model import TabNetClassifier, TabNetRegressor\n\nclf = TabNetClassifier()  #TabNetRegressor()\nclf.fit(X_train, Y_train, X_valid, y_valid)\npreds = clf.predict(X_test)\n```\n\nYou can also get comfortable with how the code works by playing with the **notebooks tutorials** for adult census income dataset and forest cover type dataset.\n\n## Model parameters\n\n- n_d : int (default=8)\n\n    Width of the decision prediction layer. Bigger values gives more capacity to the model with the risk of overfitting.\n    Values typically range from 8 to 64.\n\n- n_a : int (default=8)\n\n    Width of the attention embedding for each mask.\n    According to the paper n_d=n_a is usually a good choice. (default=8)\n\n- n_steps : int (default=3)\n\n    Number of steps in the architecture (usually between 3 and 10)  \n\n- gamma : float  (default=1.3)\n\n    This is the coefficient for feature reusage in the masks.\n    A value close to 1 will make mask selection least correlated between layers.\n    Values range from 1.0 to 2.0.\n\n- cat_idxs : list of int (default =[])\n\n    List of categorical features indices.\n\n- cat_emb_dim : list of int\n\n    List of embeddings size for each categorical features. (default =1)\n\n- n_independent : int  (default=2)\n\n    Number of independent Gated Linear Units layers at each step.\n    Usual values range from 1 to 5.\n\n- n_shared : int (default=2)\n\n    Number of shared Gated Linear Units at each step\n    Usual values range from 1 to 5\n- epsilon : float  (default 1e-15)\n\n    Should be left untouched.\n\n- seed : int (default=0)\n\n    Random seed for reproducibility\n\n- momentum : float\n\n    Momentum for batch normalization, typically ranges from 0.01 to 0.4 (default=0.02)\n\n- clip_value : float (default None)\n\n    If a float is given this will clip the gradient at clip_value.\n- lambda_sparse : float (default = 1e-3)\n\n    This is the extra sparsity loss coefficient as proposed in the original paper. The bigger this coefficient is, the sparser your model will be in terms of feature selection. Depending on the difficulty of your problem, reducing this value could help.\n\n- optimizer_fn : torch.optim (default=torch.optim.Adam)\n\n    Pytorch optimizer function\n\n- optimizer_params: dict (default=dict(lr=2e-2))\n\n    Parameters compatible with optimizer_fn used initialize the optimizer. Since we have Adam as our default optimizer, we use this to define the initial learning rate used for training. As mentionned in the original paper, a large initial learning of ```0.02 ```  with decay is a good option.\n\n- scheduler_fn : torch.optim.lr_scheduler (default=None)\n\n    Pytorch Scheduler to change learning rates during training.\n\n- scheduler_params : dict\n\n    Dictionnary of parameters to apply to the scheduler_fn. Ex : {"gamma": 0.95, "step_size": 10}\n\n- model_name : str (default = \'DreamQuarkTabNet\')\n\n    Name of the model used for saving in disk, you can customize this to easily retrieve and reuse your trained models.\n\n- saving_path : str (default = \'./\')\n\n    Path defining where to save models.\n\n- verbose : int (default=1)\n\n    Verbosity for notebooks plots, set to 1 to see every epoch, 0 to get None.\n\n- device_name : str (default=\'auto\')\n    \'cpu\' for cpu training, \'gpu\' for gpu training, \'auto\' to automatically detect gpu.\n\n- mask_type: str (default=\'sparsemax\')\n    Either "sparsemax" or "entmax" : this is the masking function to use for selecting features\n\n## Fit parameters\n\n- X_train : np.array\n\n    Training features\n\n- y_train : np.array\n\n    Training targets\n\n- X_valid : np.array\n\n    Validation features for early stopping\n\n- y_valid : np.array for early stopping\n\n    Validation targets    \n- max_epochs : int (default = 200)\n\n    Maximum number of epochs for trainng.\n- patience : int (default = 15)\n\n    Number of consecutive epochs without improvement before performing early stopping.\n\n- weights : int or dict (default=0)\n\n    /!\\ Only for TabNetClassifier\n    Sampling parameter\n    0 : no sampling\n    1 : automated sampling with inverse class occurences\n    dict : keys are classes, values are weights for each class\n\n- loss_fn : torch.loss\n\n    Loss function for training (default to mse for regression and cross entropy for classification)\n\n- batch_size : int (default=1024)\n\n    Number of examples per batch, large batch sizes are recommended.\n\n- virtual_batch_size : int (default=128)\n\n    Size of the mini batches used for "Ghost Batch Normalization"\n\n- num_workers : int (default=0)\n\n    Number or workers used in torch.utils.data.Dataloader\n\n- drop_last : bool (default=False)\n\n    Whether to drop last batch if not complete during training\n',
    'author': None,
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/dreamquark-ai/tabnet',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
