# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['fluffy_code', 'fluffy_code.static']

package_data = \
{'': ['*']}

install_requires = \
['MarkupSafe', 'Pygments', 'pygments-ansi-color', 'pyquery']

setup_kwargs = {
    'name': 'fluffy-code',
    'version': '0.0.1',
    'description': 'A developer-friendly code rendering library for Python web applications',
    'long_description': 'fluffy-code\n-----------\n\n**fluffy-code** is a developer-friendly code rendering library for Python web\napplications.\n\nIt can be used to easily render code with a bunch of user experience features\nto help give your page a polished feel:\n\n\n#### Syntax highlighting\n\n![Syntax highlighting](https://i.fluffy.cc/msbDxbzG69pZCbjnhrk3qq7vmmnh8BSJ.png)\n\n\nSyntax highlighting is backed by [Pygments](https://pygments.org/). fluffy-code\nships with two hand-picked color schemes, but you can swap those out for any\nPygments style.\n\n\n#### Line highlighting\n\n![Line highlighting](https://i.fluffy.cc/6CHS3hvqHjWJlslX20nDfr6qkGvpWck5.png)\n\nClick the line numbers to highlight a line (or click-and-drag to highlight\nmultiple). The selected line numbers are automatically added to the URL\'s\nfragment so that you can share your selection with others; when the URL is\nloaded, the lines remain highlighted and the page scrolls down to the\nselection.\n\n\n#### Easy text selection and copy-paste\n\n![Text selection](https://i.fluffy.cc/GXRPs3DPrsQWkthtnHt1wklzjT8H2fXV.png)\n\nCode is rendered inside of a read-only but contenteditable container, which\nmakes it easy to select text. All of these options work:\n\n* Click-and-drag inside the container to select text\n* Right-click inside the text and click "select all" (it won\'t select the whole\n  page, just the code!)\n* Click inside the text and move your cursor around using arrow keys (you can\n  use shift to select text, Ctrl-A to select all, etc)\n\n\n#### Diff rendering\n\n![Diff rendering](https://i.fluffy.cc/dCXrmKWl3N6nN631DJpWnt1LkrPMPtRP.png)\n\nCode can be rendered in a special diff-aware mode where the text is still\nsyntax-highlighted using the regular Pygments lexer, but diff additions and deletions are\nhighlighted with a green or red background, similar to GitHub\'s diff viewer.\n\n\n#### Terminal (ANSI) escape sequence rendering\n\n![ANSI rendering](https://i.fluffy.cc/xQRXmZ1CHxWw90mDgQCdHq4lvFzwC8S3.png)\n\n[pygments-ansi-color](https://github.com/chriskuehl/pygments-ansi-color) is\nused to render output from terminals and color text according to ANSI escape\ncodes. This is useful when rendering terminal output which was piped into a\nfile to preserve the original color and styling. 8-color, 256-color, and\ndim/bold modes are all supported.\n\n\n#### Theme support\n\n![Themes](https://i.fluffy.cc/pfQ3bsTFl7H0s9BrDRvLHPD35X3JzJ40.png)\n\nAll colors are fully themeable, and users can swap between the themes\nclientside. fluffy-code ships with one light theme (the default) and one dark\ntheme, but new themes are as easy as picking a Pygments style and defining a\nfew matching colors for the line numbers.\n\n\n## Sounds great! Where can I try it out?\n\nHere are a few samples of fluffy-code text rendered via\n[fluffy](https://github.com/chriskuehl/fluffy), a pastebin-type app where this\nlibrary originated:\n\n* [A simple Python script with syntax highlighting](https://i.fluffy.cc/cxGSDD5JcC8g6Lm3L1VngbmNJZDRR4Bm.html)\n* [A diff of a Python script with diff highlights and syntax highlighting](https://i.fluffy.cc/rjX2XQDMhflK3ZDXJNwcBxpmNt8986Vh.html)\n* [A snippet of terminal output with ANSI color code highlighting](https://i.fluffy.cc/cgQc0Wv7FtL6X1JLw5VbZ242bZ3BlGjq.html)\n\nMake sure you play with the theme dropdown in the top-right to try it out with\ndifferent color schemes.\n\nIf you just want to see a few samples of fluffy-code snippets rendered in HTML\nby themselves, check out [TODO: the auto-generated samples on GitHub Pages].\n\n\n## Usage\n\nInstall `fluffy-code` via pip, then use code like this to generate HTML:\n\n```python\nimport pygments.lexers\nfrom fluffy_code import code\nfrom fluffy_code import prebuilt_styles\n\nmarkup = code.render(\n    # Replace this with your text.\n    "my python code",\n    # You can replace this with `monokai_style()` for a dark theme, or create\n    # your own theme with the instructions below.\n    style_config=prebuilt_styles.default_style(),\n    highlight_config=code.HighlightConfig(\n        # Adjust lexer name as needed. Pygments also provides other options\n        # such as guessing the lexer based on file extension or file contents.\n        lexer=pygments.lexers.get_lexer_by_name(\'python\'),\n        # Set to True if you want to highlight additions and deletions for a diff.\n        highlight_diff=False,\n    ),\n)\n```\n\nThe returned object is an instance of `markupsafe.Markup` which can be rendered\nin Jinja and most other templating systems directly. You can pass it to `str()`\nif you just want the HTML as a string.\n\n\n### Including required CSS and JavaScript\n\nfluffy-code requires you to include a JavaScript snippet (for line number\nhighlighting to work) and some CSS styling. To get these, use:\n\n```python\nfrom fluffy_code import code\nfrom fluffy_code import prebuilt_styles\n\n# To get the global JavaScript.\nprint(code.get_global_javascript())\n\n# To get the global CSS.\nprint(code.get_global_css())\n\n# To get the CSS for a specific theme.\n#\n# These rules do not conflict, so you can include CSS for as many themes as\n# you\'d like on the same page and manipulate the CSS classes to swap between\n# them clientside.\nstyle = prebuilt_styles.default_style()\nprint(style.css)\n```\n\nYou can integrate these into your build system and put them on your CDN at\nbuild time, or include them in your HTML at runtime.\n\nAt the moment, you also need to include jQuery on your page for the JavaScript\nto function. This is on the short-term roadmap to remove.\n\n\n### Defining new themes\n\nDefining new themes is easy; you just need to pick a [Pygments\nstyle][pygments-styles] and then a few matching colors for the UI elements that\nfluffy-code adds. For a full example, check out the [pre-built\nthemes][prebuilt-themes] that ship with fluffy-code. You can construct your own\n`StyleConfig` objects in exactly the same way.\n\n\n## Contributing\n\nTo build this project locally, you\'ll need to [install\nPoetry](https://python-poetry.org/docs/) and run `poetry install`.\n\nOnce installed, you can run\n\n```bash\n$ poetry run python -m testing.generate_test_html\n```\n\nto generate a self-contained file named `test.html` using your current\ncheckout.\n\n\n## Roadmap\n### Short-term\n\n* Remove requirement on jQuery\n* Properly support multiple code views per page (currently it works fine except\n  when selecting lines, since the selected lines are added to the URL\'s\n  fragment component with no differentiation between which code view they are\n  for)\n\n\n[pygments-styles]: https://pygments.org/docs/styles/\n[prebuilt-themes]: https://github.com/chriskuehl/fluffy-code/blob/main/fluffy_code/prebuilt_styles.py\n[markupsafe]: https://markupsafe.palletsprojects.com/en/2.1.x/\n',
    'author': 'Chris Kuehl',
    'author_email': 'ckuehl@ckuehl.me',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
