# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['bridger',
 'bridger.buttons',
 'bridger.display',
 'bridger.docs',
 'bridger.endpoints',
 'bridger.filters',
 'bridger.fsm',
 'bridger.history',
 'bridger.markdown',
 'bridger.menus',
 'bridger.metadata',
 'bridger.metadata.configs',
 'bridger.migrations',
 'bridger.notifications',
 'bridger.notifications.viewsets',
 'bridger.pandas',
 'bridger.preview',
 'bridger.search',
 'bridger.serializers',
 'bridger.serializers.fields',
 'bridger.share',
 'bridger.signals',
 'bridger.tags',
 'bridger.tests',
 'bridger.tests.selenium',
 'bridger.titles',
 'bridger.utils',
 'bridger.viewsets',
 'bridger.websockets']

package_data = \
{'': ['*'], 'bridger': ['templates/bridger/*', 'templates/bridger/admin/*']}

install_requires = \
['asgiref>=3.3.0,<3.4.0',
 'celery[redis]>=4.4.0,<4.5.0',
 'channels>=2.0.0,<3.0.0',
 'channels_redis[cryptography]>=3.0.0,<3.1.0',
 'colorlog>=4.1.0,<4.2.0',
 'daphne>=2.0.0,<3.0.0',
 'dj-database-url<1.0.0',
 'django-celery-beat>=2.0.0,<2.1.0',
 'django-cors-headers>=3.0.0,<4.0.0',
 'django-extensions>=3.0.0,<4.0.0',
 'django-filter>=2.0.0,<3.0.0',
 'django-fsm>=2.0.0,<3.0.0',
 'django-mptt>=0.12.0,<0.13.0',
 'django-rest-fuzzysearch<1.0.0',
 'django-simple-history>=3.0.0,<4.0.0',
 'django-storages>=1.0.0,<2.0.0',
 'django>=3.2.0,<3.3.0',
 'djangorestframework-simplejwt>=4.0.0,<5.0.0',
 'djangorestframework>=3.0.0,<4.0.0',
 'inscriptis>=1.1,<2.0',
 'jsonschema>=3.0.0,<4.0.0',
 'jupyter>=1.0.0,<2.0.0',
 'markdown-blockdiag<1.0.0',
 'markdown>=3.0.0,<4.0.0',
 'numpy>=1.0.0,<2.0.0',
 'pandas',
 'pillow>=7.0.0,<8.0.0',
 'plotly>=4.0.0,<5.0.0',
 'psycopg2-binary>=2.0.0,<3.0.0',
 'pyjwt==1.7.1',
 'pytest-selenium>=1.0.0,<2.0.0',
 'python-decouple>=3.0.0,<4.0.0',
 'python-slugify',
 'requests>=2.0.0,<3.0.0',
 'safety>=1.0.0,<2.0.0',
 'selenium>=3.0.0,<4.0.0',
 'termcolor>=1.1.0,<2.0.0',
 'toml<1.0.0']

setup_kwargs = {
    'name': 'django-bridger',
    'version': '0.11.14',
    'description': 'The bridge between a Django Backend and a Javascript based Frontend',
    'long_description': None,
    'author': 'Christopher Wittlinger',
    'author_email': 'c.wittlinger@intellineers.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '==3.9.5',
}


setup(**setup_kwargs)
