/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import blbutil.BitArray;
import blbutil.Const;
import blbutil.StringUtil;
import ints.IntList;
import java.util.Arrays;
import java.util.stream.IntStream;
import vcf.BasicMarker;
import vcf.Marker;
import vcf.Samples;
import vcf.VcfHeader;

public final class VcfRecGTParser {
    private final VcfHeader vcfHeader;
    private final Samples samples;
    private final String vcfRec;
    private final Marker marker;
    private final int nAlleles;
    private final int nSamples;
    private final int ninthTabPos;

    private static int majAllele(IntList[] intListArray) {
        int n = 0;
        for (int i = 1; i < intListArray.length; ++i) {
            if (intListArray[i].size() <= intListArray[n].size()) continue;
            n = i;
        }
        return n;
    }

    public VcfRecGTParser(VcfHeader vcfHeader, String string) {
        if (vcfHeader.nSamples() == 0) {
            throw new IllegalArgumentException("nSamples==0");
        }
        this.vcfHeader = vcfHeader;
        this.samples = vcfHeader.samples();
        this.vcfRec = string;
        this.marker = new BasicMarker(string);
        this.nAlleles = this.marker.nAlleles();
        this.nSamples = vcfHeader.nSamples();
        this.ninthTabPos = VcfRecGTParser.ninthTabPos(string);
    }

    static int ninthTabPos(String string) {
        int n = -1;
        for (int i = 0; i < 9; ++i) {
            if ((n = string.indexOf(9, n + 1)) != -1) continue;
            throw new IllegalArgumentException("VCF record format error: " + string);
        }
        return n;
    }

    public VcfHeader vcfHeader() {
        return this.vcfHeader;
    }

    public String vcfRecord() {
        return this.vcfRec;
    }

    public Marker marker() {
        return this.marker;
    }

    public int nAlleles() {
        return this.nAlleles;
    }

    public Samples samples() {
        return this.vcfHeader.samples();
    }

    public int nSamples() {
        return this.nSamples;
    }

    public boolean storeAlleles(BitArray bitArray, BitArray bitArray2) {
        this.samples.size();
        int n = this.marker.bitsPerAllele();
        if (bitArray2.size() != this.nSamples) {
            throw new IllegalArgumentException(String.valueOf(bitArray2.size()));
        }
        if (bitArray.size() != (this.nSamples << 1) * n) {
            throw new IllegalArgumentException(String.valueOf(bitArray.size()));
        }
        int n2 = this.ninthTabPos;
        int n3 = -1;
        boolean bl = true;
        for (int i = 0; i < this.nSamples; ++i) {
            int n4;
            int n5;
            boolean bl2;
            if (n2 == -1) {
                VcfRecGTParser.throwFieldCountError(this.vcfHeader, this.vcfRec);
            }
            int n6 = this.vcfHeader.unfilteredSampleIndex(i);
            while (++n3 < n6) {
                if ((n2 = this.vcfRec.indexOf(9, n2 + 1)) != -1) continue;
                VcfRecGTParser.throwFieldCountError(this.vcfHeader, this.vcfRec);
            }
            int n7 = n2 + 1;
            int n8 = VcfRecGTParser.alEnd1(this.vcfRec, n7);
            if (n7 == n8) {
                this.throwIllegalArgException("missing data", i, false);
            }
            boolean bl3 = bl2 = n8 != (n5 = VcfRecGTParser.alEnd2(this.vcfRec, n8));
            if (bl2 != this.samples.isDiploid(i)) {
                this.haploidDiploidError(i, false, bl2);
            }
            int n9 = this.parseAllele(n7, n8);
            int n10 = n4 = n8 == n5 ? n9 : this.parseAllele(n8 + 1, n5);
            if (bl2 && this.vcfRec.charAt(n8) == '/') {
                bl = false;
            }
            if (n9 == -1 || n4 == -1) {
                bl = false;
                bitArray2.set(i);
            } else {
                int n11 = i << 1;
                int n12 = n11 | 1;
                VcfRecGTParser.storeAllele(bitArray, n11, n, n9);
                VcfRecGTParser.storeAllele(bitArray, n12, n, n9);
            }
            n2 = this.vcfRec.indexOf(9, n5);
        }
        return bl;
    }

    public boolean storeAlleles(int[] nArray, boolean[] blArray) {
        if (nArray.length != this.nSamples << 1) {
            throw new IllegalArgumentException(String.valueOf(nArray.length));
        }
        if (blArray.length != this.nSamples) {
            throw new IllegalArgumentException(String.valueOf(blArray.length));
        }
        int n = this.ninthTabPos;
        int n2 = -1;
        boolean bl = true;
        for (int i = 0; i < this.nSamples; ++i) {
            int n3;
            int n4;
            boolean bl2;
            if (n == -1) {
                VcfRecGTParser.throwFieldCountError(this.vcfHeader, this.vcfRec);
            }
            int n5 = this.vcfHeader.unfilteredSampleIndex(i);
            while (++n2 < n5) {
                if ((n = this.vcfRec.indexOf(9, n + 1)) != -1) continue;
                VcfRecGTParser.throwFieldCountError(this.vcfHeader, this.vcfRec);
            }
            int n6 = n + 1;
            int n7 = VcfRecGTParser.alEnd1(this.vcfRec, n6);
            if (n6 == n7) {
                this.throwIllegalArgException("missing data", i, false);
            }
            boolean bl3 = bl2 = n7 != (n4 = VcfRecGTParser.alEnd2(this.vcfRec, n7));
            if (bl2 != this.samples.isDiploid(i)) {
                this.haploidDiploidError(i, false, bl2);
            }
            int n8 = i << 1;
            int n9 = n8 | 1;
            int n10 = this.parseAllele(n6, n7);
            if (n10 == -1 ^ (n3 = n7 == n4 ? n10 : this.parseAllele(n7 + 1, n4)) == -1) {
                n10 = -1;
                n3 = -1;
            }
            nArray[n8] = n10;
            nArray[n9] = n3;
            blArray[i] = !bl2 || this.vcfRec.charAt(n7) == '|';
            bl &= blArray[i];
            n = this.vcfRec.indexOf(9, n4);
        }
        return bl;
    }

    public HapListRep hapListRep() {
        IntList[] intListArray = (IntList[])IntStream.range(0, this.nAlleles).mapToObj(n -> new IntList()).toArray(IntList[]::new);
        IntList intList = new IntList();
        boolean bl = true;
        int n2 = this.ninthTabPos;
        int n3 = -1;
        for (int i = 0; i < this.nSamples; ++i) {
            int n4;
            int n5;
            if (n2 == -1) {
                VcfRecGTParser.throwFieldCountError(this.vcfHeader, this.vcfRec);
            }
            int n6 = this.vcfHeader.unfilteredSampleIndex(i);
            while (++n3 < n6) {
                if ((n2 = this.vcfRec.indexOf(9, n2 + 1)) != -1) continue;
                VcfRecGTParser.throwFieldCountError(this.vcfHeader, this.vcfRec);
            }
            int n7 = n2 + 1;
            int n8 = VcfRecGTParser.alEnd1(this.vcfRec, n7);
            if (n7 == n8) {
                this.throwIllegalArgException("missing data", i, false);
            }
            boolean bl2 = n8 != (n5 = VcfRecGTParser.alEnd2(this.vcfRec, n8));
            bl &= !bl2 || this.vcfRec.charAt(n8) == '|';
            if (bl2 != this.samples.isDiploid(i)) {
                this.haploidDiploidError(i, false, bl2);
            }
            int n9 = i << 1;
            int n10 = n9 | 1;
            int n11 = this.parseAllele(n7, n8);
            int n12 = n4 = n8 == n5 ? n11 : this.parseAllele(n8 + 1, n5);
            if (n11 < 0 || n4 < 0) {
                intList.add(i);
                bl = false;
            } else {
                intListArray[n11].add(n9);
                intListArray[n4].add(n10);
            }
            n2 = this.vcfRec.indexOf(9, n5);
        }
        return new HapListRep(this, intList, intListArray, bl);
    }

    private static void storeAllele(BitArray bitArray, int n, int n2, int n3) {
        int n4 = n * n2;
        int n5 = 1;
        for (int i = 0; i < n2; ++i) {
            if ((n3 & n5) == n5) {
                bitArray.set(n4);
            }
            ++n4;
            n5 <<= 1;
        }
    }

    private int[] phasedAlleles() {
        int[] nArray = new int[2 * this.nSamples];
        int n = this.ninthTabPos;
        int n2 = -1;
        int n3 = 0;
        for (int i = 0; i < this.nSamples; ++i) {
            int n4;
            int n5;
            if (n == -1) {
                VcfRecGTParser.throwFieldCountError(this.vcfHeader, this.vcfRec);
            }
            int n6 = this.vcfHeader.unfilteredSampleIndex(i);
            while (++n2 < n6) {
                if ((n = this.vcfRec.indexOf(9, n + 1)) != -1) continue;
                VcfRecGTParser.throwFieldCountError(this.vcfHeader, this.vcfRec);
            }
            int n7 = n + 1;
            int n8 = VcfRecGTParser.alEnd1(this.vcfRec, n7);
            if (n7 == n8) {
                this.throwIllegalArgException("missing data", i, true);
            }
            boolean bl = n8 != (n5 = VcfRecGTParser.alEnd2(this.vcfRec, n8));
            int n9 = this.parseAllele(n7, n8);
            int n10 = n4 = n8 == n5 ? n9 : this.parseAllele(n8 + 1, n5);
            if (bl != this.samples.isDiploid(i)) {
                this.haploidDiploidError(i, true, bl);
            }
            if (bl && this.vcfRec.charAt(n8) != '|' || n9 == -1 || n4 == -1) {
                this.throwIllegalArgException("unphased or missing genotype", i, true);
            }
            nArray[n3++] = n9;
            nArray[n3++] = n4;
            n = this.vcfRec.indexOf(9, n5);
        }
        return nArray;
    }

    private static int alEnd1(String string, int n) {
        int n2;
        if (n == string.length()) {
            VcfRecGTParser.throwGTFormatError(string, string.length());
        }
        for (n2 = n; n2 < string.length(); ++n2) {
            char c = string.charAt(n2);
            if (c != '/' && c != '|' && c != '\t' && c != ':') continue;
            return n2;
        }
        return n2;
    }

    private static int alEnd2(String string, int n) {
        int n2;
        for (n2 = n; n2 < string.length(); ++n2) {
            char c = string.charAt(n2);
            if (c != ':' && c != '\t') continue;
            return n2;
        }
        return n2;
    }

    private int haploidDiploidError(int n, boolean bl, boolean bl2) {
        String string = (bl ? "Reference sample " : "Sample ") + this.vcfHeader.samples().id(n) + " has an inconsistent number of alleles. The first genotype is " + (this.samples.isDiploid(n) ? "diploid" : "haploid") + ", but the genotype at position " + this.marker.chrom() + ":" + this.marker.pos() + " is " + (bl2 ? "diploid" : "haploid");
        throw new IllegalArgumentException(string);
    }

    private int throwIllegalArgException(String string, int n, boolean bl) {
        String string2 = "ERROR: " + string + (bl ? " for reference sample " : " for sample ") + this.vcfHeader.samples().id(n) + " at marker [" + this.marker + "]";
        throw new IllegalArgumentException(string2);
    }

    private int parseAllele(int n, int n2) {
        int n3;
        if (n == n2) {
            String string = "ERROR: Missing sample allele: " + this.vcfRec;
            throw new IllegalArgumentException(string);
        }
        if (n + 1 == n2) {
            char c = this.vcfRec.charAt(n);
            if (c == '.') {
                return -1;
            }
            n3 = c - 48;
        } else {
            n3 = Integer.parseInt(this.vcfRec.substring(n, n2));
        }
        if (n3 < 0 || n3 >= this.nAlleles) {
            String string = this.vcfRec.substring(n, n2);
            String string2 = "ERROR: Invalid allele [" + string + "] at character " + n + " in record \"" + this.marker + "\t...\"";
            throw new IllegalArgumentException(string2);
        }
        return n3;
    }

    private static void throwGTFormatError(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(1000);
        stringBuilder.append("ERROR: genotype is missing allele separator:");
        stringBuilder.append(Const.nl);
        stringBuilder.append(string.substring(0, n));
        stringBuilder.append(Const.nl);
        stringBuilder.append("Exiting Program");
        stringBuilder.append(Const.nl);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    private static void throwFieldCountError(VcfHeader vcfHeader, String string) {
        String string2 = vcfHeader.src();
        Object[] objectArray = StringUtil.getFields(string, '\t');
        StringBuilder stringBuilder = new StringBuilder(1000);
        stringBuilder.append("ERROR: CF header line has ");
        stringBuilder.append(vcfHeader.nHeaderFields());
        stringBuilder.append(" fields, but data line has ");
        stringBuilder.append(objectArray.length);
        stringBuilder.append(" fields");
        stringBuilder.append(Const.nl);
        stringBuilder.append("File source: ");
        stringBuilder.append(string2);
        stringBuilder.append(Const.nl);
        stringBuilder.append(Arrays.toString(objectArray));
        stringBuilder.append(Const.nl);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public int[][] nonMajRefIndices() {
        int n;
        int n2;
        int[] nArray = this.phasedAlleles();
        int[] nArray2 = new int[this.nAlleles];
        int[] nArray3 = nArray;
        int n3 = nArray3.length;
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = n = nArray3[n2];
            nArray2[n4] = nArray2[n4] + 1;
        }
        int n5 = 0;
        for (n3 = 1; n3 < this.nAlleles; ++n3) {
            if (nArray2[n3] <= nArray2[n5]) continue;
            n5 = n3;
        }
        int[][] nArrayArray = new int[this.nAlleles][];
        for (n2 = 0; n2 < this.nAlleles; ++n2) {
            nArrayArray[n2] = n2 == n5 ? null : new int[nArray2[n2]];
        }
        Arrays.fill(nArray2, 0);
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = nArray[n2];
            if (n == n5) continue;
            int n6 = n;
            int n7 = nArray2[n6];
            nArray2[n6] = n7 + 1;
            nArrayArray[n][n7] = n2;
        }
        return nArrayArray;
    }

    public static class HapListRep {
        private final VcfRecGTParser recParser;
        private final IntList missingSamples;
        private final IntList[] hapLists;
        private final boolean isPhased;
        private final int majorAllele;

        private HapListRep(VcfRecGTParser vcfRecGTParser, IntList intList, IntList[] intListArray, boolean bl) {
            this.recParser = vcfRecGTParser;
            this.missingSamples = intList;
            this.hapLists = intListArray;
            this.isPhased = bl;
            this.majorAllele = VcfRecGTParser.majAllele(intListArray);
        }

        public int nonmajorAlleleCnt() {
            int n = -this.hapLists[this.majorAllele].size();
            for (IntList intList : this.hapLists) {
                n += intList.size();
            }
            return n;
        }

        public int[] missingSamples() {
            return this.missingSamples.toArray();
        }

        public int majorAllele() {
            return this.majorAllele;
        }

        public int[][] hapLists(boolean bl) {
            int[][] nArrayArray = new int[this.hapLists.length][];
            for (int i = 0; i < nArrayArray.length; ++i) {
                if (bl && i == this.majorAllele) continue;
                nArrayArray[i] = this.hapLists[i].toArray();
            }
            return nArrayArray;
        }

        public Marker marker() {
            return this.recParser.marker();
        }

        public Samples samples() {
            return this.recParser.samples();
        }

        public boolean isPhased() {
            return this.isPhased;
        }
    }
}

