/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import ints.IntArray;
import java.util.Arrays;
import java.util.stream.IntStream;
import vcf.GTRec;
import vcf.Marker;
import vcf.RefGTRec;
import vcf.Samples;

public class SeqCodedRefGTRec
implements RefGTRec {
    private final Marker marker;
    private final Samples samples;
    private final IntArray hapToSeq;
    private final IntArray seqToAllele;

    public SeqCodedRefGTRec(Marker marker, Samples samples, IntArray intArray, IntArray intArray2) {
        if (intArray.size() != 2 * samples.size()) {
            throw new IllegalArgumentException("inconsistent data");
        }
        this.marker = marker;
        this.samples = samples;
        this.hapToSeq = intArray;
        this.seqToAllele = intArray2;
    }

    @Override
    public boolean isPhased(int n) {
        if (n < 0 || n >= this.samples().size()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return true;
    }

    @Override
    public boolean isPhased() {
        return true;
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public int size() {
        return this.hapToSeq.size();
    }

    @Override
    public Marker marker() {
        return this.marker;
    }

    @Override
    public int[][] hapIndices() {
        int n;
        int[] nArray = this.alleleCounts();
        int n2 = 0;
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] <= nArray[n2]) continue;
            n2 = i;
        }
        int[][] nArrayArray = new int[nArray.length][];
        for (n = 0; n < nArray.length; ++n) {
            if (n == n2) continue;
            nArrayArray[n] = new int[nArray[n]];
        }
        Arrays.fill(nArray, 0);
        int n3 = this.size();
        for (n = 0; n < n3; ++n) {
            int n4 = this.get(n);
            if (n4 == n2) continue;
            int n5 = n4;
            int n6 = nArray[n5];
            nArray[n5] = n6 + 1;
            nArrayArray[n4][n6] = n;
        }
        return nArrayArray;
    }

    @Override
    public boolean isAlleleCoded() {
        return false;
    }

    @Override
    public int majorAllele() {
        return this.majorAllele(this.alleleCounts());
    }

    private int majorAllele(int[] nArray) {
        int n = 0;
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] <= nArray[n]) continue;
            n = i;
        }
        return n;
    }

    @Override
    public int[] alleleCounts() {
        int[] nArray = new int[this.marker.nAlleles()];
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            int n2 = this.get(i);
            nArray[n2] = nArray[n2] + 1;
        }
        return nArray;
    }

    @Override
    public int alleleCount(int n) {
        int[] nArray = this.alleleCounts();
        if (n == this.majorAllele(nArray)) {
            throw new IllegalArgumentException("major allele");
        }
        return nArray[n];
    }

    @Override
    public int allele1(int n) {
        return this.seqToAllele.get(this.hapToSeq.get(n << 1));
    }

    @Override
    public int allele2(int n) {
        return this.seqToAllele.get(this.hapToSeq.get(n << 1 | 1));
    }

    @Override
    public int get(int n) {
        return this.seqToAllele.get(this.hapToSeq.get(n));
    }

    @Override
    public int[] alleles() {
        return IntStream.range(0, this.hapToSeq.size()).map(n -> this.get(n)).toArray();
    }

    @Override
    public int hapIndex(int n, int n2) {
        int[][] nArray = this.hapIndices();
        if (nArray[n] == null) {
            throw new IllegalArgumentException("major allele");
        }
        return nArray[n][n2];
    }

    @Override
    public boolean isCarrier(int n, int n2) {
        return this.get(n2) == n;
    }

    public String toString() {
        return GTRec.toVcfRec(this);
    }

    @Override
    public int nMaps() {
        return 2;
    }

    @Override
    public IntArray[] maps() {
        return new IntArray[]{this.hapToSeq, this.seqToAllele};
    }

    @Override
    public IntArray map(int n) {
        switch (n) {
            case 0: {
                return this.hapToSeq;
            }
            case 1: {
                return this.seqToAllele;
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(n));
    }
}

