/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.ChromIds;
import blbutil.Const;
import vcf.GeneticMap;
import vcf.Marker;

public class PositionMap
implements GeneticMap {
    private final double scaleFactor;
    private final double invScaleFactor;

    public double scaleFactor() {
        return this.scaleFactor;
    }

    public PositionMap(double d) {
        if (!Double.isFinite(d) || d <= 0.0) {
            throw new IllegalArgumentException(String.valueOf(d));
        }
        this.scaleFactor = d;
        this.invScaleFactor = 1.0 / d;
    }

    @Override
    public int basePos(int n, double d) {
        if (n < 0 || n >= ChromIds.instance().size()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        long l = Math.round(d * this.invScaleFactor);
        if (l > Integer.MAX_VALUE) {
            String string = "An estimated base position exceeds the maximum integer value" + Const.nl + "Is the window parameter in cM units?";
            throw new IllegalArgumentException(string);
        }
        return (int)l;
    }

    @Override
    public double genPos(Marker marker) {
        return this.scaleFactor * (double)marker.pos();
    }

    @Override
    public double genPos(int n, int n2) {
        if (n < 0 || n >= ChromIds.instance().size()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.scaleFactor * (double)n2;
    }
}

