/*
 * Decompiled with CFR 0.152.
 */
package phase;

import blbutil.BitArray;
import blbutil.DoubleArray;
import ints.IntArray;
import ints.IntList;
import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import phase.EstPhase;
import vcf.Markers;

public final class SamplePhase {
    private final Markers markers;
    private BitArray hap1;
    private BitArray hap2;
    private IntArray unphased;
    private final IntArray missing;
    private final byte[] clustSize;

    public SamplePhase(Markers markers, DoubleArray doubleArray, int[] nArray, int[] nArray2, IntArray intArray, IntArray intArray2) {
        int n = markers.size();
        if (n != doubleArray.size()) {
            throw new IllegalArgumentException(String.valueOf(doubleArray.size()));
        }
        if (nArray.length != n) {
            throw new IllegalArgumentException(String.valueOf(nArray.length));
        }
        if (nArray2.length != n) {
            throw new IllegalArgumentException(String.valueOf(nArray2.length));
        }
        SamplePhase.checkIncreasing(intArray, n);
        SamplePhase.checkIncreasing(intArray2, n);
        this.markers = markers;
        this.hap1 = new BitArray(markers.sumHapBits());
        this.hap2 = new BitArray(markers.sumHapBits());
        markers.allelesToBits(nArray, this.hap1);
        markers.allelesToBits(nArray2, this.hap2);
        this.unphased = intArray;
        this.missing = intArray2;
        float f = 0.005f;
        this.clustSize = SamplePhase.clustSize(nArray, nArray2, intArray2, doubleArray, f);
    }

    private static void checkIncreasing(IntArray intArray, int n) {
        int n2 = -1;
        int n3 = intArray.size();
        for (int i = 0; i < n3; ++i) {
            if (intArray.get(i) <= n2) {
                throw new IllegalArgumentException(intArray.toString());
            }
            n2 = intArray.get(i);
        }
        if (n2 >= n) {
            throw new IllegalArgumentException(intArray.toString());
        }
    }

    private static byte[] clustSize(int[] nArray, int[] nArray2, IntArray intArray, DoubleArray doubleArray, float f) {
        IntList intList = new IntList(4096);
        int n = doubleArray.size();
        double d = doubleArray.get(0) + (double)f;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = n3 < intArray.size() ? intArray.get(n3++) : -1;
        for (int i = 0; i < n; ++i) {
            boolean bl2;
            boolean bl3;
            int n5 = i - n2;
            boolean bl4 = bl3 = i == n4;
            if (bl3) {
                n4 = n3 < intArray.size() ? intArray.get(n3++) : -1;
            }
            boolean bl5 = bl2 = bl3 || nArray[i] != nArray2[i];
            if ((bl || bl2 || doubleArray.get(i) > d || n5 == 255) && i > 0) {
                intList.add(n5);
                d = doubleArray.get(i) + (double)f;
                n2 = i;
            }
            bl = bl2;
        }
        intList.add(n - n2);
        return SamplePhase.toByteArray(intList);
    }

    private static byte[] toByteArray(IntList intList) {
        byte[] byArray = new byte[intList.size()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)intList.get(i);
        }
        return byArray;
    }

    public int[] clustEnds() {
        int[] nArray = new int[this.clustSize.length];
        int n = 0;
        for (int i = 0; i < this.clustSize.length; ++i) {
            nArray[i] = n += this.clustSize[i] & 0xFF;
        }
        return nArray;
    }

    public Markers markers() {
        return this.markers;
    }

    public IntArray missing() {
        return this.missing;
    }

    public IntArray unphased() {
        return this.unphased;
    }

    public void setUnphased(IntArray intArray) {
        SamplePhase.checkIncreasing(intArray, this.markers.size());
        this.unphased = intArray;
    }

    public void getHaps(BitArray bitArray, BitArray bitArray2) {
        int n = this.markers.sumHapBits();
        if (bitArray.size() != n || bitArray2.size() != n) {
            throw new IllegalArgumentException("inconsistent data");
        }
        bitArray.copyFrom(this.hap1, 0, this.hap1.size());
        bitArray2.copyFrom(this.hap2, 0, this.hap2.size());
    }

    public int allele1(int n) {
        return this.markers.allele(this.hap1, n);
    }

    public int allele2(int n) {
        return this.markers.allele(this.hap2, n);
    }

    public void setAllele1(int n, int n2) {
        this.markers.setAllele(n, n2, this.hap1);
    }

    public void setAllele2(int n, int n2) {
        this.markers.setAllele(n, n2, this.hap2);
    }

    public void swapHaps(int n, int n2) {
        int n3 = this.markers.sumHapBits(n);
        int n4 = this.markers.sumHapBits(n2);
        BitArray.swapBits(this.hap1, this.hap2, n3, n4);
    }

    public BitArray hap1() {
        return new BitArray(this.hap1);
    }

    public BitArray hap2() {
        return new BitArray(this.hap2);
    }

    public static BitArray[] toBitLists(EstPhase estPhase) {
        int n = estPhase.fpd().par().nthreads();
        int n3 = estPhase.fpd().stage1TargGT().nMarkers();
        int n4 = (n3 + n - 1) / n;
        while (n4 > 4096) {
            n4 = n4 + 1 >> 1;
        }
        int n5 = n4;
        int n6 = (n3 + (n5 - 1)) / n5;
        return (BitArray[])IntStream.range(0, n6).parallel().boxed().flatMap(n2 -> SamplePhase.bitLists(estPhase, n2, n5)).toArray(BitArray[]::new);
    }

    private static Stream<BitArray> bitLists(EstPhase estPhase, int n3, int n4) {
        int n5 = estPhase.fpd().targGT().nSamples();
        int n6 = n5 << 1;
        Markers markers = estPhase.fpd().stage1TargGT().markers();
        int n7 = n3 * n4;
        int n8 = Math.min(n7 + n4, markers.size());
        BitArray[] bitArrayArray = (BitArray[])IntStream.range(n7, n8).mapToObj(n2 -> new BitArray(n6 * markers.marker(n2).bitsPerAllele())).toArray(BitArray[]::new);
        int[] nArray = IntStream.range(n7, n8).map(n -> markers.marker(n).bitsPerAllele()).toArray();
        for (int i = 0; i < n5; ++i) {
            SamplePhase samplePhase = estPhase.get(i);
            int n9 = i << 1;
            int n10 = n9 | 1;
            int n11 = markers.sumHapBits(n7);
            int n12 = markers.sumHapBits(n7);
            for (int j = n7; j < n8; ++j) {
                int n13 = j - n7;
                int n14 = nArray[n13];
                int n15 = n9 * n14;
                int n16 = n10 * n14;
                for (int k = 0; k < n14; ++k) {
                    if (samplePhase.hap1.get(n11++)) {
                        bitArrayArray[n13].set(n15 + k);
                    }
                    if (!samplePhase.hap2.get(n12++)) continue;
                    bitArrayArray[n13].set(n16 + k);
                }
            }
        }
        return Arrays.stream(bitArrayArray);
    }
}

