/*
 * Decompiled with CFR 0.152.
 */
package main;

import blbutil.BGZIPOutputStream;
import blbutil.Utilities;
import imp.ImpData;
import imp.ImputedVcfWriter;
import imp.StateProbs;
import ints.IntList;
import ints.UnsignedByteArray;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.IntStream;
import main.Par;
import phase.Stage2Haps;
import vcf.GT;
import vcf.GTRec;
import vcf.Samples;
import vcf.VcfWriter;

public class WindowWriter
implements Closeable {
    private final Samples samples;
    private final String outPrefix;
    private final File vcfOutFile;

    public WindowWriter(Par par, Samples samples) {
        if (samples == null) {
            throw new NullPointerException("samples==null");
        }
        this.outPrefix = par.out();
        this.vcfOutFile = new File(this.outPrefix + ".vcf.gz");
        this.samples = samples;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (Closeable closeable = new PrintWriter(new BGZIPOutputStream(byteArrayOutputStream, false));){
            boolean bl = true;
            boolean bl2 = par.ap();
            boolean bl3 = par.gp();
            boolean bl4 = false;
            VcfWriter.writeMetaLines(samples.ids(), "beagle.22Jul22.46e.jar", bl, bl2, bl3, bl4, (PrintWriter)closeable);
        }
        try {
            closeable = new FileOutputStream(this.vcfOutFile);
            var5_6 = null;
            try {
                ((FileOutputStream)closeable).write(byteArrayOutputStream.toByteArray());
            }
            catch (Throwable throwable) {
                var5_6 = throwable;
                throw throwable;
            }
            finally {
                if (closeable != null) {
                    if (var5_6 != null) {
                        try {
                            ((FileOutputStream)closeable).close();
                        }
                        catch (Throwable throwable) {
                            var5_6.addSuppressed(throwable);
                        }
                    } else {
                        ((FileOutputStream)closeable).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            WindowWriter.fileOutputError(this.vcfOutFile, iOException);
        }
    }

    public String outPrefix() {
        return this.outPrefix;
    }

    public Samples samples() {
        return this.samples;
    }

    public void printImputed(ImpData impData, int n, int n2, AtomicReferenceArray<StateProbs> atomicReferenceArray) {
        WindowWriter.checkInterval(n, n2, impData.refGT().nMarkers());
        if (atomicReferenceArray.length() != impData.nTargHaps()) {
            throw new IllegalArgumentException("inconsistent data:");
        }
        UnsignedByteArray[] unsignedByteArrayArray = (UnsignedByteArray[])IntStream.range(0, impData.nClusters()).parallel().mapToObj(n3 -> WindowWriter.toByteArray(impData, n, n2, atomicReferenceArray, n3)).toArray(UnsignedByteArray[]::new);
        WindowWriter.append(unsignedByteArrayArray, this.vcfOutFile);
    }

    private static UnsignedByteArray toByteArray(ImpData impData, int n, int n2, AtomicReferenceArray<StateProbs> atomicReferenceArray, int n3) {
        ImputedVcfWriter imputedVcfWriter = new ImputedVcfWriter(impData, n, n2, n3);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (PrintWriter printWriter = new PrintWriter(new BGZIPOutputStream(byteArrayOutputStream, false));){
            imputedVcfWriter.appendRecords(atomicReferenceArray, printWriter);
        }
        return new UnsignedByteArray(byteArrayOutputStream);
    }

    public void printPhased(GT gT, int n2, int n3) {
        WindowWriter.checkInterval(n2, n3, gT.nMarkers());
        int n4 = 50000;
        int n5 = 100;
        int[] nArray = WindowWriter.ends(n2, n3, n4);
        for (int i = 1; i < nArray.length; ++i) {
            int[] nArray2 = WindowWriter.ends(nArray[i - 1], nArray[i], n5);
            UnsignedByteArray[] unsignedByteArrayArray = (UnsignedByteArray[])IntStream.range(1, nArray2.length).parallel().mapToObj(n -> WindowWriter.toByteArray(gT, nArray2[n - 1], nArray2[n])).toArray(UnsignedByteArray[]::new);
            WindowWriter.append(unsignedByteArrayArray, this.vcfOutFile);
        }
    }

    public void printPhased(Stage2Haps stage2Haps, int n, int n3) {
        GT gT = stage2Haps.fpd().targGT();
        WindowWriter.checkInterval(n, n3, gT.nMarkers());
        int n4 = 20000;
        int n5 = 50;
        int[] nArray = WindowWriter.ends(n, n3, n4);
        for (int i = 1; i < nArray.length; ++i) {
            int n6 = nArray[i - 1];
            int n7 = nArray[i];
            GTRec[] gTRecArray = stage2Haps.toGTRecs(n6, n7);
            int[] nArray2 = WindowWriter.ends(n6, n7, n5);
            UnsignedByteArray[] unsignedByteArrayArray = (UnsignedByteArray[])IntStream.range(1, nArray2.length).parallel().mapToObj(n2 -> WindowWriter.toByteArray(this.samples, Arrays.copyOfRange(gTRecArray, nArray2[n2 - 1] - n6, nArray2[n2] - n6))).toArray(UnsignedByteArray[]::new);
            WindowWriter.append(unsignedByteArrayArray, this.vcfOutFile);
        }
    }

    private static void checkInterval(int n, int n2, int n3) {
        if (n < 0 || n2 > n3 || n2 < n) {
            throw new IllegalArgumentException("start=" + n + " end=" + n2 + " nMarkers=" + n3);
        }
    }

    private static int[] ends(int n, int n2, int n3) {
        IntList intList = new IntList(2 + (n2 - n) / n3);
        for (int i = n; i < n2; i += n3) {
            intList.add(i);
        }
        intList.add(n2);
        return intList.toArray();
    }

    private static UnsignedByteArray toByteArray(GT gT, int n, int n2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (PrintWriter printWriter = new PrintWriter(new BGZIPOutputStream(byteArrayOutputStream, false));){
            VcfWriter.appendRecords(gT, n, n2, printWriter);
        }
        return new UnsignedByteArray(byteArrayOutputStream);
    }

    private static UnsignedByteArray toByteArray(Samples samples, GTRec[] gTRecArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (PrintWriter printWriter = new PrintWriter(new BGZIPOutputStream(byteArrayOutputStream, false));){
            VcfWriter.appendRecords(samples, gTRecArray, printWriter);
        }
        return new UnsignedByteArray(byteArrayOutputStream);
    }

    private static void append(UnsignedByteArray[] unsignedByteArrayArray, File file) {
        boolean bl = true;
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file, bl));){
            for (UnsignedByteArray unsignedByteArray : unsignedByteArrayArray) {
                unsignedByteArray.write(bufferedOutputStream);
            }
        }
        catch (IOException iOException) {
            WindowWriter.fileOutputError(file, iOException);
        }
    }

    @Override
    public void close() {
        boolean bl = true;
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.vcfOutFile, bl);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
            BGZIPOutputStream bGZIPOutputStream = new BGZIPOutputStream(bufferedOutputStream, true);
            Throwable throwable = null;
            if (bGZIPOutputStream != null) {
                if (throwable != null) {
                    try {
                        bGZIPOutputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    bGZIPOutputStream.close();
                }
            }
        }
        catch (IOException iOException) {
            Utilities.exit(iOException, "Error closing file: " + this.vcfOutFile);
        }
    }

    private static void fileOutputError(File file, Exception exception) {
        Utilities.exit(exception, "Error writing to file: " + file);
    }
}

