/*
 * Decompiled with CFR 0.152.
 */
package imp;

import imp.ImpData;
import ints.IndexArray;
import ints.IntArray;
import ints.IntList;
import java.util.Arrays;
import java.util.stream.IntStream;

public class CodedSteps {
    private final ImpData impData;
    private final int[] stepStarts;
    private final IndexArray[] codedSteps;

    public CodedSteps(ImpData impData) {
        this.impData = impData;
        this.stepStarts = CodedSteps.stepStarts(impData);
        this.codedSteps = (IndexArray[])IntStream.range(0, this.stepStarts.length).parallel().mapToObj(n -> CodedSteps.codeStep(impData, this.stepStarts, n)).toArray(IndexArray[]::new);
    }

    private static int[] stepStarts(ImpData impData) {
        double[] dArray = impData.pos();
        double d = impData.par().imp_step();
        IntList intList = new IntList(dArray.length / 10);
        intList.add(0);
        double d2 = dArray[0] + d / 2.0;
        int n = CodedSteps.nextIndex(dArray, 0, d2);
        while (n < dArray.length) {
            intList.add(n);
            d2 = dArray[n] + d;
            n = CodedSteps.nextIndex(dArray, n, d2);
        }
        return intList.toArray();
    }

    private static int nextIndex(double[] dArray, int n, double d) {
        int n2 = Arrays.binarySearch(dArray, n, dArray.length, d);
        return n2 < 0 ? -n2 - 1 : n2;
    }

    private static IndexArray codeStep(ImpData impData, int[] nArray, int n2) {
        int n3 = impData.nRefHaps();
        int n4 = impData.nHaps();
        int[] nArray2 = IntStream.range(0, n4).map(n -> 1).toArray();
        int n5 = nArray[n2];
        int n6 = n2 + 1 < nArray.length ? nArray[n2 + 1] : impData.nClusters();
        int n7 = 2;
        for (int i = n5; i < n6; ++i) {
            int n8;
            int n9;
            IndexArray indexArray = impData.hapToSeq(i);
            IntArray intArray = indexArray.intArray();
            int n10 = indexArray.valueSize();
            int[] nArray3 = new int[n7 * n10];
            n7 = 1;
            for (n9 = n3; n9 < n4; ++n9) {
                n8 = n10 * nArray2[n9] + intArray.get(n9);
                if (nArray3[n8] == 0) {
                    nArray3[n8] = n7++;
                }
                nArray2[n9] = nArray3[n8];
            }
            for (n9 = 0; n9 < n3; ++n9) {
                if (nArray2[n9] == 0) continue;
                n8 = nArray2[n9] * n10 + intArray.get(n9);
                nArray2[n9] = nArray3[n8];
            }
        }
        IntArray intArray = IntArray.packedCreate(nArray2, n7);
        return new IndexArray(intArray, n7);
    }

    public ImpData impData() {
        return this.impData;
    }

    public int nSteps() {
        return this.stepStarts.length;
    }

    public int stepStart(int n) {
        return this.stepStarts[n];
    }

    public IndexArray get(int n) {
        return this.codedSteps[n];
    }
}

